<?php

require "variables/variables.php";
require "theme/control/ajax/calculTarif.php";

$user = $GLA->profileInfos();

$info = $GLA->cv($user->idU);

$sepcialite = $GLA->spetialites($user->idU);
$requestUri = $_SERVER['REQUEST_URI'];

// Utilise preg_match pour extraire l'ID
if (preg_match('/^\/profile\/(\d+)$/', $requestUri, $matches)) {

    $cvId = intval($matches[1]);
    
    $GLA->UpdateNbConsultation($user->idU,($user->nbconsultation)+1);
    $GLA->UpdateNbConsultationMois($user->idU,($user->nbconsultationMois)+1);
   
    // Vous avez un ID valide, continuez avec votre logique
} else {
    // Gestion d'erreur si l'URI ne correspond pas au motif attendu
}
?>

<div class="single content profile bg6 pb40">

    <div class="bg2 pos-r profile_head">

        <img src="<?= WEBROOT ?>theme/assets/img/shape.png" alt="" class="shape">

        <div class="profile_side ta-center">

            <?= Func::avatar($user->avatar, 'bg1') ?>

        </div>

    </div>

    <div class="bg1 user_infos pt30">

        
    <?php
            $dateUpdateDisponibilite = new DateTime($user->date_update_disponibilite);
            $aujourdhui = new DateTime(); // Date d'aujourd'hui
            $colorStyle = ($dateUpdateDisponibilite > $aujourdhui) ? 'color: red;' : 'color: green;';
            echo '<h1 class="cl2 mb10 ta-center fz2 fw6" style="' . $colorStyle . '">' . Func::name($user->nom) . '</h1>';
    ?>
        <span class="cl2 mb10 ta-center fz15 d-block"><?= $info->spetialite ?></span>

        <div class="flex jc-center rating">

            <?php for ($i = 1; $i <= $user->note; $i++) {
                echo "<span class='bg5'></span>";
            } ?>

            <span class="ml10 rate">(<?= $user->nbr_note ?> avis)
        </div>

    </div>

    <div class="pos-r invert_shape bg6">

        <div class="c flex pt40">

            <div class="col-32 box bg1 p20 bg2 cl1">

                <div class="flex jc-start">
                    <span class="icon mr10 fz2">e</span>
                    <div>
                        <span class=" fz13 d-block mb10 fw4 "> Tarif journalier</span>
                        <span class="fw6 fz15 cl3"> <?=  calculerTarifJournalier($info->tarif)?>€ / jour</span>   
                    </div>
                </div>

                <div class="flex jc-start mt20">
                    <span class="icon mr10 fz2">e</span>
                    <div>
                        <span class=" fz13 d-block mb20 fw4 "> Langues</span>

                        <?php

                        $elem = array_values(explode(',', $info->langues));

                        foreach ($elem as $v) {

                            echo "<span class='fw6 bg6 tag cl2'>" . $langues[$v] . "</span>";
                        }

                        ?>

                    </div>
                </div>

            </div>

            <div class="col-32 p20 ta-center">

                <p class="rem mb20">Membre depuis <?= Func::time(strtotime($user->date)) ?></p>
                <a href="<?= WEBROOT ?>page/creer-ticket?id=<?= $user->idU ?>" class="btn2 bg3 cl1 d-in-block mb20">Lancer un ticket</a>
                <p>Veuillez cliquer sur le bouton lancer afin que nos équipes se mobilisent pour étudier votre besoin et planifier un entretien</p>
                </br>
                <a href="<?= WEBROOT ?>page/iaclient?id=<?= $user->idU ?>" class="btn2 bg3 cl1 d-in-block mb20">Utiliser IA</a>
            </div>

            <div class="col-32 box bg1 p20 ">
                <div class="flex jc-start">
                    <span class="icon mr10 fz2">u</span>
                    <div>
                        <span class=" fz13 d-block mb20 fw4 "> Mobilité géographique</span>

                        <?php

                        $elem = array_values(explode(',', $info->geos));

                        foreach ($elem as $v) {

                            echo "<span class='bg6 brc8 fw6 tag'>" . $geos[$v] . "</span>";
                        }

                        ?>
                    </div>
                </div>
            </div>

        </div>

        <img src="<?= WEBROOT ?>theme/assets/img/shape.png" alt="" class="shape">

    </div>

    <div class="c pt50 flex">

        <div class="col-65 ">

            <div class="box p30 mb20">

            <span class="fz2 mb20 fw5 cl2 d-block">Présentation</span>

                <div class="block">

                    

                    <?=$info->bio=nl2br($info->bio)?>

                    

                </div>

                <span class="fz2 mb20 fw5 cl2 d-block">Compétences</span>

                <div class="block">

                    <?php

                    $elem = array_values(explode(',', $info->competances));

                    foreach ($elem as $v) {

                        echo "<span class='tag brc8 bg6'>" . $competances[$v] . "</span>";
                    }

                    ?>

                </div>

                <?php if (!empty($info->languages)) : ?>

                    <div class="block">
                        <span class=" d-block cl4 fz15 fw5 mb20">Langages de développement</span>
                        <?php

                        $elem = array_values(explode(',', $info->languages));

                        foreach ($elem as $v) {

                            echo "<span class='tag brc8 bg6'>" . $languages[$v] . "</span>";
                        }

                        ?>
                    </div>

                <?php endif ?>

                <?php if (!empty($info->bdd)) : ?>

                    <div class="block">
                        <span class=" d-block cl4 fz15 fw5 mb20">Base de données</span>
                        <?php

                        $elem = array_values(explode(',', $info->bdd));

                        foreach ($elem as $v) {

                            echo "<span class='tag brc8 bg6'>" . $bdd[$v] . "</span>";
                        }

                        ?>
                    </div>

                <?php endif ?>

                <?php if (!empty($info->cms)) : ?>

                    <div class="block">
                        <span class=" d-block cl4 fz15 fw5 mb20">CMS</span>
                        
                        <?php

                        $elem = array_values(explode(',', $info->cms));

                        foreach ($elem as $v) {

                            echo "<span class='tag brc8 bg6'>" . $cms[$v] . "</span>";

                        }

                        ?>
                    </div>

                <?php endif ?>

                <?php if (!empty($info->os)) : ?>

                    <div class="block">
                        <span class=" d-block cl4 fz15 fw5 mb20">Système d'exploitation</span>
                        <?php

                        $elem = array_values(explode(',', $info->os));

                        foreach ($elem as $v) {

                            echo "<span class='tag brc8 bg6'>" . $os[$v] . "</span>";
                        }

                        ?>
                    </div>

                <?php endif ?>

                <?php if (!empty($info->outils)) : ?>

                    <div class="block">
                        <span class=" d-block cl4 fz15 fw5 mb20">Outils</span>
                        <?= "<span>$info->outils</span>" ?>
                    </div>

                <?php endif ?>

            </div>

            <div class="box p30 mb20 cl2">

                <span class="fz2 mb30 fw5 cl3 d-block">Expérience (<?= $info->experience_year ?> ans)</span>

                <div>

                    <?php

                    if(empty($info->experiences)){

                        $experiences = [];

                    }else{

                        //$experiences = json_decode(utf8_encode($info->experiences));
                        
                        $experiences = json_decode(utf8_encode($GLA->experienceOrg($info->user)));

                    }

                    foreach ($experiences as $f) {

                    ?>

                        <div class="flex jc-start mb20 block">

                            <span class="icon fz18 mr10">f</span>

                            <div class="exp">

                                <div class="flex ai-center">
                                    <span class=" d-block fz13 mb10 fw5"><?= $f->name ?></span>

                                    <div class="mb10 cl7 fw5">
                                        <span class="icon fz13">x</span>
                                        <span><?= "$f->ville, $f->pays" ?></span>
                                    </div>

                                </div>
                                <span class="mb10 d-block cl5 fw4"><?= $f->poste ?></span>


                                <div class="cl7 mb20">
                                    <span class="icon fz13">w</span>
                                    <span><?= date('d/m/Y', strtotime($f->debut)) ?> - <?php if(!empty($f->fin)){echo date('d/m/Y', strtotime($f->fin));}else{echo "en cours";} ?></span>
                                </div>

                                <p class="mb20"><?= $f->desc=nl2br($f->desc) ?></p>

                            </div>

                        </div>

                    <?php } ?>

                </div>
            </div>

            <div class="box mt30 p30 rates">

                <h2>Avis sur <?= Func::name($user->nom)?></h2>

                <div class="flex jc-start rating mb10">

                    <?php for ($i = 1; $i <= $user->note; $i++) {
                        echo "<span class='bg5'></span>";
                    } ?>

                    <span class="ml10 rate">(<?= $user->nbr_note ?> avis)
                </div>

                <div class="comments">

                    <?= Root\Avis::get($user->idU, $db) ?>

                </div>

            </div>

        </div>

        <div class="col-32">

            <div class="box p20 cl2 mb20">

                <span class="fz2 mb30 fw5 cl2 d-block">Formations</span>

                <?php

                if(empty($info->formations)){

                    $formations = [];

                }else{
                    
                    //$formations = json_decode(utf8_encode($info->formations));
                    $formations = json_decode(utf8_encode($GLA->formationOrg($info->user)));

                }

                foreach ($formations as $f) {

                ?>

                    <div class="block">
                        <span class=" d-block cl4 fz15 fw5 mb10"><?= $f->name ?></span>
                        <span class=" d-block fw5 fz09 mb10"><?= $f->org ?></span>
                        <span class=" d-block fw5 fz09 mb10"><?= $f->spetialite ?></span>
                        <span class=" d-block fz11"> <span class="icon fz13 mr10">w</span> <?= date('d/m/Y', strtotime($f->debut)) ?> - <?php if(!empty($f->fin)){echo date('d/m/Y', strtotime($f->fin));}else{echo "en cours";} ?></span>
                        <span class=" d-block fz11"> <span class="icon fz13 mr10">x</span> <?= "$f->adresse" ?></span>
                    </div>

                <?php

                }

                ?>

            </div>

            <!--  
            <div class="box p30 bg2 cl1 mb20">

                <span class="fz15 mb30 fw5 cl2 d-block cl3">A propos de Khaled</span>

                <p class="cl6 mb10">/*<?//= $info->bio ?></p>

                <p class="cl6 mb5">Entreprise : <?//= $user->nom ?></p>
                <p class="cl6 mb5">Forme juridique : <?//= $user->juridique ?></p>
                <p class="cl6 mb5">SIREN : <?//= $user->siren ?></p>

            </div>
            -->

            <div class="box p30 cl2 mb20">

                <span class="fz15 fw5">Partagez son profile</span>
                

                <div class="share mt20">
                   
                       <!-- Go to www.addthis.com/dashboard to customize your tools -->
                       <script type="text/javascript" src="https://platform-api.sharethis.com/js/sharethis.js#property=64d23aaf0fa8ca0019efa152&product=inline-share-buttons&source=platform" async="async"></script>
                       <!-- ShareThis BEGIN -->
                            <div class="sharethis-inline-share-buttons"></div>
                        <!-- ShareThis END -->


                </div>

            </div>

            <div class="box p30 cl2 mb20">

                <span class="fz15 fw5">Bonus  </span>
                <span class="fw6 fz15 cl3"><?= $user->bonus ?></span>

                <div class="share mt20">

                    

                </div>

            </div>
            <div class="box p30 cl2 mb20">

                    <span class="fz15 fw5">Disponibilité à partir du  </span>
            <div>

                    <span class="fw6 fz15 cl3"><?=date('d M Y', strtotime($user->date_update_disponibilite) );?></span>

                </div>
            </div>


            <div class="box p30">

                <span class="fz15 fw5 mb20 d-block">Profiles similaires</span>

                <?php Root\Utilisateur::frealancers_similaire($user->idU, $sepcialite->s, $db, 6) ?>

            </div>

        </div>
    </div>

</div>

<script src="<?= Func::cache('theme/assets/js/single.js') ?>"></script>