<?php

use Root\Utilisateur;

Func::session('../');

if (empty($_GET['ticket'])) Func::_404();

$user = \Root\Utilisateur::userById($_SESSION['id'], $db);

if (empty($user)) Func::_404();

$ticket = \Root\Ticket::getById($_GET['ticket'], $db);

if (empty($ticket) || $ticket->freelance !== $_SESSION['id']) Func::_404();

$dateComponents = getdate();

$month = $dateComponents['mon'];
$year = $dateComponents['year'];

$months_nbr = \Root\Cra::nbr_months($ticket->idT, $db);

if (isset($_POST['submit'])) \Root\Cra::add($ticket->idT, $_POST, $db);

?>

<div class="pg inf">

    <div class="c content">

        <div class="flex mb30" id="flash">



            <?php

            $selected = 'cra';

            include '_menu.php';

            ?>

            <div class="col-8 p20">

                <div class="pt30 pb30">
                    <h1><span class="icon">n</span> <?= $GLA->pageTitle() ?></h1>
                </div>

                <?= Func::getFlash() ?>

                <div class="box p20 mb20">

                    <h2>Mission : <?= $ticket->idT ?></h2>

                    <p>Description de la mission</p>
                    <br>
                    
                        <div>
                            
                            <textarea   name="description" placeholder="Contenu de la page" rows="8" style=" min-width:200px ; max-width:100% ;width:100%" ><?= $ticket->t_description ?></textarea>
                        </div>
                    </br>
                    <p>Offre <strong> <?= $ticket->t_tjm ?>€</strong> (TJM))</p>

                </div>

                <h3>Journées de travail</h3>

                <?php

                foreach ($months_nbr as $m) {

                    if ($m->month == $month && $m->year = $year) break;

                    echo "<div class='cra_table pb20'>";

                    $thismonth = \Root\Cra::work_month($ticket->idT, $m->month, $m->year, $db);

                    echo Root\Cra::build_calendar($m->month, $m->year, $thismonth);

                    echo Root\Cra::calcul($ticket->t_tarif, $thismonth);

                    echo "<div class='mt30'>";

                    echo "<a href='" . WEBROOT . "facture?ticket=$ticket->idT&month=$m->month&year=$m->year' class='btn bg2 cl1 mt30'>Télécharger la facture de ce mois</a>";

                    echo "</div>";

                    echo "</div>";
                }

                ?>



                <form method="POST">

                    <?php

                    $thismonth = \Root\Cra::work_month($ticket->idT, $month, $year, $db);

                    echo Root\Cra::build_calendar($month, $year, $thismonth, true);

                    echo Root\Cra::calcul($ticket->t_tjm, $thismonth);

                    ?>

                    <?php if (empty($thismonth)) { ?>

                        <input type="submit" name='submit' value="Valider le CRA pour ce mois" class="btn bg2 cl1 mt30">

                    <?php } else { ?>

                        <?php if($thismonth->stt == '0'){ ?>

                            <input type="submit" name='submit' value="Modifier le CRA pour ce mois" class="btn bg2 cl1 mt30">

                        <?php }else{ ?>

                            <p class="rem mt30">Vous avez déja enregistré votre CRA pour ce mois.</p>

                            <div class="mt30">

                                <a href="<?= WEBROOT ?>facture.php?ticket=<?= $ticket->idT ?>&month=<?= $month ?>&year=<?= $year ?>" class="btn bg2 cl1 mt30" target='_blank'>Télécharger la facture de ce mois</a>

                            </div>

                        <?php } ?>

                    <?php } ?>

                </form>

                <?php if (false) : ?>
                    <div class="mt30">
                        <a href="?ticket=<?= $ticket->idT ?>&submit=true" class="btn bg2 cl1 mt30">Pointer ma journée <strong><?= date('d/m/Y') ?></strong> (<?= $matin_soir ?>)</a>
                    </div>
                <?php endif ?>

            </div>

        </div>
    </div>

</div>

<script>
    function append_btn(t) {

        t.parentElement.parentElement.querySelector('input').click()

    }

    function open_cra(t) {

        t.parentElement.parentElement.classList.toggle('open_tab')

    }

    function selectDay(t, day, date, period) {

        table = t.parentElement.parentElement.parentElement.parentElement.parentElement

        if (table.getAttribute('id') == null) return

        box = document.querySelector('#select_boxes #' + period + '_' + day)

        if (box !== null) {

            if (box.checked) {

                box.removeAttribute('checked')

                t.classList.remove('bg3')

            } else {

                box.setAttribute('checked', true)

                t.classList.add('bg3')

            }

        }

    }
</script>

<script src="<?= Func::cache('theme/assets/js/session.js') ?>"></script>