<?php

use Google\Service\AdExchangeBuyerII\Date;
use Root\Utilisateur;

Func::session('../');

if (empty($_GET['ticket'])) Func::_404();

$user = \Root\Utilisateur::userById($_SESSION['id'], $db);

if (empty($user)) Func::_404();

$ticket = \Root\Ticket::getById($_GET['ticket'], $db);

if (empty($ticket) || $ticket->freelance !== $_SESSION['id']) Func::_404();

/*
$dateComponents = getdate();

$month = $dateComponents['mon'];
$year = $dateComponents['year'];
*/

$hno = \Root\Cra::cra_hno($ticket->idT, $db);

if (isset($_POST['submit'])) \Root\Cra::add_hno($ticket->idT, $ticket->entreprise, $_POST, $db);

?>

<div class="pg inf">

    <div class="c content">

        <div class="flex mb30" id="flash">

            <?php

            $selected = 'cra';

            include '_menu.php';

            ?>

            <div class="col-8 p20">

                <div class="pt30 pb30">
                    <h1><span class="icon">n</span> <?= $GLA->pageTitle() ?></h1>
                </div>

                <?= Func::getFlash() ?>

                <div class="box p20 mb20">

                    <h2>Mission : <?= $ticket->idT ?></h2>

                    <p>Description de la mission</p>
                    <br>
                    
                        <div>
                            
                            <textarea   name="description" placeholder="Contenu de la page" rows="8" style=" min-width:200px ; max-width:100% ;width:100%" ><?= $ticket->t_description ?></textarea>
                        </div>
                    </br>

                    <p>Offre <strong> <?= $ticket->t_tjm ?>€</strong> (TJM)</p>

                </div>

                <h3>CRA HNO</h3>

                <?php

                foreach ($hno as $k => $h) {

                    $date_d = strtotime($h->date_d);
                    $date_f = strtotime($h->date_f);

                    $date_d_d = new DateTime($h->date_d);
                    $date_f_d = new DateTime($h->date_f);

                    $interval = $date_d_d->diff($date_f_d);
                    $diff = '';

                    if($interval->d !== 0){
                        $diff .= "<strong>$interval->d</strong> jours, <strong>$interval->h</strong> heures et <strong>$interval->i</strong> minutes";
                    }else{
                        $diff .= "<strong>$interval->h</strong> heures et <strong>$interval->i</strong> minutes";
                    }

                    $astreinte = ($h->astreinte !== '0') ? "<span class='cl4'>(Astreinte)</span>" : "";

                    echo "<div class='box p10 mb10'>";

                    echo "<p>" . ($k + 1) . ") $astreinte De <strong>" . date('H:i - D d', $date_d) . "</strong> à <strong>" . date('H:i - D d', $date_f) . "</strong>, Durée du travail : $diff</p>";

                    if (!empty($h->note)) echo "<p class='rem mt10'>Note : $h->note</p>";

                    echo "</div>";
                }

                ?>

                <form method="POST" class="gla-form mt30">

                    <h2>Ajouter un enregistrement</h2>

                    <label class="col-48">
                        <input type="checkbox" name="astreinte" class="brc8 cl2" onchange="astreint_input(this)">
                        <span class="fz09 cl2 mb10">Déclarer une astreinte</span>
                    </label>

                    <p class="mb20 cl4" id="astreinte_p" style="display: none;">Veuillez sélectionner la date de début et de fin de votre astreinte</p>

                    <div class="flex">
                        <label class="col-48">
                            <span class="fz09 cl2 mb10 d-block">Heure de départ</span>
                            <input type="datetime-local" name="date_d" placeholder="Heure de départ" class="brc8 cl2 col-10" required>
                        </label>

                        <label class="col-48">
                            <span class="fz09 cl2 mb10 d-block">Heure de fin</span>
                            <input type="datetime-local" name="date_f" placeholder="Heure de fin" class="brc8 cl2 col-10" required>
                        </label>
                    </div>

                    <label>
                        <span class="fz09 cl2 mb10 d-block">Note sur les heures ajoutées</span>
                        <textarea name="note" placeholder="Note ..." class="brc8 cl2 col-10" style="height: 70px;"></textarea>
                    </label>

                    <input type="submit" name='submit' value="Enregistrer" class="btn bg2 cl1 mt30">

                </form>

            </div>

        </div>
    </div>

</div>

<script src="<?= Func::cache('theme/assets/js/session.js') ?>"></script>

<script>
    function astreint_input(t){

        if(t.checked){
            document.querySelector('#astreinte_p').style.display = 'block'
        }else{
            document.querySelector('#astreinte_p').style.display = 'none'
        }

    }
</script>