<?php

use Root\Utilisateur;

if (!isset($_SESSION['id']) || $_SESSION['type'] !== '1' || !isset($_GET['id']) || !isset($_GET['ticket'])) {

    Func::setFlash('error', "Veuillez vous connecter comme entreprise pour modifier ce ticket");

    Func::redirect('connexion');
}

$ticket = Root\Ticket::getById($_GET['ticket'], $db);

if ($ticket->entreprise !== $_SESSION['id']) Func::_404();

if ($ticket->t_stt > 1) {

    Func::setFlash('error', "Impossible de modifier votre ticket, votre ticket à été validé par un administrateur");

    Func::redirect('dashboard?stt=0');
}

$user_nom = "Anonyme";

if($_GET['id'] !== '0'){

    $user = Utilisateur::userById($_GET['id'], $db);

    $user_nom = $user->nom;

}


if (isset($_POST['submit'])) \Root\Ticket::edit($_GET['ticket'], $_POST, $db);

?>

<div class="content login bg6">

    <div class="c">

        <div class="flex ai-center pt100 pb40">

            <div class="box col-48 p30 m0a">
                <h2 class="h ta-center mb30 fw5"><?= $GLA->pageTitle() ?></h2>

                <?= Func::getFlash() ?>

                <form action="" method="POST" class="gla-form">

                    <label class="mb10">Freelancer</label>
                    <input type="text" name="nom" placeholder="Nom complet" required="true" value="<?= $user_nom ?>" disabled class="col-10 cl2 brc8" />

                    <label class="mb10">Tarif par jour (€) (Modifiable) *</label>
                    <input type="number" name="tarif" placeholder="Tarif ..." required="true" value="<?= $ticket->t_tarif ?>" class="col-10 cl2 brc8" />

                    <label class="mb10">Date de début de mission souhaité*</label>
                    <input type="date" name="debut" placeholder="Date de début ..." required="true" class="col-10 cl2 brc8" min='<?= date('Y-m-d') ?>' value="<?= $ticket->t_date_debut ?>"/>

                    <label class="mb10">Durée de la mission (jours)*</label>
                    <input type="number" name="duree" placeholder="Durée ..." required="true" value="<?= $ticket->t_duree ?>" class="col-10 cl2 brc8" />

                    <label class="mb10">Adresse de la mission *</label>
                    <input type="text" name="adresse" placeholder="Adresse ..." required="true" value="<?= $ticket->t_adresse ?>" class="col-10 cl2 brc8" />

                    <label class="mb10">Informations complémentaire *</label>
                    <textarea name="description" placeholder="Informations sur la mission" required="true" class="col-10 cl2 brc8"><?= $ticket->t_description ?></textarea>


                    <p class="fz07 cl2 mb20 mt20"><input type="checkbox" value="" required> J'accepte les <a href="conditions-gnrales-d-utilisation-professionnel">conditions générales d'utilisation professionnels</a></p>

                    <input type="submit" name="submit" value="Modifier le ticket" class="btn bg3 cl1 brc1solid brc3 hover-bg4 hover-cl2 hover-brc4" id="register" />

                </form>
            </div>

        </div>

    </div>

</div>