<?php

use Root\Utilisateur;

Func::session('../');

$user = \Root\Utilisateur::userById($_SESSION['id'], $db);

if (empty($user)) Func::_404();

if (isset($_POST['submit'])) \Root\Utilisateur::editUser($_POST, $db);

?>

<div class="pg inf">

    <div class="c content">

        <div class="flex mb30" id="flash">

            <?php

            $selected = 'information';

            include '_menu.php';

            ?>

            <div class="col-8 p20">

                <div class="pt30 pb30">
                    <h1><span class="icon">p</span> <?= $GLA->pageTitle() ?></h1>
                   <br></br>

                   <p><strong>Mon référent laotop : </strong> <?= strtok($user->referent, '.')?> <?= substr($user->referent,strpos($user->referent, ".") + 1)?></p>
                   </br>
                   <p><strong >Email : </strong> <?=  strtolower($user->referent) ?>@laotop.fr</p>
                </div>

                <?= Func::getFlash() ?>

                <div class="edit">
                    <form action="" method="POST" class="gla-form" id="formInformation">


                    

                        <?php if ($_SESSION['type'] == 0) : ?>
                            <h3> Mes informations personnelles</h3>
                            
                            <div class="flex">
                            <label for="" class="col-48">
                                <span class="fz09 cl2 mb10 d-block"><?= $asset->text(7) ?></span>
                                <input type="text" name="nom" value="<?= $user->nom ?>" class="brc8 cl2 col-10" required />
                            </label>

                            <label for="" class="col-48">
                                <span class="fz09 cl2 mb10 d-block">Genre</span>
                                
                                <select name="genre" class="brc8 cl2 col-10" required>
                                        <option <?= ($user->genre == 'Homme') ? 'selected' : '' ?>>Homme</option>
                                        <option <?= ($user->genre == 'Femme') ? 'selected' : '' ?>>Femme</option>
                                </select>
                            </label>
                            </div>

                        <?php endif ?>

                        <div class="flex">

                            <label for="" class="col-32">
                                <span class="fz09 cl2 mb10 d-block"><?= $asset->text(8) ?><?php if ($user->email_val == 0) echo " (Vérifié)" ?></span>
                                <input type="text" name="email" value="<?= $user->email ?>" class="brc8 cl2 col-10" <?php if ($user->email_val == 0) echo "disabled" ?> />
                            </label>

                            <label for="" class="col-32">
                                <span class="fz09 cl2 mb10 d-block"><?= $asset->text(14) ?></span>
                                <input type="tel" name="tele" value="<?= $user->tele ?>" class="brc8 cl2 col-10" required />
                            </label>

                            <label for="" class="col-32">
                                <span class="fz09 cl2 mb10 d-block"><?= $asset->text(36) ?></span>
                                <input type="text" name="adresse" value="<?= $user->adresse ?>" placeholder="Donnez votre adresse ..." class="brc8 cl2 col-10" required />
                            </label>

                        </div>

                       

                        <?php if ($_SESSION['type'] == 0) : ?>
                            <h3> Mon entreprise</h3>
                            <div>

                                <label class="col-32 mt20">
                                    <input type="checkbox" name="portage_check" onchange="portage_func(this)" <?php if (!empty($user->portage)) echo "checked" ?> />
                                    <span class="fz09 cl2 mb10">Je suis porté par une entreprise</span>
                                    
                                </label>

                                <label class="col-7" id="portage_id" <?php if (empty($user->portage)) echo "style='display:none'" ?>>
                                    <span class="fz09 cl2 mb10 d-block">Nom de l'entreprise qui me porte</span>
                                    <input type="text" name="monentreprise" value="<?= $user->monentreprise ?>" class="brc8 cl2 col-10"/>
                                  
                                </label>                               
                               
                            </div>

                            <script>
                                function portage_func(t) {

                                    element = document.querySelector('#portage_id')
                                    element_2 = document.querySelector('#entreprise_id')
                                    
                                    if (t.checked) {

                                        element.style.display = 'block'
                                        element.querySelector('input').removeAttribute('disabled')
                                        
                                        element_2.style.display = 'none'
                                        element_2.querySelector('input').setAttribute('disabled', 'true')

                                  } 
                                    else {
                                        
                                        element.style.display = 'none'
                                        element.querySelector('input').setAttribute('disabled', 'true')

                                        element_2.style.display = 'block'
                                        element_2.querySelector('input').removeAttribute('disabled')
                                        
                                    }

                                }
                            </script>

                        <?php endif ?>

                        <div>

                        
                        <div class="flex mb20">

                            <?php if ($_SESSION['type'] == 0){ ?>

                                <label for="" class="col-48" id="entreprise_id" <?php if (!empty($user->portage)) echo "style='display:none'" ?>>
                                    <span class="fz09 cl2 mb10 d-block">Nom de mon entreprise</span>
                                    <input type="text" name="monentreprise" value="<?= $user->monentreprise ?>" class="brc8 cl2 col-10" />
                                </label>

                            <?php }else{ ?>
                            
                                <label for="" class="col-48">
                                    <span class="fz09 cl2 mb10 d-block">Nom de l'entreprise</span>
                                    <input type="text" name="nom" value="<?= $user->nom ?>" class="brc8 cl2 col-10" required />
                                </label>

                            <?php } ?>

                            <label for="" class="col-48">
                                <span class="fz09 cl2 mb10 d-block">Capital</span>
                                <input type="number" name="capital" value="<?= $user->capital ?>" placeholder="capital" class="brc8 cl2 col-10" required min="1"/>
                            </label>
                        </div>

                            <div class="flex mb20">

                                <label for="" class="col-48">
                                    <span class="fz09 cl2 mb10 d-block">SIREN</span>
                                    <input type="text" name="siren" placeholder='12345678910' value="<?= $user->siren ?>" class="brc8 cl2 col-10" required />
                                </label>

                                <label for="" class="col-48">
                                    <span class="fz09 cl2 mb10 d-block">Forme juridique</span>

                                    <select name="juridique" class="brc8 cl2 col-10" required>
                                        <option <?= ($user->juridique == 'EURL') ? 'selected' : '' ?>>EURL</option>
                                        <option <?= ($user->juridique == 'SARL') ? 'selected' : '' ?>>SARL</option>
                                        <option <?= ($user->juridique == 'SA') ? 'selected' : '' ?>>SA</option>
                                        <option <?= ($user->juridique == 'SAS') ? 'selected' : '' ?>>SAS</option>
                                        <option <?= ($user->juridique == 'SASU') ? 'selected' : '' ?>>SASU</option>
                                        <option <?= ($user->juridique == 'SNC') ? 'selected' : '' ?>>SNC</option>
                                        <option <?= ($user->juridique == 'SCOP') ? 'selected' : '' ?>>SCOP</option>
                                        <option <?= ($user->juridique == 'SCA') ? 'selected' : '' ?>>SCA</option>
                                        <option <?= ($user->juridique == 'SCS') ? 'selected' : '' ?>>SCS</option>
                                        <option <?= ($user->juridique == 'EI') ? 'selected' : '' ?>>EI</option>
                                        <option <?= ($user->juridique == 'AUTO-ENTREPRENEUR') ? 'selected' : '' ?>>AUTO-ENTREPRENEUR</option>
                                    </select>
                                </label>

                            </div>
                        <?php if ($_SESSION['type'] == 0) : ?>
                            <div class="flex mb20">
                                <label for="" class="col-48">
                                        <span class="fz09 cl2 mb10 d-block">IBAN </span>
                                        <input type="text" name="iban" value="<?= $user->iban ?>" placeholder="FR42 4242 4242 4242 4242 4242 P00" class="brc8 cl2 col-10"  />
                                </label>
                                <label for="" class="col-48">
                                        <span class="fz09 cl2 mb10 d-block">BIC/SWIFT </span>
                                        <input type="text" name="bic" value="<?= $user->bic ?>" placeholder="QNTOFRP1XXX" class="brc8 cl2 col-10"  />
                                </label>

                            </div>
                            
                            <?php endif ?>
                        </div>

                        <?php if ($_SESSION['type'] == 0) : ?>


                            <h3>Mes disponibilités</h3>
                            
                            <h4>Dernière mise jour de ma disponibilité est le : <?= date('d/m/Y à H:i', strtotime($user->date_update_disponibilite))?> </h4>
                            <br></br>
                            <div class="mb20">
                                <label class="mb10">je suis disponibile à partir de : <strong><?= date('d/m/Y', strtotime($user->date_disponibilite )) ?></strong></label>
                                <input type="date" name='date_disponibilite' placeholder="Date de disponibilité..." class="col-10" min="<?= date('Y-m-d') ?>">
                            </div>


                            <h3>Mes fichiers</h3>

                            <div class="box p20 mb20">

                                <h4 class="mb20">Kabis (Max 2Mo)</h4>

                                <?= Utilisateur::files("kbis", "Mon Kbis", $db) ?>

                                <div><span class="btn2 bg3 cl1" onclick="append_btn(this)" id="loader_kbis"><span class='icon mr8 fz13'>a</span>Modifier</span></div>

                                <input type="file" name="kbis" placeholder="Votre Kbis ..." style="display:none" onchange="append_file(this, 'kbis')">

                            </div>

                            <div class="box p20 mb20">

                                <h4 class="mb20">Assurance professionnelle (Max 2Mo)</h4>

                                <?= Utilisateur::files("assurance", "Mon assurance professionnelle", $db) ?>

                                <div><span class="btn2 bg3 cl1" onclick="append_btn(this)" id="loader_assurance"><span class='icon mr8 fz13'>a</span>Modifier</span></div>

                                <input type="file" name="assurance" placeholder="Votre assurance professionnelle ..." style="display:none" onchange="append_file(this, 'assurance')">

                            </div>


                            <!--

                            <div class="box p20 mb20">

                                <h4 class="mb20">Diplôme (Max 2Mo)</h4>

                                <?= Utilisateur::files("diplome", "Mon diplôme", $db) ?>

                                <div><span class="btn2 bg3 cl1" onclick="append_btn(this)" id="loader_diplome"><span class='icon mr8 fz13'>X</span>Modifier</span></div>

                                <input type="file" name="diplome" placeholder="Votre diplome ..." style="display:none" onchange="append_file(this, 'diplome')">

                            </div>

                            <div class="box p20 mb20">

                                <h4 class="mb20">Assurance décennale (Max 2Mo)</h4>

                                <?= Utilisateur::files("ass_dec_f", "Mon Assurance décennale", $db) ?>

                                <div><span class="btn2 bg3 cl1" onclick="append_btn(this)" id="loader_ass_dec_f"><span class='icon mr8 fz13'>X</span>Modifier</span></div>

                                <input type="file" name="ass_dec_f" placeholder="Votre Assurance décennale ..." style="display:none" onchange="append_file(this, 'ass_dec_f')">

                            </div>

                            <div class="box p20 mb20">

                                <h4 class="mb20">Assurance RC PRO (Max 2Mo)</h4>

                                <?= Utilisateur::files("ass_rc_f", "Mon Assurance RC PRO", $db) ?>

                                <div><span class="btn2 bg3 cl1" onclick="append_btn(this)" id="loader_ass_rc_f"><span class='icon mr8 fz13'>X</span>Modifier</span></div>

                                <input type="file" name="ass_rc_f" placeholder="Votre Assurance RC PRO ..." style="display:none" onchange="append_file(this, 'ass_rc_f')">

                            </div>

                            -->

                        <?php endif ?>

                        <input type="submit" name="submit" value="<?= $asset->text(38) ?>" class="btn bg3 brc3 brc1solid cl1 hover-brc4 hover-bg2 hover-cl1" />

                    </form>
                </div>
            </div>

        </div>
    </div>

</div>

<script>
    function append_btn(t) {

        t.parentElement.parentElement.querySelector('input').click()

    }
</script>

<script src="<?= Func::cache('theme/assets/js/session.js') ?>"></script>

<script>
    // Fonction pour sauvegarder les données du formulaire dans localStorage
    function saveFormData() {
        var formElements = document.getElementById('formInformation').elements;
        for (var i = 0; i < formElements.length; i++) {
            var elem = formElements[i];
            if (elem.name) localStorage.setItem(elem.name, elem.value);
        }
    }

    // Fonction pour restaurer les données du formulaire depuis localStorage
    function restoreFormData() {
        var formElements = document.getElementById('formInformation').elements;
        for (var i = 0; i < formElements.length; i++) {
            var elem = formElements[i];
            if (elem.name && localStorage.getItem(elem.name)) {
                elem.value = localStorage.getItem(elem.name);
            }
        }
    }

    // Ajouter un écouteur d'événements pour enregistrer les données à chaque modification du formulaire
    document.getElementById('formInformation').addEventListener('input', saveFormData);

    // Appeler restoreFormData au chargement de la page
    window.onload = restoreFormData;
</script>
