<?php

if (empty($_GET['ticket'])) die('Error 404 !');

require "gla-adminer/class/Config.php";
require "gla-adminer/class/Func.php";

require "gla-adminer/class/BDD/App.php";
require "gla-adminer/class/BDD/Bdd.php";

$db = BDD\App::getBDD();

Func::session('../');

if (empty($_GET['ticket'])) Func::_404();

$user = \Root\Utilisateur::userById($_SESSION['id'], $db);

if (empty($user)) Func::_404();

$ticket = \Root\Ticket::getById($_GET['ticket'], $db);

if (empty($ticket) || $ticket->freelance !== $_SESSION['id']) Func::_404();

$entreprise = \Root\Utilisateur::userById($ticket->entreprise, $db);

if (empty($entreprise)) Func::_404();

$thismonth = \Root\Cra::work_month($ticket->idT, $db);

if(empty($thismonth)) Func::_404();

$day_am = json_decode($thismonth->day_am);
$day_pm = json_decode($thismonth->day_pm);

$work = count($day_am) + count($day_pm);

$total = $work * ($ticket->t_tarif / 2);
//$total = number_format($work * $demi_journee, 2, '.', ' ')

require "gla-adminer/lib/vendor/autoload.php";

use Konekt\PdfInvoice\InvoicePrinter;

$invoice = new InvoicePrinter('A4', '€', 'fr');

/* Header settings */
//$invoice->setLogo("theme/assets/img/ecoprimevape.jpg");   //logo image path
$invoice->setColor("#2a182f");      // pdf color scheme
$invoice->setType("Facture");    // Invoice Type
$invoice->setReference("LAOTOP-$ticket->idT");   // Reference
$invoice->setDate("    " . date('d/m/Y', strtotime($thismonth->date)));   //Billing Date
$invoice->setTime(date('H:i', strtotime($thismonth->date)));   //Billing Time
//$invoice->setDue(date('M dS ,Y', strtotime('+3 months')));    // Due Date
$invoice->setDue("");    // Due Date
$invoice->setFrom(array($user->nom, $user->adresse, "France"));
$invoice->setTo(array("$entreprise->juridique $entreprise->nom", $entreprise->adresse, "SIREN : $entreprise->siren"));

$invoice->addItem("Mission N° $ticket->idT", "Mission par demi journées", $work, 0, $ticket->t_tarif, 0, $total);

$invoice->setFontSizeProductDescription(9);

$invoice->addTotal("Total", $total);
$invoice->addTotal("TVA 0%", 0);
$invoice->addTotal("Total à payer", number_format($total, 2, '.', ' '), true);

$invoice->addBadge("Facture à payer avant 1 mois a partir de la date d'envoi");

$invoice->addTitle("Note");

$invoice->addParagraph("* Cette facture à été générée automatiquement");
$invoice->addParagraph("* En cas de problème ou d'erreur dans la facture veuillez nous contacter");

$invoice->setFooternote("LaoTop");

$invoice->render('example1.pdf', 'I'); 
  /* I => Display on browser, D => Force Download, F => local path save, S => return document as string */