<?php

use Root\Utilisateur;

Func::session('../');
require "theme/control/ajax/calculTarif.php";
require "theme/variables/variables.php";

$user = \Root\Utilisateur::userById($_SESSION['id'], $db);
$info = \Root\Utilisateur::userInfoCV($db);

$metiers = $db->select('idA, title', 'articles')->get();
$metiers_selected = $db->select('s', 'spetialites')->where('u = ?')->get([$_SESSION['id']]);
$cv="";

$mt_s = "";

foreach ($metiers_selected as $k => $m) {

    $mt_s .= "$m->s,";
}

$mt_s = trim($mt_s, ',');

$mt = [];

foreach ($metiers as $k => $m) {

    $mt[$m->idA] = $m->title;
}

if (empty($user)) Func::_404();

if (isset($_POST['submit'])) \Root\Utilisateur::editCV($_POST, $db);

$cv.="candidat numéro: $user->idU          ,";
$tarifAfficher=calculerTarifJournalier($info->tarif);
$cv.="Mon tjm: $tarifAfficher,";
$cv.="les outils que métrise :$info->outils,";

?>
<div class="pg inf">

    <div class="c content">

        <div class="flex mb30" id="flash">

            <?php

            $selected = 'cv';

            include '_menu.php';

            ?>

            <div class="col-8 p20">

                <div class="pt30 pb30">
                    <h1><span class="icon">e</span> <?= $GLA->pageTitle() ?></h1>
                </div>

                <?= Func::getFlash() ?>

                <div class="info mb30">Votre profile est remplis à <strong><?= $user->profile_per ?>%</strong></div>

                <div class="edit">
                    <form action="" method="POST" class="gla-form" id="formInscription">

                        <label class="mb20">

                            <span class="fz09 cl2 mb10 d-block">Afficher mon profile dans ces spetialités (ne pas dépasser 5)</span>

                            <select class="js-metiers" name="metiers[]" multiple="multiple" style="width: 100% !important;">
                                <?php
                                $cv.="mes spécialités:";
                                $elem = array_values(explode(',', $mt_s));

                                foreach ($mt as $k => $v) {

                                    $selected = '';

                                    if (in_array($k, $elem)) $selected = ' selected';

                                    echo "<option value='$k'$selected>$v</option>";
                                    $cv.= "$v,";
                                
                                }

                                ?>
                            </select>

                        </label>

                        <label for="" class="col-10">
                            <span class="fz09 cl2 mb10 d-block">Ma biographie</span>
                            <textarea name="bio" placeholder='Brève biographie de moi en deux ,trois phrases' maxlength="800" class="brc8 cl2 col-10"><?= $info->bio ?></textarea>
                        </label>

                        <label for="" class="col-10">
                            <span class="fz09 cl2 mb10 d-block">Ma spétialité (quelques mots à afficher sous votre profile)</span>
                            <input type="text" name="spetialite" placeholder='Développeur Backend - Php' value="<?= $info->spetialite ?>" class="brc8 cl2 col-10" required />
                        </label>

                        <label class="col-10 bg2 cl1 p20 brr10 mb20">
                            <span class="fz09 cl1 mb10 d-block">Mon tarif journalier (€)</span>
                            <input type="text" name="tarif" placeholder='200' value="<?= $info->tarif ?>" class="brc8 cl2 col-10" required />
                        </label>

                        <label class="mb20">

                            <span class="fz09 cl2 mb10 d-block">Langues</span>

                            <select class="js-langues" name="langues[]" multiple="multiple" style="width: 100% !important;">
                                <?php
                                $cv.="lanques métrisées:";
                                $elem = array_values(explode(',', $info->langues));

                                foreach ($langues as $k => $v) {

                                    $selected = '';

                                    if (in_array($k, $elem)) 
                                    $selected = ' selected';

                                    echo "<option value='$k'$selected>$v</option>";
                                    $cv.= "$v,";
                                
                                }

                                ?>
                            </select>

                        </label>

                        <label class="mb30">

                            <span class="fz09 cl2 mb10 d-block">Mes mobilités géographique</span>

                            <select class="js-geo" name="geos[]" multiple="multiple" style="width: 100% !important;">
                                <?php
                                $cv.="Mes mobilités géographiques:";
                                $elem = array_values(explode(',', $info->geos));

                                foreach ($geos as $k => $v) {

                                    $selected = '';

                                    if (in_array($k, $elem)) $selected = ' selected';

                                    echo "<option value='$k'$selected>$v</option>";
                                    $cv.= "$v,";}
                                

                                ?>

                                
                            </select>

                        </label>

                        <h2>Compétences</h2>

                        <label class="mb20">

                            <span class="fz09 cl2 mb10 d-block">Mes compétances</span>

                            <select class="js-geo" name="competances[]" multiple="multiple" style="width: 100% !important;">
                                <?php
                                $cv.="mes compétences:";
                                $elem = array_values(explode(',', $info->competances));

                                foreach ($competances as $k => $v) {

                                    $selected = '';

                                    if (in_array($k, $elem)) $selected = ' selected';

                                    echo "<option value='$k'$selected>$v</option>";
                                    $cv.= "$v,";
                                
                                }

                                ?>
                            </select>

                        </label>

                        <label class="mb20">

                            <span class="fz09 cl2 mb10 d-block">Langages de développement et Frameworks</span>

                            <select class="js-geo" name="languages[]" multiple="multiple" style="width: 100% !important;">
                                <?php
                                $cv.="les langages de développement:";
                                $elem = array_values(explode(',', $info->languages));

                                foreach ($languages as $k => $v) {

                                    $selected = '';

                                    if (in_array($k, $elem)) $selected = ' selected';

                                    echo "<option value='$k'$selected>$v</option>";
                                    $cv.= "$v,";
                                
                                }

                                ?>
                            </select>

                        </label>

                        <label class="mb20">

                            <span class="fz09 cl2 mb10 d-block">Base de données</span>

                            <select class="js-geo" name="bdd[]" multiple="multiple" style="width: 100% !important;">
                                <?php
                            $cv.="Mes bases de données métrisées";
                                $elem = array_values(explode(',', $info->bdd));

                                foreach ($bdd as $k => $v) {

                                    $selected = '';

                                    if (in_array($k, $elem)) $selected = ' selected';

                                    echo "<option value='$k'$selected>$v</option>";
                                    $cv.= "$v,";
                                
                                }

                                ?>
                            </select>

                        </label>

                        <label class="mb30">

                            <span class="fz09 cl2 mb10 d-block">CMS</span>

                            <select class="js-geo" name="cms[]" multiple="multiple" style="width: 100% !important;">
                                <?php
                                $cv.="les cms métrisés:";
                                $elem = array_values(explode(',', $info->cms));

                                foreach ($cms as $k => $v) {

                                    $selected = '';

                                    if (in_array($k, $elem)) $selected = ' selected';

                                    echo "<option value='$k'$selected>$v</option>";
                                    $cv.= "$v,";
                                
                                }

                                ?>
                            </select>

                        </label>

                        <label class="mb30">

                            <span class="fz09 cl2 mb10 d-block">Système d'exploitation</span>

                            <select class="js-geo" name="os[]" multiple="multiple" style="width: 100% !important;">

                                <?php
                                $cv.="les os métrisés: ";
                                $elem = array_values(explode(',', $info->os));

                                foreach ($os as $k => $v) {

                                    $selected = '';

                                    if (in_array($k, $elem)) $selected = ' selected';

                                    echo "<option value='$k'$selected>$v</option>";
                                    $cv.= "$v,";
                                
                                }

                                ?>

                            </select>

                        </label>

                        <label class="mb30">

                            <span class="fz09 cl2 mb10 d-block">Outils (séparer avec des vergules (,))</span>

                            <input type="text" name="outils" placeholder='Terminal, Apache2, ...' class="brc8 cl2 col-10" value="<?= $info->outils ?>" />

                        </label>

                        <h2>Formations</h2>

                        <div class="formations mb30" id="formations">

                            <?php

                            $formations = json_decode(utf8_encode($info->formations));

                            if (empty($formations)) {

                            ?>

                                <div class="formation mb20 formation_copy">

                                    <div class="flex">

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Titre de la formation</span>
                                            <input type="text" name="formation_name[]" placeholder='Titre de la formation' class="brc8 cl2 col-10"></input>
                                        </label>

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Spétialité</span>
                                            <input type="text" name="formation_spetialite[]" placeholder='Spécialité de la formation' class="brc8 cl2 col-10"></input>
                                        </label>

                                    </div>

                                    <div class="flex">

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Date de début</span>
                                            <input type="date" name="formation_debut[]" class="brc8 cl2 col-10"></input>
                                        </label>

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Date de fin</span>
                                            <input type="date" name="formation_fin[]" placeholder='Spécialité de la formation' class="brc8 cl2 col-10"></input>
                                        </label>

                                    </div>

                                    <div class="flex">

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Organisme de formation</span>
                                            <input type="text" name="formation_org[]" placeholder="MIT" class="brc8 cl2 col-10"></input>
                                        </label>

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Lieu</span>
                                            <input type="text" name="formation_adresse[]" placeholder='Massachusste, USA' class="brc8 cl2 col-10"></input>
                                        </label>

                                    </div>

                                    <span class="btn bg3 cl1" onclick="delete_parent(this, 'Formation')">Supprimer</span>

                                </div>

                                <?php

                            }

                            if ($formations !== null) :

                                foreach ($formations as $elem) { ?>

                                    <div class="formation mb20 formation_copy">

                                        <div class="flex">

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Titre de la formation</span>
                                                <input type="text" name="formation_name[]" placeholder='Titre de la formation' class="brc8 cl2 col-10" value="<?= $elem->name ?>"></input>
                                            </label>

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Spétialité</span>
                                                <input type="text" name="formation_spetialite[]" placeholder='Spécialité de la formation' class="brc8 cl2 col-10" value="<?= $elem->spetialite ?>"></input>
                                            </label>

                                        </div>

                                        <div class="flex">

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Daté de début</span>
                                                <input type="date" name="formation_debut[]" class="brc8 cl2 col-10" value="<?= $elem->debut ?>"></input>
                                            </label>

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Date de fin ( <input type="checkbox" name="specialite_f_fin[]" style="margin-left:10px;margin-bottom:0" <?php if (empty($elem->fin)) echo 'checked' ?> onchange="vider_date(this)" /> En cours )</span>
                                                <input type="date" name="formation_fin[]" placeholder='Spécialité de la formation' class="brc8 cl2 col-10" value="<?= $elem->fin ?>"></input>
                                            </label>

                                        </div>

                                        <div class="flex">

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Organisme de formation</span>
                                                <input type="text" name="formation_org[]" placeholder="MIT" class="brc8 cl2 col-10" value="<?= $elem->org ?>"></input>
                                            </label>

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Lieu</span>
                                                <input type="text" name="formation_adresse[]" placeholder='Massachusste, USA' class="brc8 cl2 col-10" value="<?= $elem->adresse ?>"></input>
                                            </label>

                                        </div>
                                        <?php 
                                           $cv.="Adresse du centre de la formation: $elem->adresse ,";
                                           $cv.="Organisme de la formation : $elem->org ,";
                                           $cv.="début de la formation : $elem->debut ,";
                                           $cv.="fin de la formation : $elem->fin ,";
                                           $cv.="la spécialité:$elem->spetialite ,";
                                           $cv.="Nom de la formation :$elem->name ,";
                                        ?>

                                        <span class="btn bg3 cl1" onclick="delete_parent(this, 'Formation')">Supprimer</span>

                                    </div>
                            <?php

                                }

                            endif

                            ?>


                        </div>

                        <script>
                            function delete_parent(t, elem) {

                                t.parentNode.style.opacity = '0.5'

                                setTimeout(function() {

                                    t.parentNode.style.display = 'none'

                                    t.parentNode.remove()

                                    gla_alert(elem + ' supprimée, cliquez sur le bouton enregistrer en bas de la page.')

                                }, 1000)



                            }

                            function vider_date(t) {

                                elem = t.parentNode.parentNode.querySelector("input.brc8")

                                if (t.checked) {

                                    elem.value = ''

                                    elem.setAttribute('disabled', 'true')

                                } else {

                                    elem.removeAttribute('disabled')

                                }

                            }
                        </script>

                        <span class="btn bg2 cl1" onclick="add_element('.formation_copy', '#formations')">Ajouter une formation</span>

                        <h2 class="mt30">Expérience</h2>

                        <label for="" class="col-48">
                            <span class="fz09 cl2 mb10 d-block">Années d'expérience (Ans)</span>
                            <input type="number" name="experience_year" placeholder="6" class="brc8 cl2 col-10" value="<?= $info->experience_year ?>"></input>
                        </label>

                        <label for="" class="col-48 mb20">
                            <span class="fz09 cl2 mb10 d-block">Mes expériences</span>
                        </label>

                        <div class="formations mb20" id="experience">

                            <?php

                            $experiences = json_decode(utf8_encode($info->experiences));

                            if (empty($experiences)) {

                            ?>

                                <div class="formation mb20 experience_copy">

                                    <div class="flex">

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Client</span>
                                            <input type="text" name="exp_name[]" placeholder="Nom du client" class="brc8 cl2 col-10"></input>
                                        </label>

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Poste occupé</span>
                                            <input type="text" name="exp_poste[]" placeholder='Senior Développeur back-end' class="brc8 cl2 col-10"></input>
                                        </label>

                                    </div>

                                    <div class="flex">

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Daté de début</span>
                                            <input type="date" name="exp_debut[]" class="brc8 cl2 col-10"></input>
                                        </label>

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Date de fin ( <input type="checkbox" name="specialite_f_fin[]" style="margin-left:10px;margin-bottom:0" <?php if (empty($elem->fin)) echo 'checked' ?> onchange="vider_date(this)" /> En cours )</span>
                                            <input type="date" name="exp_fin[]" class="brc8 cl2 col-10"></input>
                                        </label>

                                    </div>

                                    <label for="" class="col-10">
                                        <span class="fz09 cl2 mb10 d-block">Désciption de l'expérience</span>
                                        <textarea name="exp_desc[]" placeholder='Brève déscription ...' class="brc8 cl2 col-10"></textarea>
                                    </label>

                                    <div class="flex">

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Ville</span>
                                            <input type="text" name="exp_ville[]" placeholder="Paris" class="brc8 cl2 col-10"></input>
                                        </label>

                                        <label for="" class="col-48">
                                            <span class="fz09 cl2 mb10 d-block">Pays</span>
                                            <input type="text" name="exp_pays[]" placeholder='France' class="brc8 cl2 col-10"></input>
                                        </label>

                                    </div>

                                    <span class="btn bg3 cl1" onclick="delete_parent(this, 'Expérience')">Supprimer</span>

                                </div>

                                <?php

                            }

                            if ($experiences !== null) :

                                foreach ($experiences as $k => $elem) {

                                ?>

                                    <div class="formation mb20 experience_copy">

                                        <div class="flex">

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Client</span>
                                                <input type="text" name="exp_name[]" placeholder="Nom du client" class="brc8 cl2 col-10" value="<?= $elem->name ?>"></input>
                                            </label>

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Poste occupé</span>
                                                <input type="text" name="exp_poste[]" placeholder='Senior Développeur back-end' class="brc8 cl2 col-10" value="<?= $elem->poste ?>"></input>
                                            </label>

                                        </div>

                                        <div class="flex">

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Daté de début</span>
                                                <input type="date" name="exp_debut[]" class="brc8 cl2 col-10" value="<?= $elem->debut ?>"></input>
                                            </label>

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Date de fin ( <input type="checkbox" name="specialite_f_fin[]" style="margin-left:10px;margin-bottom:0" <?php if (empty($elem->fin)) echo 'checked' ?> onchange="vider_date(this)" /> En cours )</span>
                                                <input type="date" name="exp_fin[<?= $k ?>]" class="brc8 cl2 col-10" value="<?= $elem->fin ?>"></input>
                                            </label>

                                        </div>

                                        <label for="" class="col-10">
                                            <span class="fz09 cl2 mb10 d-block">Désciption de l'expérience</span>
                                            <textarea name="exp_desc[]" placeholder='Brève déscription ...' class="brc8 cl2 col-10"><?= $elem->desc ?></textarea>
                                        </label>

                                        <div class="flex">

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Ville</span>
                                                <input type="text" name="exp_ville[]" placeholder="Paris" class="brc8 cl2 col-10" value="<?= $elem->ville ?>"></input>
                                            </label>

                                            <label for="" class="col-48">
                                                <span class="fz09 cl2 mb10 d-block">Pays</span>
                                                <input type="text" name="exp_pays[]" placeholder='France' class="brc8 cl2 col-10" value="<?= $elem->pays ?>"></input>
                                            </label>

                                        </div>
                                        <?php 
                                            $cv.="nom du client : $elem->name,";
                                            $cv.="poste occupé : $elem->poste ,";
                                            $cv.="début de mission : $elem->debut,";
                                            $cv.="fin de mission : $elem->fin ,";
                                            $cv.="Désciption de l'expérience :$elem->desc,";
                                            $cv.="Ville de la mission :$elem->ville ,";
                                            $cv.="Ville de la mission :$elem->pays ,";
                                            
                                        ?>
                                        <span class="btn bg3 cl1" onclick="delete_parent(this, 'Expérience')">Supprimer</span>

                                    </div>

                            <?php

                                }

                            endif

                            ?>

                        </div>

                        <div class="mb30">
                            <span class="btn bg2 cl1" onclick="add_element('.experience_copy', '#experience')">Ajouter une expérience</span>
                        </div>

                        <input type="submit" name="submit" value="<?= $asset->text(38) ?>" class="btn bg3 brc3 brc1solid cl1 hover-brc2 hover-bg2 hover-cl1" />

                    </form>
                </div>
            </div>

        </div>
    </div>

</div>
<?php  $cv.="Fin de cv du candidat numéro $user->idU";?>
<?php \Root\Utilisateur::insertResumeCV($cv,$user->idU, $db);?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<script>
    function append_btn(t) {

        t.parentElement.parentElement.querySelector('input').click()

    }

    function add_element(element, parent) {

        element_copy = document.querySelector(element)
        parent_div = document.querySelector(parent)

        var new_element = document.createElement('div');
        new_element.className = element_copy.className
        new_element.innerHTML = element_copy.innerHTML

        new_element.querySelectorAll('input, textarea').forEach(function(el) {

            el.value = ''

        })

        parent_div.appendChild(new_element)

        if (parent == '#experience') {

            add_experience = add_experience + 1

            console.log(add_experience);

            if (add_experience > 3) {

                document.querySelector('#add_experience').style.display = 'none'

            }

        }

    }

    $(document).ready(function() {
        $('.js-langues, .js-geo, .js-metiers').select2();
    });
</script>

<script src="<?= Func::cache('theme/assets/js/session.js') ?>"></script>

