<?php
require "theme/control/ajax/calculTarif.php";
use Root\Utilisateur;


if (!isset($_SESSION['id']) || $_SESSION['type'] !== '1' || !isset($_GET['id'])) {

    Func::setFlash('error', "Veuillez vous connecter comme entreprise pour créer des ticktes");

    Func::redirect('connexion');
}

$email_validated = $db->select("email_val", "utilisateurs")->where("idU = ?")->find([$_SESSION['id']]);

$user_nom = "Anonyme";
$info_tarif = "";

if ($_GET['id'] !== '0') {

    $user = Utilisateur::userById($_GET['id'], $db);
    $info = Utilisateur::userCV($_GET['id'], $db);

    $user_nom = $user->nom;
    $info_tarif = $info->tarif;
}

if (isset($_POST['register']) && empty($email_validated->email_val)) \Root\Ticket::create($_GET['id'], $_POST, $db);
if (isset($_POST['registerIA']) && empty($email_validated->email_val)) {\Root\Ticket::createIA($_GET['id'], $_POST, $db);}

?>

<div class="content login bg6">

    <div class="c">

        <?= Func::getFlash() ?>

        <div class="flex ai-center pt100 pb40">

            <div class="box col-48 p30 m0a">
                <h2 class="h ta-center mb30 fw5"><?= $GLA->pageTitle() ?></h2>
                <form action="" method="POST" class="gla-form" id="formCreationTicket">

                    <label class="mb10">Freelancer</label>
                    <input type="text" name="nom" placeholder="Nom complet" required="true" value="<?= $user_nom ?>" disabled class="col-10 cl2 brc8" />

                    <label class="mb10">Tarif par jour (€) (Modifiable) *</label>
                    <input type="number" name="tarif" placeholder="Tarif ..." required="true" value="<?= calculerTarifJournalier($info->tarif)?>" class="col-10 cl2 brc8" min="0"/>
                    
                    <label class="mb10">Date de début de mission souhaité*</label>
                    <input type="date" name="debut" placeholder="Date de début ..." required="true" class="col-10 cl2 brc8" min='<?= date('Y-m-d') ?>' />

                    <label class="mb10">Durée de la mission (jours)*</label>
                    <input type="number" name="duree" placeholder="Durée ..." required="true" class="col-10 cl2 brc8" min='0' />

                    <label class="mb10">Adresse de la mission *</label>
                    <input type="text" name="adresse" placeholder="Adresse ..." required="true" class="col-10 cl2 brc8" />

                    <label class="mb10">Informations complémentaires *</label>
                    <textarea name="description" placeholder="Description de la mission" required="true" class="col-10 cl2 brc8"></textarea>

                    

                    <p class="fz07 cl2 mb20 mt20"><input type="checkbox" value="" required> J'accepte les <a href="conditions-gnrales-d-utilisation-professionnel">conditions générales d'utilisation professionnels</a></p>

                    <?php if (empty($email_validated->email_val)) { ?>
                        
                        <input type="submit" name="register" value="Créer le ticket" class="btn bg3 cl1 brc1solid brc3 hover-bg4 hover-cl2 hover-brc4" id="register" />
                      <!--  <input type="submit" name="registerIA" value="Utiliser l'IA pour parcourir les cvs" class="btn bg3 cl1 brc1solid brc3 hover-bg4 hover-cl2 hover-brc4" id="registerIA" /> -->
                        
                    <?php } else { ?>

                        <p class="error">Veuillez valider votre adresse email pour créer des tickets. <span class="closebtn" onclick="this.parentElement.style.display=&quot;none&quot;">×</span></p>

                    <?php } ?>

                </form>
            </div>

        </div>

    </div>

</div>

<script>
    // Fonction pour sauvegarder les données du formulaire dans localStorage
    function saveFormData() {
        var formElements = document.getElementById('formCreationTicket').elements;
        for (var i = 0; i < formElements.length; i++) {
            var elem = formElements[i];
            if (elem.name) localStorage.setItem(elem.name, elem.value);
        }
    }

    // Fonction pour restaurer les données du formulaire depuis localStorage
    function restoreFormData() {
        var formElements = document.getElementById('formCreationTicket').elements;
        for (var i = 0; i < formElements.length; i++) {
            var elem = formElements[i];
            if (elem.name && localStorage.getItem(elem.name)) {
                elem.value = localStorage.getItem(elem.name);
            }
        }
    }

    // Ajouter un écouteur d'événements pour enregistrer les données à chaque modification du formulaire
    document.getElementById('formCreationTicket').addEventListener('input', saveFormData);

    // Appeler restoreFormData au chargement de la page
    window.onload = restoreFormData;
</script>
