<?php

use Root\Utilisateur;

Func::session('../');

if (empty($_GET['ticket'])) Func::_404();

$user = \Root\Utilisateur::userById($_SESSION['id'], $db);

if (empty($user)) Func::_404();

$ticket = \Root\Ticket::getById($_GET['ticket'], $db);

$freelance = \Root\Utilisateur::userById($ticket->freelance, $db);

if (empty($ticket) || $ticket->entreprise !== $_SESSION['id']) Func::_404();

$dateComponents = getdate();

$month = $dateComponents['mon'];
$year = $dateComponents['year'];

$months_nbr = \Root\Cra::nbr_months($ticket->idT, $db);

if (isset($_POST['submit'])) \Root\Cra::add($ticket->idT, $_POST, $db);

?>

<div class="pg inf">

    <div class="c content">

        <div class="flex mb30" id="flash">



            <?php

            $selected = 'cra';

            include '_menu.php';

            ?>

            <div class="col-8 p20">

                <div class="pt30 pb30">
                    <h1><span class="icon">n</span> <?= $GLA->pageTitle() ?></h1>
                </div>

                <?= Func::getFlash() ?>

                <div class="box p20 mb20">

                    <h2>Mission : <?= $ticket->idT ?></h2>

                    <p>Description de la mission</p>
                    <br>
                    
                        <div>
                            
                            <textarea   name="description" placeholder="Contenu de la page" rows="8" style=" min-width:200px ; max-width:100% ;width:100%" ><?= $ticket->t_description ?></textarea>
                        </div>
                    </br>

                    <p>Offre <strong> <?= $ticket->t_tarif ?>€</strong></p>

                </div>

                <div class="box p20 mb20 print_d_b" style="display: none;">

                    <p class="mb20">Freelance : <?= $freelance->nom ?></p>
                    <p class="mb20">Email : <?= $freelance->email ?></p>
                    <p class="mb20">Numéro de téléphone : <?= $freelance->tele ?></p>
                    <p>Adresse : <?= $freelance->adresse ?></p>

                </div>

                <h3>Journées de travail</h3>

                <?php

                foreach ($months_nbr as $m) {

                    if ($m->month == $month && $m->year = $year) break;

                    echo "<div class='cra_table pb20'>";

                    $thismonth = \Root\Cra::work_month($ticket->idT, $m->month, $m->year, $db);

                    echo Root\Cra::build_calendar($m->month, $m->year, $thismonth);

                    echo Root\Cra::calcul_entreprise($ticket->t_tarif, $thismonth);

                    echo "<div class='mt30'>";

                    echo "<a href='" . WEBROOT . "facture-client.php?ticket=$ticket->idT&month=$m->month&year=$m->year' class='btn bg2 cl1 mt30'>Télécharger la facture de ce mois</a>";

                    echo "</div>";

                    echo "</div>";
                }

                ?>



                <form method="POST">

                    <?php

                    $thismonth = \Root\Cra::work_month($ticket->idT, $month, $year, $db);

                    echo Root\Cra::build_calendar($month, $year, $thismonth, true);

                    echo Root\Cra::calcul_entreprise($ticket->t_tarif, $thismonth);

                    ?>

                    <?php if (!$thismonth) { ?>

                        <p class="rem mt30">Le freelance n'as pas encore enregistré son CRA pour ce mois</p>

                    <?php } else { ?>

                        <p class="rem mt30">Le freelance à enregistré son CRA pour ce mois</p>

                    <?php } ?>

                </form>


                <div class="col-10 mt40">

                    <span class="btn bg3 cl1" onclick="window.print()">Imprimer le CRA</span>

                    <a href="<?= WEBROOT ?>facture-client.php?ticket=<?= $ticket->idT ?>&month=<?= $month ?>&year=<?= $year ?>" class="btn bg2 cl1 mt30" target='_blank'>Télécharger la facture de ce mois</a>

                </div>

            </div>

        </div>
    </div>

</div>

<script>
    function append_btn(t) {

        t.parentElement.parentElement.querySelector('input').click()

    }

    function open_cra(t) {

        t.parentElement.parentElement.classList.toggle('open_tab')

    }

    function selectDay(t, day, date, period) {

        return false

    }
</script>

<script src="<?= Func::cache('theme/assets/js/session.js') ?>"></script>


<style>
    @media print {

        header,
        footer,
        .command,
        .btn,
        .gla-home,
        h1 {
            display: none
        }

        .print_d_b {
            display: block !important
        }

        * {
            -webkit-print-color-adjust: exact
        }

    }
</style>