<?php

use Root\Utilisateur;

Func::session('../');

if (empty($_GET['ticket'])) Func::_404();

$user = \Root\Utilisateur::userById($_SESSION['id'], $db);

if (empty($user)) Func::_404();

$ticket = \Root\Ticket::getById($_GET['ticket'], $db);

$freelance = \Root\Utilisateur::userById($ticket->freelance, $db);

if (empty($ticket) || $ticket->entreprise !== $_SESSION['id']) Func::_404();

$hno = \Root\Cra::cra_hno($ticket->idT, $db);

?>

<div class="pg inf">

    <div class="c content">

        <div class="flex mb30" id="flash">

            <?php

            $selected = 'cra';

            include '_menu.php';

            ?>

            <div class="col-8 p20">

                <div class="pt30 pb30">
                    <h1><span class="icon">n</span> <?= $GLA->pageTitle() ?></h1>
                </div>

                <?= Func::getFlash() ?>

                <div class="box p20 mb20">

                    <h2>Mission : <?= $ticket->idT ?></h2>

                    <p>Mois : Juillet</p>

                </div>

                <div class="box p20 mb20 print_d_b" style="display: none;">

                    <p class="mb20">Freelance : <?= $freelance->nom ?></p>
                    <p class="mb20">Email : <?= $freelance->email ?></p>
                    <p class="mb20">Numéro de téléphone : <?= $freelance->tele ?></p>
                    <p>Adresse : <?= $freelance->adresse ?></p>

                </div>

                <h3>CRA HNO</h3>

                <?php

                foreach ($hno as $k => $h) {

                    $date_d = strtotime($h->date_d);
                    $date_f = strtotime($h->date_f);

                    $date_d_d = new DateTime($h->date_d);
                    $date_f_d = new DateTime($h->date_f);

                    $interval = $date_d_d->diff($date_f_d);
                    $diff = '';

                    if ($interval->d !== 0) {
                        $diff .= "<strong>$interval->d</strong> jours, <strong>$interval->h</strong> heures et <strong>$interval->i</strong> minutes";
                    } else {
                        $diff .= "<strong>$interval->h</strong> heures et <strong>$interval->i</strong> minutes";
                    }

                    $astreinte = ($h->astreinte !== '0') ? "<span class='cl4'>(Astreinte)</span>" : "";

                    echo "<div class='box p10 mb10'>";

                    echo "<p>" . ($k + 1) . ") $astreinte De <strong>" . date('H:i - D d', $date_d) . "</strong> à <strong>" . date('H:i - D d', $date_f) . "</strong>, Durée du travail : $diff</p>";

                    if (!empty($h->note)) echo "<p class='rem mt10'>Note : $h->note</p>";

                    echo "</div>";
                }

                ?>

                <div class="col-10 mt40">

                    <span class="btn bg3 cl1" onclick="window.print()">Imprimer le CRA HNO</span>

                </div>

            </div>

        </div>

    </div>

</div>

<script src="<?= Func::cache('theme/assets/js/session.js') ?>"></script>

<style>
    @media print {

        header,
        footer,
        .command,
        .btn,
        .gla-home,
        h1 {
            display: none
        }

        .print_d_b {
            display: block !important
        }

    }
</style>