<?php

$mission = $GLA->missionInfos();
$user = $GLA->missionUser($mission->user);

if (isset($_POST['commander']) && isset($_SESSION['session']) && $_SESSION['type'] == 1 and $mission->stt == '0') \Root\Commandes::addOffer($mission->idC, $user->nom, $_POST, $db);

if (isset($_SESSION['session']) and $_SESSION['type'] == 1) {

    $offer = $GLA->missionOfferSent($mission->idC);

    $userPro = Root\Utilisateur::userById($_SESSION['id'], $db);
}

?>

<div class="single content">

    <div class="c4" style="background-image:url(<?="'".WEBROOT."theme/assets/img/large/".$asset->pic(19)."'"?>)">

        <div class="back p50" >

            <h1 class="cl1 ta-center col-6 m0a"><?= $mission->titre ?></h1>

        </div>

    </div>

    <div class="c mt40 mb40">

        <div class="flex">

            <div class="col-7 mission_content">

                <h1 class="mb20"><?= $mission->titre ?></h1>

                <p><span class="icon">è</span> <?= $mission->postal ?> le <?= date("d/m/Y", strtotime($mission->jour)) ?> à <?= date("H:i", strtotime($mission->heure)) ?></p>

                <div class="box mt30 p30">

                    <p>Service : <?= $GLA->missionCategorie($mission->service) ?></p>

                    <h3>Description du service</h3>

                    <p><?= $mission->description ?></p>

                    <h3>Rénumération du service</h3>

                    <span class="fz2"><?= $mission->duree ?> heures pour <?= $mission->prix ?> € / heure + Frais</span>

                    <div class="flex ai-center">
                        <div class="bg8 col-4 p10 mt20 box">
                            <span>Total TTC <span class="fw_b"><?= $mission->total ?></span> €</span>
                        </div>

                        <?php if ($mission->stt == '0') { ?>
                            <div class="mt30">
                                <span class="btn bg3 cl1" onclick="body.classList.toggle('commander');">Proposer mes services</span>
                            </div>
                        <?php } else { ?>

                            <p class="cl3">Mission clôturée, impossible de faire une offre</p>

                        <?php } ?>
                    </div>

                </div>

                <?= Func::getFlash() ?>

            </div>

            <div class="col-3 mission_side">

                <div class="ta-center p20">

                    <?= Func::avatar($user->avatar, 'bg3') ?>

                    <h2><?= $user->nom ?></h2>

                    <div class="mt20 bg6 brc1solid brc8 br8 p20 cl2">

                        <span><?= $asset->text(20) ?></span>

                        <div class="share mt20">

                            <span class="icon fb mr5 fz2 hover-cl3" data-n="fb">z</span>
                            <span class="icon pin mr5 fz2 hover-cl3" data-n="pin">à</span>
                            <span class="icon tw fz2 hover-cl3" data-n="tw">ç</span>

                        </div>

                    </div>

                </div>

            </div>


        </div>

    </div>

    <div class="commande_s p50">

        <div class="pos-r">
            <div class="col-6 m0a bg1 br8 p40 ">

                <?php if (isset($offer) and $offer == true) { ?>

                    <p class="bg8 p30 box">Vous avez déja envoyé une offre à cette mission</p>

                <?php } else { ?>

                    <h3>Proposer une offre</h3>

                    <form method='POST' class="gla-form">

                        <div class="flex">

                            <div class="col-5 p10">

                                <label>Prix de l'heure (€)</label>

                                <div class="flex m_p_btns jc-start mt10 mb20">
                                    <span class="bg3 cl1" onclick="moin('prix', true)">-</span>
                                    <input type="text" name='prix' placeholder="Nombre d'heures de travail" value="<?= $mission->prix ?>" class="col-4 ta-center" id="prix" <?php Func::value('prix') ?>>
                                    <span class="bg3 cl1" onclick="plus('prix', true)">+</span>
                                </div>
                            </div>

                            <div class="col-5 p10">

                                <label>TVA</label>

                                <select name="tva" id="tva" class="mt10" onchange="_tva(this)">
                                    <option value="0">0% (Si vous êtes auto entrepreneur)</option>
                                    <option value="2.1">2.1%</option>
                                    <option value="5.5">5.5%</option>
                                    <option value="7">7%</option>
                                    <option value="10">10%</option>
                                    <option value="20">20% (TVA soumis au taux normal)</option>
                                </select>

                            </div>

                        </div>

                        <input type="hidden" name="duree" value="<?= $mission->duree ?>">
                        <input type="hidden" name="commission" value="<?= $mission->commission ?>" id="commission_input">
                        <input type="hidden" name="commission_tva" value="<?= $mission->tva_commission ?>" id="commission_tva_input">
                        <input type="hidden" name="tva_per" value="0" id="tva_per_input">
                        <input type="hidden" name="tva_prix" value="0" id="tva_prix_input">
                        <input type="hidden" name="total" value="<?= $mission->total ?>" id="total_input">

                        <div>

                            <p class="mb20">TVA (<span id="tva_per">0</span>%) : <span id="tva_prix">0</span> €</p>

                            <p class="mb20">Commission HT : <span class="fw_b" id="commission"><?= $mission->commission ?></span> €</p>
                            <p class="mb20">Commission TVA 20% : <span class="fw_b" id="commission_tva"><?= $mission->tva_commission ?></span> €</p>
                            <p class="mb20">Commission TTC : <span class="fw_b" id="commission_ttc"><?= $mission->commission + $mission->tva_commission ?></span> €</p>

                            <p class="mb20">Le montant TTC de la prestaion est de <span class="fw_b" id="prix_text"><?= $mission->total ?></span> € pour <span class="fw_b" id="duree_text"><?= $mission->duree ?></span> heures de travail</p>

                            <?php if (isset($_SESSION['session']) && $_SESSION['type'] == 1) { ?>

                                <div class="bg8 p20">
                                    <p class="mb20">Vous allez passer cette commande sous le nom <span class="fw_b"><?= $_SESSION['name'] ?></span>, adresse email <span class="fw_b"><?= $_SESSION['email'] ?></span> et numéro de téléphone <span class="fw_b"><?= $_SESSION['tele'] ?></span></p>

                                    <div class="mb20">
                                        <p>Entreprise : <?= $userPro->entreprise ?></p>
                                        <p>SIREN : <?= $userPro->siren ?></p>
                                        <p>TVA : <?= $userPro->tva ?></p>
                                    </div>
                                    <div><a href="<?= WEBROOT ?>page/information" class="cl3">Modifier mes informations</a></div>
                                </div>

                                <input type="submit" name="commander" value="Envoyer ma proposition" class="btn bg3 cl1 mt20 brc3">

                            <?php } else { ?>

                                <p class="bg8 p20"><a href="<?= WEBROOT ?>page/connexion?r=mission/<?= $mission->idC ?>" class="cl3">Connectez vous</a> en tant que professionnel pour proposer votre offre à <?= $user->nom ?></p>

                            <?php } ?>

                        </div>

                    </form>

                <?php } ?>
        
            </div>
        </div>

        <span class="bg1 close cl2 p10 br8" onclick="body.classList.toggle('close-commander');">
            <span class="icon">m</span>
        </span>

    </div>

</div>

<script>
    var duree = <?= $mission->duree ?>;
    var prix = <?= $mission->prix ?>;
    var tva_per = 0;
    var tva_prix = 0
</script>

<script src="<?= Func::cache('theme/assets/js/single.js') ?>"></script>