<?php

$json = json_decode($entreprise->etape2);

?>

<div class="box p20">

    <h2>Etape 2 : Lancement de la création d’entreprise</h2>

    <p class="mb20">Nous transmettre les informations suivantes :</p>

    <form method="post" class="mb20 gla-form col-6" enctype="multipart/form-data">

        <div class="mb10">
            <label class="mb10">Pièce d’identité recto verso (pdf)</label>

            <?php

            if (!empty($json->identite_file)) {
                echo "<a href='" . WEBROOT . "theme/assets/files/$json->identite_file' target='_blank' class='cl4'>Ma pièce d’identité (PDF)</a><br><br>";
            }

            ?>

            <?php if ($json->succes == false) : ?>
                <input type="file" name='identite_file' class="col-10" required accept="application/pdf" onchange="upload(this, 'identite_file', 2)">
            <?php endif ?>
        </div>

        <div class="mb10">
            <label class="mb10">Justificatif de domicile de 3 mois de type électricité EDF, ENGIE ... (pdf)</label>

            <?php

            if (!empty($json->justificatif_file)) {
                echo "<a href='" . WEBROOT . "theme/assets/files/$json->justificatif_file' target='_blank' class='cl4'>Mon Justificatif de domicile (PDF)</a><br><br>";
            }

            ?>

            <?php if ($json->succes == false) : ?>

                <input type="file" name='justificatif_file' class="col-10" required accept="application/pdf" onchange="upload(this, 'justificatif_file', 2)">

                <?php if (isset($json->message)) echo "<p class='error'>$json->message</p>"; ?>
                
            <?php endif ?>
        </div>

        <p class="rem mb20">* Une fois cette étape validé ces fichiers seront supprimés</p>

        <?php if ($json->succes == true) : ?>
            <p class='succes'>Ces informations ont été validés</p>
        <?php endif ?>

    </form>

    <div class="flex mt40">
        <a href="?etape=1" class="btn bg3 cl1">Etape précédente</a>
        <a href="?etape=3" class="btn bg3 cl1">Etape suivante</a>
    </div>

</div>