<?php

if (!empty($entreprise->etape1)) {
    $json = json_decode($entreprise->etape1);
} else {
    $json = [];
}
//$user = \Root\Utilisateur::userById($_SESSION['id'], $db);
?>
    
<div class="box p20">

    <h2>Etape 1 : Rendez-vous avec notre parteanaire FIPARCO <img class="logo-fiparco"  src="https://www.laotop.fr/theme/assets/img/large/fiparco-logo.png" ></h2>

    <p>Pour commencer la création de votre entreprise merci de suivre les étapes ci-dessous :</p>

    <ul class="ul_li mt30 mb40">
        <li>Etape 1: Remplir toutes les informations ci-dessous</li>
        <li>Etape 2: Cliquez sur enregistrer</li>
        <li>Etape 3: Choisir une date pour un premier rendez-vous avec l'expert comptale</li>
        <li>Etape 4: Attendre la fin de votre rendez-vous et la validation du comptable pour passer à l'étape suivante</li>
        
    </ul>

    <div class="mb30">
        
    
    </div>

    <p class="pre mb20">Veuillez remplir ses informations pour obtenir un rendez-vous</p>

    <form method="post" class="mb20 gla-form col-6" id="formRemplirFormulaire">

        <h3>Situation personnelle</h3>

        <div class="mb20">
            <label class="mb10">Nom</label>
            <input type="text" name='nom' placeholder="Nom ..." class="col-10" required <?php if (isset($json->nom)) echo 'value="' . $json->nom . '"'; ?>>
        </div>

        <div class="mb20">
            <label class="mb10">Prénom</label>
            <input type="text" name='prenom' placeholder="Prénom ..." class="col-10" required <?php if (isset($json->prenom)) echo 'value="' . $json->prenom . '"'; ?>>
        </div>

        <div class="mb20">
            <label class="mb10">Date de naissance</label>
            <input type="date" name='naissance' placeholder="Date de naissance ..." class="col-10" required <?php if (isset($json->naissance)) echo 'value="' . $json->naissance . '"'; ?> max="2013-01-01" min="1920-01-01">
        </div>

        <div class="mb20">
            <label class="mb10">Situation familiale</label>
            <select name="situation" class="col-10">
                <option <?php if (isset($json->situation) && $json->situation == 'Célibataire') echo 'selected'; ?>>Célibataire</option>
                <option <?php if (isset($json->situation) && $json->situation == 'Marié') echo 'selected'; ?>>Marié</option>
            </select>
        </div>

        <div class="mb20">
            <label class="mb10">Nombre d'enfants</label>
            <input type="number" name='enfants' placeholder="Nombre d'enfants ..." class="col-10" required <?php if (isset($json->enfants)){echo 'value="' . $json->enfants . '"';}else{echo "value='0'";}; ?> min="0">
        </div>

        <div class="mb20">
            <label class="mb10">Email</label>
            <input type="text" name='email' placeholder="Email ..." class="col-10" required <?php if (isset($json->email)) echo 'value="' . $json->email . '"'; ?>>
        </div>

        <div class="mb20">
            <label class="mb10">Numéro de téléphone</label>
            <input type="text" name='telephone' placeholder="Numéro de téléphone ..." class="col-10" required <?php if (isset($json->telephone)) echo 'value="' . $json->telephone . '"'; ?>>
        </div>

        <h3>Situation professionnelle</h3>

        <div class="mb20">
            <label class="mb10">Situation professionnelle actuelle</label>
            <select name="situation_actuelle" class="col-10">
                <option <?php if (isset($json->situation_actuelle) && $json->situation_actuelle == 'Chômage sans indemnité') echo 'selected'; ?>>Chômage sans indemnité</option>
                <option <?php if (isset($json->situation_actuelle) && $json->situation_actuelle == 'Chômage avec des indemnités salarié') echo 'selected'; ?>>Chômage avec des indemnités salarié</option>
                <option <?php if (isset($json->situation_actuelle) && $json->situation_actuelle == 'Sans emploi') echo 'selected'; ?>>Sans emploi</option>
                <option <?php if (isset($json->situation_actuelle) && $json->situation_actuelle == 'Freelance') echo 'selected'; ?>>Freelance</option>
                <option <?php if (isset($json->situation_actuelle) && $json->situation_actuelle == 'Autre') echo 'selected'; ?>>Autre</option>
            </select>
        </div>

        <div class="mb20">
            <label class="mb10">Avez-vous déjà un client</label>
            <select name="client" class="col-10">
                <option <?php if (isset($json->client) && $json->client == 'Non') echo 'selected'; ?>>Non</option>
                <option <?php if (isset($json->client) && $json->client == 'Oui') echo 'selected'; ?>>Oui</option>
            </select>
        </div>

        <div class="mb20">
            <label class="mb10">Avez-vous une autre entreprise ?</label>
            <select name="autre_entreprise" class="col-10" onchange="activate_option(this, 'Oui', ['nombre_entreprises', 'statuts_entreprises'])">
                <option <?php if (isset($json->autre_entreprise) && $json->autre_entreprise == 'Non') echo 'selected'; ?>>Non</option>
                <option <?php if (isset($json->autre_entreprise) && $json->autre_entreprise == 'Oui') echo 'selected'; ?>>Oui</option>
            </select>
        </div>

        <div class="mb20">
            <label class="mb10">Nombre d'entreprises</label>
            <input type="number" name='nombre_entreprises' placeholder="Nombre d'entreprises ..." class="col-10" <?php if (isset($json->nombre_entreprises)){echo 'value="' . $json->nombre_entreprises . '"';}else{echo "disabled";}; ?> id='nombre_entreprises' min="0">
        </div>

        <div class="mb20">
            <label class="mb10">Statuts de vos entreprises</label>
            <input type="text" name='statuts_entreprises' placeholder="SAS, Auto Entrepreneur ... ..." class="col-10" <?php if (isset($json->statuts_entreprises)){echo 'value="' . $json->statuts_entreprises . '"';}else{echo "disabled";}; ?> id="statuts_entreprises">
        </div>

        <h3>Entreprise</h3>

        
        <div class="mb20">
            <label class="mb10">Quel nom choisissez-vous pour votre entreprise</label>
            <input type="text" name='entreprise_name' placeholder="Nom de votre entreprise ..." class="col-10" required <?php if (isset($json->entreprise_name)) echo 'value="' . $json->entreprise_name . '"'; ?>>
        </div>

        <div class="mb20">
            <label class="mb10">Dans quelle date souhaitez-vous créer votre entreprise</label>
            <input type="date" name='date_creation' placeholder="Date de création de l'entreprise ..." class="col-10" required <?php if (isset($json->date_creation)) echo 'value="' . $json->date_creation . '"'; ?> min="<?= date('Y-m-d') ?>">
        </div>

        <div class="mb20">
            <label class="mb10">Estimation de chiffre d'affaires la première année</label>
            <input type="number" name='chiffre_affaires' placeholder="Chiffre d'affaires ..." class="col-10" <?php if (isset($json->chiffre_affaires)){echo 'value="' . $json->chiffre_affaires . '"';}; ?> min="0">
        </div>

        <div class="mb20">
            <label class="mb10">Combien y a-t-il d’associés fondateurs</label>
            <input type="number" name='nombre_associes' placeholder="Nombre d'associés ..." class="col-10" <?php if (isset($json->nombre_associes)){echo 'value="' . $json->nombre_associes . '"';}; ?> min="0">
        </div>

        <div class="mb20">
            <label class="mb10">Capital social (minimum 1 euro)</label>
            <input type="number" name='capital_social' placeholder="Capital social ..." class="col-10" <?php if (isset($json->capital_social)){echo 'value="' . $json->capital_social . '"';}; ?> min="0">
        </div>

        <div class="mb20">
            <label class="mb10">Où sera fixé le siège social de la société</label>
            <input type="text" name='siege_social' placeholder="Siège social ..." class="col-10" required <?php if (isset($json->siege_social)) echo 'value="' . $json->siege_social . '"'; ?>>
        </div>

        <div class="mb20">
            <label class="mb10">Avez-vous déjà mandaté un expert-comptable pour effectuer votre comptabilité annuelle</label>
            <select name="autre_comptable" class="col-10">
                <option <?php if (isset($json->autre_comptable) && $json->autre_comptable == 'Non') echo 'selected'; ?>>Non</option>
                <option <?php if (isset($json->autre_comptable) && $json->autre_comptable == 'Oui') echo 'selected'; ?>>Oui</option>
            </select>
        </div>
         <!-- <h3>Rendez-vous avec un expert comptable</h3>-->
   <!-- Début de widget de lien Calendly -->
<!--<link href="https://assets.calendly.com/assets/external/widget.css" rel="stylesheet">-->
<!--<script src="https://assets.calendly.com/assets/external/widget.js" type="text/javascript" async></script>-->
<!--<a href="" onclick="Calendly.initPopupWidget({url: 'https://calendly.com/laotop/creation-d-entreprise?hide_gdpr_banner=1&text_color=eb3768&primary_color=29182f'});return false;">Je prends un rendez-vous avec l'expert comptable partenaire</a>-->
<!-- Fin de widget de lien Calendly -->


        <?php if (isset($json->succes) && $json->succes == true) { ?>
            <p class='succes'>Ces informations ont été validés</p>
        <?php } else { ?>

            <?php if (isset($json->message)) echo "<p class='error'>$json->message</p>"; ?>

            <input type="submit" name="submit_etape_1" class="btn bg4 cl1 brc4 brc1solid" value="Enregistrer">

        <?php } ?>

    </form>

    <div class="flex mt40">
        <span></span>

        <a href="?etape=1.5" class="btn bg3 cl1">Etape suivante, Paiement</a>
    </div>

</div>

<script>

    function activate_option(t, value, elements){

        elements.forEach(el => {

            if(t.value !== value){

                document.querySelector('#' + el).setAttribute('disabled', true)

            }else{

                document.querySelector('#' + el).removeAttribute('disabled', true)

            }

        })

    }

    document.querySelectorAll('input, select').forEach(i => {if(i.value !== '') i.style.fontWeight='bold'})

</script>
<script>
    // Fonction pour sauvegarder les données du formulaire dans localStorage
    function saveFormData() {
        var formElements = document.getElementById('formRemplirFormulaire').elements;
        for (var i = 0; i < formElements.length; i++) {
            var elem = formElements[i];
            if (elem.name) localStorage.setItem(elem.name, elem.value);
        }
    }

    // Fonction pour restaurer les données du formulaire depuis localStorage
    function restoreFormData() {
        var formElements = document.getElementById('formRemplirFormulaire').elements;
        for (var i = 0; i < formElements.length; i++) {
            var elem = formElements[i];
            if (elem.name && localStorage.getItem(elem.name)) {
                elem.value = localStorage.getItem(elem.name);
            }
        }
    }

    // Ajouter un écouteur d'événements pour enregistrer les données à chaque modification du formulaire
    document.getElementById('formRemplirFormulaire').addEventListener('input', saveFormData);

    // Appeler restoreFormData au chargement de la page
    window.onload = restoreFormData;
</script>
   <!-- Début de widget de lien Calendly -->
   <link href="https://assets.calendly.com/assets/external/widget.css" rel="stylesheet">
<script src="https://assets.calendly.com/assets/external/widget.js" type="text/javascript" async></script>
<?php if (isset($_SESSION['calendly_triggered']) && $_SESSION['calendly_triggered']): ?>
<script>
    window.onload = function() {
        Calendly.initPopupWidget({url: 'https://calendly.com/laotop/creation-d-entreprise?hide_gdpr_banner=1&text_color=eb3768&primary_color=29182f'});
    };
</script>
<?php 
    // Réinitialiser l'indicateur pour éviter de déclencher Calendly à nouveau lors d'un rafraîchissement de page
    $_SESSION['calendly_triggered'] = false;
endif; 
?>
