<?php

if (!isset($_GET['entreprise'])) Func::_404();

use Root\Comptable;
use Root\Entreprise;

$entreprise = Entreprise::getById($_GET['entreprise'], $db);

$user = $db->select('nom, email, tele', 'utilisateurs')->where('idU = ?')->find([$entreprise->user]);

if (isset($_POST['submit_etape_6'])) Comptable::submit_etape_6($entreprise->idE, $user->email, $user->nom, $_POST, $db);

?>

<div class="c pb100 page_page c0">

    <div class="col-10 mb20 flex">
        <a href="<?= WEBROOT ?>page/comptable" class="btn bg4 cl1">Accueil</a>
        <a href="<?= WEBROOT ?>page/logout" class="btn bg3 cl1"><span class="icon">s</span> Déconnexion</a>
    </div>

    <div class="box p20 mb20">

        <h1 class="mb20">Création de l'entreprise N° <?= $entreprise->idE ?></h1>

        <p class="mb10">Utilisateur : <strong><?= $user->nom ?></strong></p>
        <p class="mb10">Email : <strong><?= $user->email ?></strong></p>
        <p class="mb10">Téléphone : <strong><?= $user->tele ?></strong></p>
        <p class="mb10">Date de demande : <strong><?= $entreprise->created_at ?></strong></p>

    </div>

    <div class="box p20 mb20" id="etape1">

        <h4 class="mb20">Etape 1 (Informations freelances)</h4>

        <?php

        if (!empty($entreprise->etape1) && $entreprise->etape >= 1) {

            $json = json_decode($entreprise->etape1);

            echo "<ul class='mb30'>";

            echo "<h4 class='mb30'>Situation personnelle</h4>";
            echo "<li class='mb10'>Nom : <strong>$json->nom</strong></li>";
            echo "<li class='mb10'>Prénom : <strong>$json->prenom</strong></li>";
            echo "<li class='mb10'>Date de naissance : <strong>$json->naissance</strong></li>";
            echo "<li class='mb10'>Situation familiale : <strong>$json->situation</strong></li>";
            echo "<li class='mb10'>Nombre d'enfants : <strong>$json->enfants</strong></li>";
            echo "<li class='mb10'>Email : <strong>$json->email</strong></li>";
            echo "<li class='mb10'>Numéro de téléphone : <strong>$json->telephone</strong></li>";
            echo "<h4 class='mb20 mt30'>Situation professionnelle</h4>";
            echo "<li class='mb10'>Situation professionnelle actuelle : <strong>$json->situation</strong></li>";
            echo "<li class='mb10'>Avez-vous déjà un client : <strong>$json->client</strong></li>";
            echo "<li class='mb10'>Avez-vous une autre entreprise ? : <strong>$json->autre_entreprise</strong></li>";
            echo "<li class='mb10'>Nombre d'entreprises : <strong>$json->nombre_entreprises</strong></li>";
            echo "<li class='mb10'>Statuts de vos entreprises : <strong>$json->statuts_entreprises</strong></li>";
            echo "<h4 class='mt30 mb20'>Entreprise</h4>";
            echo "<li class='mb10'>Quel nom choisissez-vous pour votre entreprise : <strong>$json->entreprise_name</strong></li>";
            echo "<li class='mb10'>Dans quelle date souhaitez-vous créer votre entreprise : <strong>$json->date_creation</strong></li>";
            echo "<li class='mb10'>Estimation de chiffre d'affaires la première année : <strong>$json->chiffre_affaires</strong></li>";
            echo "<li class='mb10'>Combien y a-t-il d’associés fondateurs : <strong>$json->nombre_associes</strong></li>";
            echo "<li class='mb10'>Capital social (minimum 1 euro) : <strong>$json->capital_social</strong></li>";
            echo "<li class='mb10'>Où sera fixé le siège social de la société : <strong>$json->siege_social</strong></li>";
            echo "<li class='mb10'>Avez-vous déjà mandaté un expert-comptable pour effectuer votre comptabilité annuelle : <strong>$json->autre_comptable</strong></li>";

            echo "</ul>";

            if (!$json->succes) {

                if (isset($json->message)) echo "<p class='error'>$json->message</p>";

                echo "<div class='flex'><span class='btn bg3 cl1' onclick='erreur(this, $entreprise->idE, 1)'>Envoyer un message d'erreur</span> <span class='btn bg4 cl1' onclick=\"validate($entreprise->idE, 'etape1', 1.5)\">Valider cette étape</span></div>";
            }
        } else {
            echo "<p class='rem'>Cette étape n'est pas encore été remplis</p>";
        }

        ?>

    </div>

    <div class="box p20 mb20" id="etape2">

        <h4 class="mb20">Etape 2 (Justificatifs)</h4>

        <?php

        if (!empty($entreprise->etape2) && $entreprise->etape >= 2) {

            $json = json_decode($entreprise->etape2);

            echo "<ul class='mb30'>";
            if (!empty($json->identite_file)) echo "<li class='mb10'>Pièce d'identité : <strong><a href='" . WEBROOT . "theme/assets/files/$json->identite_file' target='_blank' class='cl4'>Pièce d’identité (PDF)</a></strong></li>";
            if (!empty($json->justificatif_file)) echo "<li>Justificatif de domicile : <strong><a href='" . WEBROOT . "theme/assets/files/$json->justificatif_file' target='_blank' class='cl4'>Mon Justificatif de domicile (PDF)</a></strong></li>";
            echo "</ul>";


            if (!$json->succes) {

                echo "<p><input type='checkbox' onchange='show_btn(this)' /> J'ai téléchargé les fichiers</p>";

                if (isset($json->message)) echo "<p class='error'>$json->message</p>";

                echo "<div class='flex'><span class='btn bg3 cl1' onclick='erreur(this, $entreprise->idE, 2)'>Envoyer un message d'erreur</span> <span class='btn bg4 cl1' onclick=\"validate($entreprise->idE, 'etape2', 3)\" id='_etape_2_btn' style='display:none'>Valider cette étape</span></div>";
            }
        } else {
            echo "<p class='rem'>Cette étape n'est pas encore été remplis</p>";
        }

        ?>

    </div>

    <script>
        function show_btn(t) {

            console.log(document.querySelector('#_etape_2_btn'))

            if (t.checked) {
                document.querySelector('#_etape_2_btn').style.display = 'block'
            } else {
                document.querySelector('#_etape_2_btn').style.display = 'none'
            }

        }
    </script>

    <div class="box p20 mb20" id="etape4">

        <h4 class="mb20">Etape 4 (Attestation dépôt capital)</h4>

        <?php

        if (!empty($entreprise->etape4) && $entreprise->etape >= 4) {

            $json = json_decode($entreprise->etape4);

            echo "<ul class='mb30'>";
            if (!empty($json->attestation_depot_file)) echo "<li class='mb10'>Attestation de dépot : <strong><a href='" . WEBROOT . "theme/assets/files/$json->attestation_depot_file' target='_blank' class='cl4'>Attestation de dépot (PDF)</a></strong></li>";
            echo "</ul>";

            if (!$json->succes) {

                if (isset($json->message)) echo "<p class='error'>$json->message</p>";

                echo "<div class='flex'><span class='btn bg3 cl1' onclick='erreur(this, $entreprise->idE, 4)'>Envoyer un message d'erreur</span> <span class='btn bg4 cl1' onclick=\"validate($entreprise->idE, 'etape4', 5)\">Valider cette étape</span></div>";
            }
        } else {
            echo "<p class='rem'>Cette étape n'est pas encore été remplis</p>";
        }

        ?>

    </div>

    <div class="box p20 mb20" id="etape5">

        <h4 class="mb20">Etape 5 (Kbis)</h4>

        <?php

        if (!empty($entreprise->etape5) && $entreprise->etape >= 5) {

            $json = json_decode($entreprise->etape5);

            echo "<ul class='mb30'>";
            if (!empty($json->kbis_file)) echo "<li class='mb10'>Kbis : <strong><a href='" . WEBROOT . "theme/assets/files/$json->kbis_file' target='_blank' class='cl4'>Kbis (PDF)</a></strong></li>";
            echo "</ul>";

            if (!$json->succes) {

                if (isset($json->message)) echo "<p class='error'>$json->message</p>";

                echo "<div class='flex'><span class='btn bg3 cl1' onclick='erreur(this, $entreprise->idE, 5)'>Envoyer un message d'erreur</span> <span class='btn bg4 cl1' onclick=\"validate($entreprise->idE, 'etape5', 6)\"><span class='btn bg4 cl1' onclick=\"validate($entreprise->idE, 'etape5', 6)\">Valider cette étape</span></div>";
            }
        } else {
            echo "<p class='rem'>Cette étape n'est pas encore été remplis</p>";
        }

        ?>

    </div>

    <div class="box p20 mb20" id="etape6">

        <h4 class="mb20">Etape 6 (les accés à l'espace cloud)</h4>

        <?= Func::getFlash() ?>

        <?php if (!empty($entreprise->etape6) && $entreprise->etape >= 6) {

            $json = json_decode($entreprise->etape6);

            $etape1 = json_decode($entreprise->etape1);

        ?>

            <form method="POST" class="gla-form">

                <h5 class="mb20">ACCÈS ESPACE PRO CLIENT</h5>

                <div class="flex">

                    <label for="" class="col-48">
                        <span class="fz09 cl2 mb10 d-block">Login</span>
                        <input type="text" name="login" placeholder="Login ..." class="brc8 cl2 col-10" required value="<?= $json->login ?>">
                    </label>

                    <label for="" class="col-48">
                        <span class="fz09 cl2 mb10 d-block">Mot de passe</span>
                        <input type="text" name="motdepasse" placeholder="Mot de passe ..." class="brc8 cl2 col-10" required value="<?= $json->motdepasse ?>">
                    </label>

                </div>

                <p class="rem">Ces informations et le mot de passe vont être envoyés à l'adresse email <strong><?= $user->email ?></strong></p>

                <label for="" class="col-10 mt20">
                    <span class="fz09 cl2 mb10 d-block">URL du compte</span>
                    <input type="text" name="url" placeholder="Url ..." class="brc8 cl2 col-10" required value="<?= $json->url ?>">
                </label>

                <input type="hidden" name="email" value="<?= $etape1->email ?>">

                <div class="col-2">
                    <input type="submit" name="submit_etape_6" value="Envoyer" class="btn bg4 cl1 brc4 brc1solid">
                </div>

            </form>

        <?php

        } else {
            echo "<p class='rem'>Cette étape n'est pas encore été remplis</p>";
        }

        ?>

    </div>

    <div class="box p20 mb20" id="etape7">

        <h4 class="mb20">Etape 7 (Assurance professinelle)</h4>

        <?php

        if (!empty($entreprise->etape7) && $entreprise->etape >= 7) {

            $json = json_decode($entreprise->etape7);

            echo "<ul class='mb30'>";
            if (!empty($json->assurance)) echo "<li class='mb10'>Assurance professionnelle : <strong><a href='" . WEBROOT . "theme/assets/files/$json->assurance' target='_blank' class='cl4'>Assurance (PDF)</a></strong></li>";
            echo "</ul>";

            if (!$json->succes) {

                if (isset($json->message)) echo "<p class='error'>$json->message</p>";

                echo "<div class='flex'><span class='btn bg3 cl1' onclick='erreur(this, $entreprise->idE, 7)'>Envoyer un message d'erreur</span> <span class='btn bg4 cl1' onclick=\"validate($entreprise->idE, 'etape7', 8)\">Valider cette étape</span></div>";
            }
        } else {
            echo "<p class='rem'>Cette étape n'est pas encore été remplis</p>";
        }

        ?>

    </div>

    <?php if($entreprise->etape >= 8) : ?>
    <div class="box p20 mb20" id="etape8">

        <h4>Etape 8 (Mutuelle santé)</h4>
        <br><p>Le freelance à validé l'étape de la mutuelle</p></br>

    </div>
    <?php endif ?>

    <?php if($entreprise->etape >= 9) : ?>
    <div class="box p20 mb20" id="etape9">

        <h4>Etape 9 (Retraite complémentaire )</h4>
        <br><p>Le freelance à validé l'étape  la retraite complémentaire</p></br>

    </div>
    <?php endif ?>

    <?php if($entreprise->etape == 10) : ?>
    <div class="box p20 mb20" id="etape10">

        <h4>Etape 10 : Création de l'entreprise finalisée.</h4>

    </div>
    <?php endif ?>

</div>

<div id="error_msg_box" class="gla-form col-10 bg6 p10 pb20" style="display: none;">

    <h3>Envoyer un message d'erreur pour cette étape</h3>

    <p class="rem mb10">Attention si vous avez déja envoyé un message il va être écrasé par le nouveau</p>
    <textarea id="erreur_message" placeholder="Votre message ..." class="col-5"></textarea>

    <div>
        <span class="btn bg3 cl1" onclick="send_error_message(this)">Envoyer</span>
    </div>

</div>

<script>
    function validate(entreprise_id, etape, etape_go) {

        fetch(webroot + "theme/control/ajax/comptable_validate.php", {
                body: JSON.stringify({
                    'entreprise_id': entreprise_id,
                    'etape': etape,
                    'etape_go': etape_go,
                }),
                method: "POST"
            })
            .then(json => json.json())
            .then(json => {

                if (json.succes) {

                    window.location.reload()

                } else {

                    alert('Une erreur est servenu, impossible de valider cette étape')

                }

            })
    }

    function send_error_message(t) {

        let parent = t.parentNode.parentNode

        let entreprise_id = parent.getAttribute('data-entreprise')
        let etape = parent.getAttribute('data-etape')

        if (entreprise_id == null || etape == null) return false

        let textarea = parent.querySelector('textarea')

        if (textarea.value == '') return

        fetch(webroot + "theme/control/ajax/comptable_error_message.php", {
                body: JSON.stringify({
                    'entreprise_id': entreprise_id,
                    'etape': etape,
                    'message': textarea.value,
                }),
                method: "POST"
            })
            .then(json => json.json())
            .then(json => {

                if (json.succes) {

                    window.location.reload()

                } else {

                    alert("Une erreur est servenu, impossible d'envoyer ce message")

                }

            })

    }

    function erreur(t, entreprise_id, etape) {

        let error_msg_box = document.querySelector('#error_msg_box').cloneNode(true)

        error_msg_box.dataset.entreprise = entreprise_id
        error_msg_box.dataset.etape = etape

        error_msg_box.style.display = 'block'

        document.querySelector('#etape' + etape).appendChild(error_msg_box)

        t.parentNode.remove()

    }
</script>

<style>
    table {
        width: 100%;
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 0 7px rgba(0, 0, 0, .2);
        border-collapse: collapse;
    }

    table thead {
        background: #0257B1;
        color: #fff;
    }

    table thead th {
        padding: 20px;
        text-transform: uppercase;
        font-size: 0.9em;
    }

    table td {
        padding: 16px 5px
    }

    table tr:nth-child(2n) {
        background-color: #E1E1E1;
    }
</style>