<div class="pg">

    <div class="c content">

        <div class="flex mb30">

            <?php

            $selected = 'dashboard';

            include 'theme/page/_menu.php';

            ?>

            <div class="col-8 p20">

                <div class="a4 box mb30">

                    <div class="head flex p30">

                        <div class="col-5">

                            <h4>Prestataire</h4>

                            <p>Entreprise : <?= $prestataire->entreprise ?></p>
                            <p>SIREN : <?= $prestataire->siren ?></p>
                            <p>N° TVA : <?= $prestataire->tva ?></p>

                        </div>

                        <div class="col-5">
                            <h1>Facture NAS-<?= $mission->idC ?></h1>
                            <h4 class="mt10">Date de la facture : <?= date('d/m/Y - H:i', strtotime($offer->created_at)) ?></h4>
                        </div>

                        <img src="<?= Func::cache("theme/assets/img/large/" . $asset->pic(1)) ?>" />

                    </div>

                    <hr>

                    <div class="flex p30">

                        <div class="col-5">
                            <h4>Lieu de la prestatation :</h4>
                            <p class="col-8"><?= $mission->adresse ?></p>
                        </div>

                        <div class="col-5">

                            <h4>Client</h4>

                            <p>Nom : <?= $client->nom ?></p>
                            <p>Adresse : <?= $client->adresse ?></p>

                        </div>

                    </div>

                    <hr>

                    <div class="p20">
                        <table>

                            <thead>
                                <tr>
                                    <td>Désignation</td>
                                    <td>Quantité</td>
                                    <td>Prix unitaire / Heure</td>
                                    <td>Montant (€)</td>
                                </tr>
                            </thead>

                            <tr>
                                <td><?= $mission->titre ?></td>
                                <td><?= $offer->duree ?></td>
                                <td><?= $offer->prix  ?> €</td>
                                <td><?= $offer->prix * $offer->duree ?> €</td>
                            </tr>

                            <tr>
                                <td class="v_no"></td>
                                <td class="v_no"></td>
                                <td class="bg_head">TOTAL HT</td>
                                <td><?= $offer->prix * $offer->duree ?> €</td>
                            </tr>

                            <tr>
                                <td class="v_no"></td>
                                <td class="v_no"></td>
                                <td class="bg_head">TVA <?= $offer->tva_per ?>%</td>
                                <td><?= $offer->tva_prix ?> €</td>
                            </tr>

                            <tr>
                                <td class="v_no"></td>
                                <td class="v_no"></td>
                                <td class="bg_head">Commission HT</td>
                                <td><?= $offer->commission ?> €</td>
                            </tr>

                            <tr>
                                <td class="v_no"></td>
                                <td class="v_no"></td>
                                <td class="bg_head">TVA commission (20%)</td>
                                <td><?= $offer->tva_commission ?> €</td>
                            </tr>

                            <tr>
                                <td class="v_no"></td>
                                <td class="v_no"></td>
                                <td class="bg_head"><b>TOTAL TTC</b></td>
                                <td><b><?= $offer->total ?> €</b></td>
                            </tr>

                        </table>
                    </div>

                    <p class="p30">"Facture acquittée"</p>

                    <div class="foot">

                        <p>* Taux normal de 20 % (art. 278 du CGI)</p>
                        <?php if ($offer->tva_per == '10') { ?>
                            <p>* Taux réduit de 10 % (art. 278 du CGI)</p>
                        <?php } elseif ($offer->tva_per == '5.5') { ?>
                            <p>* Taux réduit de 5,5 % (art. 278 du CGI)</p>
                        <?php } elseif ($offer->tva_per == '2.1') { ?>
                            <p>* Taux particulier de 2,1 % (art. 281 du CGI)</p>
                        <?php } else { ?>
                            <p>* TVA non applicable - (art. 293 du CGI)</p>
                        <?php } ?>

                        <p>Facture établie par nousartisans.com au nom et pour le compte de (<b><?= $prestataire->nom ?></b>/<b><?= $prestataire->entreprise ?></b>).</p>

                    </div>

                </div>

                <span class="btn bg3 cl1" onclick="window.print()">Imprimer la facture</span>

            </div>

        </div>
    </div>
</div>