function _(x){ return document.querySelector(x)}

var webroot = location.protocol + '//' + window.location.host +'/';

var config = {

    'url': webroot,
    'loader': webroot+'gla-adminer/assets/image/loader.gif'

}

if(NodeList.prototype.forEach === undefined){
    NodeList.prototype.forEach = function(callback){
        [].forEach.call(this, callback);
    }
}

var c_ajax = {

    getObj : function(){

        var xhr = false;

        if (window.ActiveXObject) {
            try {
                xhr = new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e) {
                xhr = new ActiveXObject("Microsoft.XMLHTTP");
            }
        } else if (window.XMLHttpRequest) {
            xhr = new XMLHttpRequest();
        }

        return xhr;

    },

    load : function(url,data,callback,load){

        var xhr = this.init();
        if(!xhr||!url) return;
        if (xhr.overrideMimeType) xhr.overrideMimeType('text/plain');

        var formData = new FormData();

        for(var i in data){
            formData.append(i, data[i]);
        }


        if(load){

            loadBox();

            xhr.upload.addEventListener("progress", function(e) {
                var per = (e.loaded / e.total) * 100;
                Q('#PR #PRB').style.width = Math.round(per)+'%';
                Q('#PR #PRB #PRP').innerHTML = Math.round(per)+' %';
                Q('#TSZ').innerHTML = Math.round(e.total / 1024);
            }, true);

        }

        xhr.open('POST', config.url+'theme/control/ajax/'+url+'.php', true);

        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {

                var result = "";
                if(xhr.responseText) result = xhr.responseText;

                if(callback) callback(result);

            } else {

                return 0;
            }
        }

        xhr.send(formData);

    },

    init : function() {return this.getObj();}

}

function search(s_input) {

    res = document.querySelector('.search_results')

    console.log(s_input.value);

    if (s_input.value.length > 1) {

        res.style.display = 'block'

        res.innerHTML = "<span class='loader'></span><ul></ul>"

        c_ajax.load('search', { 't': s_input.value}, function (data) {

            console.log(data);

            if (data !== '') {

                res.innerHTML = data;

            }else{

                res.innerHTML = "<li><p class='p20 rem'>Aucun résultat</p></li>";

            }

        }, false);

    } else {

        res.innerHTML = "";

        res.style.display = 'none'

    }

}

// ----- Slider

var slider = function (childs, slide, time, cw) {

    var img = document.querySelectorAll(childs)
    var slider = _(slide);

    if (!time) time = 4000;

    var opt = {

        t: (time * 1000),
        w: cw.innerWidth || cw.clientWidth,
        h: cw.innerHeight || cw.clientHeight

    }

    slider.style.width = (img.length * opt.w) + 'px';


    for (var i = 0; i < img.length; i++) {

        img[i].style.width = opt.w + 'px';
        img[i].style.height = opt.h + 'px';

    }

    var j = 1;

    var fade = function () {

        if (j >= (img.length)) {

            j = 0;

        }

        slider.style.transform = 'translateX(-' + (j * opt.w) + 'px)';

        slider.classList.toggle('anim');

        j++;

    }

    if (_('#nx') !== 'null') {

        _('#nx').addEventListener('click', function () {
            j++;

            if (j >= (img.length)) {

                j = 0;

            }

            slider.style.transform = 'translateX(-' + (j * opt.w) + 'px)';

            clearTimeout(fade);

        });

    }

    if (_('#pv') !== 'null') {

        _('#pv').addEventListener('click', function () {

            if (j == 0) {
                j = (img.length - 1);
            } else {
                j--;
            }

            slider.style.transform = 'translateX(-' + (j * opt.w) + 'px)';

            clearTimeout(fade);

        });

    }

    setInterval(fade, opt.t);

}

// Gla Slider

let gla_slider = class {

    parent = null
    childs = []
    slider = null
    position = 0
    position_slides = 0 
    childs_nbr = 0

    screen_size = 'min_600'

    timer = null

    option = {
        childs: 5,
        items: ".gla-item",
        margin: 10,
        btn_class: "bgg",
        next: "E",
        previos: "D",
        speed: 5
    }

    constructor(element, option) {

        this.option = { ...this.option, ...option }

        this.parent = document.querySelector(element)

        this.size()

        this.init()

    }

    init() {

        this.parent.classList.add("gla_slider")
        this.parent.classList.add(this.option.slider_type)

        let parent_width = this.parent.innerWidth || this.parent.clientWidth

        this.childs = this.parent.querySelectorAll(this.option.items)

        this.childs_nbr = this.childs.length

        this.child_width = parent_width / this.option.childs

        if (this.screen_size == 'min_960') {

            this.option.childs = Math.ceil(this.option.childs / 2)

            this.child_width = parent_width / this.option.childs

        } else if (this.screen_size == 'min_600') {

            this.option.childs = Math.ceil(this.option.childs / 3)

            this.child_width = parent_width / this.option.childs

        } else if (this.screen_size == 'min_400') {

            this.option.childs = 1

            this.child_width = parent_width

        }

        console.log(this.screen_size);

        this.position_slides = this.childs.length - this.option.childs

        this.childs.forEach(function (elem) {

            elem.style.margin = '0' + this.option.margin + 'px'
            elem.style.width = this.child_width + 'px'
            elem.style.minWidth = 'unset'

        }, this)

        this._slider(this.parent.innerHTML)

        this.parent.innerHTML = ''

        this.parent.appendChild(this.slider)

        this.btns()

        this.timeout()

    }

    _slider(HTML) {

        this.slider = document.createElement('div')
        this.slider.classList.add('gla_slider_slider')

        let slider_width = this.child_width * this.childs_nbr

        this.slider.style.width = slider_width + 'px'

        console.log('slider => ' + slider_width);

        this.slider.innerHTML = HTML

    }

    btns() {

        if (this.childs_nbr <= this.option.childs) return false

        let next_btn = document.createElement('span')
        next_btn.className = 'icon slider_btn next_btn'
        next_btn.classList.add(this.option.btn_class)
        next_btn.innerText = this.option.next

        next_btn.addEventListener('click', this.next.bind(this))

        let previos_btn = document.createElement('span')
        previos_btn.className = 'icon slider_btn previos_btn'
        previos_btn.classList.add(this.option.btn_class)
        previos_btn.innerText = this.option.previos

        previos_btn.addEventListener('click', this.previos.bind(this))

        this.parent.appendChild(next_btn)
        this.parent.appendChild(previos_btn)

    }

    next() {

        if (this.position < this.position_slides) {

            this.position = this.position + 1

        } else {

            this.position = 0

        }

        this.slider.style.transform = "translateX(-" + this.child_width * this.position + "px)"

        this.timeout()
    }

    previos() {

        if (this.position == 0) {

            this.position = this.position_slides

        } else {

            this.position = this.position - 1

        }

        this.slider.style.transform = "translateX(-" + this.child_width * this.position + "px)"

        this.timeout()

    }

    timeout() {

        clearTimeout(this.timer)

        this.timer = setInterval(this.next.bind(this), this.option.speed * 1000);

    }

    // Media query

    size() {

        if (window.matchMedia("(min-width: 960px)").matches) {
            
            this.screen_size = 'max_960'

        } else if (window.matchMedia("(min-width: 600px)").matches) {

            this.screen_size = 'min_960'

        }else if (window.matchMedia("(min-width: 400px)").matches) {
            
            this.screen_size = 'min_600'

        } else {
            
            this.screen_size = 'min_400'
        }

    }

}

// GLA Alert

function gla_alert(message){

    let mask = document.createElement('div')
    mask.classList.add('mask')

    let gla_alert = document.createElement('div')
    gla_alert.classList.add('gla_alert')

    gla_alert.innerHTML = `

        <p>${message}</p>

        <div class="gla_btns">
            <span class="cl2 hover-cl3" onclick="document.querySelector('.mask').remove()">OK</span>
        </div>
    
    `

    mask.appendChild(gla_alert)

    document.querySelector('body').appendChild(mask)

}

// Gla Captcha

let gla_captcha = class {

    parent = null
    element = null

    code = null
    code_enter = null
    code_enter_text = ''

    timer = null

    constructor(element) {

        this.element = document.querySelector(element)
        this.parent = this.element.parentNode

        this.code = Math.floor(Math.random() * (9999 - 100) + 100)

        this.init()

    }

    init() {

        this.element.innerHTML = 'Chargement ...'

        this.inputs()

        this.variables()

    }

    inputs() {

        this.element.innerHTML = `
        
            <div class='flex ai-center'>
            
                <h3>Entrez le numéro ${this.code}</h3>
                
                <h3 class='gla_code_enter'>****</h3>

            </div>

            <div class='flex'>
            
                <span class='gla_btn_0'>0</span>
                <span class='gla_btn_1'>1</span>
                <span class='gla_btn_2'>2</span>
                <span class='gla_btn_3'>3</span>
                <span class='gla_btn_4'>4</span>
                <span class='gla_btn_5'>5</span>
                <span class='gla_btn_6'>6</span>
                <span class='gla_btn_7'>7</span>
                <span class='gla_btn_8'>8</span>
                <span class='gla_btn_9'>9</span>
                <span class='gla_btn_c'>c</span>

            </div>

        `

    }

    variables() {

        this.code_enter = document.querySelector('.gla_code_enter')

        this.events(0)
        this.events(1)
        this.events(2)
        this.events(3)
        this.events(4)
        this.events(5)
        this.events(6)
        this.events(7)
        this.events(8)
        this.events(9)
        this.events('c')

    }

    events(elem) {

        document.querySelector('.gla_btn_' + elem).addEventListener('click', function(e){

            if (elem == 'c') {

                this.code_enter_text = ''
                this.code_enter.innerHTML = '****'

            }else{

                this.code_enter_text = this.code_enter_text + elem.toString()

                if(this.code_enter_text.length > 4) return

                this.code_enter.innerHTML = ''

                this.code_enter.innerHTML += this.code_enter_text

                this.verify()

            }

        }.bind(this))

    }

    verify() {

        if (this.code_enter_text == this.code) {
           
            this.element.innerHTML = `
        
                <h4>Code valide . Vous pouvez soumettre le formulaire</h4>
            
                <input type='hidden' name='gla_captcha' value='gla_form_validated'>

            `

        }

    }

}

// GLA Cookies

let gla_cookies = class {

    time = 30
    siteName = window.location.host
    code = null

    constructor(time) {

        this.time = time
        this.code = null

        this.check()

    }

    popup() {

        this.code = document.createElement("div")
        this.code.classList.add("gla_cookies")

        var c = document.createElement('div')
        c.innerHTML = `${this.siteName} n'utilise des cookies qu'à  des fins de statistiques. En poursuivant votre navigation, vous déclarez accepter leur utilisation.`

        var span = document.createElement('span')
        span.innerText = 'Ok'
        span.addEventListener('click', this.setCookie.bind(this))

        var a = document.createElement('a')
        a.href = `https://${this.siteName}/page/conditions-generales-d-utilisation`
        a.innerText = 'En savoir plus'

        c.appendChild(span)
        c.appendChild(a)
        this.code.appendChild(c)

        document.querySelector('body').appendChild(this.code)

    }

    check() {

        let name = "gla_cookies=";
        let decodedCookie = decodeURIComponent(document.cookie);
        let ca = decodedCookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }

        this.popup()

        return
    }

    setCookie() {

        var d = new Date();
        d.setTime(d.getTime() + (24 * 60 * 60 * 1000) * 30);

        document.cookie = "gla_cookies=accept;expires=" + d.toUTCString() + ";path=/";

        this.code.remove()

    }

}

window.addEventListener("DOMContentLoaded", function () {
    new gla_cookies(30)
})