<?php

$tele_val = ($user->tele_val == 0) ? "<span class='green'>Validé</span>" : "";
$email_val = ($user->email_val == 0) ? "<span class='green'>Validé</span>" : "";

?>

<div class="links box">
    <h1 class="mb20">Modifier l'utilisateur : <?= $user->nom ?> </h1>

    <?= Func::getFlash() ?>

    <form action="" method="POST" enctype="multipart/form-data">
        <div class="left">

            <div class="mb10">
                <label>Nom</label>
                <input type="text" name="nom" placeholder="Nom" value="<?= $user->nom ?>" spellcheck="true" />
            </div>

            <div class="mb10">
                <label>Email <?= $email_val ?></label>
                <input type="text" name="email" placeholder="Email" value="<?= $user->email ?>" spellcheck="true" />
            </div>

            <div class="mb10">
                <label>Téléphone <?= $tele_val ?></label>
                <input type="text" name="tele" placeholder="Téléphone" value="<?= $user->tele ?>" spellcheck="true" />
            </div>

            <div class="mb10">
                <label>Référent <?= $tele_val ?></label>
                <input type="text" name="referent" placeholder="Référent" value="<?= $user->referent ?>" spellcheck="true" />
            </div>
        <?php if ($user->type == 0) : ?>
            <div class="mb10">
                <label>IBAN <?= $tele_val ?></label>
                <input type="text" name="iban" placeholder="iban" value="<?= $user->iban ?>" spellcheck="true" />
            </div>
            <div class="mb10">
                <label>BIC <?= $tele_val ?></label>
                <input type="text" name="bic" placeholder="bic" value="<?= $user->bic ?>" spellcheck="true" />
            </div>
            <div class="mb10">
               <a href="<?= WEBROOT ?>gla-adminer/action/edit/relance.php?id=<?= $user->idU ?>"><li>Envoyer un email de rappel pour remplir le CV</li></a>
            </div>
            <div class="mb10">
               <a href="<?= WEBROOT ?>gla-adminer/action/edit/entretien.php?id=<?= $user->idU ?>"><li>Proposer un entretien</li></a>
            </div>
            <div class="mb10">
                <label>Remarques </label>
                <textarea type="text" name="remarques" placeholder="remarques" style="height: 130px" ><?= $user->remarques ?></textarea>
            </div>

        </div>
        <div class="right">
           
                <div class="mb10">
                    <label>Nom de l'entreprise</label>
                    <input type="text" name="entreprise" placeholder="Nom de l'entreprise" value="<?= $user->monentreprise ?>" spellcheck="true" />
                </div>

                <div class="mb10">
                    <label>SIREN</label>
                    <input type="text" name="siren" placeholder="Siren" value="<?= $user->siren ?>" spellcheck="true" />
                </div>

                <div class="mb10">
                    <label>Forme juridique</label>
                    <input type="text" name="juridique" placeholder="Forme juridique" value="<?= $user->juridique ?>" spellcheck="true" />
                </div>
                
                
                <?php if ($user->portage == 1) : ?>
                    <label>il est porté par l'entreprise <strong> <?= $user->monentreprise?> </strong></label>
                    <?php endif ?>
                
                <div class="mb10">
                    <label>La date de la derniere mise à jour</label>
                    <input type="text" name="date_update_disponibilite" placeholder="La date de la derniere mise à jour" value="<?= $user->date_update_disponibilite ?>" spellcheck="true" />
                </div>

                <div class="mb10">
                    <label>La date de disponibilité</label>
                    <input type="text" name="date_disponibilite" placeholder="La date de la derniere mise à jour" value="<?= $user->date_disponibilite ?>" spellcheck="true" />
                </div>

                <div class="mb10">
                    <label>Bonus(entre 1.0 et 0.5)</label>
                    <input type="text" name="bonus" placeholder="Bonus-malus" value="<?= $user->bonus ?>" spellcheck="true" />
                </div>

                <div class="mb10">
                    <label>Consultation CV Mois <?php echo date('F');?></label>
                    <span><?= htmlspecialchars($user->nbconsultationMois) ?></span>
                </div>

                <div class="mb10">
                    <label>Consultation CV global depuis <?= $user->date ?></label>
                    <span><?= htmlspecialchars($user->nbconsultation) ?></span>
                </div>
        </div>
        <?php endif ?>
        

        <div class="right">

            <button type="submit" name="submit" class="btn b-g" id="btnLoad"><span class="icon">W</span> Enregistrer</button>

        </div>


    </form>

    <div class="clear"></div>

</div>

<script src="<?= Func::cache('gla-adminer/assets/js/gla-script.js') ?>"></script>