<?php 

$info = \Root\Utilisateur::getTarifbyID($db,$ticket->f_idU);

?>

<div class="links box">
    <h1 class="mb20">Modifier le ticket : <?= $ticket->idT ?></h1>

    <?= Func::getFlash() ?>

    <form action="" method="POST">
        <div class="left">

            <div class="mb10">

                <h3 class="mb10">Entreprise(client)</h3>
                <p class="mb10">Nom : <?= $ticket->nom ?></p>
                <p class="mb10">Email : <?= $ticket->email ?></p>
                <p class="mb10">tele : <?= $ticket->tele ?></p>

            </div>

            <div class="mb10">

                <h3 class="mb10">Freelance</h3>

                <?php if ($ticket->freelance == '0') : ?>

                    <label>Affecter un freelance à ce ticket (Entrez l'identifiant du freelance)</label>
                    <input type="number" id="freelance_id" placeholder="ID du freelance ..." class="mb10">

                    <div class="mb10">
                        <span class="btn b-g" onclick="setFreelance(this)"><span class="icon">W</span> Affecter</span>
                    </div>

                <?php endif ?>

                <p class="mb10">Nom : <?= $ticket->f_nom ?></p>
                <p class="mb10">Email : <?= $ticket->f_email ?></p>
                <p class="mb10">Tele : <?= $ticket->f_tele ?></p>
                <p class="mb10">IBAN : <?= $ticket->f_iban ?> BIC : <?= $ticket->f_bic ?></p>
                <p class="mb10">Entreprise <?= $ticket->f_monentreprise ?></p>
                <p class="mb10">TJM souhaité par le freelance : <?= $info->tarif ?></p>

                <p class="mb10"> <?= \Root\Utilisateur::files("kbis", "Kbis", $db) ?></p>
                <p class="mb10"><?= \Root\Utilisateur::files("assurance", "Assurance professionnelle", $db) ?></p>


            </div>

            <hr class="mb10">

            <div class="mb10">

                <h3 class="mb10 mt10">Modifier le statut du ticket</h3>

                <select name="stt" class="mb10">

                    <option value="0" <?php if ($ticket->t_stt == 0) echo "selected"; ?>>Mettre en attente</option>
                    <option value="1" <?php if ($ticket->t_stt == 1) echo "selected"; ?>>Envoyer un message d'erreur</option>
                    <option value="2" <?php if ($ticket->t_stt == 2) echo "selected"; ?>>Envoyer date d'entretien</option>
                    <option value="3" <?php if ($ticket->t_stt == 3) echo "selected"; ?>>Lancer la mission</option>
                    <option value="4" <?php if ($ticket->t_stt == 4) echo "selected"; ?>>Finaliser</option>

                </select>

                <label>Message pour l'entreprise</label>
                <input type="text" name="message" placeholder="Message ..." class="mb10" value="<?= $ticket->message ?>">

                <label>Date entretien</label>
                <input type="datetime-local" name="entretien" placeholder="Date entrtient ..." value="<?= date('Y-m-d\TH:i', strtotime($ticket->entretien)) ?>">

            </div>


            <div class="mb10">
        <button type="submit" name="submit" class="btn b-g"><span class="icon">W</span> Enregistrer</button>

                <?php if(!empty($last_cra->stt)) : ?>
                <a href='?id=<?= $ticket->idT ?>&cra=<?= $last_cra->idC ?>' class="btn b-g">Débloquer le dernier mois du CRA (mois <?= $last_cra->month ?>)</a>
                <?php endif ?>
            </div>

        </div>

        <div class="right">
            <div class="mb10">
                    <h3 class="mb10">Cacule TJM freelance</h3>
                    <p class="mb10">TJM Minimun proposé au freelance: <?= $ticket->t_tarif-0.05*$ticket->t_tarif ?></p>
                    <p class="mb10">TJM afficher par laotop <?= calculerTarifJournalier($info->tarif) ?> </p>
                    <p class="mb10">Augmentation grace au bonus <?= $ticket->f_bonus ?> et le tjm <?= $ticket->t_tjm ?> est : <?=($ticket->t_tarif-(($ticket->t_tarif-$ticket->t_tjm)*(0.8+0.2*$ticket->f_bonus)))-$ticket->t_tjm?> euros par jour </p>
                   
                    
            </div> 

            <div class="mb10">
                <label>TJM proposé par le client</label>
                <input type="text" name="tarif" placeholder="Tarif" value="<?= $ticket->t_tarif ?>" required />
            </div>

            <div class="mb10">
                <label>TJM payé par Laotop au freelance</label>
                <input type="text" name="tjm" placeholder="TJM" value="<?= $ticket->t_tjm ?>" required />
            </div>

            <div class="mb10">
                <label>Durée (jours)</label>
                <input type="text" name="duree" placeholder="Durée" value="<?= $ticket->t_duree ?>" required />
            </div>

            <div class="mb10">
                <label>Adresse de la mission</label>
                <input type="text" name="adresse" placeholder="adresse" value="<?= $ticket->t_adresse ?>" required />
            </div>

            <div class="mb10">
                <label>Description du ticket</label>
                <textarea name="description" placeholder="Contenu de la page" style="height: 130px"><?= $ticket->t_description ?></textarea>
            </div>

            <div class="mt30">
                <a href="<?= WEBROOT ?>contrat.php?ticket=<?= $ticket->idT ?>" >Généré  le  contrat numéro : <?= $ticket->idT ?></a>
            </div>

        </div>

    </form>

    <div class="clear"></div>

</div>

<script src="<?= Func::cache('gla-adminer/assets/js/gla-script.js') ?>"></script>

<script>
    function setFreelance(t) {

        input = document.querySelector('#freelance_id')

        if (input.value !== '') {

            fetch(webroot + "gla-adminer/control/ajax/setFreelance.php", {
                body: JSON.stringify({
                    ticket: <?= $ticket->idT ?>,
                    freelance: input.value
                }),
                method: "POST"
            })
            .then(json => json.json())
            .then(json => {

                console.log(json)

                if (json.succes) {

                    alert(json.message)

                    window.location.reload()

                } else {

                    alert(json.message)

                }

            })

        } else {

            alert("Veuillez entrer un identifiant d'un freelance");

        }


    }
</script>

<?php function calculerTarifJournalier($tarif) {
   
    
   if ($tarif < 100) {
       return number_format($tarif + 60, 0) ;
   } else if ($tarif < 200) {
       return number_format($tarif + 55, 0) ;
   } else if ($tarif < 300) {
       return number_format($tarif + 50, 0) ;
   } else if ($tarif < 400) {
       return number_format($tarif + 45, 0) ;
   } else if ($tarif < 500) {
       return number_format($tarif * 1.09, 0) ;
   } else {
       return number_format($tarif * 1.06, 0) ;
   }
}
?>