<?php

namespace Root;


class Utilisateur {

    static function userById($id, $db, $r = 'index.php'){

        $user = $db->query('SELECT * FROM utilisateurs WHERE idU = ?',[$id])->fetch();

        if(!empty($user)){

            return $user;

        }else{

            \Func::redirect($r);

        }

    }

    static function userCV($id, $db, $r = 'index.php'){

        $user = $db->query('SELECT * FROM cv WHERE user = ?', [$id])->fetch();

        if (!empty($user)) {

            return $user;

        } else {

            \Func::redirect($r);

        }

    }

    static function userInfoCV($db){

        $user = $db->query('SELECT * FROM cv WHERE user = ?', [$_SESSION['id']])->fetch();

        if (!empty($user)) {

            return $user;

        } else {

            $db->query("INSERT INTO cv (user) VALUES (?)", [$_SESSION['id']]);

            \Func::redirect('#cv');

        }
    }

    static function getTarifbyID($db,$id){

        $tarif = $db->query("SELECT tarif FROM cv WHERE user = '$id'")->fetch();

        return $tarif;
    }

    static function userInfoCVIA($db){

        $user = $db->query('SELECT * FROM cvia WHERE user = ?', [$_SESSION['id']])->fetch();

        if (!empty($user)) {

            return $user;

        } else {

            $db->query("INSERT INTO cvia (user) VALUES (?)", [$_SESSION['id']]);

            \Func::redirect('#cvia');

        }
    }


    static function isPremium($user, $db){

        $last = $db->query("SELECT abonnement FROM utilisateurs WHERE idU = ?", [$user])->fetch();

        $now = new \DateTime(date('Y-m-d'));
        $premium = new \DateTime($last->abonnement);

        if ($now < $premium) return $last->abonnement;

        return false;

    }

    static function files($type, $name, $db){

        $file = $db->query("SELECT $type AS ext FROM utilisateurs WHERE idU = ?", [$_SESSION['id']])->fetch();

        if(!empty($file->ext)){

            return "<div class='mb40'><a href='". WEBROOT ."theme/assets/img/user/" . $_SESSION['id'] . "/$type.$file->ext?t=" . time() ."' target='_blank'>$name.$file->ext</a></div>";

        }

        return false;
    }

    static function insertUser($p, $db){

        if(!empty($p['nom']) && !empty($p['email']) && !empty($p['tele']) && !empty($p['password']) && !empty($p['password_verif'])){

            if($p['password'] == $p['password_verif']){

                if(\Validation::between($p['nom'],2,128)){

                    \Func::setFlash('error',"Veuillez vérifier votre nom");

                    return false;

                }

                if (!filter_var($p['email'] , FILTER_VALIDATE_EMAIL)) {

                    \Func::setFlash('error',"Veuillez vérifier votre adresse email");

                    return false;

                }

                if (!\Validation::isUnique(trim($p['email']), 'email', 'utilisateurs', $db)) {

                    \Func::setFlash('error',"Adresse email déja utilisée dans un autre compte");

                    return false;

                }

                if(!preg_match("/^\\+?\\d{1,4}?[-.\\s]?\\(?\\d{1,3}?\\)?[-.\\s]?\\d{1,4}[-.\\s]?\\d{1,4}[-.\\s]?\\d{1,9}$/", trim($p['tele']))){

                    \Func::setFlash('error',"Veuillez entrer un numéro de téléphone valide");

                    return false;

                }

                extract($p);

                $password = password_hash($password, PASSWORD_BCRYPT, ['cost' => 10]);
                $derniere_connexion = date('Y-m-d H:i:s');

                $email_val = rand(10000, 99999);
                $tele_val = rand(10000, 99999);

                $app_token = md5(rand(0, 99999) . "_gla") . '_' . md5(rand(0, 99999) . "_gla");

                $db->query("INSERT INTO utilisateurs (nom,monentreprise,email,tele,password,date,derniere_connexion,email_val,tele_val,app_token,type) VALUES (?,?,?,?,?,NOW(),?,?,?,?,1)",[trim($nom),$nom, strtolower(trim($email)), trim($tele), $password,$derniere_connexion, $email_val, $tele_val, $app_token]);

                \Mail::welcom_email_validation(trim($email), $nom, $email_val);

                \Func::setFlash('succes',"Bonjour <strong>$nom</strong>, Bienvenue sur votre espace membre <b>". \Config::get('site_title') ."</b> vous pouvez commencer à utiliser votre compte, Vous avez reçu un email de bienvenu et d'activation de votre adresse email $email");

                self::connectRegester(strtolower(trim($email)), $db);

            }else{

                \Func::setFlash('error',"Veuillez vérifier votre mot de passe.");

                return false;

            }

        }

    }

    static function insertUserFreelance($p, $db){

        if (!empty($p['nom']) && !empty($p['email']) && !empty($p['tele']) && !empty($p['adresse']) && !empty($p['password']) && !empty($p['password_verif'])) {

            if ($p['password'] == $p['password_verif']) {

                if (\Validation::between($p['adresse'], 2, 128)) {

                    \Func::setFlash('error', "Veuillez vérifier votre adresse");

                    return false;
                }

                if (\Validation::between($p['nom'], 8, 128)) {

                    \Func::setFlash('error', "Veuillez entrer le nom du gérant");

                    return false;
                }

                if (!filter_var($p['email'], FILTER_VALIDATE_EMAIL)) {

                    \Func::setFlash('error', "Veuillez vérifier votre adresse email");

                    return false;
                }

                if (!\Validation::isUnique(trim($p['email']), 'email', 'utilisateurs', $db)) {

                    \Func::setFlash('error', "Adresse email déja utilisée dans un autre compte");

                    return false;
                }

                if(!preg_match("/^\\+?\\d{1,4}?[-.\\s]?\\(?\\d{1,3}?\\)?[-.\\s]?\\d{1,4}[-.\\s]?\\d{1,4}[-.\\s]?\\d{1,9}$/", trim($p['tele']))){

                    \Func::setFlash('error',"Veuillez entrer un numéro de téléphone valide");

                    return false;

                }

                extract($p);

                $password = password_hash($password, PASSWORD_BCRYPT, ['cost' => 10]);

                $email_val = rand(10000, 99999);
                $tele_val = rand(10000, 99999);

                $app_token = md5(rand(0, 99999) . "_gla") . '_' . md5(rand(0, 99999) . "_gla");

                $date_disponibilite = date('Y-m-d H:i:s');
                $date_update_disponibilite = date('Y-m-d H:i:s');
                $derniere_connexion = date('Y-m-d H:i:s');

                $db->query("INSERT INTO utilisateurs (nom,email,tele,adresse,password,date, derniere_connexion,date_disponibilite, date_update_disponibilite,email_val,tele_val,app_token,type) VALUES (?,?,?,?,?,NOW(),?,?,?,?,?,?,0)", [trim($nom), strtolower(trim($email)), trim($tele), $adresse, $password, $derniere_connexion,$date_disponibilite, $date_update_disponibilite, $email_val, $tele_val, $app_token]);

                \Mail::welcom_email_validation(trim($email), $nom, $email_val);

                \Func::setFlash('succes', "Bonjour <strong>$nom</strong>, Bienvenue sur votre espace membre <b>" . \Config::get('site_title') . "</b> vous pouvez commencer à utiliser votre compte, Vous avez reçu un email de bienvenu et d'activation de votre adresse email <strong>$email</strong>");

                self::connectRegester(strtolower(trim($email)), $db, 'bienvenue');

            } else {

                \Func::setFlash('error', "Veuillez vérifier votre mot de passe.");

                return false;
            }
        }
    }

    static function editUser($p, $db){

        if(!empty($p['nom']) && !empty($p['tele']) && !empty($p['siren']) && !empty($p['juridique'])){

            if(\Validation::between($p['nom'], 2, 128)){

                \Func::setFlash('error',"Veuillez vérifier votre nom et votre prénom");

                return false;

            }

            if(!preg_match("/^\\+?\\d{1,4}?[-.\\s]?\\(?\\d{1,3}?\\)?[-.\\s]?\\d{1,4}[-.\\s]?\\d{1,4}[-.\\s]?\\d{1,9}$/", trim($p['tele']))){

                \Func::setFlash('error',"Veuillez entrer un numéro de téléphone valide");

                return false;

            }

            $siren = (empty($p['siren'])) ? NULL : $p['siren'];
            $juridique = (empty($p['juridique'])) ? NULL : $p['juridique'];

            $portage = (empty($p['portage_check'])) ? 0 : 1;

            $monentreprise = (!empty($p['monentreprise'])) ? $p['monentreprise'] : '';
           

            $db->query("UPDATE utilisateurs SET nom = ?, monentreprise = ?, tele = ?, adresse = ?, genre = ?, siren = ?, juridique = ?,iban = ?,bic = ?, capital = ?, portage = ? WHERE idU = ?",[$p['nom'], $monentreprise, $p['tele'], $p['adresse'], $p['genre'], $siren, $juridique, $p['iban'],$p['bic'],$p['capital'], $portage, $_SESSION['id']]);
            
            $date_disponibilite = (!empty($p['date_disponibilite'])) ? $p['date_disponibilite'] : '';
            $date_update_disponibilite = date('Y-m-d H:i:s');

            if(!empty($date_disponibilite)) $db->query("UPDATE utilisateurs SET date_disponibilite = ?, date_update_disponibilite = ? WHERE idU = ?",[$date_disponibilite, $date_update_disponibilite, $_SESSION['id']]);

            $_SESSION['name'] = $p['nom'];
            $_SESSION['tele'] = $p['tele'];

            if(!empty($p['email'])){

                if(\Validation::isUniqueNotMinde(trim($p['email']), 'email', 'utilisateurs', $_SESSION['id'], $db)){

                    $db->query("UPDATE utilisateurs SET email = ? WHERE idU = ?",[trim($p['email']),$_SESSION['id']]);

                    $_SESSION['email'] = $p['email'];

                }

            }

            \Func::setFlash("succes", "Informations modifiées avec succes");

            \Func::redirect('#flash');

        }else{

            \Func::setFlash("error", "Tous les champs sont obligatoires");

            \Func::redirect('#flash');

        }

    }
    static function insertResumeCV($cv,$id,$db){
      
        $texte_encode = mb_convert_encoding($cv, 'UTF-8', 'ISO-8859-1');
        $cv_echappe =  addslashes($texte_encode);
        $vowels = array( "\xc2\x80","\xc2\x82", "\xc2\x83" , "\xc2\x84","\xc2\x85" ,"\xc2\x86", "\xc2\x87" , "\xc2\x88", "\xc2\x89","\xc2\x8a","\xc2\x8b","\xc2\x8c" , "\xc2\x8e", "\xc2\x91","\xc2\x92","\xc2\x93" ,"\xc2\x94","\xc2\x95",  "\xc2\x97", "\xc2\x98", "\xc2\x99"  ,"\xc2\x9a","\xc2\x9b","\xc2\x9c","\xc2\x9e","\xc2\x9f");
        $onlyconsonants = str_replace($vowels, "", $cv_echappe);
         $db->query("UPDATE utilisateurs SET resume_cv = '$onlyconsonants' WHERE idU = '$id'");
 
 
     }
     static function getCV($id, $db){

      
        $rcv= $db->query("SELECT resume_cv FROM utilisateurs WHERE idU = $id ")->fetch();
     
            return $rcv;


            
    }
    

    

    static function getCVR($db){

      
        $rcv= $db->query("SELECT resume_cv FROM utilisateurs WHERE  type = 0 and resume_cv != 'NULL' and profile_per>90 ")->fetchall();
    
            return $rcv;


    }
    static function editCV($p, $db){

        if (!empty($p['spetialite']) && !empty($p['tarif'])) {

            $profile_per = 25;

            if (\Validation::between($p['spetialite'], 2, 128)) {

                \Func::setFlash('error', "Veuillez entrer une spétialité valide");

                return false;
            }

            $db->query("UPDATE cv SET bio = ?, spetialite = ?, tarif = ?, outils = ?, experience_year = ? WHERE user = ?", [$p['bio'], $p['spetialite'], $p['tarif'], $p['outils'], $p['experience_year'], $_SESSION['id']]);

            $langues = '';

            if (isset($p['langues']) && $p['langues'] !== null) {

                $profile_per = $profile_per + 10;

                foreach ($p['langues'] as $l) {
                    $langues .= "$l,";
                }
            }

            $langues = trim($langues, ',');

            $geos = '';

            if (isset($p['geos']) && $p['geos'] !== null) {

                $profile_per = $profile_per + 10;

                foreach ($p['geos'] as $l) {
                    $geos .= "$l,";
                }
            }

            $geos = trim($geos, ',');

            $competances = '';

            if (isset($p['competances']) && $p['competances'] !== null) {

                $profile_per = $profile_per + 10;

                foreach ($p['competances'] as $l) {
                    $competances .= "$l,";
                }
            }

            $competances = trim($competances, ',');

            $languages = '';

            if (isset($p['languages']) && $p['languages'] !== null) {

                $profile_per = $profile_per + 5;

                foreach ($p['languages'] as $l) {
                    $languages .= "$l,";
                }
            }

            $languages = trim($languages, ',');

            $bdd = '';

            if (isset($p['bdd']) && $p['bdd'] !== null) {

                $profile_per = $profile_per + 5;

                foreach ($p['bdd'] as $l) {
                    $bdd .= "$l,";
                }
            }

            $bdd = trim($bdd, ',');

            $cms = '';

            if(isset($p['cms']) && $p['cms'] !== null){

                $profile_per = $profile_per + 5;

                foreach ($p['cms'] as $l) {
                    $cms .= "$l,";
                }
            }

            $cms = trim($cms, ',');

            $os = '';

            if ($p['os'] !== null) {

                $profile_per = $profile_per + 5;

                foreach ($p['os'] as $l) {
                    $os .= "$l,";
                }
            }

            $os = trim($os, ',');

            $db->query("UPDATE cv SET langues = ?, geos = ?, competances = ?, languages = ?, bdd = ?, cms = ?, os = ? WHERE user = ?", [$langues, $geos, $competances, $languages, $bdd, $cms, $os, $_SESSION['id']]);

            $formations = [];

            if ($p['formation_name'] !== null) {

                $date_order = 0;

                foreach ($p['formation_name'] as $k => $v) {

                    echo "<div style='display:none'>date_order:$date_order</div>";

                    if (!empty($v)) array_push($formations, ['name' => $v, 'spetialite' => $p['formation_spetialite'][$k], 'debut' => $p['formation_debut'][$k], 'fin' => $p['formation_fin'][$date_order], 'org' => $p['formation_org'][$k], 'adresse' => $p['formation_adresse'][$k]]);
                
                    $date_order = $date_order + 1;

                };
            }

            if(!empty($formations)) $profile_per = $profile_per + 15;

            $formations = json_encode($formations);

            $experiences = [];

            if ($p['exp_name'] !== null) {

                $date_order = 0;
                
                foreach ($p['exp_name'] as $k => $v) {
                    
                    echo "<div style='display:none'>date_order:$date_order</div>";

                    $this_exp = ['name' => $v, 'poste' => $p['exp_poste'][$k], 'debut' => $p['exp_debut'][$k], 'fin' => $p['exp_fin'][$date_order], 'desc' => $p['exp_desc'][$k], 'ville' => $p['exp_ville'][$k], 'pays' => $p['exp_pays'][$k]];
                    
                    if (!empty($v)) array_push($experiences, $this_exp);

                    $date_order = $date_order + 1;
                
                };

            }

            if(!empty($experiences)) $profile_per = $profile_per + 10;

            $experiences = json_encode($experiences);


            $db->query("UPDATE cv SET formations = ?, experiences = ? WHERE user = ?", [$formations, $experiences, $_SESSION['id']]);

            $message_flash = "";



            if (!isset($p['metiers']) || count($p['metiers']) == 0 || count($p['metiers']) > 5) {

                $profile_per = $profile_per + 0;
                
                $message_flash = "Veuillez ajouter entre 1 et 5 spetialités pour afficher votre profile, ";
            
            } else {
            
                $db->query("DELETE FROM spetialites WHERE u = ?", [$_SESSION['id']]);

                foreach ($p['metiers'] as $m) {
                    $db->query("INSERT INTO spetialites (u, s) VALUES (?, ?)", [$_SESSION['id'], $m]);
                }

            }

            $db->query("UPDATE utilisateurs SET profile_per = ? WHERE idU = ?", [$profile_per, $_SESSION['id']]);

            $message_flash .= "Profile modifié avec succes";

            \Func::setFlash("succes", $message_flash);

            \Func::redirect('#flash');

        } else {

            \Func::setFlash("error", "Veuillez remplir les champs obligatoir");

            \Func::redirect('#flash');
        }
    }

    static function login($db,$post,$rem = false){

        extract($post);

        $user = $db->query('SELECT idU, nom, email, tele, avatar,nbr_connexion, password, type FROM utilisateurs WHERE (email = :login OR tele = :login)',['login' => strtolower(trim($login))])->fetch();
        $derniere_connexion = date('Y-m-d H:i:s');
        if(!empty($user)){

            if(password_verify($pass, $user->password)) {

                if ($rem) self::remember($user,$db);

                if (isset($_GET['token'])) self::validateEmail($user->email, $_GET['token'], $db);
                $db->query("UPDATE utilisateurs SET derniere_connexion = ?,nbr_connexion = ? WHERE idU = ?", [$derniere_connexion,$user->nbr_connexion+1, $user->idU]);

                self::connect($user);

            }else{

                \Func::setFlash('error','Mot de passe incorrecte');

            }

        }else{

            \Func::setFlash('error','Veuillez vérifier votre adresse email ou numéro de téléphone');

        }
    }

    static function connectRegester($email, $db, $r = 'dashboard'){

        $user = $db->query('SELECT idU, nom, email, tele, avatar, type FROM utilisateurs WHERE email = ?',[$email])->fetch();

        self::connect($user, $r);

    }

    static function connect($u, $r = 'dashboard'){

        $_SESSION['session'] = true;
        $_SESSION['id'] = $u->idU;
        $_SESSION['name'] = $u->nom;
        $_SESSION['email'] = $u->email;
        $_SESSION['tele'] = $u->tele;
        $_SESSION['avatar'] = $u->avatar;
        $_SESSION['type'] = $u->type;

        if(isset($_GET['r'])){

            \Func::redirect(WEBROOT.$_GET['r']);

        }else{

            \Func::redirect($r);

        }

    }

    static function validateEmail($email, $token, $db){

        $verif = $db->query("SELECT idU FROM utilisateurs WHERE email = ? AND email_val = ?", [$email, $token])->fetch();

        if (!empty($verif)) {

            $db->query("UPDATE utilisateurs SET email_val = 0 WHERE email = ?", [$email]);
        }
    }

    // HOME -------------------------------------

    static function exp_frealancers($db, $limit){

        $freelancers = $db->query('SELECT idU, nom, avatar, note, nbr_note, spetialite FROM utilisateurs INNER JOIN cv ON user = idU WHERE profile_per > 85 ORDER BY note DESC')->fetchAll();

        self::frealancers($freelancers);
        
    }

    static function frealancers_by_spetialite($spetialite, $db, $limit){

        $freelancers = $db->query('SELECT idU, nom, avatar, note, nbr_note, spetialite FROM utilisateurs INNER JOIN spetialites ON u = idU INNER JOIN cv ON user = idU WHERE spetialites.s = ? AND profile_per > 85 ORDER BY note DESC', [$spetialite])->fetchAll();

        self::frealancers($freelancers);

    }

    static function frealancers_similaire($me, $spetialite, $db, $limit){

        $freelancers = $db->query('SELECT idU, nom, avatar, note, nbr_note, spetialite FROM utilisateurs INNER JOIN spetialites ON u = idU INNER JOIN cv ON user = idU WHERE idU != ? AND spetialites.s = ? AND profile_per > 85 ORDER BY note DESC', [$me, $spetialite])->fetchAll();

        foreach ($freelancers as $f) {

            $n = 0;

            echo "<a href='" . WEBROOT . "profile/$f->idU' class='pro-small cl2'>";

            echo "<img src='" .  WEBROOT . "theme/assets/img/profile/$f->avatar' alt='$f->nom'>";

            echo "<div>";

            echo "<span class='mb5 d-block fw5'>$f->spetialite</span>";

            echo "<div class='flex jc-center rating'>";

            for ($i = 0; $i < $f->note; $i++) {
                echo "<span class='bg5'></span>";
                $n = $i;
            }

            $n = 5 - $n;

            for ($i = 1; $i < $n; $i++) {
                echo "<span class='bg8'></span>";
            }

            echo "<span class='ml10 rate'>($f->nbr_note avis)</span>";

            echo "</div>";

            echo "</div>";

            echo "</a>";
        }

    }


    static function editCVIA($p, $db){

        if (!empty($p['spetialite']) && !empty($p['tarif'])) {

            $profile_per = 25;

            if (\Validation::between($p['spetialite'], 2, 128)) {

                \Func::setFlash('error', "Veuillez entrer une spétialité valide");

                return false;
            }

            $db->query("UPDATE cven SET bio = ?, spetialite = ?, tarif = ?, outils = ?, experience_year = ? WHERE user = ?", [$p['bio'], $p['spetialite'], $p['tarif'], $p['outils'], $p['experience_year'], $_SESSION['id']]);

            $langues = '';

            if (isset($p['langues']) && $p['langues'] !== null) {

                $profile_per = $profile_per + 10;

                foreach ($p['langues'] as $l) {
                    $langues .= "$l,";
                }
            }

            $langues = trim($langues, ',');

            $geos = '';

            if (isset($p['geos']) && $p['geos'] !== null) {

                $profile_per = $profile_per + 10;

                foreach ($p['geos'] as $l) {
                    $geos .= "$l,";
                }
            }

            $geos = trim($geos, ',');

            $competances = '';

            if (isset($p['competances']) && $p['competances'] !== null) {

                $profile_per = $profile_per + 10;

                foreach ($p['competances'] as $l) {
                    $competances .= "$l,";
                }
            }

            $competances = trim($competances, ',');

            $languages = '';

            if (isset($p['languages']) && $p['languages'] !== null) {

                $profile_per = $profile_per + 5;

                foreach ($p['languages'] as $l) {
                    $languages .= "$l,";
                }
            }

            $languages = trim($languages, ',');

            $bdd = '';

            if (isset($p['bdd']) && $p['bdd'] !== null) {

                $profile_per = $profile_per + 5;

                foreach ($p['bdd'] as $l) {
                    $bdd .= "$l,";
                }
            }

            $bdd = trim($bdd, ',');

            $cms = '';

            if(isset($p['cms']) && $p['cms'] !== null){

                $profile_per = $profile_per + 5;

                foreach ($p['cms'] as $l) {
                    $cms .= "$l,";
                }
            }

            $cms = trim($cms, ',');

            $os = '';

            if ($p['os'] !== null) {

                $profile_per = $profile_per + 5;

                foreach ($p['os'] as $l) {
                    $os .= "$l,";
                }
            }

            $os = trim($os, ',');

            $db->query("UPDATE cven SET langues = ?, geos = ?, competances = ?, languages = ?, bdd = ?, cms = ?, os = ? WHERE user = ?", [$langues, $geos, $competances, $languages, $bdd, $cms, $os, $_SESSION['id']]);

            $formations = [];

            if ($p['formation_name'] !== null) {

                $date_order = 0;

                foreach ($p['formation_name'] as $k => $v) {

                    echo "<div style='display:none'>date_order:$date_order</div>";

                    if (!empty($v)) array_push($formations, ['name' => $v, 'spetialite' => $p['formation_spetialite'][$k], 'debut' => $p['formation_debut'][$k], 'fin' => $p['formation_fin'][$date_order], 'org' => $p['formation_org'][$k], 'adresse' => $p['formation_adresse'][$k]]);
                
                    $date_order = $date_order + 1;

                };
            }

            if(!empty($formations)) $profile_per = $profile_per + 15;

            $formations = json_encode($formations);

            $experiences = [];

            if ($p['exp_name'] !== null) {

                $date_order = 0;
                
                foreach ($p['exp_name'] as $k => $v) {
                    
                    echo "<div style='display:none'>date_order:$date_order</div>";

                    $this_exp = ['name' => $v, 'poste' => $p['exp_poste'][$k], 'debut' => $p['exp_debut'][$k], 'fin' => $p['exp_fin'][$date_order], 'desc' => $p['exp_desc'][$k], 'ville' => $p['exp_ville'][$k], 'pays' => $p['exp_pays'][$k]];
                    
                    if (!empty($v)) array_push($experiences, $this_exp);

                    $date_order = $date_order + 1;
                
                };

            }

            if(!empty($experiences)) $profile_per = $profile_per + 10;

            $experiences = json_encode($experiences);


            $db->query("UPDATE cven SET formations = ?, experiences = ? WHERE user = ?", [$formations, $experiences, $_SESSION['id']]);

            $message_flash = "";



            if (!isset($p['metiers']) || count($p['metiers']) == 0 || count($p['metiers']) > 5) {

                $profile_per = $profile_per + 0;
                
                $message_flash = "Veuillez ajouter entre 1 et 5 spetialités pour afficher votre profile, ";
            
            } else {
            
                $db->query("DELETE FROM spetialites WHERE u = ?", [$_SESSION['id']]);

                foreach ($p['metiers'] as $m) {
                    $db->query("INSERT INTO spetialites (u, s) VALUES (?, ?)", [$_SESSION['id'], $m]);
                }

            }

            //$db->query("UPDATE utilisateurs SET profile_per = ? WHERE idU = ?", [$profile_per, $_SESSION['id']]);

            $message_flash .= "Profile modifié avec succes";

            \Func::setFlash("succes", $message_flash);

            \Func::redirect('#flash');

        } else {

            \Func::setFlash("error", "Veuillez remplir les champs obligatoir");

            \Func::redirect('#flash');
        }
    }

    static function frealancers($freelancers){

        foreach ($freelancers as $f) {

            $n = 0;

            echo "<a href='" . WEBROOT . "profile/$f->idU' class='freelancer bg1'>";

            if(!empty($f->avatar)){

                echo "<img alt='' src='" .  WEBROOT . "theme/assets/img/profile/$f->avatar'>";

            }else{

                echo "<img alt='' src='" .  WEBROOT . "theme/assets/img/default-avatar.png'>";

            }

            echo "<span class='name'>$f->spetialite</span>";

            echo "<div class='flex jc-center rating mt20'>";

            for ($i = 0; $i < $f->note; $i++) {
                echo "<span class='bg5'></span>";
                $n = $i;
            }

            $n = 5 - $n;

            for ($i = 1; $i < $n; $i++) {
                echo "<span class='bg8'></span>";
            }

            echo "<span class='ml10 rate'>($f->nbr_note)</span>";

            echo "</div>";

            echo "</a>";
        }

    }

    static function parrainnage_edit($p, $db){

        $freelance = [];

        if ($p['cooptation_freelance_name'] !== null) {

            foreach ($p['cooptation_freelance_name'] as $k => $v) {

                if (!empty($v)) array_push($freelance, ['name' => $v, 'email' => $p['cooptation_freelance_email'][$k], 'tele' => $p['cooptation_freelance_telephone'][$k], 'adresse' => $p['cooptation_freelance_adresse'][$k]]);
            
            };

        }

        $freelance = json_encode($freelance);

        $client = [];

        if ($p['cooptation_client_entreprise'] !== null) {

            foreach ($p['cooptation_client_entreprise'] as $k => $v) {

                if (!empty($v)) array_push($client, ['entreprise' => $v, 'name' => $p['cooptation_client_name'][$k], 'email' => $p['cooptation_client_email'][$k], 'tele' => $p['cooptation_client_telephone'][$k], 'adresse' => $p['cooptation_client_adresse'][$k]]);
            
            };

        }

        $client = json_encode($client);

        $db->query("DELETE FROM parrainage WHERE idU = ?", [$_SESSION['id']]);

        $db->query("INSERT INTO parrainage (idU, freelance, client) VALUES (?,?,?)", [$_SESSION['id'], $freelance, $client]);

        \Func::setFlash('succes', "Informations modifiées avec succès");

        \Func::redirect('#flash');

    }

    static function copie_cv_cven($db,$iduser){

        $db->query("UPDATE INTO cvia SELECT * FROM cv WHERE user='$iduser'");
 
        $db->query("
        UPDATE cvia SET bio   = (SELECT cv.bio FROM cv WHERE cv.user = '$iduser') 
        ,spetialite = (SELECT cv.spetialite FROM cv WHERE cv.user = '$iduser')
        ,tarif = (SELECT cv.tarif FROM cv WHERE cv.user = '$iduser')
        ,langues = (SELECT cv.langues FROM cv WHERE cv.user = '$iduser')
        ,geos = (SELECT cv.geos FROM cv WHERE cv.user = '$iduser')
        ,competances = (SELECT cv.competances FROM cv WHERE cv.user = '$iduser')
        ,languages = (SELECT cv.languages FROM cv WHERE cv.user = '$iduser')
        ,bdd = (SELECT cv.bdd FROM cv WHERE cv.user = '$iduser')
        ,cms = (SELECT cv.cms FROM cv WHERE cv.user = '$iduser')
        ,os = (SELECT cv.os FROM cv WHERE cv.user = '$iduser')
        ,outils = (SELECT cv.outils FROM cv WHERE cv.user = '$iduser')
        ,formations = (SELECT cv.formations FROM cv WHERE cv.user = '$iduser')
        ,experience_year = (SELECT cv.experience_year FROM cv WHERE cv.user = '$iduser')
        ,experiences = (SELECT cv.experiences FROM cv WHERE cv.user = '$iduser')");

        

        \Func::setFlash("succes", " veuillez rafraichir la page");

       // \Func::redirect('#flash');

    }

    static function get_users_profile85($db){

       return $db->query("SELECT nom,email FROM `utilisateurs` WHERE type=0 AND profile_per < 85;")->fetchall();
       // return $db->query("SELECT nom,email FROM `utilisateurs` WHERE type=0 && idU=46")->fetchall();
     }

     static function get_users_profileDiponibilte($db){

      return $db->query("SELECT nom, email, date_update_disponibilite FROM  `utilisateurs`  WHERE type = 0 AND profile_per >= 85 AND date_update_disponibilite < CURDATE() - INTERVAL 1 MONTH;")->fetchall();


       //return $db->query("SELECT nom,email,date_update_disponibilite FROM `utilisateurs` WHERE type=0 && idU=46")->fetchall();
     }

     static function initNbconsultatioMois($db,$id){  

       
        $db->query("UPDATE utilisateurs SET nbconsultationMois = 0 WHERE idU = ?", [$id]);
        
     }
     static function get_users_profileCV($db){

       // return $db->query("SELECT nom,email FROM `utilisateurs` WHERE type=0 AND profile_per < 85;")->fetchall();
    // return $db->query("SELECT idU,nom ,email,nbr_mission,date_disponibilite,date,nbconsultation,nbconsultationMois FROM `utilisateurs` WHERE type=0 && idU=46")->fetchall();
    return $db->query("SELECT idU,nom ,email,nbr_mission,date_disponibilite,date,nbconsultation,nbconsultationMois FROM `utilisateurs`WHERE type=0 AND profile_per >= 85;")->fetchall();
      }
}
