<?php
/**
 * Created by PhpStorm.
 * User: Khaled
 * Date: 29/09/2019
 * Time: 11:36
 */

namespace Root;

class Transactions {

    static $prix_abonnement = 9.99;

    static function transactionById($id, $db){

        $transaction = $db->query("SELECT idT, transaction_id, user, prestataire, price, card, last4, url, created_at FROM payment_transaction WHERE idT = :id OR transaction_id = :id", ['id' => $id])->fetch();

        if (empty($transaction)) \Func::_404();

        return $transaction;
    }

    static function transactionByMission($mission_id, $prestataire, $db){
    
        $transaction = $db->query("SELECT idT, transaction_id, user, prestataire, price, card, last4, url, created_at FROM payment_transaction WHERE mission = ? AND user = ? AND prestataire = ? ORDER BY idT DESC", [$mission_id, $_SESSION['id'], $prestataire])->fetch();

        if(empty($transaction)) \Func::_404();

        return $transaction;

    }

    static function add($p_id, $offer, $card, $last4, $url, $db){

        $db->query("INSERT INTO payment_transaction (transaction_id, user, prestataire, price, card, last4, url, mission, commission, tva_commission, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())", [$p_id, $_SESSION['id'], $offer->idU, $offer->total, $card, $last4, $url, $offer->mission, $offer->commission, $offer->tva_commission]);

    }

    static function addAbonnementTransaction($p_id, $prix, $card, $last4, $url, $db){

        $db->query("INSERT INTO payment_transaction (transaction_id, user, prestataire, price, card, last4, url, mission, commission, tva_commission, created_at, type) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), 1)", [$p_id, $_SESSION['id'], 0, $prix / 100, $card, $last4, $url, 0, 0, 0]);

    }

    static function addRefund($p_id, $mission_id, $offer, $card, $last4, $url, $reason, $db){

        $db->query("INSERT INTO payment_transaction (transaction_id, user, prestataire, price, card, last4, url, reason, mission, commission, tva_commission, created_at, stt) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), 2)", [$p_id, $_SESSION['id'], $offer->idU, ($offer->total * -1), $card, $last4, $url, $reason, $mission_id, $offer->commission, $offer->tva_commission]);
    
    }

    static function get($db){

        $transactions = $db->query("SELECT idT, transaction_id, price, card, last4, url, reason, payment_transaction.created_at, payment_transaction.stt, titre FROM payment_transaction INNER JOIN commandes ON idC = payment_transaction.mission WHERE payment_transaction.user = ? ORDER BY idT DESC", [$_SESSION['id']])->fetchAll();

        foreach($transactions AS $t){

            $background = '';

            if ($t->stt == '1' || $t->stt == '3') {

                $background = 'background: rgba(0,255,0,0.2) !important';

            } elseif ($t->stt == '2') {

                $background = 'background:rgba(255,0,0,0.2) !important';
                
            }

            echo "<tr style='$background'>";
            echo "<td>$t->titre</td>";
            echo "<td><b>$t->price</b> €</td>";
            echo "<td>$t->transaction_id</td>";
            echo "<td>$t->card - $t->last4</td>";
            echo "<td>";
            if(!empty($t->url)){
                echo "<a href='$t->url' target='_blanl'>Lien</a>";
            }else{
                echo "<b>Remboursement</b> : $t->reason";
            }
            echo "</td>";
            echo "<td>$t->created_at</td>";
            echo "</tr>";

        }

    }




    // Prestataire

    static function getPrestataire($db){

        $transactions = $db->query("SELECT idT, price, reason, payment_transaction.commission, payment_transaction.tva_commission, payment_transaction.created_at, payment_transaction.stt, titre FROM payment_transaction INNER JOIN commandes ON idC = payment_transaction.mission WHERE payment_transaction.prestataire = ? ORDER BY idT DESC", [$_SESSION['id']])->fetchAll();

        foreach ($transactions as $t) {

            echo "<tr>";
            echo "<td>$t->titre</td>";
            echo "<td>$t->price €</td>";
            
            if($t->stt == 2){

                echo "<td>-" . ($t->commission + $t->tva_commission) . " €</td>";
                echo "<td><b>" . ($t->price + $t->commission + $t->tva_commission) . "</b> €</td>";

            }else{

                echo "<td>-" . ($t->commission + $t->tva_commission) . " €</td>";
                echo "<td><b>" . ($t->price - $t->commission - $t->tva_commission) . "</b> €</td>";

            }
            
            echo "<td>$t->created_at</td>";
            if($t->stt == 0){
                echo "<td class='cl7'>Paiement en attente</td>";
            }elseif($t->stt == 1){
                echo "<td style='color:blue'><b>Mission finalisée</b></td>";
            }elseif ($t->stt == 2) {
                echo "<td style='color:red'><b>Paiement annulé</b> : $t->reason</td>";
            }elseif($t->stt == 3) {
                echo "<td style='color:green'><b>Paiement reçu</b></td>";
            }
            echo "</tr>";
        }
    }


    // Abonnement

    static function addAbonnement($p_id, $p_status, $prix, $user, $card, $last4, $url, $db, $prix_abonnement){

        $isInserted = $db->query("SELECT transaction_id FROM payment_transaction WHERE transaction_id = ?", [$p_id])->fetch();
        
        if(empty($isInserted)){

            if ($p_status == 'succeeded' && $user == $_SESSION['id']) {

                if($prix / 100 !== $prix_abonnement){

                    \Func::setFlash("error", "Impossible d'accepter ce paiement, il est différent de $prix_abonnement € / mois");

                    \Func::redirect('paiements');

                }

                Transactions::addAbonnementTransaction($p_id, $prix, $card, $last4, $url, $db);

                $premium = Utilisateur::isPremium($_SESSION['id'], $db);

                if($premium == false){

                    $db->query("UPDATE utilisateurs SET abonnement = DATE_ADD('". date('Y-m-d'). "', INTERVAL 1 MONTH) WHERE idU = ?", [$_SESSION['id']]);

                }else{

                    $db->query("UPDATE utilisateurs SET abonnement = DATE_ADD('$premium', INTERVAL 1 MONTH) WHERE idU = ?", [$_SESSION['id']]);

                }

            } else {

                \Func::setFlash("error", "Impossible d'accepter ce paiement, Paiement non effectué, veuillez vérifier votre banque");

                \Func::redirect('paiements');
            }

        }else{

            \Func::setFlash("error", "Impossible d'enregistrer un paiement une deuxième fois");

            \Func::redirect('paiements');

        }
        
    }

    static function getAbonnementPaiements($db){

        $transactions = $db->query("SELECT idT, transaction_id, price, price, card, last4, url, created_at FROM payment_transaction WHERE user = ? ORDER BY idT DESC", [$_SESSION['id']])->fetchAll();

        foreach ($transactions as $t) {

            echo "<tr>";
            echo "<td>$t->transaction_id</td>";
            echo "<td>$t->price €</td>";

            echo "<td>$t->card - $t->last4</td>";
            echo "<td><a href='$t->url' target='_blank'>lien</a></td>";
            echo "<td>$t->created_at</td>";
            echo "<td><a href='facture?transaction_id=$t->idT' class='btn2 bg3 cl1'><span class='icon mr8 fz13'>-</span>facture</a></td>";
            
            echo "</tr>";
        }
    }

} 