<?php
/**
 * Created by PhpStorm.
 * User: Khaled
 * Date: 29/09/2019
 * Time: 11:36
 */

namespace Root;


class Ticket {

    static function get($db){

        $filter = '';

        if(isset($_GET['stt'])) $filter .= " AND t_stt = '". $_GET['stt'] ."'";

        $tickets = $db->query("SELECT idT, freelance, t_tarif, t_duree, t_adresse, t_description, t_stt, message, entretien, t_date, idU, nom, email, tele, avatar FROM ticket INNER JOIN utilisateurs ON idU = freelance WHERE entreprise = ?$filter ORDER BY idT DESC", [$_SESSION['id']])->fetchAll();

        foreach($tickets AS $t){

            echo "<div class='box p20 mb30'>";

            echo "<h2>$t->nom</h2>";

            echo "<textarea class='mb20' rows='8' style=' min-width:200px ; max-width:100% ;width:100%'>Description de la mission : $t->t_description</textarea>";

            echo "<p class='mb20'>Mon offre : <strong>". $t->t_tarif."€</strong></p>";
            
            echo "<p class='mb20'>Adresse de la mission : <strong>$t->t_adresse</strong></p>";

            //echo "<h3>Total de la mission : ". $t->t_tarif * $t->t_duree. "€</h3>";

            if ($t->t_stt == 1) {

                echo "<hr>";

                echo "<p class='error'>$t->message</p>";

            } elseif ($t->t_stt == 2) {

                echo "<hr>";

                echo "<p class='succes'>Entretien avec le freelance</p>";

                echo "<h3>Date de l'entretien</h3>";

                echo "<p class='mb20'>Date : <strong>". date('d/m/Y à H:i', strtotime($t->entretien)) ."</strong></p>";

            } elseif ($t->t_stt == 3) {

                echo "<hr>";

                echo "<p class='succes'>Accepté - Mission en cours</p>";

                echo "<h3>Informations du freelance</h3>";

                echo "<p class='mb20'>Adresse email : <strong>$t->email</strong></p>";
                echo "<p class='mb30'>Numéro de téléphone : <strong>$t->tele</strong></p>";

                echo "<a href='cra?ticket=$t->idT' class='btn cl1 bg2 mb10'>CRA</a> ";
                echo "<a href='cra-hno?ticket=$t->idT' class='btn cl1 bg2 mb10'>CRA HNO</a>";

            } elseif($t->t_stt == 4) {
                echo "<hr>";
                echo "<p class='p20'>Mission finalisé</p>";

                echo "<a href='cra?ticket=$t->idT' class='btn cl1 bg2 mb10'>CRA</a> ";
                echo "<a href='cra-hno?ticket=$t->idT' class='btn cl1 bg2 mb10'>CRA HNO</a> ";

                if(Avis::exist($t->idT, $db)) echo "<a href='avis?ticket=$t->idT' class='btn cl1 bg2 mb10'>Ajouter un avis sur le freelance</a>";
            }

            if ($t->t_stt == 0 || $t->t_stt == 1) echo "<hr><div class='flex jc-start mt20'><a href='modifier-ticket?id=$t->freelance&ticket=$t->idT' class='btn bg4 cl1 mr10'>Modifer</a> <span onclick='delete_ticket(this, event, $t->idT)' class='btn bg3 cl1'>Supprimer</span></div>";

            echo "</div>";

        }

    }

    static function getFreelance($db){

        $filter = '';

        if (isset($_GET['commandes'])) $filter .= " AND t_stt = '" . $_GET['commandes'] . "'";

        $tickets = $db->query("SELECT idT, freelance, t_tarif, t_duree, t_adresse, t_description, t_stt, t_tjm, message, entretien, t_date, idU, nom, email, tele, avatar FROM ticket INNER JOIN utilisateurs ON idU = entreprise WHERE freelance = ?$filter ORDER BY idT DESC", [$_SESSION['id']])->fetchAll();
 // Vérifier si $tickets est vide
            if (empty($tickets)) {
    // Afficher le message indiquant que l'utilisateur n'a aucune mission
            echo "<p>Vous avez <strong style='color:red;'>0</strong> mission.</p>";
        } else {
        
        foreach ($tickets as $t) {

            echo "<div class='box p20 mb20'>";

            echo "<h2>Mission : $t->idT</h2>";

            echo "<textarea class='mb20' rows='8' style=' min-width:200px ; max-width:100% ;width:100%'>Description de la mission : $t->t_description</textarea>";
            
            if ($t->t_tjm == 0){
            echo "<p class='mb20'>Offre : <strong>en négociation</strong> (TJM)</p>";
            } else{
            echo "<p class='mb20'>Offre : <strong>" . $t->t_tjm . "€</strong> (TJM)</p>";
            }

            if ($t->t_stt == 0 || $t->t_stt == 1) {

                echo "<hr>";

                echo "<p class='mb20 mt20 rem'>Mission en attente de validation par un adminstrateur</p>";

            } elseif ($t->t_stt == 2) {

                echo "<hr>";

                echo "<p class='succes'>Entretien avec l'entreprise</p>";

                echo "<h3>Date de l'entretien</h3>";

                echo "<p class='mb20'>Date : <strong>" . date('d/m/Y à H:i', strtotime($t->entretien)) . "</strong></p>";

            } elseif ($t->t_stt == 3) {

                echo "<hr>";

                echo "<p class='succes'>Accepté - Mission en cours</p>";

                echo "<h3>Informations de l'entreprise</h3>";

                echo "<p class='mb20'>Nom : <strong>$t->nom</strong></p>";
                echo "<p class='mb20'>Adresse email : <strong>$t->email</strong></p>";
                echo "<p class='mb20'>Numéro de téléphone : <strong>$t->tele</strong></p>";

                echo "<p class='mb30'>Adresse de la mission : <strong>$t->t_adresse</strong></p>";

                echo "<a href='remplir-cra?ticket=$t->idT' class='btn bg2 cl1'>CRA</a> ";
                echo "<a href='remplir-cra-hno?ticket=$t->idT' class='btn bg2 cl1'>CRA HNO</a>";

            } elseif ($t->t_stt == 4) {

                echo "<hr>";
                echo "<p class='p20'>Mission finalisé</p>";
            }

            echo "</div>";
        }
    }
    }

    static function getById($id, $db, $select = '*'){
  

        $ticket = $db->query("SELECT $select FROM ticket WHERE idT = ?", [$id])->fetch();

        if(!empty($ticket)) return $ticket;

        \Func::_404();
    
    }

    static function create($freelance, $post, $db){

        if(isset($freelance) && !empty($post['tarif']) && !empty($post['duree']) && !empty($post['adresse']) && !empty($post['description'])){

            $db->query("INSERT INTO ticket (entreprise, freelance, t_tarif, t_date_debut, t_duree, t_adresse, t_description, t_date) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())", [$_SESSION['id'], $freelance, $post['tarif'], $post['debut'], $post['duree'], $post['adresse'], $post['description']]);

            $freelance_user = $db->select('nom, email', 'utilisateurs')->where('idU = ?')->find([$freelance]);
           
            \Mail::alerte_client_freelance($freelance_user->email, $freelance_user->nom," un client s'intéresse à votre profile , un de nos commerciaux se charge du dossier et vous contactera dans le plus bref délai"," - Bravo nouvelle mission ");

            \Func::setFlash('succes', "Ticket crée avec succès, nous allons vous recontacter");
            \Func::redirect('dashboard?stt=0');
            
        }else{

            \Func::setFlash('error', "Veuillez remplir tous les champs obligatoires");
            \Func::redirect('#flash');

        }

    }
    static function createIA($freelance, $post, $db){

        if(isset($freelance) && !empty($post['tarif']) && !empty($post['duree']) && !empty($post['adresse']) && !empty($post['description'])){

            $db->query("INSERT INTO ticket (entreprise, freelance, t_tarif, t_date_debut, t_duree, t_adresse, t_description, t_date) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())", [$_SESSION['id'], $freelance, $post['tarif'], $post['debut'], $post['duree'], $post['adresse'], $post['description']]);
            
            $idT = $db->query('SELECT idT FROM ticket ORDER BY idT DESC LIMIT 1')->fetch();
        
           
       
           // $freelance_user = $db->select('nom, email', 'utilisateurs')->where('idU = ?')->find([$freelance]);
           
           //  \Mail::alerte_client_freelance($freelance_user->email, $freelance_user->nom," un client s'intéresse à votre profile , un de nos commerciaux se charge du dossier et vous contactera dans le plus bref délai"," - Bravo nouvelle mission ");

            \Func::setFlash('succes', "Ticket crée avec succès, nous allons vous recontacter");
            \Func::redirect("chatgbtClient?id=$idT->idT");
           
            
            
       }else{

           \Func::setFlash('error', "Veuillez remplir tous les champs obligatoires");
           \Func::redirect('#flash');

        }

    }
    static function edit($ticket, $post, $db){

        if (!empty($post['tarif']) && !empty($post['debut']) && !empty($post['duree']) && !empty($post['adresse']) && !empty($post['description'])) {

            $db->query("UPDATE ticket SET t_tarif = ?, t_date_debut = ?, t_duree = ?, t_adresse = ?, t_description = ? WHERE idT = ? AND entreprise = ?", [$post['tarif'], $post['debut'], $post['duree'], $post['adresse'], $post['description'], $ticket, $_SESSION['id']]);

            \Func::setFlash('succes', "Ticket modifié avec succès");
            \Func::redirect('#flash');

        } else {

            \Func::setFlash('error', "Veuillez remplir tous les champs obligatoires");
            \Func::redirect('#flash');
        }
    }

} 