<?php

namespace Root;

class Stripe {

    static function init(){

        require "gla-adminer/lib/vendor/autoload.php";

        $stripe = new \Stripe\StripeClient("pk_live_51LSjnoFAedrPb3xgJkGGhILDnZ2d6zxImwDRBR2d6XSN8AWqGG3JOrqYcvRGGbVjb9iNNFWfMBkeBB1iW7YzNL5h00QRxq4LoJ");

        return $stripe;

    }

    static function create_customer($db){

        $res = $db->query("SELECT customer FROM payment_customer WHERE user = ?", [$_SESSION['id']])->fetch();

        if(empty($res)){

            if ($_SESSION['type'] == 0) {

                $stripe = self::init();

                $return = $stripe->customers->create([
                    'name' => $_SESSION['name'],
                    'email' => $_SESSION['email']
                ]);

                //var_dump($return);

                $db->query("INSERT INTO payment_customer (user, customer) VALUES (?,?)", [$_SESSION['id'], $return['id']]);

                return $return['id'];

            }

        }else{

            return $res->customer;

        }

    }

    static function create_payment_method($post, $customer, $db){

        if (!empty($post['card']) && !empty($post['month']) && !empty($post['year']) && !empty($post['cvc'])) {

            $stripe = self::init();

            /*
            $return = $stripe->paymentMethods->create([
                'type' => 'card',
                'card' => [
                    'number' => $post['card'],
                    'exp_month' => $post['month'],
                    'exp_year' => $post['year'],
                    'cvc' => $post['cvc']
                ],
            ]);
            
            $stripe->paymentMethods->attach(
                $return['id'],
                ['customer' => $customer]
            );

            */

            $token = $stripe->tokens->create([
                'card' => [
                    'number' => '4242424242424242',
                    'exp_month' => 12,
                    'exp_year' => 2022,
                    'cvc' => '314',
                ],
            ]);

            $return = $stripe->customers->createSource(
                $customer,
                ['source' => $token['id']]
            );

            var_dump($return);
            var_dump($customer);

            $db->query("UPDATE payment_customer SET payment_method = ? WHERE user = ?", [$return['id'], $_SESSION['id']]);

            
        }

    }

    // Créer un paiement avec un customer

    static function create_paiement($service_id, $price, $db){

        $res = $db->query("SELECT customer, payment_method FROM payment_customer WHERE user = ?", [$_SESSION['id']])->fetch();

        if (!empty($res)) {

            if ($_SESSION['type'] == 0) {

                $stripe = self::init();

                $return = $stripe->paymentIntents->create([
                    'amount' => $price * 100,
                    'currency' => 'eur',
                    //'payment_method_types' => ['card'],
                    'customer' => $res->customer,
                    'payment_method' => $res->payment_method,
                    'confirm' => true,
                    "metadata" => ["service_id" => $service_id],
                    'description' => 'Piement du service : ' . $service_id,
                    'receipt_email' => 'service.comptabilite@laotop.fr'
                ]);

                /*

                Valider le peiement manuellement Si non mettre 'confirm' = true et ajouter payment_methode

                $pm = $stripe->paymentIntents->confirm(
                    $return['id'],
                    ['payment_method' => $res->payment_method]
                );

                */

                var_dump($return);

                $db->query("INSERT INTO payment_transaction (transaction_id, user, price, service, created_at) VALUES (?, ?, ?, ?, NOW())", [$return['id'], $_SESSION['id'], $price, $service_id]);

                return $return['id'];
            }

        } else {

            return false;
        }
    }

    //Créer un paiement avec une carte directement (Sans customer)

    static function create_paiement_with_card($service_id, $price, $db){

        $stripe = self::init();

        $token = $stripe->tokens->create([
            'card' => [
                'number' => '4242424242424242',
                'exp_month' => 12,
                'exp_year' => 2022,
                'cvc' => '314',
            ],
        ]);

        $return = $stripe->charges->create([
            'amount' => $price * 100,
            'currency' => 'eur',
            'source' => $token['id'],
            'description' => 'My First Test Charge (created for API docs)',
            "metadata" => ["service_id" => $service_id]
        ]);


        var_dump($return);

        return $return['id'];
            
    }

    //Créer un paiement vers compte bancaire

    static function create_payout($card, $db){

        //$card = 'card_1K8W2eC00VZGTHxtPZKxBMt4'

        $stripe = self::init();

        $return = $stripe->payouts->create([
            'amount' => 24784,
            'currency' => 'eur',
            'source_type' => 'bank_account'
        ]);

        var_dump($return);

        return $return['id'];

    }

    //Créer un intent

    static function create_intents($mission_id, $offer_id, $price){

        $stripe = self::init();

        $intent = $stripe->paymentIntents->create(
            [
                'amount' => $price * 100,
                'currency' => 'eur',
                'description' => "Piement de la mission $mission_id par " . $_SESSION['name'],
                'metadata' => ["mission_id" => $mission_id, "offer_id" => $offer_id, "user_id" => $_SESSION['id']],
                'receipt_email' => "service.comptabilite@laotop.fr",
                'automatic_payment_methods' => ['enabled' => true],
            ]
        );

        return $intent;

    }

    static function create_intents_abonnement($price = 9.99){

        $stripe = self::init();

        $intent = $stripe->paymentIntents->create(
            [
                'amount' => $price * 100,
                'currency' => 'eur',
                'description' => "Paiement d'un abonnement par " . $_SESSION['name'],
                'metadata' => ["user_id" => $_SESSION['id']],
                'receipt_email' => "service.comptabilite@laotop.fr",
                'automatic_payment_methods' => ['enabled' => true]
            ]
        );

        return $intent;
    }

    //Vérifier un intent

    static function verify_intents($payment_intent){

        $stripe = self::init();

        $intent = $stripe->paymentIntents->retrieve(
            $payment_intent,
            []
        );

        return $intent;
        
    }

    //Créer un remboursement / refund

    static function create_refund($intent){

        $stripe = self::init();

        $refund = $stripe->refunds->create([
            'payment_intent' => $intent,
            'reason' => 'requested_by_customer'
        ]);

        return $refund;
    }

} 