<?php

namespace Root;

class SocialConnect {

    // Facebook ------------------------------------------------------

    static function facebookProvider(){

        require "gla-adminer/lib/vendor/autoload.php";

        $provider = new \League\OAuth2\Client\Provider\Facebook([
            'clientId'          => '535729274587144',
            'clientSecret'      => 'd1eb77372f2a88f659e1949be992396c',
            'redirectUri'       => 'https://www.laotop.fr/page/connexion-facebook',
            'graphApiVersion'   => 'v12.0',
        ]);

        return $provider;
    }

    static function facebook(){

        $provider = self::facebookProvider();

        $authUrl = $provider->getAuthorizationUrl([
            'scope' => ['email'],
        ]);

        $_SESSION['oauth2state'] = $provider->getState();

        return htmlspecialchars($authUrl);

    }

    static function facebookConnect(){

        if (empty($_GET['code'])) \Func::_404();

        $provider = self::facebookProvider();

        // Try to get an access token (using the authorization code grant)
        $token = $provider->getAccessToken('authorization_code', [
            'code' => $_GET['code']
        ]);

        // Optional: Now you have a token you can look up a users profile data
        try {

            // We got an access token, let's now get the user's details
            $user = $provider->getResourceOwner($token);

            if(!empty($user->getEmail())){

                $db = \BDD\App::getBDD();

                $user_infos = $db->query('SELECT idU, nom, email, tele, avatar, type FROM utilisateurs WHERE (email = :login OR tele = :login) AND type = 0', ['login' => strtolower(trim($user->getEmail()))])->fetch();

                if (!empty($user_infos)) {

                    Utilisateur::connect($user_infos);
                    
                } else {

                    \Func::setFlash('succes', "Vous n'avez pas encore un compte sur laotop.fr inscrivez vous dès maintenant");
                    
                    //\Func::redirect('inscription?nom=' . $user->getName() . '&email='. $user->getEmail());

                }

            }else{

                \Func::setFlash('error', "Votre compte facebook ne dispose d'aucune adresse email, impossibile de vous connecter avec facebook");
                \Func::redirect('connexion');

            }

        } catch (\Exception $e) {

            // Failed to get user details
            //exit('Oh dear...');

            \Func::setFlash('error', "Impossibile de vous connecter avec facebook");

            \Func::redirect('connexion');

        }

        echo '<pre>';
        // Use this to interact with an API on the users behalf
        var_dump($token->getToken());
        # string(217) "CAADAppfn3msBAI7tZBLWg...

        // The time (in epoch time) when an access token will expire
        var_dump($token->getExpires());
        # int(1436825866)
        echo '</pre>';

        $id = $user->getId();
        var_dump($id);
        # string(1) "4"

        $name = $user->getName();
        var_dump($name);
        # string(15) "Mark Zuckerberg"

        $firstName = $user->getFirstName();
        var_dump($firstName);
        # string(4) "Mark"

        $lastName = $user->getLastName();
        var_dump($lastName);
        # string(10) "Zuckerberg"

        # Requires the "email" permission
        $email = $user->getEmail();
        var_dump($email);
        # string(15) "thezuck@foo.com"

        # Requires the "user_hometown" permission
        $hometown = $user->getHometown();
        var_dump($hometown);
        # array(10) { ["id"]=> string(10) "12345567890" ...

        # Requires the "user_about_me" permission
        $bio = $user->getBio();
        var_dump($bio);
        # string(426) "All about me...

        $pictureUrl = $user->getPictureUrl();
        var_dump($pictureUrl);
        # string(224) "https://fbcdn-profile-a.akamaihd.net/hprofile- ...

        $isDefaultPicture = $user->isDefaultPicture();
        var_dump($isDefaultPicture);
        # boolean false

        $coverPhotoUrl = $user->getCoverPhotoUrl();
        var_dump($coverPhotoUrl);
        # string(111) "https://fbcdn-profile-a.akamaihd.net/hphotos- ...

        $gender = $user->getGender();
        var_dump($gender);
        # string(4) "male"

        $locale = $user->getLocale();
        var_dump($locale);
        # string(5) "en_US"

        $timezone = $user->getTimezone();
        var_dump($timezone);
        # int -5

        $link = $user->getLink();
        var_dump($link);
        # string(62) "https://www.facebook.com/app_scoped_user_id/1234567890/"

        $maxAge = $user->getMaxAge();
        var_dump($maxAge);
        # int 17 | null

        $minAge = $user->getMinAge();
        var_dump($minAge);
# int 21

    }




    // Google ------------------------------------------------------

    static function googleProvider(){

        require "gla-adminer/lib/vendor/autoload.php";

        $provider = new \League\OAuth2\Client\Provider\Google([
            'clientId'     => '777782030307-8gh07n8o63lg6lod99uuilhrinain1tu.apps.googleusercontent.com',
            'clientSecret' => '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',
            'redirectUri'  => 'https://www.laotop.fr/page/connexion-google',
        ]);

        return $provider;
    }

    static function google(){

        $provider = self::googleProvider();

        // No HTML for demo, prevents any attempt at XSS
        //header('Content-Type', 'text/plain');

        $authUrl = $provider->getAuthorizationUrl();

        $_SESSION['oauth2state'] = $provider->getState();

        return htmlspecialchars($authUrl);
    
    }

    static function googleConnect(){

        if (empty($_GET['code'])) \Func::_404();

        $provider = self::googleProvider();

        $token = $provider->getAccessToken('authorization_code', [
            'code' => $_GET['code']
        ]);

        // Optional: Now you have a token you can look up a users profile data
        try {

            // We got an access token, let's now get the owner details
            $ownerDetails = $provider->getResourceOwner($token);

            if (!empty($ownerDetails->getEmail())) {

                $db = \BDD\App::getBDD();

                $user_infos = $db->query('SELECT idU, nom, email, tele, avatar, type FROM utilisateurs WHERE (email = :login OR tele = :login) AND type = 0', ['login' => strtolower(trim($ownerDetails->getEmail()))])->fetch();

                if (!empty($user_infos)) {

                    Utilisateur::connect($user_infos);

                } else {

                    \Func::setFlash('succes', "Vous n'avez pas encore un compte sur laotop.fr inscrivez vous dès maintenant");

                }
                
            } else {

                \Func::setFlash('error', "Votre compte Google ne dispose d'aucune adresse email, impossibile de vous connecter avec Google");
                \Func::redirect('connexion');

            }

        } catch (Exception $e) {


            \Func::setFlash('error', "Impossibile de vous connecter avec google");

            \Func::redirect('connexion');

        }

    }


    // Connecte ------------------------------------------------------

    static function userByEmail($email){


    }

}