<?php
namespace Root;


class GLAsite {

    public $url;
    private $page;
    public $article_by_page;
    public $date;
   
    private $single;
    private int $singleArticle;
    private $singleRedaction;
    public $site;

    public function __construct($db){

        $this->url = $_GET['u'];
        $this->page = $this->exp($this->url);
        $this->db = $db;
        $this->article_by_page = 8;

        $this->single = null;
        $this->singleRedaction = null;
        $this->singleArticle=1;
        $this->site = $this->siteInformation();

    }

    public function informations(){

        $p = $this->page[0];

        if(empty($this->url)){

            return [
                "title" => $this->site->title." - ".$this->site->name,
                "meta-description" => $this->site->description
            ];

        }else{

            if(isset($p) && in_array($p ,['page','categorie','search','typearticle','mission','profile']) && isset($this->page[1])){

                switch($p){

                    case 'page':
                        return [
                            "title" => $this->pageTitle()." - ".$this->site->name,
                            "meta-description" => substr($this->pageContent(),0,230)
                        ];
                    break;

                    case 'categorie':
                        return [
                            "title" => $this->catTitle()." - ".$this->site->name,
                            "meta-description" => substr($this->catDesc(),0,230)
                        ];
                    break;

                    case 'typearticle':
                        return [
                            "title" => $this->typeTitle()." - ".$this->site->name,
                            "meta-description" => substr($this->typeDesc(),0,230)
                        ];
                    break;

                    case 'search':

                        if(empty($_GET['s'])) $_GET['s'] = '';

                        return [
                            "title" => $_GET['s']." - ".$this->site->name,
                            "meta-description" => $this->site->name. " recherche de produits ".$_GET['s']
                        ];
                    break;

                    case 'mission':
                        return [
                            "title" => $this->missionTitle()." - ".$this->site->name,
                            "meta-description" => substr($this->missionDesc(),0,180)
                        ];
                    break;

                    case 'profile':
                        return [
                            "title" => \Func::name($this->profileTitle()) . " - " . $this->site->name,
                            "meta-description" => substr($this->profileTitle(), 0, 180)
                        ];
                    break;

                }

            }else{

                if($p == '404'){

                    return [
                        "title" => "Page introuvable - Erreur 404 - ".$this->site->name,
                        "meta-description" => "Cette page est introuvable, elle à peut être été supprimé ou son url à été changé."
                    ];

                }else{
                    if (isset($this->singleArticle)) {
                        if ($this->singleArticle === 0) {
                            $this->singleRedaction();
                          /*  return [
                                "title" => $this->redactionarticleTitle()." - ".$this->site->name,
                                "meta-description" => substr($this->redactionarticleContent(),0,230),
                                "meta-opengraph" => "
                                <meta property='og:title' content=\"".$this->redactionarticleTitle()."\"/>
                                <meta property='og:type' content='article'/>
                                <meta property='og:url' content='".WEBROOT.$this->redactionarticleUrl()."/'/>
                                <meta property='og:image' content='".$this->redactionarticleImageFull()."'/>\n"
                            ];*/
                        } else {
                            $this->single();
                            return [
                                "title" => $this->articleTitle()." - ".$this->site->name,
                                "meta-description" => substr($this->articleContent(),0,230),
                                "meta-opengraph" => "
                                <meta property='og:title' content=\"".$this->articleTitle()."\"/>
                                <meta property='og:type' content='article'/>
                                <meta property='og:url' content='".WEBROOT.$this->articleUrl()."/'/>
                                <meta property='og:image' content='".$this->articleImageFull()."'/>\n"
                            ];
        
                        }
                    }
                }

            }

        }

    }

    public function getMeta(){

        echo $this->metaDescription();
        echo "    <title>".$this->title()."</title>\n";
        echo "    ". $this->siteMetaTags()."\n";

        echo $this->metaOpenGraph();

    }

    public function siteInformation(){

        return $this->db->query("SELECT * FROM site")->fetch();

    }

    private function title(){return $this->informations()['title'];}
    private function metaDescription(){return "<meta name='description' content=\"".strip_tags($this->informations()['meta-description'])."\">\n";}
    private function metaOpenGraph(){

        if(!empty($this->informations()['meta-opengraph'])) return $this->informations()['meta-opengraph'];

    }

    public function exp(){
        $e = trim($this->url,'/');
        return explode('/',$e);
    }

    private function page(){

        $page = $this->page;

        if(isset($page['1'])){

            $p = $this->db->query('SELECT * FROM pages WHERE url = ?',[$page['1']])->fetch();
            if(!empty($p)){

                return $p;

            }else {

                \Func::_404();

            }

        }

    }

    private function categorie(){

        $page = $this->page;

        if(isset($page['2'])){

            $p = $this->db->query('SELECT * FROM categories WHERE url = ?',[$page['2']])->fetch();
            if(!empty($p)){

                return $p;

            }else {

                \Func::_404();

            }

        }else{

            if(isset($page['1'])){

                $p = $this->db->query('SELECT * FROM categories WHERE url = ?',[$page['1']])->fetch();
                if(!empty($p)){

                    return $p;

                }else {

                    \Func::_404();

                }

            }

        }

    }
    private function typearticle(){

        $page = $this->page;

        if(isset($page['2'])){

            $p = $this->db->query('SELECT * FROM typearticles WHERE url = ?',[$page['2']])->fetch();
            if(!empty($p)){

                return $p;

            }else {

                \Func::_404();

            }

        }else{

            if(isset($page['1'])){

                $p = $this->db->query('SELECT * FROM typearticles WHERE url = ?',[$page['1']])->fetch();
                if(!empty($p)){

                    return $p;

                }else {

                    \Func::_404();

                }

            }

        }

    }
    private function single(){

        $page = $this->page;

        if(isset($page['0'])){

            $p = $this->db->query('SELECT * FROM articles WHERE url = ?',[$page['0']])->fetch();
            $p1 = $this->db->query('SELECT * FROM redactionarticles WHERE url = ?',[$page['0']])->fetch();

            if(!empty($p)||!empty($p1)){
                if(!empty($p)||empty($p1))
 
                 $this->single = $p;
                 else{ $this->single = $p1;}
 
             }else {
 
                 \Func::_404();
 
             }

        }

    }
    private function singleRedaction() {
        $page = $this->page;
     
        if (isset($page['0'])) {
            $p = $this->db->query('SELECT * FROM redactionarticles WHERE url = ?', [$page['0']])->fetch();
    
            if (!empty($p)) {
                $this->singleRedaction = $p;
               
            } else {
                \Func::_404();
            }
        }
    }
    private function missions(){

        $page = $this->page;

        if(isset($page['1'])){

            $p = $this->db->query('SELECT * FROM commandes WHERE idC = ?',[$page['1']])->fetch();
            
            if(!empty($p)){

                return $p;

            }else {

                \Func::_404();

            }

        }

    }

    private function profile(){

        $page = $this->page;

        if (isset($page['1'])) {

            $p = $this->db->query('SELECT * FROM utilisateurs WHERE idU = ? AND type = 0', [$page['1']])->fetch();

            if (!empty($p)) {

                return $p;

            } else {

                \Func::_404();

            }
        }
    }

    public function cv($id){

        $p = $this->db->query('SELECT * FROM cv WHERE user = ?', [$id])->fetch();

        if (!empty($p)) {

            return $p;

        } else {

            \Func::_404();

        }

    }

    public function experienceOrg($id) {
     
       $result = $this->db->query('SELECT experiences FROM cv WHERE user = ?', [$id])->fetch();
       
       //$experiences = json_decode($result->experiences, true);
    
      $experiences = json_decode(utf8_encode($result->experiences), true);
    
        usort($experiences, function($a, $b) {
            if (empty($a['fin']) && !empty($b['fin'])) {
                return -1;
            } elseif (!empty($a['fin']) && empty($b['fin'])) {
                return 1;
            } else {
                return strtotime($b['debut']) - strtotime($a['debut']);
            }
        });

        $experiences_json = json_encode($experiences);
        

        if (!empty($experiences_json)) {
        
    
            return $experiences_json;
        } else {
            \Func::_404();
        }
    }

    public function formationOrg($id) {
     
        $result = $this->db->query('SELECT formations FROM cv WHERE user = ?', [$id])->fetch();
        
     
       $formations = json_decode(utf8_encode($result->formations), true);
     
         usort($formations, function($a, $b) {
             if (empty($a['fin']) && !empty($b['fin'])) {
                 return -1;
             } elseif (!empty($a['fin']) && empty($b['fin'])) {
                 return 1;
             } else {
                 return strtotime($b['debut']) - strtotime($a['debut']);
             }
         });
 
         $formations_json = json_encode($formations);
         
 
         if (!empty($formations_json)) {
         
     
             return $formations_json;
         } else {
             \Func::_404();
         }
     }

    public function spetialites($id){
        
        $p = $this->db->query("SELECT s FROM spetialites WHERE u = ?", [$id])->fetch();

        return $p;

    }

    public function getMenu(){

        $menu = $this->db->query("SELECT idM,name,url,parent FROM menu ORDER BY place ASC")->fetchAll();

        foreach($menu AS $m){

            if($m->parent == "0"){

                $tab[$m->idM] = $m;

            }

        }

        foreach($menu AS $key => $m){

            if($m->parent !== "0"){

                $tab[$m->parent]->sous[$m->idM] = $m;

            }

        }

        unset($tab[0]);

        echo "<ul>";

        foreach($tab AS $key => $m){

            if(empty($m->sous)){

                echo "<li><a href='".WEBROOT."$m->url'>$m->name</a></li>";

            }else{

                echo "<li><a href='".WEBROOT."$m->url'>$m->name<span class='icon cl1 ml5'>=</span></a>";

                echo "<ul>";

                foreach($m->sous AS $sm){

                    echo "<li><a href='".WEBROOT."$sm->url'>$sm->name</a></li>";

                }

                echo "</ul>";

                echo"</li>";

            }

        }

        echo "</ul>";

    }

    /* PAGINATION */

    public function article_by_page(){

        $this->article_by_page = 12;

    }

    public function date_format(){

        return "d/m/Y H:i";

    }

    public function paginationNbrArticles(){

        $c = $this->db->query("SELECT COUNT(idA) AS nbr FROM articles WHERE (categorie = :catID OR categorie IN (SELECT idC FROM categories WHERE parent = :catID))",[':catID' => $this->catID()])->fetch();

        return $c->nbr;

    }

    public function paginationNbrredactionArticles(){

        $c = $this->db->query("SELECT COUNT(idA) AS nbr FROM redactionarticles WHERE (categorie = :typeID OR categorie IN (SELECT idC FROM typearticles WHERE parent = :typeID))",[':typeID' => $this->typeID()])->fetch();
      
        return $c->nbr;

    }

    public function getPagination(){

        $nbr_article = $this->paginationNbrArticles();

        if(empty($nbr_article)) return false;

        $nbr_page = ceil($nbr_article / $this->article_by_page);

        if($nbr_page == 1) return false;

        $page = (!empty($_GET['page'])) ? $_GET['page'] : 1;

        $next = ($page < $nbr_page) ? ($page + 1) : $page;

        $prev = ($page > 1) ? ($page - 1) : $page;

        echo "<a href='?page=$prev' class='btn brc2 cl2 hover-bg2 hover-cl1'><</a>";

        for($i = 1; $i <= $nbr_page ; $i++){

            if($page == $i){
                $a = "class='btn bg2 brc2 cl1'";
            }else{
                $a = "class='btn brc2 cl2 hover-bg2 hover-cl1'";
            }

            echo "<a href='?page=$i' $a>$i</a>";

        }

        echo "<a href='?page=$next' class='btn brc2 cl2 hover-bg2 hover-cl1'>></a>";

    }

    public function getPaginationRedactionArticle(){
        

        $nbr_article = $this->paginationNbrredactionArticles();

        if(empty($nbr_article)) return false;

        $nbr_page = ceil($nbr_article / $this->article_by_page);

        if($nbr_page == 1) return false;

        $page = (!empty($_GET['page'])) ? $_GET['page'] : 1;

        $next = ($page < $nbr_page) ? ($page + 1) : $page;

        $prev = ($page > 1) ? ($page - 1) : $page;

        echo "<a href='?page=$prev' class='btn brc2 cl2 hover-bg2 hover-cl1'><</a>";

        for($i = 1; $i <= $nbr_page ; $i++){

            if($page == $i){
                $a = "class='btn bg2 brc2 cl1'";
            }else{
                $a = "class='btn brc2 cl2 hover-bg2 hover-cl1'";
            }

            echo "<a href='?page=$i' $a>$i</a>";

        }

        echo "<a href='?page=$next' class='btn brc2 cl2 hover-bg2 hover-cl1'>></a>";

    }

    public function articleByCategoriePagination(){

        $this->article_by_page();

        $page = (!empty($_GET['page'])) ? $_GET['page'] : 1;

        if($page > $this->paginationNbrArticles() || $page <= 1) $page = 1;

        $page = ($page - 1) * $this->article_by_page;

        return $this->db->query("SELECT * FROM articles WHERE (categorie = :catID OR categorie IN (SELECT idC FROM categories WHERE parent = :catID)) ORDER BY idA DESC LIMIT $page,$this->article_by_page",['catID' => $this->catID()])->fetchAll();

    }

    public function redactionarticleByCategoriePagination(){

        $this->article_by_page();

        $page = (!empty($_GET['page'])) ? $_GET['page'] : 1;

        if($page > $this->paginationNbrredactionArticles() || $page <= 1) $page = 1;

        $page = ($page - 1) * $this->article_by_page;

        return $this->db->query("SELECT * FROM redactionarticles WHERE (categorie = :typeID OR categorie IN (SELECT idC FROM typearticles WHERE parent = :typeID)) ORDER BY idA DESC LIMIT $page,$this->article_by_page",['typeID' => $this->typeID()])->fetchAll();

    }

    public function articleMosteSeen($limit = 8){

        return $this->db->query("SELECT idA, title, url, image, prix_min, prix_max FROM articles ORDER BY n_see DESC LIMIT $limit")->fetchAll();

    }


    /* ARTICLES RECUPERATION */

    public function articles($articles){

        foreach ($articles as $a) {

            echo "<a href='" . WEBROOT . "$a->url' class='article cl2'>";

            if ($a->image !== "") {
                echo "<img alt='' src='" . WEBROOT . "gla-adminer/uploads/article/small/$a->image'>";
            } else {
                echo "<img alt='' src='" . \Func::cache('theme/assets/img/pic.png') . "' >";
            }

            echo "<span class='title'>" . $a->title . "</span>";
            
            echo "</a>";
            
        }

    }

       /* REDACTION ARTICLES RECUPERATION */

    public function redactionarticles($articles){

        foreach ($articles as $a) {

            echo "<a href='" . WEBROOT . "$a->url' class='article cl2'>";

            if ($a->image !== "") {
                echo "<img src='" . WEBROOT . "gla-adminer/uploads/article/small/$a->image'>";
            } else {
                echo "<img src='" . \Func::cache('theme/assets/img/pic.png') . "' >";
            }

            echo "<span class='title'>" . $a->title . "</span>";
            
            echo "</a>";
            
        }

    }


    public function articleOptionsColor(){

        echo "<form>";
        echo "<input type='hidden' id='commande_price' value='". $this->articlePrice() ."'>";
        echo "<input type='hidden' id='commande_option' value='0'>";
        echo "<input type='hidden' id='commande_qtt' value='1'>";
        echo "</form>";

        $options = $this->db->query("SELECT * FROM articles_options WHERE article = ?", [$this->articleID()])->fetchAll();

        $colors = [];

        foreach($options AS $o){

            if (!array_key_exists($o->color, $colors)) {

                $colors[$o->color] = "$o->color";

            }

        }

        $size_display = true;

        if(count($colors) > 1){

            echo "<div class='grid5 mt10 mb30'>";

            foreach ($colors as $c) {

                echo "<span style='background-color:#$c' class='brc1solid brc1 hover-brc2' onclick=\"selectColor('cl$c', this)\"></span>";
            }

            echo "</div>";

            $size_display = false;

        }

        echo "<div class='gla-form article_options'>";

        foreach($colors AS $c){

            $active = ($size_display) ? "active" : "";

            echo "<div class='item flex cl$c $active'>";

                if(!$size_display) echo "<span style='background-color:#$c' class='span_2'></span>";

                echo "<select class='col-6 mr10' onchange='selectSize(this)'>";

                echo "<option value='0' selected disabled hidden>Sélectionner une taille / pointure</option>";

                foreach ($options as $o) {

                    if ($c == $o->color){

                        $disabled = ($o->qtt == 0) ? 'disabled' : '';
                        
                        if($o->qtt > 4){

                            $stock = "";

                        }elseif($o->qtt == 0){

                            $stock = " -- indésponible";

                        }else{

                            $stock = " -- $o->qtt en stock";
                            
                        }
                        
                        echo "<option value='$o->idO' data-qtt='$o->qtt' data-color='$c' $disabled>$o->size $stock</option>";

                    }

                }

                echo "</select>";

                echo "<input type='number' placeholder='Quantité ...' class='col-3 qtt_$c' min='1' value='1' onchange='selectQtt(this)'>";

            echo "</div>";


        }

        echo "</div>";

    }

    public function articleByID($id){

        return $this->db->query("SELECT * FROM articles WHERE idA = ?",[$id])->fetch();

    }

    public function articleOption($id){

        return $this->db->query("SELECT * FROM articles_options WHERE idO = ?", [$id])->fetch();

    }

    public function articleMostSeen($limit = 40){

        return $this->db->query("SELECT * FROM articles ORDER BY n_see DESC LIMIT $limit")->fetchAll();

    }

    public function articleMostSeenByCategorie($idCat,$idA ,$limit = 40){

        return $this->db->query("SELECT * FROM articles WHERE ((categorie = ? OR categorie IN (SELECT idC FROM categories WHERE parent = ?)) AND idA != ?) ORDER BY n_see DESC LIMIT $limit",[$idCat,$idCat,$idA])->fetchAll();

    }

    public function articleByCategorie($idCat,$limit = 40){

        return $this->db->query("SELECT * FROM articles WHERE (categorie = ? OR categorie IN (SELECT idC FROM categories WHERE parent = ?)) ORDER BY idA DESC LIMIT $limit",[$idCat,$idCat])->fetchAll();

    }

    public function lastArticlesByCategorie($idCat,$idA,$limit = 40){

        return $this->db->query("SELECT * FROM articles WHERE ((categorie = ? OR categorie IN (SELECT idC FROM categories WHERE parent = ?)) AND idA != ?) ORDER BY idA DESC LIMIT $limit",[$idCat,$idCat,$idA])->fetchAll();

    }

    public function lastArticles($limit = 40){

        return $this->db->query("SELECT * FROM articles ORDER BY idA DESC LIMIT $limit")->fetchAll();

    }

    public function promotionArticles($limit = 40){

        return $this->db->query("SELECT * FROM articles WHERE remise != '' ORDER BY idA DESC LIMIT $limit")->fetchAll();
    }

    public function favoritesArticles($limit = 40){

        return $this->db->query("SELECT * FROM articles INNER JOIN favorite ON prod = idA WHERE user = ? ORDER BY idA DESC LIMIT $limit",[$_SESSION['id']])->fetchAll();

    }

    public function isfavoriteArticle(){

        if(isset($_SESSION['id'])){

            $isFav = $this->db->query("SELECT idF FROM favorite WHERE user = ? AND prod = ?", [$_SESSION['id'], $this->articleID()])->fetch();
    
            if(!empty($isFav)) return "cl3 brc3 isfav";

        }

        return "cl2 brc2";

    }

    public function articleMoreImage($id){
        return $this->db->query("SELECT nameI FROM image WHERE prI = ?",[$id])->fetchAll();
    }

    public function articlesPromo($limit = 40){

        return $this->db->query("SELECT * FROM articles WHERE (remise != ?) ORDER BY idA DESC LIMIT $limit",[0])->fetchAll();

    }

    /* CATEGORIE RECUPERATION */

    public function categorieNoParent($limit = 40){
        

        return $this->db->query("SELECT * FROM categories WHERE parent = '' ORDER BY date ASC LIMIT $limit")->fetchAll();

    }

    public function typearticleNoParent($limit = 40){

        return $this->db->query("SELECT * FROM typearticles WHERE parent = '' ORDER BY date ASC LIMIT $limit")->fetchAll();

    }

    public function categorieNameById($id){

        $cat =  $this->db->query("SELECT name FROM categories WHERE idC = ?",[$id])->fetch();
        return $cat->name;

    }

    public function typearticleNameById($id){
        

        $cat =  $this->db->query("SELECT name FROM typearticles WHERE idC = ?",[$id])->fetch();
        return $cat->name;

    }

    public function categorieImgById($id){

        $cat =  $this->db->query("SELECT image FROM categories WHERE idC = ?",[$id])->fetch();
        return $cat->image;

    }

    public function categorieIdByName($name){

        $cat =  $this->db->query("SELECT idC FROM categories WHERE name = ?",[$name])->fetch();
        return $cat->idC;

    }

    public function categorieUrlById($id){

        $cat =  $this->db->query("SELECT url,parent FROM categories WHERE idC = ?",[$id])->fetch();

        if(empty($cat->parent)){

            return "categorie/$cat->url";

        }else{

            return $this->categorieUrlById($cat->parent)."$cat->url";

        }

    }

    public function typearticleUrlById($id){
 
        $cat =  $this->db->query("SELECT url,parent FROM typearticles WHERE idC = ?",[$id])->fetch();

        if(empty($cat->parent)){

            return "typearticle/$cat->url";

        }else{

            return $this->typearticleUrlById($cat->parent)."$cat->url";

        }

    }
    /* PAGES */

    public function pages($limit = 40){

        return $this->db->query("SELECT name,url FROM pages LIMIT $limit")->fetchAll();

    }

    /* Tags */

    public function tags($limit = 10){

        return $this->db->query("SELECT tag,u,image FROM tags ORDER BY see DESC LIMIT $limit")->fetchAll();

    }

    public function articleTags($idA){

        $tags = $this->db->query("SELECT tag,u,image FROM tags INNER JOIN tag ON t = idT WHERE a = ?",[$idA])->fetchAll();

        foreach($tags AS $tag){

            echo "<a href='".WEBROOT."tag/$tag->u' class='tag cl3 hover-cl2 mr10'>$tag->tag</a> ";

        }

    }

    /* MODELES TAGS RECUPERATION */

    public function articlesByTagPagination($page){

        $this->article_by_page();

        $page = ($page < 1) ? 1 : $page;

        $limit = ($page - 1) * 9 .','. $this->article_by_page;

        return $this->db->query("SELECT * FROM articles INNER JOIN tag ON a = idA WHERE t = ? ORDER BY idA DESC LIMIT $limit",[$this->tagId()])->fetchAll();

    }

    public function articlePaginationBtn($page){

        $nombre = $this->db->query("SELECT COUNT(idA) AS nbr FROM articles INNER JOIN tag ON a = idA WHERE t = ?",[$this->tagId()])->fetch();

        $n = ceil($nombre->nbr / 9);

        if($n == 1) return false;

        if($page > 1) echo "<a href='?page=".($page - 1)."'><</a>";

        for($i = 1; $i <= $n ; $i++){

            if($i == $page){
                echo "<a href='?page=$i' class='btn'>$i</a>";
            }else{
                echo "<a href='?page=$i'>$i</a>";
            }

        }

        if($page < $n) echo "<a href='?page=".($page + 1)."'>></a>";

    }

    /* MODELES SELECTION RECUPERATION */

    public function articlesBySelection(){

        return $this->db->query("SELECT * FROM articles INNER JOIN selection_list ON id_a = idA WHERE id_s = ? ORDER BY idA DESC", [$this->selectionId()])->fetchAll();
    
    }

    /* IMAGES RECUPERATION */

    public function imageUrl($img,$size = 'small'){

        return WEBROOT."gla-adminer/uploads/article/$size/$img";

    }

    public function imageMoreUrl($img){

        return WEBROOT."gla-adminer/uploads/image/$img";

    }

    /* SLIDER */

    public function sliderImages(){

        return $this->db->query("SELECT nameI FROM image WHERE typeI = ? ORDER BY idI DESC",['slider'])->fetchAll();

    }

    public function sliderSpeed(){

        $sl = $this->db->query("SELECT sl_sp FROM theme")->fetch();

        return $sl->sl_sp;

    }

    /* PARTENAIRE */

    public function getPartenaires($limit){

        $part = $this->db->query("SELECT name,image FROM partenaires ORDER BY idP DESC LIMIT $limit")->fetchAll();

        foreach($part AS $a){

            echo "<div><img src='". WEBROOT ."gla-adminer/uploads/article/small/$a->image' alt=\"$a->name\"/></div>";

        }

    }

    /* SITE ------------------------------------------------------------------------ */
    public function siteName(){return $this->site->name;}
    public function siteTitle(){return $this->site->title;}
    public function siteDesc(){return $this->site->description;}
    public function siteTele(){return $this->site->tele;}
    public function siteEmail(){return $this->site->email;}
    public function siteAdresse(){return $this->site->adresse;}
    public function sitePageFacebook(){return $this->site->pagefacebook;}
    public function sitePageTwitter(){return $this->site->pagetwitter;}
    public function sitePageKiuper(){return $this->site->pagekiuper;}
    public function sitePageInstagram(){return $this->site->pageinstagram;}
    public function sitePageYoutube(){return $this->site->pageyoutube;}
    public function siteCodeIntegration(){return $this->site->integercode;}
    public function siteMetaTags(){return $this->site->metatags;}
    public function siteAnalytics(){return $this->site->analytics;}

    /* SINGLE ------------------------------------------------------------------------ */
    public function articleSee(){$this->db->query("UPDATE articles SET n_see = (n_see + 1) WHERE idA = ?",[$this->single->idA]);}
    public function articleID(){return $this->single->idA;}
    public function articleTitle(){return $this->single->title;}
    public function articleUrl(){return $this->single->url;}
    public function articleContent(){return $this->single->content;}
    public function articleImageSmall(){return WEBROOT."gla-adminer/uploads/article/small/".$this->single->image;}
    public function articleImageFull(){return WEBROOT."gla-adminer/uploads/article/full/".$this->single->image;}
    public function articleDate(){return $this->single->date;}
    public function articleCategorieID(){return $this->single->categorie;}
    public function articleCategorieName(){return $this->categorieNameById($this->single->categorie);}
    public function articleCategorieUrl(){return $this->categorieUrlById($this->single->categorie);}
    public function articleComments(){return $this->single->showc;}
    public function articlePrix(){return $this->single->prix;}
    public function articleRemise(){return $this->single->remise;}
    public function articleQtt(){return $this->single->qtt;}
    public function articleAffiliation(){return $this->single->aff_prix;}

    public function articlePrice(){

        if (!empty($this->single->remise)) return $this->single->remise;

        return $this->single->prix;

    }

    public function getPrice($prix, $remise, $qtt = 1){

        if(!empty($remise) && !empty($prix)){

            echo "<span class='price cl3'>" . number_format($remise * $qtt, 0, '', ' ') ." DA <strike class='cl5'>". number_format($prix * $qtt, 0, '', ' ') . " DA </strike></span>";

        }elseif(!empty($prix)){

            echo "<span class='price'>". number_format($prix * $qtt,0,'',' ') ." DA</span>";

        }

    }
   /* SINGLE Redaction Article------------------------------------------------------------------------ */
    public function redactionarticleSee(){$this->db->query("UPDATE redactionarticles SET n_see = (n_see + 1) WHERE idA = ?",[$this->single->idA]);}
    public function redactionarticleID(){return $this->single->idA;}
    public function redactionarticleTitle(){return $this->single->title;}
    public function redactionarticleUrl(){return $this->single->url;}
    public function redactionarticleContent(){return $this->single->content;}
    public function redactionarticleImageSmall(){return WEBROOT."gla-adminer/uploads/article/small/".$this->single->image;}
    public function redactionarticleImageFull(){return WEBROOT."gla-adminer/uploads/article/full/".$this->single->image;}
    public function redactionarticleDate(){return $this->single->date;}
    public function redactionarticleCategorieID(){return $this->single->categorie;}
    public function redactionarticleCategorieName(){return $this->typearticleNameById($this->single->categorie);}
    public function redactionarticleCategorieUrl(){return $this->typearticleUrlById($this->single->categorie);}
    public function redactionarticleComments(){return $this->single->showc;}
    public function redactionarticlePrix(){return $this->single->prix;}
    public function redactionarticleRemise(){return $this->single->remise;}
    public function redactionarticleQtt(){return $this->single->qtt;}
    public function redactionarticleAffiliation(){return $this->single->aff_prix;}


    /* CATEGORIES ------------------------------------------------------------------------ */
    public function catID(){return $this->categorie()->idC;}
    public function catTitle(){return $this->categorie()->name;}
    public function catUrl(){return $this->categorie()->url;}
    public function catParent(){return $this->categorie()->parent;}
    public function catDesc(){return $this->categorie()->description;}
    public function catImg(){return $this->categorie()->image;}

    /* TYPEARTICLES ------------------------------------------------------------------------ */
    public function typeID(){return $this->typearticle()->idC;}
     public function typeTitle(){return $this->typearticle()->name;}
     public function typeUrl(){return $this->typearticle()->url;}
     public function typeParent(){return $this->typearticle()->parent;}
     public function typeDesc(){return $this->typearticle()->description;}
     public function typeImg(){return $this->typearticle()->image;}


    /* PAGES ------------------------------------------------------------------------ */
    public function pageID(){return $this->page()->idP;}
    public function pageTitle(){return $this->page()->name;}
    public function pageUrl(){return $this->page()->url;}
    public function pageContent(){return $this->page()->content;}

    /* Tags ------------------------------------------------------------------------ */
    //public function tagSee(){$this->db->query("UPDATE tags SET see = (see + 1) WHERE idT = ?",[$this->tagsRoot()->idT]);}
    public function missionId(){return $this->missions()->idC;}
    public function missionTitle(){return $this->missions()->titre;}
    public function missionDesc(){return $this->missions()->description;}
    public function missionInfos(){return $this->missions();}

    public function missionCategorie($service){
        $title = $this->db->query("SELECT title FROM articles WHERE idA = ?", [$service])->fetch();

        return $title->title;
    }

    public function missionUser($user){
        $user = $this->db->query("SELECT nom, avatar FROM utilisateurs WHERE idU = ?", [$user])->fetch();

        return $user;
    }

    public function missionOfferSent($mission){

        $offer = $this->db->query("SELECT idO FROM commandes_offers WHERE mission = ? AND user = ?", [$mission, $_SESSION['id']])->fetch();

        if(!empty($offer)) return true;

    }

    /* Selections ------------------------------------------------------------------------ */
    public function profileId(){return $this->profile()->idU;}
    public function profileTitle(){return $this->profile()->nom;}
    public function profileInfos(){return $this->profile();}

      /* Consultation CV ------------------------------------------------------------------------ */

    public function UpdateNbConsultation($user,$nombre){
        
        $this->db->query("UPDATE utilisateurs SET nbconsultation = ? WHERE idU = ?", [$nombre, $user]);

    }
    public function UpdateNbConsultationMois($user,$nombre){
        
        $this->db->query("UPDATE utilisateurs SET nbconsultationMois = ? WHERE idU = ?", [$nombre, $user]);

    }


}
