<?php
/**
 * Created by PhpStorm.
 * User: Khaled
 * Date: 29/09/2019
 * Time: 11:36
 */

namespace Root;


class Cra {

    static function build_calendar($month, $year, $thismonth, $id = false){

        // Create array containing abbreviations of days of week.
        $daysOfWeek = array('S', 'M', 'T', 'W', 'T', 'F', 'S');

        // What is the first day of the month in question?
        $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);

        // How many days does this month contain?
        $numberDays = date('t', $firstDayOfMonth);

        // Retrieve some information about the first day of the
        // month in question.
        $dateComponents = getdate($firstDayOfMonth);

        // What is the name of the month in question?
        $monthName = $dateComponents['month'];

        // What is the index value (0-6) of the first day of the
        // month in question.
        $dayOfWeek = $dateComponents['wday'];

        // Create the table tag opener and day headers

        $id = ($id) ? " id='select_boxes'" : "";

        $calendar = "<table class='calendar mt30' $id>";
        $calendar .= "<caption class='mb20' onclick=open_cra(this)> $monthName $year</caption>";
        $calendar .= "<tr>";

        // Create the calendar headers

        foreach ($daysOfWeek as $day) {
            $calendar .= "<th class='header p10'>$day</th>";
        }

        // Create the rest of the calendar

        // Initiate the day counter, starting with the 1st.

        $currentDay = 1;

        $calendar .= "</tr><tr>";

        // The variable $dayOfWeek is used to
        // ensure that the calendar
        // display consists of exactly 7 columns.

        if ($dayOfWeek > 0) {
            $calendar .= "<td colspan='$dayOfWeek'>&nbsp;</td>";
        }

        $month = str_pad($month, 2, "0", STR_PAD_LEFT);

        while ($currentDay <= $numberDays) {

            // Seventh column (Saturday) reached. Start a new row.

            if ($dayOfWeek == 7) {

                $dayOfWeek = 0;
                $calendar .= "</tr><tr>";
            }

            $currentDayRel = str_pad($currentDay, 2, "0", STR_PAD_LEFT);

            $date = "$year-$month-$currentDayRel";

            $aujourdhuit = date('Y-m-d');

            $style = ($aujourdhuit == $date) ? "style='font-weight:bold'" : '';

            $this_day = "";

            if(!$thismonth){

                $this_day .= "<div class='flex mt10'><span class='cra_btn hover-bg3' onclick='selectDay(this, \"$currentDay\", \"$date\", \"AM\")'>AM</span><span class='cra_btn hover-bg3' onclick='selectDay(this, \"$currentDay\", \"$date\", \"PM\")'>PM</span></div>";
                $this_day .= "<input type='checkbox' name='day_am[$currentDay]' id='AM_$currentDay' style='display:none'/><input type='checkbox' name='day_pm[$currentDay]' id='PM_$currentDay' style='display:none'/>";

            }else{

                $day_am = json_decode($thismonth->day_am);
                $day_pm = json_decode($thismonth->day_pm);

                $am = "";
                $pm = "";

                if(in_array($currentDay, $day_am)){

                    $am = "<span class='cra_btn bg3 hover-bg3' onclick='selectDay(this, \"$currentDay\", \"$date\", \"AM\")'>AM</span><input type='checkbox' name='day_am[$currentDay]' id='AM_$currentDay' checked='true' style='display:none'/>";

                }else{

                    $am = "<span class='cra_btn hover-bg3' onclick='selectDay(this, \"$currentDay\", \"$date\", \"AM\")'>AM</span><input type='checkbox' name='day_am[$currentDay]' id='AM_$currentDay' style='display:none'/>";

                }

                if (in_array($currentDay, $day_pm)) {

                    $pm = "<span class='cra_btn bg3 hover-bg3' onclick='selectDay(this, \"$currentDay\", \"$date\", \"PM\")'>PM</span><input type='checkbox' name='day_pm[$currentDay]' id='PM_$currentDay' checked='true' style='display:none'/>";
                
                } else {

                    $pm = "<span class='cra_btn hover-bg3' onclick='selectDay(this, \"$currentDay\", \"$date\", \"PM\")'>PM</span><input type='checkbox' name='day_pm[$currentDay]' id='PM_$currentDay' style='display:none'/>";
                
                }

                $this_day .= "<div class='flex mt10'>$am $pm</div>";

            }            

            $calendar .= "<td class='day ta-center' rel='$date'$style>$currentDay $this_day</td>";

            // Increment counters

            $currentDay++;
            $dayOfWeek++;
        }

        // Complete the row of the last week in month, if necessary

        if ($dayOfWeek != 7) {

            $remainingDays = 7 - $dayOfWeek;
            $calendar .= "<td colspan='$remainingDays'>&nbsp;</td>";
        }

        $calendar .= "</tr>";

        $calendar .= "</table>";

        return $calendar;
    }

    /*
    static function today($ticket, $db){

        $date = getdate();

        $hours = $date['hours'];
        $day = $date['mday'];
        $month = $date['mon'];
        $year = $date['year'];

        $matin_soir = ($hours < 12) ? 1 : 2;

        $exist = $db->query("SELECT idC from cra WHERE ticket = ? AND day = ? AND period = ?", [$ticket, "$year-$month-$day", $matin_soir])->fetch();

        if (!empty($exist)) return true;

    }
    */

    static function calcul($montant, $thismonth){

        $demi_journee = $montant / 2;

        if(!empty($thismonth)){

            $day_am = json_decode($thismonth->day_am);
            $day_pm = json_decode($thismonth->day_pm);

            $work = count($day_am) + count($day_pm);

            echo "<h2 class='mt30'>Ce mois ci vous avez travaillé pendant ". $work / 2 . " jours</h2>";

            echo "<p class='p20 bg3 cl1'>Le montant total que vous avez gagné pour ce mois et de <strong>" . number_format(($work * $demi_journee) * 1.2, 2, '.', ' ') . " € TTC</strong></p>";

        }
        
    }

    static function calcul_entreprise($montant, $thismonth){

        $demi_journee = $montant / 2;

        if(!empty($thismonth)){

            $day_am = json_decode($thismonth->day_am);
            $day_pm = json_decode($thismonth->day_pm);

            $work = count($day_am) + count($day_pm);

            echo "<h2 class='mt30'>Ce mois ci le freelance à travaillé pendant ". $work / 2 . " jours</h2>";

            echo "<p class='p20 bg3 cl1'>Le montant total généré pour ce mois et de <strong>" . number_format(($work * $demi_journee) * 1.2, 2, '.', ' ') . " € TTC</strong></p>";

        }
        
    }

    static function work_days($ticket, $db){

        return $db->query("SELECT idC, day, period from cra WHERE ticket = ?", [$ticket])->fetchAll();
        
    }

    static function work_month($ticket, $month, $year, $db){

        return $db->query("SELECT idC, day_am, day_pm, date, stt from cra WHERE ticket = ? AND month = ? AND year = ?", [$ticket, $month, $year])->fetch();

    }

    static function nbr_months($ticket, $db){

        return $db->query("SELECT idC, month, year, stt from cra WHERE ticket = ? ORDER BY idC ASC", [$ticket])->fetchAll();

    }

    static function add($ticket, $post, $db){


        $date = getdate();

        $hours = $date['hours'];
        $day = $date['mday'];
        $month = $date['mon'];
        $year = $date['year'];

        $exist = $db->query("SELECT idC FROM cra WHERE ticket = ? AND month = ? AND year = ? AND stt = 0", [$ticket, $month, $year])->fetch();

        if (empty($exist)) {

            // -------------------------------- AM

            $day_am = "[";

            foreach ($_POST['day_am'] as $k => $v) {

                $day_am .= "$k,";
            }

            $day_am = trim($day_am, ',');

            $day_am .= "]";

            // -------------------------------- PM

            $day_pm = "[";

            foreach ($_POST['day_pm'] as $k => $v) {

                $day_pm .= "$k,";
            }

            $day_pm = trim($day_pm, ',');

            $day_pm .= "]";

            // --------------------------------- SAVE

            $db->query("INSERT INTO cra (ticket, month, year, day_am, day_pm, date) VALUES (?,?,?,?,?, NOW())", [$ticket, $month, $year, $day_am, $day_pm]);

            \Func::setFlash('succes', "Mois validé avec succès");

        }else{

            // -------------------------------- AM

            $day_am = "[";

            foreach ($_POST['day_am'] as $k => $v) {

                $day_am .= "$k,";
            }

            $day_am = trim($day_am, ',');

            $day_am .= "]";

            // -------------------------------- PM

            $day_pm = "[";

            foreach ($_POST['day_pm'] as $k => $v) {

                $day_pm .= "$k,";
            }

            $day_pm = trim($day_pm, ',');

            $day_pm .= "]";

            // --------------------------------- SAVE

            $db->query("UPDATE cra SET day_am = ?, day_pm = ?, stt = ? WHERE idC = ?", [$day_am, $day_pm, 1, $exist->idC]);

            \Func::setFlash('succes', "CRA Modifié avec succès");

            //\Func::setFlash('error', "Vous avez déja enregistrer ce mois, si vous voullez apporter des modifications contactez l'administrateur");

        }

        \Func::redirect('?ticket=' . $ticket);

    }

    // CRA HNO ----------------------------------------------------

    static function cra_hno($ticket, $db){

        return $db->query("SELECT idC, date_d, date_f, note, astreinte, created_at from cra_hno WHERE ticket = ? ORDER BY date_d ASC", [$ticket])->fetchAll();

    }

    static function add_hno($ticket, $entreprise, $post, $db){

        $date = getdate();

        $month = $date['mon'];
        $year = $date['year'];

        $date_d = $post['date_d'];
        $date_f = $post['date_f'];

        $note = $post['note'];

        $astreinte = (isset($post['astreinte'])) ? 1 : 0;

        $d1 = new \DateTime($date_d);
        $d2 = new \DateTime($date_f);

        if (date('n-Y', strtotime($date_d)) == "$month-$year" && date('n-Y', strtotime($date_f)) == "$month-$year" && $d1 < $d2) {

            $db->query("INSERT INTO cra_hno (ticket, entreprise, freelance, date_d, date_f, note, astreinte, created_at) VALUES (?,?,?,?,?,?,?, NOW())", [$ticket, $entreprise, $_SESSION['id'], $date_d, $date_f, $note, $astreinte]);

            \Func::setFlash('succes', "Enregistrement ajouté avec succès à ce mois.");

        } else {

            \Func::setFlash('error', "Impossible d'effectué cette opération, Il faut des date dans le mois en cours, veuillez vérifier les données que vous avez entrez.");
        
        }

        \Func::redirect('?ticket=' . $ticket);

    }

} 