<?php

/**
 * Created by PhpStorm.
 * User: Khaled
 * Date: 26/02/2019
 * Time: 11:21
 */

namespace Root;

use Func;

class Commandes{

    static function get($db){

        if (isset($_GET['commandes'])) {

            if ($_GET['commandes'] == 2) {

                $filter = " AND commandes.stt = 2";

            } else {

                $filter = " AND commandes.stt != 2";

            }

        } else {

            $filter = "";
        }

        $commandes = $db->query("SELECT idC, titre, adresse, postal, jour, heure, duree, prix, commission, tva_commission, total, created_at, offer_id, nbr_offers, stt FROM commandes WHERE user = ?$filter ORDER BY stt, created_at DESC, stt", [$_SESSION['id']])->fetchAll();

        foreach ($commandes as $c) {

            $background = '';

            if($c->stt == '1'){

                $background = 'background: #a3f7b5 !important; border: 1px solid #7bf1a8;';

            } elseif ($c->stt == '2') {

                $background = 'background:#ffcad4 !important; border: 1px solid #f4acb7';

            }

            echo "<div class='br8 mb20 brc8 brc1solid bg6 p20' style='$background'>";

            if ($c->stt == 0) {

                echo "<div class='flex p10'>";

                echo "<div class='col-3 brc1Right brc8 mr20'><h4 class='mb10'>$c->titre</h4>$c->adresse<br>$c->postal</div>";

                echo "<div class='col-2 brc1Right brc8 mr20'><span class='mb10 d-in-block'>Durée : <b>$c->duree</b></span> heures<br>Prix : <b>$c->prix</b> € / heure</div>";

                echo "<div class='col-3 brc1Right brc8 mr20'><span class='mb10 d-in-block'>Commission : <b>$c->commission</b> € </span><br><span class='mb10 d-in-block'>Commission TVA : <b>$c->tva_commission</b> €</span><br><span class='cl3'>Mon offre : <b>$c->total</b> €</span></div>";

                echo "<div class='col-2 btns ta-end'>";

                echo "<a href='modifier?mission_id=$c->idC' class='btn2 bg3 cl1 ta-center'><span class='icon mr8 fz13'>X</span>Modifier</a>";
                echo "<a href='supprimer?mission_id=$c->idC' class='btn2 bg5 cl1 ta-center'><span class='icon mr8 fz13'>8</span>Supprimer</a>";

                echo "</div>";

                echo "</div>";

                echo "<div class='flex ai-center p10 bg8 br8'>";

                echo "<div class='col-3'><span class='icon fz13 mr8'>s</span> <b>" . date('d/m/Y', strtotime($c->jour)) . "</b> à <b>" . date('H:i', strtotime($c->heure)) . "</b></div>";

                echo "<div class='col-4'>";

                if (!empty($c->nbr_offers)) {

                    echo "<span class='rem cl3'>($c->nbr_offers) propositions</span>";
                } else {

                    echo "<span class='rem cl3'>Aucune proposition pour l'instant</span>";
                }
                echo "</div>";

                echo "<div class='col-3 ta-end'>Ajoutée le " . date('d/m/Y à H:i', strtotime($c->created_at)) . "</div>";

                echo "</div>";

                if (!empty($c->nbr_offers) && $c->stt == 0) self::offersByMission($c->idC, $db);

            }else{

                $offer = Offer::offerById($c->offer_id, $db);

                echo "<div class='flex p10'>";

                echo "<div class='col-3 brc1Right mr20' style='border-color: rgba(255,255,255, .4)'><h4 class='mb10'>$c->titre</h4>$c->adresse</div>";

                echo "<div class='col-2 brc1Right mr20' style='border-color: rgba(255,255,255, .4)'><span  class='mb10 d-in-block'> Durée : <b>$c->duree</span></b> heures<br>Prix : <b>$offer->prix</b> € / heure</div>";

                echo "<div class='col-3 brc1Right mr20' style='border-color: rgba(255,255,255, .4)'><span  class='mb10 d-in-block'>Commission : <b>$offer->commission</b> €</span><br><span style='color:#04AA6D' class='fw_b'>Montant payé : <b>$offer->total</b> €</span></div>";

                echo "<div class='col-2 btns ta-end ai-center'>";

                if ($c->stt == 1) {

                    echo "<a href='". WEBROOT ."page/finaliser?mission_id=$c->idC' class='btn2 bg3 cl1 ta-center d-block mb10' title='Finalisez cette offer pour que le préstataire récupère son argent'><span  class='icon mr8 fz13'>V</span>Finaliser</a>";
                    echo "<a href='". WEBROOT ."page/annuler?mission_id=$c->idC' class='btn2 bg5 cl1 ta-center d-block' title='Si vous annulez cette mission vous allez etre remboursé'><span  class='icon mr8 fz13'>Q</span>Annuler</a>";

                } elseif ($c->stt == 2) {

                    echo "<span class='cl7 ta-center d-block mb10'><span class='icon mr8 fz13'>V</span>Finalisée</span> <a href='" . WEBROOT . "page/facture?mission_id=$c->idC' class='btn2 bg3 cl1 d-block ta-center' style='margin:0'><span class='icon mr8 fz13'>-</span>Facture</a>";

                }

                echo "</div>";

                echo "</div>";

                if ($c->stt == 1) {

                    echo "<div class='bg8 br8 p10 mt20' style='background: rgba(255,255,255, .3)'>";

                    $user = \Root\Utilisateur::userById($offer->user, $db);

                    echo "<div class='flex p10 jc-start fz09'>";

                    echo "<div class='col-3'>Prestataire : <b>$user->nom</b></div>";
                    echo "<div class='col-2'>Tel : <b>$user->tele</b></div>";
                    echo "<div class='col-3'>Email : <b>$user->email</b></div>";

                    echo "</div>";

                    echo "<div class='flex p10 jc-start fz09'>";

                    echo "<div class='col-3'>Entreprise : <b>$user->entreprise</b></div>";
                    echo "<div class='col-2'>SIRENT : <b>$user->siren</b></div>";
                    echo "<div class='col-3'>N° TVA : <b>$user->tva</b></div>";

                    echo "</div>";

                    echo "</div>";
                }

            }

            echo "</div>";

        }
    }

    static function offersByMission($mission, $db){

        $offers = $db->query("SELECT idO, prix, commission, total, tva_per,tva_prix, created_at, idU, nom, avatar, note, nbr_note FROM commandes_offers INNER JOIN utilisateurs ON idU = user WHERE mission = ? ORDER BY created_at DESC", [$mission])->fetchAll();

        foreach($offers AS $o){

            echo "<div class='offers p10 bg8'>";

            echo "<div class='col-3'><a href='". WEBROOT ."profile/$o->idU' class='user_info'>". \Func::avatar($o->avatar, 'brc3 bg3') ."<span class='name'>$o->nom<br><span style='font-size:0.8em;font-weight:normal'>$o->note ($o->nbr_note avis) </span></span></a></div>";

            echo "<div class='col-2'>Prix : <b>$o->prix</b> € / heure<br>TVA $o->tva_per% : <b>$o->tva_prix</b> €<br>Commission : <b>$o->commission</b> €</div>";
            echo "<div class='col-3'><span class='cl3'>Total à payer : <b>$o->total</b> €</span></div>";

            echo "<div class='col-2 flex jc-end'><a href='accept?mission_id=$mission&offer_id=$o->idO' class='btn2 bg3 cl1'><span class='icon mr8 fz13'>V</span>Accepter</a></div>";

            echo "</div>";

        }
    }

    static function byCategorie($categorie, $db, $limit = 15){

        $commandes = $db->query("SELECT idC, titre, postal, description, jour, heure, duree, prix, total, created_at, nom, avatar FROM commandes INNER JOIN utilisateurs ON utilisateurs.idU = user WHERE service = ? AND commandes.stt = 0 ORDER BY created_at DESC LIMIT $limit", [$categorie])->fetchAll();

        self::missions($commandes);
        
    }

    static function last($db, $limit = 6){

        $commandes = $db->query("SELECT idC, titre, postal, description, jour, heure, duree, prix, total, created_at, nom, avatar FROM commandes INNER JOIN utilisateurs ON utilisateurs.idU = user ORDER BY created_at DESC LIMIT $limit")->fetchAll();

        self::missions($commandes);

    }

    static function missions($missions){

        foreach ($missions as $c) {

            echo "<a href='" . WEBROOT . "mission/$c->idC' class='article cl2 shad brc6 brc1solid p20 grid1 jc-between'>";
            
            echo "<div>";

                echo "<div class='user_info mb10'>";
                echo \Func::avatar($c->avatar);
                echo "<span class='name'>$c->nom</span>";
                echo "</div>";

                echo "<span class='title fw5'>$c->titre</span>";

                echo "<p class='mb20 fz09'>$c->description</p>";

            echo "</div>";

            echo "<div class=' flex-col flex jc-end'>";

                echo "<span class='price cl4 d-block mb10'>$c->duree heures pour $c->prix € / heure</span>";

                echo "<p class='flex ai-center jc-start mb5'><span class='icon mr10 fz15'>s</span>" . date('d/m/Y', strtotime($c->jour)) . " à " . date('H:i', strtotime($c->heure)) . "</p>";

                echo "<p class='flex ai-center jc-start'><span class='icon mr10 fz15'>j</span>$c->postal</p>";
            
            echo "</div>";

            echo "</a>";
        }

    }

    static function add($id, $p, $db){

        if (!empty($p['titre']) && !empty($p['adresse']) && !empty($p['postal']) && !empty($p['jour']) && !empty($p['heure']) && !empty($p['duree']) && !empty($p['prix']) && !empty($p['commission']) && !empty($p['commission_tva']) && !empty($p['total'])) {

            $article = $db->query("SELECT idA FROM articles WHERE idA = ?", [$id])->fetch();

            if (!empty($article)) {

                if (\Validation::between($p['titre'], 2, 256)) {

                    \Func::setFlash('error', "Veuillez entrer un titre valide");

                    return false;
                }

                if (\Validation::between($p['adresse'], 10, 256)) {

                    \Func::setFlash('error', "Veuillez enter une adresse valide");

                    return false;
                }

                if (\Validation::between($p['postal'], 2, 10)) {

                    \Func::setFlash('error', "Veuillez enter un code postal valide");

                    return false;
                }

                extract($p);

                $db->query("INSERT INTO commandes (service, user, titre, adresse, postal, description, jour, heure, duree, prix, commission, tva_commission, total, created_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())", [$id, $_SESSION['id'], $titre, $adresse, $postal, $description, $jour, $heure, $duree, $prix, $commission, $commission_tva, $total]);

                \Func::setFlash('succes', "Service demandé avec succès, Votre mission à été déposée et visible pour les prestataires de nousartisans");

                \Func::redirect('page/dashboard');

            }else{

                Func::setFlash('error', "Une erreur est servenu, impossible d'envoyer votre demande");

            }

        }else{

            Func::setFlash('error', "Veuillez entrer toutes les informations obligatoires");

        }

    }

    static function remove($id, $db){

        if (array_key_exists($id, $_SESSION['panier']['produits'])) {

            unset($_SESSION['panier']['produits'][$id]);

            $_SESSION['panier']['nbr'] = $_SESSION['panier']['nbr'] - 1;
        }

        /*

            $cookie_val = $_SESSION['panier']['nbr'] . ".";

            foreach ($_SESSION['panier']['produits'] as $p) {

                $cookie_val .= "$p.";

            }

            if ($_SESSION['panier']['nbr'] !== 0) setcookie('kh_globalads_dz', trim($cookie_val, '.'), time() + (3600 * 24 * 30), '/');
        
            */

        echo $_SESSION['panier']['nbr'];
    }

    // OFFERS -----------------------------------------------------------


    static function addOffer($mission, $name, $p, $db){

        if (!empty($mission) && !empty($p['prix']) && !empty($p['duree']) && !empty($p['commission']) && !empty($p['commission_tva']) && !empty($p['total']) && isset($_POST['tva_per'], $_POST['tva_prix'])) {

            $article = $db->query("SELECT idC FROM commandes WHERE idC = ?", [$mission])->fetch();

            if (!empty($article)) {

                extract($p);

                $db->query("INSERT INTO commandes_offers (mission, user, prix, duree, commission, tva_commission, tva_per,tva_prix, total, created_at) VALUES (?,?,?,?,?,?,?,?,?,NOW())", [$mission, $_SESSION['id'], $prix, $duree, $commission, $commission_tva, $tva_per, $tva_prix, $total]);
                
                $db->query("UPDATE commandes SET nbr_offers = nbr_offers + 1 WHERE idC = ?", [$mission]);

                \Func::setFlash('succes', "Offre envoyée à $name avec succès");

                \Func::redirect('#flash');

            } else {

                Func::setFlash('error', "Une erreur est servenu, impossible d'envoyer votre offre");
            }
        } else {

            Func::setFlash('error', "Veuillez entrer toutes les informations obligatoires");
        }

    }

}
