<?php
/**
 * Created by PhpStorm.
 * User: Khaled
 * Date: 29/09/2019
 * Time: 11:36
 */

namespace Root;


class Avis {

    static function get($user, $db){

        $avis = $db->query("SELECT idA, avis.note, comment, avis.created_at, idU, nom, avatar FROM avis INNER JOIN utilisateurs ON idU = client WHERE prestataire = ? ORDER BY idA DESC", [$user])->fetchAll();

        foreach($avis AS $a){

            $note = '';

            for($i = 0; $i < $a->note; $i++){
                $note .= "<span class='bg5'></span>";
            }

            echo "<div class='comment'>";

            echo "<div class='flex ai-center'>";
            echo "<div class='user_info'>";
            echo \Func::avatar($a->avatar, 'bg3');
            echo "<span class='name'>$a->nom</span>";
            echo "</div>";

            echo "<span class='cl7'>". \Func::time(strtotime($a->created_at)) ."</span>";

            echo "</div>";

            echo "<div class='flex jc-start rating2 mb10'>";
            echo "$note";
            echo "</div>";

            echo "<p>$a->comment</p>";

            echo "</div>";

        }

    }

    static function exist($ticket, $db){

        $avis = $db->query("SELECT idA FROM avis WHERE ticket = ?", [$ticket])->fetch();

        if(empty($avis)) return true;


    }

    static function create($ticket, $entreprise, $freelance, $post, $db){

        $db->query("INSERT INTO avis (client, prestataire, ticket, note, comment, created_at) VALUES (?, ?, ?, ?, ?, NOW())", [$entreprise, $freelance, $ticket, $post['note'], $post['comment']]);

        // Calcul note

        $notes = $db->query("SELECT COUNT(idA) AS nbr, SUM(note) AS sum FROM avis WHERE prestataire = ?", [$freelance])->fetch();

        $note = number_format($notes->sum / $notes->nbr, 1, '.', 2);

        $db->query("UPDATE utilisateurs SET note = ?, nbr_note = nbr_note + 1 WHERE idU = ?", [$note, $freelance]);

        // Message
        
        \Func::setFlash('succes', "Avis envoyé avec succès sur le ticket N° $ticket");
        
        \Func::redirect('dashboard');

    }

} 