<?php

namespace Recuperation;

class Utilisateurs {

    static function getUtilisateurs($db,$limit){

      $limit = (isset($_GET['limit'])) ? 1000000 : $limit;

        $users = $db->query("SELECT * FROM utilisateurs ORDER BY idU DESC LIMIT $limit")->fetchAll();

        foreach($users AS $u){

            $tele_val = ($u->tele_val == 0) ? "<br><span class='green'>Validé</span>" : "";
            $email_val = ($u->email_val == 0) ? "<br><span class='green'>Validé</span>" : "";

            echo "<tr>";
            echo "<td>$u->idU</td>";
            echo "<td><a href='" . WEBROOT . "profile/$u->idU'>$u->nom</a></td>";
            echo "<td>$u->email $email_val</td>";
            echo "<td>$u->tele $tele_val</td>";
            
            if($u->type == 1){

                echo "<td>SIRENT : $u->siren<br>Forme : $u->juridique</td>";
                
            }else{

                echo "<td>$u->profile_per %</td>";
            }
            echo "<td>".date('d/m/Y à H:i', strtotime($u->date))."</td>";
            echo "<td>$u->nbr_connexion</td>";
            echo "<td>".date('d/m/Y à H:i', strtotime($u->derniere_connexion))."</td>";
            echo "<td class='actions'><div class='flex'><a href='action/edit/user.php?id=$u->idU' class='btn b-g'><span class='icon'>&</span></a> <a onclick='confirm_action(event,this)' href='action/delete.php?table=utilisateurs&label=idU&id=$u->idU&r=utilisateurs.php' class='btn b-r'><span class='icon'>[</span></a></div></td>";
            echo "</tr>";

        }

    }

    static function utilisateurById($id, $db){

        return $db->query("SELECT * FROM utilisateurs WHERE idU = ?",[$id])->fetch();

    }

    static function editEtilisateur($post, $id, $db, $session = false){

        if(isset($post['nom'], $post['email'], $post['tele'])){

            $entreprise = (empty($post['entreprise'])) ? NULL : $post['entreprise'];
            $siren = (empty($post['siren'])) ? NULL : $post['siren'];
            $juridique = (empty($post['juridique'])) ? NULL : $post['juridique'];

            $db->query("UPDATE utilisateurs SET nom = ?, email = ?, tele = ?, siren = ?, monentreprise = ?, juridique = ?, bonus = ?, referent = ?,remarques = ?,date_update_disponibilite = ?, date_disponibilite = ? WHERE idU = ?",[$post['nom'],$post['email'],$post['tele'], $siren, $entreprise, $juridique, $post['bonus'],$post['referent'], $post['remarques'],$post['date_update_disponibilite'], $post['date_disponibilite'], $id]);

            if($session) $_SESSION['name'] = $post['nom'];

            \Func::setFlash("success", "Informations modifié avec succes");

            \Func::redirect('#flash');

        }else{

            \Func::setFlash("error", "Tous les champs sont obligatoir");

            \Func::redirect('#flash');

        }

    }

}
