<?php

namespace Recuperation;

class Tickets {

    static function get($db, $limit){

        $cond = '';

        if(isset($_GET['stt'])) $cond = " AND ticket.t_stt = ". $_GET['stt'];

        if(isset($_GET['user'])) $cond = " AND ticket.idU = ". $_GET['user'];

        $limit = (isset($_GET['limit'])) ? 1000000 : $limit;

        $tickets = $db->query("SELECT idT, entreprise, t_tarif, t_duree, t_adresse, t_description, t_stt, t_date, f.idU AS f_idU, f.nom AS f_nom, f.email AS f_email, f.tele AS f_tele, f.monentreprise AS f_monentreprise, e.idU, e.nom, e.email, e.tele  FROM ticket INNER JOIN utilisateurs AS f ON f.idU = freelance INNER JOIN utilisateurs AS e ON e.idU = entreprise WHERE idT != 0 $cond ORDER BY t_date DESC LIMIT $limit")->fetchAll();

        foreach ($tickets as $p) {

            echo "<tr>";
            echo "<td>$p->idT</td>";
            echo "<td><a href='".WEBROOT."gla-adminer/action/edit/user.php?id=$p->idU'>$p->nom</a><br>$p->tele<br>$p->email</td>";
            echo "<td><a href='".WEBROOT."gla-adminer/action/edit/user.php?id=$p->f_idU'>$p->f_nom</a><br>$p->f_tele<br>$p->f_email<br>$p->f_monentreprise</td>";
            echo "<td><b>$p->t_tarif</b> € pour <b>$p->t_duree</b> jours</td>";
            echo "<td><b>$p->t_adresse</td>";
            echo "<td><textarea>$p->t_description </textarea></td>";
            echo "<td>$p->t_date</td>";
            echo "<td>";
            
            if($p->t_stt == 0){
                echo "<p>Offre en attente</p><br>";
            }elseif($p->t_stt == 1){
                echo "<p style='color:red'>Demande de modifications</p><br>";
            } elseif ($p->t_stt == 2) {
                echo "<p style='color:blue'>Date d'entretien envoyé</p><br>";
            } elseif ($p->t_stt == 3) {
                echo "<p style='color:green'>Informations du freelance envoyée</p><br>";
            }else{
                echo "<p style='color:red'>Mission finalisée</p><br>";
            }

            echo "<a href='".WEBROOT."gla-adminer/action/edit/ticket.php?id=$p->idT' class='btn b-b' style='margin-bottom:5px'>Modifier</a>";
            
            echo "<a onclick='confirm_action(event,this)' href='".WEBROOT."gla-adminer/action/delete.php?table=ticket&label=idT&id=$p->idT&r=tickets.php' class='btn b-r'>Supprimer</a></td>";
            echo "</tr>";

        }

    }

    static function getById($id, $db){
        return $db->query("SELECT idT, entreprise, freelance, t_tarif, t_duree, t_adresse, t_description, t_stt, t_tjm, message, entretien, t_date, f.idU AS f_idU, f.nom AS f_nom,f.bonus AS f_bonus,f.referent AS f_referent,f.remarques AS f_remarques,f.iban AS f_iban,f.bic AS f_bic, f.email AS f_email,f.monentreprise AS f_monentreprise, f.tele AS f_tele, e.idU, e.nom, e.email, e.tele FROM ticket INNER JOIN utilisateurs AS f ON f.idU = freelance INNER JOIN utilisateurs AS e ON e.idU = entreprise WHERE idT = ?", [$id])->fetch();
    }

    static function lastCra($id, $db){
        return $db->query("SELECT idC, month, stt FROM cra WHERE ticket = ? ORDER BY idC DESC", [$id])->fetch();
    }

    static function edit($ticket, $post, $db){

        if (!empty($post['tarif']) && !empty($post['duree']) && !empty($post['adresse']) && !empty($post['description']) && isset($post['stt']) && isset($post['tjm'])) {

            $db->query("UPDATE ticket SET t_tarif = ?, t_duree = ?, t_adresse = ?, t_description = ?, t_stt = ?, t_tjm = ?, message = ?, entretien = ? WHERE idT = ?", [$post['tarif'], $post['duree'], $post['adresse'], $post['description'], $post['stt'], $post['tjm'], $post['message'], $post['entretien'], $ticket]);

            $entreprise_db = $db->query('SELECT entreprise, nom, email FROM ticket INNER JOIN utilisateurs ON idU = entreprise WHERE idT = ?', [$ticket])->fetch();
            $freelance_db = $db->query('SELECT freelance, nom, email FROM ticket INNER JOIN utilisateurs ON idU = freelance WHERE idT = ?', [$ticket])->fetch();
            $ticket_db = $db->query('SELECT * FROM ticket WHERE idT = ?', [$ticket])->fetch();

            $token_freelance = $db->query("SELECT token from utilisateur_token WHERE id = ?", [$freelance_db->freelance])->fetch();
            $token_entreprise = $db->query("SELECT token from utilisateur_token WHERE id = ?", [$entreprise_db->entreprise])->fetch();

            if($post['stt'] == 1){

                \Mail::alerte_client_freelance($entreprise_db->email, $entreprise_db->nom, $post['message']," - message concernant votre ticket numéro   $ticket_db->idT ");

            }

            if($post['stt'] == 2){

                $date_entretien = date('d-m-Y \ à H:i', strtotime($ticket_db->entretien));         

                \Mail::alerte_client_freelance($entreprise_db->email, $entreprise_db->nom, "une date d'entretien est bien planfiée le  $date_entretien "  , " - date de l'entretien pour le ticket numéro $ticket_db->idT");
                \Mail::alerte_client_freelance($freelance_db->email, $freelance_db->nom, "une date d'entretien est bien planfiée le  $date_entretien ", " - date de l'entretien pour le ticket numéro $ticket_db->idT");

                $notification_freelance = [
                    "to" => $token_freelance->token,
                    "notification" => [
                        "title" => "Date d'entretien planfiée",
                        "body" => "Une date d'entretien est bien planfiée le  $date_entretien pour le ticket numéro $ticket_db->idT"
                    ]
                ];

                $notification_entreprise = [
                    "to" => $token_entreprise->token,
                    "notification" => [
                        "title" => "Date d'entretien planfiée",
                        "body" => "Une date d'entretien est bien planfiée le  $date_entretien pour le ticket numéro $ticket_db->idT"
                    ]
                ];

            }

            if($post['stt'] == 3){

                \Mail::alerte_client_freelance($entreprise_db->email, $entreprise_db->nom, "la mission avec le freelance  $freelance_db->nom est bien validée "  , " - démarrage de la mission numéro $ticket_db->idT ");
                \Mail::alerte_client_freelance($freelance_db->email, $freelance_db->nom, "la mission avec l'entreprise  $entreprise_db->nom est validée un contrat vous sera envoyé par email ", " - Bravo ! démarrage de la mission numéro $ticket_db->idT ");
                
                $notification_freelance = [
                    "to" => $token_freelance->token,
                    "notification" => [
                        "title" => "Mission validée",
                        "body" => "La mission avec l'entreprise $entreprise_db->nom est bien validée"
                    ]
                ];

                $notification_entreprise = [
                    "to" => $token_entreprise->token,
                    "notification" => [
                        "title" => "Mission validée",
                        "body" => "La mission avec le freelance  $freelance_db->nom est bien validée"
                    ]
                ];

            }

            if($post['stt'] == 4){

                \Mail::alerte_client_freelance($entreprise_db->email, $entreprise_db->nom, "la mission avec le freelance  $freelance_db->nom s'est bien terminée, merci de laisser un commentaire sur la qualité de la prestation "  , " - fin de la mission numéro $ticket_db->idT ");
                \Mail::alerte_client_freelance($freelance_db->email, $freelance_db->nom, "la mission avec l'entreprise  $entreprise_db->nom s'est bien terminée ", " - fin de la mission numéro $ticket_db->idT ");
                
                $notification_freelance = [
                    "to" => $token_freelance->token,
                    "notification" => [
                        "title" => "Mission finalisée",
                        "body" => "La mission avec l'entreprise $entreprise_db->nom s'est bien terminée"
                    ]
                ];

                $notification_entreprise = [
                    "to" => $token_entreprise->token,
                    "notification" => [
                        "title" => "Mission finalisée",
                        "body" => "La mission avec le freelance  $freelance_db->nom s'est bien terminée"
                    ]
                ];

            }
        
            if(!empty($notification_freelance) && !empty($token_freelance)){

                $firebase_server_key = 'AAAA6VgTFeo:APA91bGkLJ8lql2TM00WcFMEK0DAKgHByKJOShI6iS-JlcPcHlH37grP3LBufqzSWnD6qbLG06-Sl4wdyxboMBNtP9ZBfqZN7ZHumlmjWXtbbveRw5O7DqvCkWurgcqJiOkeFRNXvySv';

                $ch = curl_init();
        
                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notification_freelance));
            
                $headers = array();
                $headers[] = 'Authorization: key=' . $firebase_server_key;
                $headers[] = 'Content-Type: application/json';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            
                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
            
                curl_close($ch);

            }

            if(!empty($notification_entreprise) && !empty($token_entreprise)){

                $ch = curl_init();
        
                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($notification_entreprise));
            
                $headers = array();
                $headers[] = 'Authorization: key=' . $firebase_server_key;
                $headers[] = 'Content-Type: application/json';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            
                $result = curl_exec($ch);
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
            
                curl_close($ch);

            }

            \Func::setFlash('success', "Ticket modifié avec succès");
            \Func::redirect('#flash');

        } else {

            \Func::setFlash('error', "Veuillez remplir tous les champs obligatoir");
            \Func::redirect('#flash');
        }
    }

    static function debloquer_cra($ticket, $id, $db){

        $db->query("UPDATE cra SET stt = 0 WHERE idC = ?", [$id]);

        \Func::setFlash('success', "CRA débloqué avec succès");

        \Func::redirect("?id=$ticket");

    }
}
