<?php
namespace Recuperation;

use Func;

class Selection {

    static function selections($db,$limit){

        $selections = $db->query("SELECT idS,name,description,image,date FROM selections LIMIT $limit")->fetchAll();

        foreach($selections AS $t){

            $add_to_selection = (isset($_GET['add_article']) && isset($_GET['idA'])) ? "<a href='selections.php?add=$t->idS&id={$_GET['idA']}' class='btn b-g' title='Ajouter l'article à cette sélection'><span class='icon'>Z</span> Ajouter</a> " : "";

            echo "<tr>";
            echo "<td>$t->idS</td>";
            echo "<td><a href='articles.php?article_by_selection=$t->idS' title='Afficher les articles de cette sélection'>$t->name</a></td>";
            echo "<td>".substr($t->description,0,64)."...</td>";
            echo "<td><img src='". Func::cache('gla-adminer/uploads/article/small/' . $t->image) ."'/></td>";
            echo "<td>".date('d/m/Y à h',$t->date)."h</td>";
            
            if(isset($_GET['add_article'])){
                echo "<td>$add_to_selection</td>";
            }else{
                echo "<td><a href='action/edit/selection.php?id=$t->idS' class='btn b-g'><span class='icon'>&</span> Modifier</a> <a href='action/delete.php?table=selections&label=idS&id=$t->idS&r=selections.php' class='btn b-r'><span class='icon'>[</span> Supprimer</a></td>";
            }
            
            echo "</tr>";

        }

    }

    static function addSelection($post,$db){

        if(!empty($post['name']) && !empty($post['description'])){

            $url = \Validation::toUrl($_POST['name']);

            $db->query("INSERT INTO selections (name,u,description,image,date,see) VALUES (?,?,?,?,?,0)",[$_POST['name'],$url,$_POST['description'], $_POST['imagenom'], time()]);

            \Func::setFlash('success',"Selection ajoutée avec succes");

            #\Func::execute(WEBROOT."sitemap/tag.php");

            \Func::redirect('../selections.php');

        }else{

            \Func::setFlash('error','Le titre et la description sont obligatoirs');

        }

    }

    static function addArticleToSelection($selection, $article, $db){

        $exist = $db->query("SELECT idL FROM selection_list WHERE id_s = ? AND id_a = ?", [$selection, $article])->fetch();

        if(empty($exist)){

            $db->query("INSERT INTO selection_list (id_s, id_a) VALUES (?,?)", [$selection, $article]);

            \Func::setFlash('success', "Article ajouté à la selection");

            \Func::redirect("selections.php?article_by_selection=$selection");

        }else{

            \Func::setFlash('error', "L'article à déja été ajouté a cette sélection");

            \Func::redirect('selections.php');

        }

    }

    static function removeArticleFromSelection($selection, $article, $db){

        $db->query("DELETE FROM selection_list WHERE id_s = ? AND id_a = ?", [$selection, $article]);

        \Func::setFlash('success', "Article retiré de à la selection");

        \Func::redirect("articles.php?article_by_selection=$selection");
    
    }

} 