<?php

class Mail
{
//************************************************* récupération du mot de passe****************/
    static function passwordRecup($mail, $link)
    {

        $sujet = \Config::get('site_title') . " - Rénitialiser mon mot de passe";

        ob_start();

?>

        <!DOCTYPE html>
        <html>

        <head>
            <meta charset="UTF-8">
            <title><?= \Config::get('site_title') ?></title>
        </head>

        <body>

            <h1><?= \Config::get('site_title') ?> - Récupération de mot de passe.</h1>

            <p>Ce ci est un email de <a href="<?= \Config::get('url') ?>"><?= \Config::get('site_title') ?></a>.</p>

            <p>Pour réinitialier votre mot de passe veuillez cliquer sur le lien suivant</p>

            <a href="<?= $link ?>">Réinitialier Mon mot de passe</a>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			
			<?php
					
					include("Signature/signature_support_technique.html");
			?>
			

        </body>

        </html>

    <?php

        $content = ob_get_clean();

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
        $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
        $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
        header_remove();

        mail($mail, $sujet, $content, $headers);
    }

//************************************************* bienvenu à la platforme ****************/

    static function welcom_email_validation($mail, $name, $code)
    {

        $link = WEBROOT . "page/connexion?email=$mail&token=$code";

        $sujet = \Config::get('site_title') . " - Bienvenue";

        ob_start();

    ?>

        <!DOCTYPE html>
        <html>

        <head>
            <meta charset="UTF-8">
            <title><?= \Config::get('site_title') ?></title>
        </head>

        <body>

            <h1><?= $name ?>, bienvenue sur <?= \Config::get('site_title') ?>.</h1>

            <p>Ce ci est un email vous informant que votre inscription sur <a href="<?= \Config::get('url') ?>"><?= \Config::get('site_title') ?></a> s'est bien déroulée.</p>

            <p>Pour valider votre adresse email veuillez cliquer sur le lien suivant</p>

            <a href="<?= $link ?>">Valider mon adresse email</a>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			
			<?php
					
					include("Signature/signature_bienvenue.html");
			?>

        </body>

        </html>

    <?php

        $content = ob_get_clean();

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
        $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
        $headers .= "Bcc: youghourta.messai@laotop.fr". "\r\n";
        $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
        header_remove();

        mail($mail, $sujet, $content, $headers);
    }


    //************************************************* email de relance freelance pour saisr son CV ****************/

    static function relance_email_freelance($mail, $name)
    {

       // $link = WEBROOT . "page/connexion?email=$mail&token=$code";

        $sujet = " Bienvenue chez LAOTOP - Découvrez nos services et avantages exclusifs !";

        ob_start();

    ?>

        <!DOCTYPE html>
        <html>

        <head>
            <meta charset="UTF-8">
            <title><?= \Config::get('site_title') ?></title>
        </head>

        <body>

            <h1>Bonjour <?= $name ?></h1>

            <p></p>
            <p>Nous sommes ravis de vous accueillir sur Laotop, la plateforme de mise en relation entre les freelances et les entreprises.</p>
            <p>Nous vous remercions de votre inscription et de votre confiance en notre plateforme. Notre objectif est de vous accompagner dans votre recherche de missions et de vous offrir les meilleurs services pour faciliter votre travail.</p>
            <p>Nous vous invitons à nous communiquer votre CV, si vous avez des difficultés à le renseigner dans la plateforme.</p>
            <p>Vous pouvez dès à présent compléter votre profil et le rendre plus attractif en y ajoutant vos compétences, votre expérience professionnelle ainsi que vos références.</p>
            <p>Notre équipe reste à votre disposition pour toute question ou assistance dont vous pourriez avoir besoin.</p>
            <p>Nous vous souhaitons beaucoup de succès sur notre plateforme.</p>
            <p>Bien cordialement,</p>
         

            
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			
			<?php
					
					include("Signature/signature_bienvenue.html");
			?>

        </body>

        </html>

    <?php

        $content = ob_get_clean();

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
        $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
        $headers .= "Bcc: service.marketing@laotop.fr". "\r\n";
        $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
        header_remove();

        mail($mail, $sujet, $content, $headers);
    }



//************************************************* email de relance freelance pour saisr son CV < 85% ****************/

    static function relance_email_freelance85($mail, $name)
    {

       // $link = WEBROOT . "page/connexion?email=$mail&token=$code";

        $sujet = " Votre Expertise Mérite d'Être Vue – Complétez Votre Profil Laotop";

        ob_start();

    ?>

        <!DOCTYPE html>
        <html>

        <head>
            <meta charset="UTF-8">
            <title><?= \Config::get('site_title') ?></title>
        </head>

        <body>

            <h1>Bonjour <?= $name ?></h1>

            <p></p>
           


<p>Nous sommes heureux de vous voir faire partie de la communauté Laotop, où les connexions entre freelances et entreprises prennent vie. Votre présence ici est un premier pas vers de nouvelles opportunités passionnantes.</p>
<p>Après avoir revu votre profil, nous avons remarqué que vous êtes sur le point de débloquer tout votre potentiel sur Laotop. Actuellement, votre profil est rempli à moins de 85%, ce qui signifie que les clients ne peuvent pas encore le découvrir. Un profil complet est votre porte d'entrée vers des missions à la hauteur de votre expertise.</p>
<p>Pour rendre votre CV visible aux clients et ne pas passer à côté de missions passionnantes, nous vous encourageons à le compléter dès maintenant. Il s'agit d'ajouter les détails qui comptent : vos compétences spécifiques, vos expériences professionnelles marquantes et, si possible, des références qui attestent de votre savoir-faire.</p>
<p>Si vous rencontrez la moindre difficulté ou avez des questions sur la manière de peaufiner votre profil, notre équipe d'assistance est prête à vous aider. Nous sommes là pour que votre profil reflète au mieux votre professionnalisme et attire les entreprises à la recherche de votre talent unique.</p>
<p>Avec un profil complet, les portes de nombreuses opportunités s'ouvriront. N'attendez plus, franchissez ce dernier pas.Complétez votre profil</a>.</p>
<p>Nous sommes impatients de voir votre profil briller sur Laotop et nous vous souhaitons tout le succès mérité.</p>

            
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			
			<?php
					
					include("Signature/signature_bienvenue.html");
			?>

        </body>

        </html>

    <?php

        $content = ob_get_clean();

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
        $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
        $headers .= "Bcc: noreplay@laotop.fr". "\r\n";
        $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
        header_remove();

        mail($mail, $sujet, $content, $headers);
    }


    //************************************************* email de relance freelance pour update dadate diponibilite  ****************/

    static function relance_email_freelanceupdtaeDisponibilte($mail, $name,$dateUpdate)
    {

       // $link = WEBROOT . "page/connexion?email=$mail&token=$code";

        $sujet = " Êtes-vous Toujours Disponible ? Confirmez votre Disponibilité sur Laotop";

        ob_start();

    ?>

        <!DOCTYPE html>
        <html>

        <head>
            <meta charset="UTF-8">
            <title><?= \Config::get('site_title') ?></title>
        </head>

        <body>

            <h1>Bonjour <?= $name ?></h1>

            <p></p>
           


        


            <p>Nous apprécions grandement votre engagement dans la communauté Laotop, un lieu où les talents freelances et les entreprises dynamiques se rencontrent pour créer des opportunités enrichissantes. Nous sommes conscients que nous vous demandons souvent de mettre à jour votre profil et nous vous remercions pour votre patience et votre réactivité face à ces sollicitations.</p>
            <p>La dernière mise à jour de votre profil date un peu <?= $dateUpdate ?>, et pour continuer à attirer des clients qui comptent sur la disponibilité de professionnels compétents comme vous, nous vous invitons à vous connecter et à rafraîchir vos informations de disponibilité.</p>
            <p>Prendre un moment pour cette mise à jour est indispensable pour maintenir la confiance que nos clients placent en nos freelances et pour vous assurer que vous ne manquez aucune mission qui pourrait correspondre à vos compétences uniques.</p>
            <p>Vous pouvez facilement mettre à jour votre profil et votre disponibilité en vous connectant via le lien suivant : <a href="https://www.laotop.fr/page/information">Mettre à jour mon profil</a>.</p>
            <p>Si vous avez besoin d'aide ou si vous avez des questions concernant la mise à jour, notre équipe d'assistance est à votre disposition pour vous accompagner. Nous sommes ici pour vous aider à naviguer sur la plateforme et à saisir chaque opportunité.</p>
            <p>Merci encore pour l'attention que vous portez à ces détails importants. Ensemble, construisons un réseau professionnel où chaque projet trouve son expert freelance.</p>
            <p>Nous attendons avec impatience de voir les nouvelles mises à jour de votre profil.</p>

            
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			
			<?php
					
					include("Signature/signature_bienvenue.html");
			?>

        </body>

        </html>

    <?php

        $content = ob_get_clean();

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
        $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
        $headers .= "Bcc: noreplay@laotop.fr". "\r\n";
        $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
        header_remove();

        mail($mail, $sujet, $content, $headers);
    }
//************************************************* email pour fixer un rdv d'entretien ****************/

static function entretien_email_freelance($mail, $name)
{

   // $link = WEBROOT . "page/connexion?email=$mail&token=$code";

    $sujet = " Bienvenue chez LAOTOP -  Fixons un entretien pour mieux vous connaître";

    ob_start();

?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="UTF-8">
        <title><?= \Config::get('site_title') ?></title>
    </head>

    <body>

        <h1>Cher <?= $name ?></h1>

        <p></p>
      
        <p>Nous sommes ravis de vous accueillir sur Laotop, la plateforme de mise en relation entre freelances et clients. Nous avons examiné attentivement votre profil et nous sommes très intéressés par votre expertise.</p>

        <p>Afin de mieux vous connaître et d'évaluer les opportunités de collaboration, nous vous proposons de fixer un entretien. Veuillez choisir une date et une heure dans le calendrier ci-dessous :</p>

        <p>https://calendly.com/entretiens-laotop</p>

        <p>Nous sommes impatients de discuter davantage avec vous et d'en apprendre plus sur vos compétences et votre expérience. Si vous avez des questions ou des préoccupations, n'hésitez pas à nous contacter.</p>

        <p>Nous vous remercions encore de votre inscription sur Laotop et nous avons hâte de vous rencontrer lors de notre entretien</p>
        <p>Bien cordialement,</p>
        
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        
        <?php
                
                include("Signature/signature_commercial.html");
        ?>

    </body>

    </html>

<?php

    $content = ob_get_clean();

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
    $headers .= "From: service.commercial@laotop.fr" . "\r\n";
    $headers .= "Bcc: service.commercial@laotop.fr". "\r\n";
    $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
    header_remove();

    mail($mail, $sujet, $content, $headers);
}


//************************************************* alerte message reçu par la platforme admin ou comptable phase création dn'entreprise ****************/

    static function alerte_message_platforme($mail, $name, $message)
    {

        

        $sujet = \Config::get('site_title') . " - Vous avez un nouveau message";

        ob_start();

    ?>

        <!DOCTYPE html>
        <html>

        <head>
            <meta charset="UTF-8">
            <title><?= \Config::get('site_title') ?></title>
        </head>

        <body>

            <h1><?= $name ?>Un message de la platforme<?= \Config::get('site_title') ?>.</h1>

            <p>Ce ci est un email vous informant que vous avez reçu un message de la part <a href="<?= \Config::get('url') ?>"><?= \Config::get('site_title') ?></a>.</p>

            <p>Message : <?= $message ?></p>
            
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			<br>
			
			<?php
					
					include("Signature/signature_creation_entreprise.html");
			?>

        </body>

        </html>

    <?php

        $content = ob_get_clean();

        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
        $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
        $headers .= "Bcc: youghourta.messai@laotop.fr". "\r\n";
        $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
        header_remove();

        mail($mail, $sujet, $content, $headers);
    }

//************************************************* alerte  pour le client concernant avancement du ticket validation et date entretien*/

static function alerte_client_ticket($mail, $name, $message)
{

    

    $sujet = \Config::get('site_title') . " - votre ticket est ";

    ob_start();

?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="UTF-8">
        <title><?= \Config::get('site_title') ?></title>
    </head>

    <body>

        <h1><?= $name ?>  Un message de la platforme <?= \Config::get('site_title') ?>.</h1>

        <p>Ce ci est un email vous informant que vous avez une mise à jour de votre ticket <a href="<?= \Config::get('url') ?>"><?= \Config::get('site_title') ?></a>.</p>

        <p>Message : <?= $message ?></p>
        
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        
        <?php
                
                include("Signature/signature_commercial.html");
        ?>

    </body>

    </html>

<?php

    $content = ob_get_clean();

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
    $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
    $headers .= "Bcc: youghourta.messai@laotop.fr". "\r\n";
    $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
    header_remove();

    mail($mail, $sujet, $content, $headers);
}



//************************************************* alerte pour informer le freelance qu'un client s'interesse a son profile*/

static function alerte_client_freelance($mail, $name, $message,$titre)
{

    

    $sujet = \Config::get('site_title') . $titre;

    ob_start();

?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="UTF-8">
        <title><?= \Config::get('site_title') ?></title>
    </head>

    <body>

        <h1><?= $name ?>  Un message de la platforme <?= \Config::get('site_title') ?>.</h1>

        <p>Ce ci est un email vous informant que vous avez une mise à jour de votre ticket <a href="<?= \Config::get('url') ?>"><?= \Config::get('site_title') ?></a>.</p>

        <p>Message : <?= $message ?></p>
        
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        
        <?php
                
                include("Signature/signature_commercial.html");
        ?>

    </body>

    </html>

<?php

    $content = ob_get_clean();

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
    $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
    $headers .= "Bcc: youghourta.messai@laotop.fr". "\r\n";
    $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
    header_remove();

    mail($mail, $sujet, $content, $headers);
}
       //************************************************* alerte  pour mettre à jour la date de disponibilité*/



//************************************************* alerte pour informer le freelance qu'un client s'interesse a son profile*/

static function envoie_email($mail,$message,$titre)
{

    

    $sujet = $titre;

    ob_start();

?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="UTF-8">
        <title><?= \Config::get('site_title') ?></title>
    </head>

    <body>

        <h1> <?= \Config::get('site_title') ?>:<?= $titre?></h1>

       

        <p><?= $message ?></p>
        
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        
        <?php
                
                include("Signature/signature_commercial.html");
        ?>

    </body>

    </html>

<?php

    $content = ob_get_clean();

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
    $headers .= "From:service.commercial@laotop.fr" . "\r\n";
    $headers .= "Bcc: $mail". "\r\n";
    $headers .= "Reply-To: service.commercial@laotop.fr". "\r\n";
    header_remove();

    mail("service.commercial@laotop.fr", $sujet, $content, $headers);
}
       //************************************************* alerte  pour mettre à jour la date de disponibilité*/

static function alerte_update_date_disponibilité_freelance($mail, $name)
{

    

    $sujet = \Config::get('site_title') . " - date de l'entretien ";

    ob_start();

?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="UTF-8">
        <title><?= \Config::get('site_title') ?></title>
    </head>

    <body>

        <h1><?= $name ?>, Un message de la platforme <?= \Config::get('site_title') ?>.</h1>

        <p>Votre date de disponibilité n'est pas à jours depuis un mois veuillez la mettre à jours <a href="<?= \Config::get('url') ?>"><?= \Config::get('site_title') ?></a>.</p>
        
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        
        <?php
                
                include("Signature/signature_commercial.html");
        ?>

    </body>

    </html>

<?php

    $content = ob_get_clean();

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
    $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
    $headers .= "Bcc: noreplay@laotop.fr". "\r\n";
    $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
    header_remove();

    mail($mail, $sujet, $content, $headers);
}
    

//************************************************* Un message pour le comptable */

static function alerte_message_comptable($mail,$emailFreelance, $name, $message,$titre)
{

    

    $sujet = \Config::get('site_title') . $titre;

    ob_start();

?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="UTF-8">
        <title><?= \Config::get('site_title') ?></title>
    </head>

    <body>

        <h1><?= $name ?></h1>

        <p>Un message de platforme : <a href="<?= \Config::get('url') ?>"><?= \Config::get('site_title') ?></a>.</p>

        <p><?= $message ?></p>
        
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
        
        <?php
                
                include("Signature/signature_creation_entreprise.html");
        ?>

    </body>

    </html>

<?php

    $content = ob_get_clean();

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
    $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
    $headers .= "Bcc: youghourta.messai@laotop.fr". "\r\n";
    $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
    
    $headers.= "Bcc: $emailFreelance"."\r\n";
    header_remove();

    mail($mail, $sujet, $content, $headers);
}
    
     //************************************************* alerte  profile n'est pas complet*/

     static function alerte_complete_profil_freelance($mail, $name, $message)
     {
     
         
     
         $sujet = \Config::get('site_title') . " - date de l'entretien ";
     
         ob_start();
     
     ?>
     
         <!DOCTYPE html>
         <html>
     
         <head>
             <meta charset="UTF-8">
             <title><?= \Config::get('site_title') ?></title>
         </head>
     
         <body>
     
             <h1><?= $name ?>Un message de la platforme<?= \Config::get('site_title') ?>.</h1>
     
             <p>Votre profile n'est pas complet,veuillez le compléter afin qu'il soit visible par nos recruteurs : <a href="<?= \Config::get('url') ?>"><?= \Config::get('site_title') ?></a>.</p>
     
             <p>Message : <?= $message ?></p>
             
             <br>
             <br>
             <br>
             <br>
             <br>
             <br>
             <br>
             <br>
             
             <?php
                     
                     include("Signature/signature_bienvenue.html");
             ?>
     
         </body>
     
         </html>
     
     <?php
     
         $content = ob_get_clean();
     
         $headers = "MIME-Version: 1.0" . "\r\n";
         $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
         $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
         $headers .= "Bcc: noreplay@laotop.fr". "\r\n";
         $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
         header_remove();
     
         mail($mail, $sujet, $content, $headers);
     }


    //************************************************* Mot de passe FIPARCO */

    static function envoyer_motdepasse_fiparco($mail, $nom, $post){
    
        $sujet = \Config::get('site_title') . " - Informations compte cloud FIPARCO";
    
        ob_start();
    
    ?>
    
        <!DOCTYPE html>
        <html>
    
        <head>
            <meta charset="UTF-8">
            <title><?= \Config::get('site_title') ?></title>
        </head>
    
        <body>
    
            <h1><?= $nom ?>, Un message de la platforme <?= \Config::get('site_title') ?>.</h1>
    
            <p>Vos informations de compte cloud FIPARCO pour la création de votre entreprise :</p>
    
            <h2>Login : <?= $post['login'] ?></h2>
            <h2>Mot de passe : <?= $post['motdepasse'] ?></h2>
            <h2>Url : <a href="<?= $post['url'] ?>"><?= $post['url'] ?></a></h2>
            
            <br>
            <br>
            <br>
            <br>
            <br>
            <br>
            <br>
            <br>
            
            <?php
                    
                    include("Signature/signature_bienvenue.html");
            ?>
    
        </body>
    
        </html>
    
    <?php
    
        $content = ob_get_clean();
    
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
        $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
        $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
        header_remove();
    
        mail($mail, $sujet, $content, $headers);
    }
     
    
       //************************************************* alerte  pour mettre à jour la date de disponibilité*/

static function rapportCV($mail, $name,$nbconsultationMois,$nbconsultation,$nbr_mission,$date_disponibilite,$date)
{



    $sujet = \Config::get('site_title') . " - Rapport d'activité";

    ob_start();

?>

    <!DOCTYPE html>
    <html>

    <head>
        <meta charset="UTF-8">
        <title><?= \Config::get('site_title') ?></title>
    </head>

    <body>

<h1>Bonjour <strong><?= htmlspecialchars($name) ?></strong>,</h1>

<p>Voici un bref rapport de votre activité sur <strong style="color:#DE3F6D;"><?= \Config::get('site_title') ?></strong> pour le mois en cours :</p>

<ul>
            <li>Nombre de consultations de votre profil ce mois : <strong style="color:#DE3F6D;"><?= htmlspecialchars($nbconsultationMois) ?></strong></li>
            <li>Depuis votre inscription le <strong style="color:#DE3F6D;"><?= htmlspecialchars($date) ?></strong>, votre profil a été consulté <strong style="color:#DE3F6D;"><?= htmlspecialchars($nbconsultation) ?> fois</strong>.</li>
            <li>Nombre de missions réalisées : <strong style="color:#DE3F6D;"><?= htmlspecialchars($nbr_mission) ?></strong></li>
            <li>Votre disponibilité pour le marché est actuellement définie pour le : <strong style="color:#DE3F6D;"><?= htmlspecialchars($date_disponibilite) ?></strong></li>
        </ul>

        <p>Si cette date a changé ou va bientôt changer, nous vous encourageons à mettre à jour votre disponibilité dès que possible en vous rendant sur <a href="<?= \Config::get('url') ?>" style="color:#DE3F6D;"><?= \Config::get('site_title') ?></a>. Cela aide à maximiser vos opportunités sur notre plateforme en permettant aux clients de savoir quand vous êtes disponible.</p>

<p>Merci de rester actif et à jour pour maximiser vos opportunités sur notre plateforme.</p>

<?php include("Signature/signature_commercial.html"); ?>

</body>

    </html>

<?php

    $content = ob_get_clean();

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type: text/html; charset=utf-8" . "\r\n";
    $headers .= "From: " . \Config::get('site_title') . " <" . \Config::get('site_email') . ">" . "\r\n";
    $headers .= "Bcc: noreplay@laotop.fr". "\r\n";
    $headers .= "Reply-To: " . \Config::get('site_email') . "\r\n";
    header_remove();

    mail($mail, $sujet, $content, $headers);
}

}
