<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.8.1
*/function
adminer_errors($cc,$ec){return!!preg_match('~^(Trying to access array offset on value of type null|Undefined array key)~',$ec);}error_reporting(6135);set_error_handler('adminer_errors',E_WARNING);$wc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($wc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$fh=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($fh)$$X=$fh;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$g;return$g;}function
adminer(){global$c;return$c;}function
version(){global$fa;return$fa;}function
idf_unescape($v){if(!preg_match('~^[`\'"]~',$v))return$v;$wd=substr($v,-1);return
str_replace($wd.$wd,$wd,substr($v,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($kf,$wc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($z,$X)=each($kf)){foreach($X
as$od=>$W){unset($kf[$z][$od]);if(is_array($W)){$kf[$z][stripslashes($od)]=$W;$kf[]=&$kf[$z][stripslashes($od)];}else$kf[$z][stripslashes($od)]=($wc?$W:stripslashes($W));}}}}function
bracket_escape($v,$_a=false){static$Sg=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($_a?array_flip($Sg):$Sg));}function
min_version($uh,$Id="",$h=null){global$g;if(!$h)$h=$g;$Sf=$h->server_info;if($Id&&preg_match('~([\d.]+)-MariaDB~',$Sf,$C)){$Sf=$C[1];$uh=$Id;}return(version_compare($Sf,$uh)>=0);}function
charset($g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
script($bg,$Rg="\n"){return"<script".nonce().">$bg</script>$Rg";}function
script_src($kh){return"<script src='".h($kh)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($lg){return
str_replace("\0","&#0;",htmlspecialchars($lg,ENT_QUOTES,'utf-8'));}function
nl_br($lg){return
str_replace("\n","<br>",$lg);}function
checkbox($E,$Y,$Na,$sd="",$te="",$Ra="",$td=""){$K="<input type='checkbox' name='$E' value='".h($Y)."'".($Na?" checked":"").($td?" aria-labelledby='$td'":"").">".($te?script("qsl('input').onclick = function () { $te };",""):"");return($sd!=""||$Ra?"<label".($Ra?" class='$Ra'":"").">$K".h($sd)."</label>":$K);}function
optionlist($xe,$Nf=null,$oh=false){$K="";foreach($xe
as$od=>$W){$ye=array($od=>$W);if(is_array($W)){$K.='<optgroup label="'.h($od).'">';$ye=$W;}foreach($ye
as$z=>$X)$K.='<option'.($oh||is_string($z)?' value="'.h($z).'"':'').(($oh||is_string($z)?(string)$z:$X)===$Nf?' selected':'').'>'.h($X);if(is_array($W))$K.='</optgroup>';}return$K;}function
html_select($E,$xe,$Y="",$se=true,$td=""){if($se)return"<select name='".h($E)."'".($td?" aria-labelledby='$td'":"").">".optionlist($xe,$Y)."</select>".(is_string($se)?script("qsl('select').onchange = function () { $se };",""):"");$K="";foreach($xe
as$z=>$X)$K.="<label><input type='radio' name='".h($E)."' value='".h($z)."'".($z==$Y?" checked":"").">".h($X)."</label>";return$K;}function
select_input($wa,$xe,$Y="",$se="",$Xe=""){$_g=($xe?"select":"input");return"<$_g$wa".($xe?"><option value=''>$Xe".optionlist($xe,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Xe'>").($se?script("qsl('$_g').onchange = $se;",""):"");}function
confirm($D="",$Of="qsl('input')"){return
script("$Of.onclick = function () { return confirm('".($D?js_escape($D):lang(0))."'); };","");}function
print_fieldset($u,$Ad,$xh=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$Ad</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($xh?"":" class='hidden'").">\n";}function
bold($Ga,$Ra=""){return($Ga?" class='active $Ra'":($Ra?" class='$Ra'":""));}function
odd($K=' class="odd"'){static$t=0;if(!$K)$t=-1;return($t++%2?$K:'');}function
js_escape($lg){return
addcslashes($lg,"\r\n'\\/");}function
json_row($z,$X=null){static$xc=true;if($xc)echo"{";if($z!=""){echo($xc?"":",")."\n\t\"".addcslashes($z,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$xc=false;}else{echo"\n}\n";$xc=true;}}function
ini_bool($cd){$X=ini_get($cd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$K;if($K===null)$K=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$K;}function
set_password($th,$O,$V,$G){$_SESSION["pwds"][$th][$O][$V]=($_COOKIE["adminer_key"]&&is_string($G)?array(encrypt_string($G,$_COOKIE["adminer_key"])):$G);}function
get_password(){$K=get_session("pwds");if(is_array($K))$K=($_COOKIE["adminer_key"]?decrypt_string($K[0],$_COOKIE["adminer_key"]):false);return$K;}function
q($lg){global$g;return$g->quote($lg);}function
get_vals($I,$d=0){global$g;$K=array();$J=$g->query($I);if(is_object($J)){while($L=$J->fetch_row())$K[]=$L[$d];}return$K;}function
get_key_vals($I,$h=null,$Vf=true){global$g;if(!is_object($h))$h=$g;$K=array();$J=$h->query($I);if(is_object($J)){while($L=$J->fetch_row()){if($Vf)$K[$L[0]]=$L[1];else$K[]=$L[0];}}return$K;}function
get_rows($I,$h=null,$m="<p class='error'>"){global$g;$fb=(is_object($h)?$h:$g);$K=array();$J=$fb->query($I);if(is_object($J)){while($L=$J->fetch_assoc())$K[]=$L;}elseif(!$J&&!is_object($h)&&$m&&defined("PAGE_HEADER"))echo$m.error()."\n";return$K;}function
unique_array($L,$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$K=array();foreach($w["columns"]as$z){if(!isset($L[$z]))continue
2;$K[$z]=$L[$z];}return$K;}}}function
escape_key($z){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$z,$C))return$C[1].idf_escape(idf_unescape($C[2])).$C[3];return
idf_escape($z);}function
where($Z,$o=array()){global$g,$y;$K=array();foreach((array)$Z["where"]as$z=>$X){$z=bracket_escape($z,1);$d=escape_key($z);$K[]=$d.($y=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($y=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($o[$z],q($X))));if($y=="sql"&&preg_match('~char|text~',$o[$z]["type"])&&preg_match("~[^ -@]~",$X))$K[]="$d = ".q($X)." COLLATE ".charset($g)."_bin";}foreach((array)$Z["null"]as$z)$K[]=escape_key($z)." IS NULL";return
implode(" AND ",$K);}function
where_check($X,$o=array()){parse_str($X,$Ma);remove_slashes(array(&$Ma));return
where($Ma,$o);}function
where_link($t,$d,$Y,$ue="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$ue:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($e,$o,$N=array()){$K="";foreach($e
as$z=>$X){if($N&&!in_array(idf_escape($z),$N))continue;$ua=convert_field($o[$z]);if($ua)$K.=", $ua AS ".idf_escape($z);}return$K;}function
cookie($E,$Y,$Dd=2592000){global$ba;return
header("Set-Cookie: $E=".urlencode($Y).($Dd?"; expires=".gmdate("D, d M Y H:i:s",time()+$Dd)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($zc=false){$nh=ini_bool("session.use_cookies");if(!$nh||$zc){session_write_close();if($nh&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($z){return$_SESSION[$z][DRIVER][SERVER][$_GET["username"]];}function
set_session($z,$X){$_SESSION[$z][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($th,$O,$V,$k=null){global$Kb;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($Kb))."|username|".($k!==null?"db|":"").session_name()),$C);return"$C[1]?".(sid()?SID."&":"").($th!="server"||$O!=""?urlencode($th)."=".urlencode($O)."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($C[2]?"&$C[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($B,$D=null){if($D!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($B!==null?$B:$_SERVER["REQUEST_URI"]))][]=$D;}if($B!==null){if($B=="")$B=".";header("Location: $B");exit;}}function
query_redirect($I,$B,$D,$sf=true,$jc=true,$qc=false,$Gg=""){global$g,$m,$c;if($jc){$hg=microtime(true);$qc=!$g->query($I);$Gg=format_time($hg);}$dg="";if($I)$dg=$c->messageQuery($I,$Gg,$qc);if($qc){$m=error().$dg.script("messagesPrint();");return
false;}if($sf)redirect($B,$D.$dg);return
true;}function
queries($I){global$g;static$nf=array();static$hg;if(!$hg)$hg=microtime(true);if($I===null)return
array(implode("\n",$nf),format_time($hg));$nf[]=(preg_match('~;$~',$I)?"DELIMITER ;;\n$I;\nDELIMITER ":$I).";";return$g->query($I);}function
apply_queries($I,$S,$fc='table'){foreach($S
as$Q){if(!queries("$I ".$fc($Q)))return
false;}return
true;}function
queries_redirect($B,$D,$sf){list($nf,$Gg)=queries(null);return
query_redirect($nf,$B,$D,$sf,false,!$sf,$Gg);}function
format_time($hg){return
lang(1,max(0,microtime(true)-$hg));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Le=""){return
substr(preg_replace("~(?<=[?&])($Le".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($F,$qb){return" ".($F==$qb?$F+1:'<a href="'.h(remove_from_uri("page").($F?"&page=$F".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($F+1)."</a>");}function
get_file($z,$yb=false){$uc=$_FILES[$z];if(!$uc)return
null;foreach($uc
as$z=>$X)$uc[$z]=(array)$X;$K='';foreach($uc["error"]as$z=>$m){if($m)return$m;$E=$uc["name"][$z];$Og=$uc["tmp_name"][$z];$gb=file_get_contents($yb&&preg_match('~\.gz$~',$E)?"compress.zlib://$Og":$Og);if($yb){$hg=substr($gb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$hg,$yf))$gb=iconv("utf-16","utf-8",$gb);elseif($hg=="\xEF\xBB\xBF")$gb=substr($gb,3);$K.=$gb."\n\n";}else$K.=$gb;}return$K;}function
upload_error($m){$Od=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(2).($Od?" ".lang(3,$Od):""):lang(4));}function
repeat_pattern($Ue,$Bd){return
str_repeat("$Ue{0,65535}",$Bd/65535)."$Ue{0,".($Bd%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($lg,$Bd=80,$pg=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Bd).")($)?)u",$lg,$C))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Bd).")($)?)",$lg,$C);return
h($C[1]).$pg.(isset($C[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($kf,$Yc=array(),$df=''){$K=false;foreach($kf
as$z=>$X){if(!in_array($z,$Yc)){if(is_array($X))hidden_fields($X,array(),$z);else{$K=true;echo'<input type="hidden" name="'.h($df?$df."[$z]":$z).'" value="'.h($X).'">';}}}return$K;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($Q,$rc=false){$K=table_status($Q,$rc);return($K?$K:array("Name"=>$Q));}function
column_foreign_keys($Q){global$c;$K=array();foreach($c->foreignKeys($Q)as$p){foreach($p["source"]as$X)$K[$X][]=$p;}return$K;}function
enum_input($U,$wa,$n,$Y,$Yb=null){global$c;preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$Jd);$K=($Yb!==null?"<label><input type='$U'$wa value='$Yb'".((is_array($Y)?in_array($Yb,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Jd[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$Na=(is_int($Y)?$Y==$t+1:(is_array($Y)?in_array($t+1,$Y):$Y===$X));$K.=" <label><input type='$U'$wa value='".($t+1)."'".($Na?' checked':'').'>'.h($c->editVal($X,$n)).'</label>';}return$K;}function
input($n,$Y,$r){global$ah,$c,$y;$E=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$r){$ta=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$ta[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$ta);$r="json";}$_f=($y=="mssql"&&$n["auto_increment"]);if($_f&&!$_POST["save"])$r=null;$Gc=(isset($_GET["select"])||$_f?array("orig"=>lang(8)):array())+$c->editFunctions($n);$wa=" name='fields[$E]'";if($n["type"]=="enum")echo
h($Gc[""])."<td>".$c->editInput($_GET["edit"],$n,$wa,$Y);else{$Pc=(in_array($r,$Gc)||isset($Gc[$r]));echo(count($Gc)>1?"<select name='function[$E]'>".optionlist($Gc,$r===null||$Pc?$r:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($Gc))).'<td>';$ed=$c->editInput($_GET["edit"],$n,$wa,$Y);if($ed!="")echo$ed;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$wa value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$wa value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$Jd);foreach($Jd[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$Na=(is_int($Y)?($Y>>$t)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$E][$t]' value='".(1<<$t)."'".($Na?' checked':'').">".h($c->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$E'>";elseif(($Eg=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($Eg&&$y!="sqlite")$wa.=" cols='50' rows='12'";else{$M=min(12,substr_count($Y,"\n")+1);$wa.=" cols='30' rows='$M'".($M==1?" style='height: 1.2em;'":"");}echo"<textarea$wa>".h($Y).'</textarea>';}elseif($r=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$wa cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Qd=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$C)?((preg_match("~binary~",$n["type"])?2:1)*$C[1]+($C[3]?1:0)+($C[2]&&!$n["unsigned"]?1:0)):($ah[$n["type"]]?$ah[$n["type"]]+($n["unsigned"]?0:1):0));if($y=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$Qd+=7;echo"<input".((!$Pc||$r==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($Qd?" data-maxlength='$Qd'":"").(preg_match('~char|binary~',$n["type"])&&$Qd>20?" size='40'":"")."$wa>";}echo$c->editHint($_GET["edit"],$n,$Y);$xc=0;foreach($Gc
as$z=>$X){if($z===""||!$X)break;$xc++;}if($xc)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $xc), oninput: function () { this.onchange(); }});");}}function
process_input($n){global$c,$l;$v=bracket_escape($n["field"]);$r=$_POST["function"][$v];$Y=$_POST["fields"][$v];if($n["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($n["auto_increment"]&&$Y=="")return
null;if($r=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($r=="NULL")return"NULL";if($n["type"]=="set")return
array_sum((array)$Y);if($r=="json"){$r="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$uc=get_file("fields-$v");if(!is_string($uc))return
false;return$l->quoteBinary($uc);}return$c->processInput($n,$Y,$r);}function
fields_from_edit(){global$l;$K=array();foreach((array)$_POST["field_keys"]as$z=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$z];$_POST["fields"][$X]=$_POST["field_vals"][$z];}}foreach((array)$_POST["fields"]as$z=>$X){$E=bracket_escape($z,1);$K[$E]=array("field"=>$E,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($z==$l->primary),);}return$K;}function
search_tables(){global$c,$g;$_GET["where"][0]["val"]=$_POST["query"];$Qf="<ul>\n";foreach(table_status('',true)as$Q=>$R){$E=$c->tableName($R);if(isset($R["Engine"])&&$E!=""&&(!$_POST["tables"]||in_array($Q,$_POST["tables"]))){$J=$g->query("SELECT".limit("1 FROM ".table($Q)," WHERE ".implode(" AND ",$c->selectSearchProcess(fields($Q),array())),1));if(!$J||$J->fetch_row()){$gf="<a href='".h(ME."select=".urlencode($Q)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$E</a>";echo"$Qf<li>".($J?$gf:"<p class='error'>$gf: ".error())."\n";$Qf="";}}}echo($Qf?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($Xc,$Xd=false){global$c;$K=$c->dumpHeaders($Xc,$Xd);$Ie=$_POST["output"];if($Ie!="text")header("Content-Disposition: attachment; filename=".$c->dumpFilename($Xc).".$K".($Ie!="file"&&preg_match('~^[0-9a-z]+$~',$Ie)?".$Ie":""));session_write_close();ob_flush();flush();return$K;}function
dump_csv($L){foreach($L
as$z=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$L[$z]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$L)."\r\n";}function
apply_sql_function($r,$d){return($r?($r=="unixepoch"?"DATETIME($d, '$r')":($r=="count distinct"?"COUNT(DISTINCT ":strtoupper("$r("))."$d)"):$d);}function
get_temp_dir(){$K=ini_get("upload_tmp_dir");if(!$K){if(function_exists('sys_get_temp_dir'))$K=sys_get_temp_dir();else{$vc=@tempnam("","");if(!$vc)return
false;$K=dirname($vc);unlink($vc);}}return$K;}function
file_open_lock($vc){$q=@fopen($vc,"r+");if(!$q){$q=@fopen($vc,"w");if(!$q)return;chmod($vc,0660);}flock($q,LOCK_EX);return$q;}function
file_write_unlock($q,$sb){rewind($q);fwrite($q,$sb);ftruncate($q,strlen($sb));flock($q,LOCK_UN);fclose($q);}function
password_file($i){$vc=get_temp_dir()."/adminer.key";$K=@file_get_contents($vc);if($K||!$i)return$K;$q=@fopen($vc,"w");if($q){chmod($vc,0660);$K=rand_string();fwrite($q,$K);fclose($q);}return$K;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$A,$n,$Fg){global$c;if(is_array($X)){$K="";foreach($X
as$od=>$W)$K.="<tr>".($X!=array_values($X)?"<th>".h($od):"")."<td>".select_value($W,$A,$n,$Fg);return"<table cellspacing='0'>$K</table>";}if(!$A)$A=$c->selectLink($X,$n);if($A===null){if(is_mail($X))$A="mailto:$X";if(is_url($X))$A=$X;}$K=$c->editVal($X,$n);if($K!==null){if(!is_utf8($K))$K="\0";elseif($Fg!=""&&is_shortable($n))$K=shorten_utf8($K,max(0,+$Fg));else$K=h($K);}return$c->selectVal($K,$A,$n,$X);}function
is_mail($Vb){$va='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Jb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Ue="$va+(\\.$va+)*@($Jb?\\.)+$Jb";return
is_string($Vb)&&preg_match("(^$Ue(,\\s*$Ue)*\$)i",$Vb);}function
is_url($lg){$Jb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($Jb?\\.)+$Jb(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$lg);}function
is_shortable($n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]);}function
count_rows($Q,$Z,$kd,$s){global$y;$I=" FROM ".table($Q).($Z?" WHERE ".implode(" AND ",$Z):"");return($kd&&($y=="sql"||count($s)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$s).")$I":"SELECT COUNT(*)".($kd?" FROM (SELECT 1$I GROUP BY ".implode(", ",$s).") x":$I));}function
slow_query($I){global$c,$T,$l;$k=$c->database();$Hg=$c->queryTimeout();$Zf=$l->slowQuery($I,$Hg);if(!$Zf&&support("kill")&&is_object($h=connect())&&($k==""||$h->select_db($k))){$qd=$h->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$qd,'&token=',$T,'\');
}, ',1000*$Hg,');
</script>
';}else$h=null;ob_flush();flush();$K=@get_key_vals(($Zf?$Zf:$I),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$K;}function
get_token(){$qf=rand(1,1e6);return($qf^$_SESSION["token"]).":$qf";}function
verify_token(){list($T,$qf)=explode(":",$_POST["token"]);return($qf^$_SESSION["token"])==$T;}function
lzw_decompress($Da){$Gb=256;$Ea=8;$Ta=array();$Af=0;$Bf=0;for($t=0;$t<strlen($Da);$t++){$Af=($Af<<8)+ord($Da[$t]);$Bf+=8;if($Bf>=$Ea){$Bf-=$Ea;$Ta[]=$Af>>$Bf;$Af&=(1<<$Bf)-1;$Gb++;if($Gb>>$Ea)$Ea++;}}$Fb=range("\0","\xFF");$K="";foreach($Ta
as$t=>$Sa){$Ub=$Fb[$Sa];if(!isset($Ub))$Ub=$Ch.$Ch[0];$K.=$Ub;if($t)$Fb[]=$Ch.$Ub[0];$Ch=$Ub;}return$K;}function
on_help($Za,$Xf=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $Za, $Xf) }, onmouseout: helpMouseout});","");}function
edit_form($Q,$o,$L,$ih){global$c,$y,$T,$m;$ug=$c->tableName(table_status1($Q,true));page_header(($ih?lang(10):lang(11)),$m,array("select"=>array($Q,$ug)),$ug);$c->editRowPrint($Q,$o,$L,$ih);if($L===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$o)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($o
as$E=>$n){echo"<tr><th>".$c->fieldName($n);$zb=$_GET["set"][bracket_escape($E)];if($zb===null){$zb=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$zb,$yf))$zb=$yf[1];}$Y=($L!==null?($L[$E]!=""&&$y=="sql"&&preg_match("~enum|set~",$n["type"])?(is_array($L[$E])?array_sum($L[$E]):+$L[$E]):(is_bool($L[$E])?+$L[$E]:$L[$E])):(!$ih&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$zb)));if(!$_POST["save"]&&is_string($Y))$Y=$c->editVal($Y,$n);$r=($_POST["save"]?(string)$_POST["function"][$E]:($ih&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$ih&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$r="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$r="now";}input($n,$Y,$r);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$c->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($ih?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($ih?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($ih?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$o?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$T,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\n1ٌ̇l7B14vb0fsn2Bѱ٘n:#(b.\rDc)a7Elñi1̎s-4f	i7t4yZf4iATVVf:Ϧ,:1Qݼb2`#>:7G1sLXD*bv<܌#e@:4!fot:<咾o\ni',a_:iBv|N4.5Nfivphl֚O= OFQk\$id2Tp6-Z6h:a,2#8А#6nJht4O42ok*r@p@!?6r[L:2Bj!HbP=!1V\"0\nSD7DڛC!!Gʌ +=tC.C:+=%c1MR/EȒ42䱠`8(ӹ[W=ySb=-ܹBS+ɯ@pL4Ydq63ĬAc܌Ψk[&>Zpkm]u-c:Ntδpҝ8=#[.ޯ~myPP|I֛Q9v[Q\nr'g+T2Vz48(	Ey*#j2]R)[NR\$<>:>\$;>\rHT\nwN wأ<Gw\\Y_Rt^>\r}S\rz4=\nL%J\",Z8i0u?s3#ى:㽖E]xs^8K^*0w~:iv2w^77cu+U%{P*4̼LX./!1Cqx!HFdLĠ`65fĆ=Hl V1\0a2;6_ه\0&ZSd)KE'n[X\0ZɊF[Pޘ@!Y,`\"ڷ0Ee9yF>9bF5:\0}Ĵ(\$37H MA6R{Mq7GCCm2(Ct>[-t/&C]etG̬4@r><Sq/QhmL#K|6fKP\r%tV=\"SH\$} )w,W\0Fu@b9\rr2#DXyOI>nǢ%'_t\rτz\\1hl]Q5Mp6kqh\$H~|!*4`SS tPP\\g7\n-:袪plB7Өc(wO0\\:wp4{TjO6HÊrq\n%%y']\$aZ.fcq*-FWkzjlg:\$\"N\r#dÂsc̠\"j\rՒPh1/DA)[knp76YR{MP@\n-a6[zJH,dlBho+#Dr^^eE ĜaPJGzt2XVȳB_%K=Eb弾§kU(.!ܮ8I.@Kxn:P32mH		C*:vT\nR0uҧ]P/JQd{L޳:Y2bT 34cV=L4r!BY6MeLio9< GƕЙMhm^UNTr5HiM/n흳T[-<__3/Xr(<uҖGNX20\r\$^:'9O;kfN'ab,V1HI!%6@\$EGڜ1(mUrս`iN+Ü)0lf0[UV-:I^\$sb\reugh~9߈bf+0 hXrݬ!\$e,w+3_Ak\nkrʛcuWdY\\={.čgp8t\rRZvJ:>Y|+@Ct\rjt6%?ǎ>/9F`וv~KRWzlmwL9Y*qxzSeݛ~Dxɟi72Oݻ_{53t_z3d)C\$?KӪP%T&&\0PNA^~p Ϝ\r\$b*+D6궦ψJ\$(olh&KBS>;zxoz>oZ\nʋ[vȜ2OxِV0f2Blbk6ZkhXcd0*KTH=πp0lV\rnm)((:#E:CC\rG\ré0i:`Z1Q\n:\r\0q:`-M#}1;q#|ShlD\0fiDpL``0y1\r=MQ\\%oq\01211 ќbi:\r/Ѣ `)0@I1NCOZ1q1 ,\rdIǦvj1 tB⁒0:01A2V0%fi3!&QRc%q&w%\rV#Qw`% m*ry&i+r{*(rg(#(2()R@i- 1\"\0R.e.r,ry(2Cb!Bޏ3%ҵ,R1&tba\rL-3\0Bp194O'R3*=\$[^iI;/3i5&}17# ѹ8\"789*23!!1\\\08rk9;S23ړ*:q]5S<#383#e=>~9S螳r)T*a@іbes:-*;,ؙ3!iLҲ#1 +n *@3i71_FS;3F\rA3>x: \r0@-/w7SJ3 .F\$OB%4+t'gLq\rJtJM2\r7T@)ⓣd2P>ΰFi಴\nr\0bk(DKQ1\"2tP\r,\$KCt5#)P#Pi.U2C~\"");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`wJD29t*yNiIh\\9:xﭵyl*ȈY8W?ޛ3!\"6n[\r*\$Ƨnzx9\r|*3ףpﻶ:(p\\;mz98Nj2\rHH&(z7ik cet2:SHȠ/)x@tri98yҷV+^WڦkZYlʣ4Ƌ\\E{7\0pDi-T0l%=˃9(5\n\nn,4\0a}܃.Rs\02B\\b1S\0003,XPHJspdK CA!2*W2\$+f^\n1zE Iv\\2.*AE(db܄9Dh&?HsQ2x~nÁJT2&eRGQTwݑP\\)6sh\\3\0R	'\r+*;RH.!['~%t< pK#!lLe,&\$	`CXӆ0֭:Mh	ڜG!&3D<!23?hJe h\rmNiNHl7vWI.-5֧ey\rEJ\ni*\$@RU0,\$UEªu)@(tSJkp!~d`>\n;#\rp9jɹ]&Nc(rTQUS\08n`ybLO5,>xf䴒+\"I{kM[\r%[	ea1! ԮF@b)R720\nWLܜҮtd+0wgl0n@ɢiM\nAM5n\$EױNl%1 AkriFBol,muNx-_֤C( fl\r1p[9x(iBҖzQl8C	XU TbI`p+V\0;CbX+ϒs]H[kxG*]awn!6mSIK~/ӥ7eeNS/;dA>}l~ %^fآpڜDEat\nx=kЎ*dTj2j\n ,e=M84aj@Tsnf\n6\rd0Y'%ԓ~	Ҩ<AHG8΃\$z{u2*a>(wK.bP{o´z#28=8>A,e+Cx*-b=m,alzk\$W,mJiʧ+0[.RsKXZL2`(CvZ\$׹,D?HNxX)M\$,*\nѣ\$<qşh!SxsA!:K}RA2kXp\n<l3VV}g&Yݍ!+;<YYE3rَCo5ճkkۣtU)[}ul:D+Ϗ _oh1400bK㬒lG#|UdIK7^@O\0HHi6\r\\cg\02B*e\n	zr!nWz& {H'\$X w@8DGr*H'p#Į\nd,,;g~\0#E\rI`'%E.]`Л%&m\r%4Sv#\nfH\$%-#qBQ-c2&] qh\rl]sh7n#-jEFrl&dzF6\"|s@z)0rpڏ\0X\0|DL<!o*D{.B<E0nB( |\r\n^ h!r\$(^~/pqBO,\\#RR%dHj`̭ V bSdiEohr<i/k\$-\$o+ŋlO&evƒijMPA'u'( M(h/+WDSo.n.n((\"h&p//1D̊j娸E&⦀,'l\$/.,dWbbO3BsH:J`!.,F7(Կ1ls ҎŢqX\r~R鰱`ҞY*:RrJ%L+n\"\r͇H!qb2Li%Wj#9ObE.I:67\06+%.a7E8VS?(DGӳB%;/<\r >M@HDsZ[tHEnx(Rx@GkjW>#T/8c8Q0_IIGII!YEdE^tdth`DV!C8\rb3!3@33N}ZB3	330M(>}\\tffI\r337 X\"td,\nbtNO`P;ܕҭ\$\nZѭ5U5WU^hotPM/5K4EjKQ&53GXXx)<5D\rV\nr5b܀\\J\">1S\r[-Du\r)00Yˢk{\n#\r^|uܻU_nU4U~Yt\rI@䏳R 3:uePMS0TwWXDKOU;U\nOYYQ,M[\0_DWJ*\rg(]\r\"ZC6u+YY6ô0q(8}3AX3Th9jjfMtPJbqMP5>Yk%&\\1dE4 Yn\$<U]Ӊ1mbֶ^\"NVppeMWܢ\\)\n \nf7\n2r8=Ek7tV7PLa6v@'6ij&>;`a	\0pڨ(J)\\nĬm\02eqJPtfj\"[\0X,<\\+md~s%omn),ׄԇ\r48\rmEH]HWM0D߀~ˁKE}|f^\r>-z]2sxDd[stS\0Qf-K`twT9Z	\nB9 Nb<BI5ooJpJNd\rhލ2\"xHCݍ:9Yn16zr+z\\m T @Y2lQ<2O+%.Ӄh0AZ2R1/hH\rXaNB& M@[xʮ8&LV͜v*jۚGH\\ٮ	&s\0Q\\\"b	\rBsw	BN`7Co(\nè19*E SU0U t'|m?h[\$.#5	 	pyB@R]@|{P\0x/ w%EsBdCU~O׷P@X]Z31{eLYڐ\\(*R`	\nQCF*霬pX|`N\$[@UZ`Zd\"\\\")I:toD\0[-g*`hu%,I7īHm6}Nͳ\$MUYf&1e]pzImG/ w !\\#54IdEhqѬkx|kqDbz?>:[LƬZX:jw5	Y0 \$\0CdSg{@\n`	C M# t}xN{۰)CFKZj\0PFYBpFk0<>D<JEg\r.28U@*5fkJD4TDU76/@K+J@=WIOD85MN\$R\05\r_EIϳNly\\qUQ\n@ۺpP۱7ԽN\rR{*qm\$\0RԓqÈ+U@BOf*CˬMC`_ ˵NT5٦C׻ \\We&_X_؍hB3%FW|Gޛ'[łV#^\rGRPFgYi z\n+^/\\6bdmh@qAh),JWcmem]ӏekZb0Y]ymfeB;OwapDW{\0-2/bNsֽ޾RaϮh&qt\n\"iRmhzeFS7PP䖤:BsmY d7}3?*tlT}~=c	3;TL5*	~#Asx-7f5`#\"NbG@e[s-M6qq he5\0Ң*bISFή9}p-`{ɖkP0T<Z90<՚\r;!g\r\nK\n\0*\nb7(_@,e2\r]K+\0p C\\Ѣ,0^MЧ@;X\r?\$\rj+/BPJ{\"a6䉜|\n\0\\5	156 .[Uد\0d8Y:!=X.uC!SopB7ůRh\\hE=y:< :u280siTsB@\$ @u	Q.T0M\\/d+ƃ\n=dA)\r@@h38.eZa|.7Ykc'D#Y@Xq=M44B AMdU\"Hw4(>8C?e_`X:A9øpGGy6FXrl1ػBÅ9RzhB{\0^-0%D5F\"\"i`nAf \"tDZ\"_V\$!/Dᚆ٦̀F,25jTy\0Nx\rYl#Eq\nB2\n64!/\nQ*;)bRZ0\0CDo˞48e\nS%\\PIk(0u/G\\}4FpG_G?)got[v\0?b;`(یNS)\nx=+@7j0,1Åz>0GcLVX%Q+oFܶ>Q-clwz5G@(hcHr?Nb@lx3U`rwUt8=l#l䨉8E\"O6\n1e`\\hKfV/зPaYKO x	Ojr7F;B̒>ЦV\rĖ|'Jz#PBY5\0NC^\n~LrR[̟RìgeZ\0x^i<Q/)%@ʐfBHf{%P\"\"@)DE(iM2S*yS\"e̒1ט\n4`ʩ>Q*ynTu~%+WXKQ[ʔlPYy#D٬D<FL@6']Ƌ\rF`!%\n0c˩%c8WrpG.TDoUL2*|\$:Xt5XYIp# ^\n:#D@1\r*K7@D\0CCxBhEnK,1\"*y[#!יٙl_/x\05Z4\0005Jh\"2%Yaa1SO4%niPߴq_ʽ6~I\\ddD3g^@^6_HD.ksL@ɈnI~\rb@ӀNt\0s]:uXb@^1\02?T6dLNe+\0:Ёlz6q=̺xN6O,%@s0\n\\)L<C|PbA>I\"	^K4gIXi@PjE&/1@f	Nx0coaߧ,C'y#6F@РH0{z3t|cXMJ.*B)ZDQ\0T-vXa*,*<b#xјdPKG8 yK	\\#=)gȑh&8])C\nô9zW\\gM 7!,9\$T\",%.F!˚ A--g\0002R>KE'U_I9˼j(Q@@4/7'J.RT\0]KSDAp5\rH0!´e	d@Rҝิ9S;7HBbxJ_viU`@SAMXGXiU*':VWJvDN'\$zh\$d_yZ]Y8ؔ]P*h֧e;pe\$kw*7NDTx_ԧGi&PԆt͆b\\EH\$iE\"cr0l?>C(W@322aI{B`ڳiŸGo^6E\rGMp1iIX\00032Kzl&ֆ'IL\\\"7>j(>jFG_& 10IA31=h q\0Fķ_JԳVΖ܆q՚	(/dOC_sm<gx\0\"\n@EkH\0J8(km[S4\nY40+L\n#Bӫb%R֖׭R:<\$!ۥr;	%|ʨ(|H\0]cҡ=0Z\"\"=X)fN6V}F=[ৢhu-\0tbW~QiJL5׭q#kbWnQT!encS[+ִE<-a]ŃYb\n\nJ~|JɃ8 Lpo NܨJ.ŃS2c9jy-`a\0*ֈ@\0+mg61Me\0Q _}!IGLf)Xo,Shx\0000\"h+LM јZ	j\0/\$>u*Z9Ze+JtzRKԯDyq0C-fmBI|HBsQlX.|c[ZhZlx@'mlKrQ26]ҷnd[񎩇d\"GJ9uBoZߖan@nlW|*gX\nn2F|x`DkuPP!Q\rr`W/	1[-o,71bUsN7Gq.\\Q\"CCT\"*?uts]٩Pz[[YFϹFD3\"]u۝)wz:#Iiwpɛ{o0n;\\x\0qm&~79[HqdLO2v|Bt\\ƤHdH\" N\n\0GgFF}\"&QEK{}\ryǎrכt7Nuó[Agh;S.Ҡ¥|y[Ն_bȨ!+RZX@0NP%jD¯z	[U\"{e8>EL4Jн07 d Q^`0`]c<g@hy8p.ef\nehaXmSjBژQ\"\rK3=>ǪAX[,,\"'<%aӴ.\$\0%\0sVpM\$@j>}Ve\$@̈́#(3:`UYu@V#EG/XD\$havxS\"]k18aя9dJROӊs`EJUom{lB8(\n}eib, ;N͇Q\\ǸI5yR\$!>\\ʉguj*?nM޲h\r%U(dNd#}pA:-\\A*42I\r֣ 0h@\\Ե83rq]d8\"Qƙ:cy4	ᑚdaΠ6>UA:@2\$eh2FəN+\rԀ(Ard*\0[#cj>!(SLeTM	9\0W:BD3J_@srue +'B}\"B\"z2rlxF[L˲Ea9cdb^,UC=/2/\$C#8}D6`^;6B0U7_=	,1j1V[.	H9(1ҏLzC	\$.Afh㖫DrY	He~or19م\\߄P)\"Q,eLw0\0;wXǝqo~>9>}dc\0gfq&9-J#3^4m/\0\0006n8>䈴.ӗcph_A@[7|9\$pMh>5KE=hAt^V	\"	cB;iQҠt@,\n)s`;4Iy-0yeʨUBv3HPG5s|\r\$01l3(*oF~PK.,'J/Ӳtd:n\njYz(wZ#Z	Io@1λ\$=VWz	nBaAq@Ip	@5ӖlH{UoXfӿ\\z.,-\\ڗ^y n^BqzX㉡\$*J72D4.!M0DFGLmc*mcI5Ɍ^tjl7替SQ.ihLڱB6Ԅh&Jl\\Wecf%kj pR=i@.(2klHUW\"ojp!S5pL'`\0O *Q3XlJ\08\n\r*a떞r`<&XBh8!x&Bht\$]n߆cL[Ƶd<`\0ςawO%;BCQ\r̭pPQZZAu=N&ia\nmK6I}n	t\nd)bp\"g'07u&@78XNx\$BZB/MgBiѧ\\mmIĀ;5=#&4PՍqA\\,qcޟ\ncBw\0BgjD@;=0mk\rĲ`'5k-{\0_Mu2׆q>)9W\nd+ԧG\rn4O:581:Κ?(yGgWK\r7m5.eHhJAk#L..\\=UЄ:>7W+^yDbGOZ4r(|xPr,y8qaܩO2kn#p2ǈؔ.cUcłj\$8Ĭ~7ZR:׆89Ψw(aL%-,쿌#f%8|c%XW\n}6H˞#&J,'zMMຑ܆ /y6YQںdәd:Ep2gg/,Ո'8^;UWN{OCziKXڔNdGRCJYiy#>zSMUcRORԾ0)0]:=Ϟt'\$srF67	=\$B!qs	1\"v%Il<b!ۮ6(Cd-^<H`~2KzKٜԱy,qA*\0}Cpb\\S5'(|MW5;\$5T|;kt@;9);i.;_F=DM`H\0	 N @%wdPb\$H|k[dCI!:l,<utNeϝW^w'6Dfu ihIZ:~ϣrz3+uoCs2buaXwWK	HԶ27>WyMJrpTL|`f:Atd|i[wjW 7aueA5Q' ʐ\03Ҿ\$\rk)a;H=֐~IGI<\"I1'蠙Gcm\0P\nw#>xB\"Em|2\$}<3PYXgod߶<qE\"`4g8r]\n:qVbTm9K&ғĤm7)@Qz=ߵűH\n}Oi}\r٣.vpJW&u550	5PI\nl\0O5*=	P-H\0f%tぺ*S:tϛ?ȂHq4K@Ԭ܂.O(Z\$]onzA!t85<WR2[8n5\$I浕Z]'}ET\n.&7V@_Do&J64ij\$ELut+IТأ~SSZTXPYz\"\$V_]M(7t_S/tĂmH:\05- _Z'#1P,}(~\0!Җ`-P\ney (`9O!;5\n\${UA7![ YF濴>8&!CLH(\0'Ǐ2d\r%;k抐4_O>5@DҼ\0VA6' AYSrԾ4+h@bOM\0r̛@\rJm0\08O;kӠA(6|	`8 \0&EV\0VwkNKxdpsALAXku\0t Ԣ.>(NK'fldA?++N~kPR\0xʑBK]bU\\̛d\0S@Q͉b\0\0b\0_\\@\nNOAPfԏAj M4<9+`S w3T7XT!\0ePAIb 1!\04' @!8\0/!:K,CASXfeM.::t._d81v`B\"!.^*N.^\n&\r(.O0@Pnjڗ#&rH< !3(i @Aa{ ¬#S6𨘶F@Y[O(./B)L02B؈-ƀqpJ<.Б\0\n\0/@8C4P\r	P)F\$q.]\"B#	#\\84\$s:.(*Oi>|#T'`Bua/CTKaX8`p\0`\0");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0P	sn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E <L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJk7*O .ġ\r\$#pWT>!v|}נ.%,;f*?焘\0pD! #:MRcB/06	7@\0VvghZ\nR\"@F	+ʚEI\n8&2bXPĬͤ=h[+ʉ\r:F\0:*\r}#!\"c;hŦ/0ޒEj]Z\0@iW_h;VRbP%!b]SBUl	r\r-\0\"Q=Ih	 FLFxRэ@\0*j5k\00'	@ElOHCx@\"G41`ϼP(G91\0\"f:Qʍ@`'>7ȎdR41>rIHGt\nRH	bҏ71fh)D8B`(V<Q8c? 2E4j\09\r͐@\0'FD,!H=*E(?Ѫ&xd_HǢE6~uG\0RXZ~P'U=@l+A\nhIiƔPGZ`\$P.;E\0} Q%jAWإ\$!3r1 {Ӊ%i=IfK!e\$80!h#\\HF|i8tl\$lli*(GL	 \$x.q\"Wzs{8d`&W\0&E15jWbćVR-#{\0Xig*7VF3`妏p@#7	0[Ү[éh˖\\o{T]Ŧᑀ8l`f@reh\nW2*@\0`K(L̷\0vT\0c'L: 0@L1T0bhW|\\-DN\ns3\"`Ǣ肒2&\rU+^ReSni0u˚b	J2sps^n<♱Fla\0\0mA2`|؟6	nr\0Dټ7&mߧ-)\\݌\n=;*b蓈Ty7c|o/:tP<Y:K&C'G/@Q*8v/&W6p.\0u3Bq:(eOPp	駲\r0(ac>N|	t\n6v_e;y6fgQ;yβ[S	gǰOuddHH=Z\r'qC*)gEO \"!k('`\nkhT*s5REa\n#!1\0;Siȼ@(lI v\rnj~63ΈI:h\n.2pl9Bt0\$bp+ǀ*tJsJQ8;4P(ҧѶ!.Ppk@)65!(\n+{`=H,Ɂ\\Ѵ4\"[C1-luo4[E%\"w] ( ʏTe)KAE={ \n`;?-G5I.%q%EsgFs	KGn4i/,i0ux)73SzgV[hDp'L<TMjP*o≴\nH\n4M-WNA/@8mHRptpV=h*0	1;\0uGT6@s\0)6ƣT\\(\"U,C:5iKlۧE*\"r.@jRJQ/L@SZP)(jjJL*\0\r-Q*Qڜg9~P@H\n-e\0Qw%^ ET< 2H@޴e\0 e#;ITl+A+C*Yh/D\\!鬚8»3AЙEE/}0tJ|1Qmn%(p!\n±U)\rsEX5u%B- w]*E)<+qyV@mFH BN#]YQ1:V#\$<&Xxt@]GԶj)-@qL\ncIY?qC\rv(@X\0Ov<R3XQJ99lxCuīd vTZkl\rJ\\o&?o6Eq\r'3ɪJ6'Y@6FZ50VTyC`\0VS!&66rDf`ꛨJvqzF@ݵ҅Z.\$kXkJ\\\"\"֝i:E\roX\0>PPmi]\0aV=I6jK3ZQmEb0:32V4N6!l^ڦ@hhU>:	E>j0g\\|Sh7yބ\$,5aė7&:[WX4q Jׂc8!HVDĎ+D:9,DUa!X\$ЯڋG܌Bt9-+otL}ĭqKx6&%xtR\"πRIWA`c}l6~*0vkp68z+qXw*EIN*qPKFO\0,(|k *YF5;<6@QU\"\rbOAXÎvv)Ho`STpbj1+ŋe ʀQx8@5\\Q,ĉNޘb#YHp1kB8NoX3,#Uک'\"销eeH#zq^rG[:\rmng5V]-(W0~kh\\Z`lk ojW!.hF[tAweM૫3!nK_SFj-S[r̀w0^hf-?X5/IY V7ad 8bqbn\n1YRvT,+!NT2I߷K`K\"O)\nY4!}K^D@na\$@ \$Aj\\D[=	bHpSOAGho!F@lU`Xn\$\\͈_˘`HB]2\"z0i1\\w.fy޻K) p0XS>1	*,]\r\"<cQ\$tq.	<+t,]L!{gX\$6v %GHEX*0ۊ)qnC)I\"툳`KF@d5Ap{\\pɾNr'S(+5Њ+\"ĀU0iː!nMbrK6úr|a@x|ka9WR4\"?5pۓkrĘߒ7Hp5YpWG#rʶAWD+`=\"}@H\\pЀߋ)C3!sO:)_F/\r4<A\nn/T3f7P16OYлϲq;؁aXtS<9nwsx@1Ξxs?3Ş@54oȃ0pR\0yqL&S^:Q>\\4OInZnv33+PL(.x\$«CCnAkc:L6rwhnrZ==jђ6}MGu~3bg4s6sQ#:3g~v3<+<a}ϧ=e8'n)ӞcCz4L=h{iJ^~wgDjL^=6ΧNӔ\\DNE?h:S*>+uhh҅WE1jxt't[wS9T[,jvtA#T枂9jK-ޠYiQe?4Ӟ_Wz@JkWYhpuj|z4	im	O5\0>|9ז轠gVyu=}gs_Vsծ{k@r^(wH'a=iN4_{6tϨϗe[h-Ul?J0O\0^Hl\0.Zxu\"<	/7 i:\nǠ;!3_0`\0H`2\0H#h[P<עgm@~(\0ߵkYv#>\nz\n@Q\n(G\n'k5n5ۨ@_`Ї_l1wpPw\0coEl{ݾ7o0Ibϝnz﷛ {8w=|/y3a߼#xq@ka!\08dmR[wvǋRGp8v\$Zmtǽuop`2m|;#xmn~;VE3O\r,~ow[N} clyO;?~^j\"Wz:'xW.	u(Ýq<gvhWq\\;ߟ8)M\\5vڷx=hib-|bpyDЕHh\rcey7pxG@D= 1!4Ra\r9!\0'Y@>iS>oofsO 9.\"Fl20E!QːD9dBW4\0y`RoF>Fa00	2<IP'\\I\0\$\n RaU.sЄ\"1ІeY砢Zq1|#G!PP\0|HFnp>W:`YP%ď\na8P>`]4`<r\0Îz484`mh:ΪHDj+p>*8ՠ08A:с]wúz>9\n+:iiPoG01)ZږneR֖gMgsLCr8Ѐ!3R)00sIJVPpK\n|9e[ˑD0z4ϑo,N8ns#{蓷z3>BS\";e5VD0[\$7z0=8	T 3Q'RnLyŋ'\0o,\0:[}(|X>xvqW?tBE1wG;!݋5΀|0JI@#uņI\\p8!']߮l-lSB,ӗ]1ԕHN8%%	/;FGSh\\لct2|W\$t<hO+#BaN1{yw2\\Z&)db',Xxm~H@:d	>=-lK܏J\0́@rϥ@\"(AZ7h>\\#>\0XrYYxŝq=:Թ\rlomgbD_TxC0.yR]_ZǻWIG	Mɪ(|@\0SOs {@k}FXSb8=_l\0=g{HyG s_J\$hkFqd4ω'>vϏ!_7Vq@1zuSejKdyuS.2\"{K?s˦hRd`:yGھ\nQow'hS>LX}eG@9퟈W|Ϲ@_uZ=,!}\0I@#\"'Y`\\?p,Gל_'G	T#oH\r\"o}?O鼔7|'=8MQyaH?߮ \0bUd67I O\"-2_0\r?hO׿t\0\0002~° 4K,oh	Pcz`@\"H; ,='S.bSCc욌R,~X@ '8Z0&(np<pȣ32(.@R3@^\r+@,\$	ϟEtB,⪀ʰh\r><6]#;C.Ҏ8P3;@L,+>p(#-f1z,8ߠƐP:9R۳)e\0ڢR!\nr{eGA@*nD6N\rR8QK0颽>PNIQ=r<;&fNGJ;UAAP&`);!s\0pp\rn(@%&	SdYuC,8O#oRv,#|7\"CpB`jX3~R@v9B#@\n0>T-5/= E\nd\"!;p*nZ\08/jX\r>F	Pϐe>OLO0\0)k㦃[	ϳ'L	1 1\0C1T`RʐzĚp< .>5\0> Bnˊ<\"he>кîs!H{ܐ!\r\r\"|>R1d\"U@D63>o\rvL:K2+0쾁>\0 B{!r*Hy;`8\0دd\r02A?+\0Å\0AwSl\r[ԡ6co=0z/J+ꆌW[~C0e30HQPDPY}4#YDp)	|@&-/F	T	aH5#H.A>0;.Yġ	*D2=3	pBnuDw\n!zCQ \0HQ4D*7\0J%ıpuD(O=!>u,71TM+31:\"PRQ?P+11= M\$ZlT7,Nq%E!S2&U*>GDS&ozh8881\\:Z0hT C+#ʱA%D!\0XDA3\0!\\#h9bT!dYj2S\nA+ͽHwD`(AB*+%EX.ˠB#ȿ&XeEo\"|r8W2@8Da|NhJ8[۳Wz{Z\"L\0\0Ȇ8x۶X@ Eh;af1;nhZ3E0| 옑AtB,~W8^Ǡ׃<2/	8+۔O+%P#ή\n?߉?e˔O\\]7(#D۾(!c)NMFE#DXg)0A\0:rB``  QH>!\rB\0V%ceHFHm2B2I`#D>n\n:L9C0\0x(ޏ(\nL\"G\n@`[\ni'\0)y)&(p\0N	\"N:8.\r!'4|ל~ʀ\"cDlt0c5kQQר+ZGk!Fc4Rx@&>z=\$(?(\n쀨>	ҵCqیt-}G,tGW xqHfb\0\0zT9zwЅDmn'ccbH\0z3! HHz׀Iy\",-\0\"<2'#H`d-#cljĞ`i(_dgȎǂ*j\r\0> 662kj<Cq9ĐI\r\$CAI\$x\rH78 ܀ZpZrR_U\0l\rIRXi\0<r~xS%^%j@^T33ɀGHz&\$(q\0f&8+\rɗ%2hCxIlbɀ(hSY&B`fxvn.L+/\"=I0d\$47rA(42gJ(D=F(-'ĠXG29Z=,r`);x\"8;>&',@2pl:0lI\rrJDhAz22p`O2h8HĄwtBFg`72{,Kl߰%C%om+X41򹸎\n2p	ZB!=VܨȀ+H6*\0k%< K',3rI;8\0Z+Eܭ`+lW+Yҵ-tfbQ_-Ӏޅ+ 95LjJ.Gʩ,\\ԅ.\$2J\\-1-cˇ.lfxBqK,dˀ8AKo-3Kr/|/\\r,HϤ!Y10@.&|+J\00P3J-ZQ	\r&\nL*jĉ|#Ծ\"˺A/8)1#7\$\"6\n>\n7L1h9\0BZd#b:\0+A22'̕\nt̜O2lʳ.LHC\02+L\\rKk+˳.ꌒ;(Dƀ1sds9P4쌜@.AnhJ13K03J\$\02Lk3Q;3n\0\0,sI@u/VA1UM<Le4D2V% Ap\nȬ235A-Tu53۹1+fL~\n	-> ҡM4XLSdٲ͟*\\@ͨYkSDM5 XfDsUs%	̱p+K6/ݒ8Xނ=K6pH%3ͫ7lIK0LDu`P\rSO͙&(;L@ψN>S28(`JErF	2SEMM\$qE\$ã/I\$\\ID\"\n䱺w.tS	ђP#\nW-\0Cҵ:jR^S8;d`5ԪaʖE+(XrM;3;B,*1&2XS)< L9;RSNgIs+ӰK<sLY-Z:A<OO*2vW7+|˻<T9hy\$<#ρ;v\$O\0 ,Hk-Ϛ\rϣ;O>7>3@O{.4pO?Tb..~O4S>1SS*4Pȣ>3\0W>2><P?4@t\nNAxp%=P@C@R˟?x\n0NwO?TJC@#	.dMt&=\\4A:L\$N:\rI'Arግ;\r/CBӮi>L7:9|C\$)z@tl:>C\nBi0G,\0FD%p)o\0\n>`)QZIKG%M\0#\0DQ.H'\$E\n \$ܐ%4ID3o:L\$m 0	B\\(8通hDCsDX4TK{x`\n,\nE:p\n'>o\0tI` -\0D/KP`/H\$\n=>UFP0UG}4B\$?E%TWD} *H0T\0t\"!o\0E7R.tfRFu!ԐD\n\0F-4VQH%40uN\0DQRuE	)I\n&Qm)ǚm #\\D(\$̓x4WFM&ԜR5H%q[F+IF \nTR3DLoy4TQ/E[ў<t^F)Q+4QI#IF'TiѪX!ѱF*nR>5pKm+sIRE+ԩM\0(R?+HҀJ\"TD\$	4wQ}Tz\0G8|xR6R	4XR6\n4ymNQNM&RH&2Q/7#қ{'ҍ,|\n	.\0>{o#1D;?UҕJ9*jFNщJ #~%-?CL3@EP{`>QȔ%O)4R%I@%,\"I<\$ԉTP>\n\0QP5DkOFTY<oQ=T\0x	5D,0?i?x  mE}>|[\0&RLHS9GI1䀖M4VHoT-S)QGF [TQRjN#x]N(U8\nuU\n?5,TmԞ??@U\nu-R9U/S \nU3IEStQYJu.QFo\$&i	KPC6>5G\0uRu)U'R0ЀDuIUJ@	:V8*Rf%&\\RMU9RfUAU[TUQSe[\0KeZUaUhmS<,Rs`&Tj@G!\\x^0>\0&p΂QQ)TUPs@%\0W	`\$(1Q?\$CQp\nOJX#V7Xu;!YBSc+V#MUWHURǅU-+VmY}\\OKM\$SeToVHT!!<{RZA5R!=3U({@*Ratz\0)QP5H؏հN5+P[9V%\"\nGSL9l\rVؤ[ouUIYR_TYp5O֧\\q`U[Bu'Uw\\mRUԭ\\Es5K\\V\\S{AZ%O\$F>5EWVm`Wd]& \$Ό!RZ}ԅ]}v5ZUgQ^y` !^=FR^vUKex@+r5#@?=uΓsץYNsS!^c5\$.u`\0XE~19JUZ@#1_[4J2\n\$VI4n\0?4aR!U~)&B>tRI0_EkTUS|Uk_8&E(‘?@J5JUBQT}HVjQx\neVsU=VN4ղؗ\\xR34GD\":	KQ>[\rY_#!#][j<6خX	c#KL}>`'\05XcU[\0(Wt|tR]p/]H2IQO1SQjZHm)d^SXCY\rtu@Jp%M?UQ\n=Rar:ԿE-G\0\$d]meh*QWtc`AY=S\r	m-=MwH]J\"䴏f\"{#9TeMcNIDU6g2ݝeaLQ&&uTX51Y>S֊Q#Ij\0WP?ub5FULn)V5R@\$!%oP'EUP-Bp\nF\$S4tUF|{qȓ0Umjs\$ڛjcڐ֫aZI5Xj26&>v\n\r)2_kGTJeQ-cZVMֽz>]acc`tHj6+kM\0>##3l='^6\0èvZ9Se\"bΡB>)/T=9\0`P\$\0]/0ڪ䵏k-6{k[F\r|SѿJMQD=/WXVa'atol冶Xj}C@\"KPom3\0#HVv~{?gx	n|[?U[rhG`3#Gk%L\0I`CD	 \"\0ŧ#cN6ڹfzێ;ѤeeF7/N\r:QG9	\$Iռ]TWGsdWMIfBcۤ!#cnu&(S_wSf&TZ:0CSLN`ܳYj=>ŲZ!=rV]g	ӣrXl-.U'uJuJ\0sJ'W%\\>?BVj4J}I/-ҝrRLS3\0,RgqӭTf>1\0_\\V8Ztc耆<^\\llj\0T]CwΓzIZwNpVWjvY>2	o\$|UWL%{toX3_RJ5~6\"Zl}`kceR=^UԎ1ѽw7edvb=\0f,m)Gp-Ӽ)9L>| \"@5`:\0,t@xlJb6aA\0ػAR[A0\$qoAS@<@y\"as.V^讥^\0H[H@bK)z\r=^zB\0No<̇t<x\0ڬ0*RI{^E:{KՐ1E0Y/c\"\04F7'\n0`UT?MPl4r(	Z|&t\"ILw+m}Wi\r>U__u63y[8T-V}x_~%7{jMo_E~]P\$JCaXG9\0007Ń5A#\0.\r˴_%\n\r#<MxJ|2\0;o^a+F笀Lk;_#M\\pr@õOR~zANEYO	(1N׉R8Cn?O)1ADo\0\rǢ?kJ\",OFa-b6]PS)ƙ5xC=@jLL:\"胻Ίl#Bk@N:>|B9	:N\$S CB:j6ΉJkuK_W͢ØI=@Tv\n0^o\\Ӡ?/&u._\rC+c~Jb6e\0yѡ\0wxh8j%SVH@N'\\ۯN`n\runKqUB+f>G\r=@Gd\n)FO hʷÈfCɅX|I]3auyUi^9y\no^rt\r8͇#N	VY;c*%V<#h9r\rxcv(\ra(xja`g0V̼Qx(glհ{gh`sW<Kj';)Gnq\$p+Ɍ_d^& Dx!bv!EjPV'(=b\r\"bL\0bt\n>J1;ۈ4^sQp`fr`7xE<l	8s'PTֺ˃z_T[>:`1.;7@[>6!*\$`\0`,@?m>>\0LCǸRn/+`;C\0*<F+q M;1K\n:b3j1l:c>Yhގ#;3ֺ85:\\\0XHaM1\\L[YCvN\0+\0t#\$!@*l	FdhdF&Ƙf)=04x\0004ED6K䢣\0nN];q4sj-=-8\0sǨDf5p4J^'Ӕ[H^NR FKwz EgF|!codbx\0-6,E_3up /wz(exRaHYce59d\00@2@ҐYfeyYcMוh[ez\rv\\0e\\cʃ[ueNY`ۖ]9h姗~^Yqe]qe_|6!u`fJ{7M{YهjeCS6\0DuasFL}\$ȇ(MbƤ,0Buίт2gxFљ{an:i\rPjerrGBYM+qiYd˙`0,>6fo0o Xf\0VL!fl6 /1e\0>kbf\r!uf<%(r˛a&	Y!mBg=@\r; \r5phI9bm\$BYˋgx#@QEOm90\"!tˉЇO* \0>%\$orN&s9f4g~jMfwygy\\`X1y5x^z_,& k|1xA6 \no蔻&xgg{r?緛-|t3}gHgK9J<CC197gh6!0HcdyfDA;9T0\0p! 6^.S²?E(PΈ .5hEPJv.+\$5>P+?~g6\rhpz(W`\"y:FadŬ6:fi\0A;e^wf >y`-\r\0hr\rr8i\"_	9CIfXˈ2\"ŢhL~\"%V:!%xyizygvx]}qgZi|`+ _g٣譞6PAʀ\$=9h|p!.!i^iˢ8zVCZ\"(9U)!DgU\0j?`4LTo@BNa{r:\n̟E8æ&=E*Z:\n?g̊h.N5(Shi2*cf@7z\"|rP.ǀL8T'k:(q2&ED2~ر9v8@^X=X`qZQ֮`9j5^@竸nqv3(I6jdT\\ 3,hk3(3PuV|\0阮Uk;JQ.	:J\r1nBI\r\0ɬh@?N\nsh\";r~7O\$(5R	ʽjFYFܔ~x޾f\"vۓo˨º#aP<h-3麝/Gxni@\"G?,ZpxX`v4X[I7åXc	!b}j_95qti6fٞ5FƹiѱpX'2r0ƺD,#GU2؏I\rl( 챣=Aa쩳-8dbS4~H;06b{޺Rs3zNބ`ˆ+4<^ay	}ryk&4@?~cE@LS@z^qqN</Hj^sC`sbgGy^\nN\n:GN}c\n +=p1NTB[dЋܹ`noj;jěwhc9p̡[y405͋N+ο`Xda/zn*P#t赸~9W	V~=#n)	2;j:JkC!>x5==2.|'[';v;:SA	&[men˵<6ma=Y.神:g腀;I߻x[IJ\0~zaYwT\\`V\n~P)zJQ@[{rʉDBv|i-EK;^n{:Nh;2ƀpѴ6罘99XhQ~iA@D j}ozLVѳ~	8B?#F}FTdezcFg7Η 6#.E££S.J35KɥJ;n5:ySCvoս.{	d\\0?W\0!)'Eg;+\0YNtbp+c\0B=\"cT:BcPIDV0!ROlON~aF|%ߺ)O	WoQw:ٟl0h@:օ8Q&[nFp,æ@JTw9(<{ƐO\r	ڂ\$m/HnP\$o^U\"{Ė<.nq8\r\0;n硟+޳3n{D\$7,Ez7\0l!{8x҂.s8PAFxrQۮ1̅p+@d9OP5lK/\\msqvQ/	!z7oEǆ:qV5?GHOO\$l+,\r;~Ač錳{`7|Ăr'Ji\rc+|#+<&қ<W,>^P&nJhe%dCizXA'D>ΈEk@Bw(.\n99AhNckNd`p`%2\0");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$q=file_open_lock(get_temp_dir()."/adminer.version");if($q)file_write_unlock($q,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$c,$g,$l,$Kb,$Rb,$bc,$m,$Gc,$Lc,$ba,$dd,$y,$a,$vd,$re,$We,$mg,$Qc,$T,$Ug,$ah,$hh,$fa;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Me=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Me[]=true;call_user_func_array('session_set_cookie_params',$Me);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$wc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$vd=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$a;return$a;}function
lang($v,$ie=null){if(is_string($v)){$Ze=array_search($v,get_translations("en"));if($Ze!==false)$v=$Ze;}global$a,$Ug;$Tg=($Ug[$v]?$Ug[$v]:$v);if(is_array($Tg)){$Ze=($ie==1?0:($a=='cs'||$a=='sk'?($ie&&$ie<5?1:2):($a=='fr'?(!$ie?0:1):($a=='pl'?($ie%10>1&&$ie%10<5&&$ie/10%10!=1?1:2):($a=='sl'?($ie%100==1?0:($ie%100==2?1:($ie%100==3||$ie%100==4?2:3))):($a=='lt'?($ie%10==1&&$ie%100!=11?0:($ie%10>1&&$ie/10%10!=1?1:2)):($a=='bs'||$a=='ru'||$a=='sr'||$a=='uk'?($ie%10==1&&$ie%100!=11?0:($ie%10>1&&$ie%10<5&&$ie/10%10!=1?1:2)):1)))))));$Tg=$Tg[$Ze];}$ta=func_get_args();array_shift($ta);$Cc=str_replace("%d","%s",$Tg);if($Cc!=$Tg)$ta[0]=format_number($ie);return
vsprintf($Cc,$ta);}function
switch_lang(){global$a,$vd;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$vd,$a,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$a="en";if(isset($vd[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$a=$_COOKIE["adminer_lang"];}elseif(isset($vd[$_SESSION["lang"]]))$a=$_SESSION["lang"];else{$ka=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Jd,PREG_SET_ORDER);foreach($Jd
as$C)$ka[$C[1]]=(isset($C[3])?$C[3]:1);arsort($ka);foreach($ka
as$z=>$H){if(isset($vd[$z])){$a=$z;break;}$z=preg_replace('~-.*~','',$z);if(!isset($ka[$z])&&isset($vd[$z])){$a=$z;break;}}}$Ug=$_SESSION["translations"];if($_SESSION["translations_version"]!=1579331192){$Ug=array();$_SESSION["translations_version"]=1579331192;}function
get_translations($ud){switch($ud){case"en":$f="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3Q/ӗJ6g2qs_foE2<B6k@ZΦ#ƤnEcЂ>`@\$cB3:x߻8xJ\0|63,bׇx481Dc:CΎA&2,.(N'N78cC:EB6%Ш<\r=\$6-\n:ƀӫˌ3#94N)\0#t403WaAc@#пU2)0XIkl*8\00030[T6431@&\ru8>#}2m48C{C4 W>Ws2Y(	/˂\\b /d\"'~,r)s([3\\E\n%C˥z:PA,873B7B\rA Cx3\rJP *\r7(5BhU@OwjI~GF5!1ܐˎ[K06 gU%Ҥ:.hAGT/M8ŌT_qoc{2!Ȫ:)+`}Xl-˯mbJ2EH7N	S8l㇤\\[QmGQ}ޅk_&I؟^X>em2HL\rd𦩐R<O8׹\") VY\"\\e A s=\$0e[hsq\rDe\n=+ҫL1,~̈`qB@Pzu@\n\n\0)\$Dg \r(RA߫wLfi2d\\ʒO&\$魇b~'Č9t.aR\n>#os<@C4q<:@R\\7U\$*g!)I+%3֣&4pOz&.ZzD!.9TM&̨CLC'd16	G2ur1BxS\n0MST8̖91u%KV45es\$l1N82d#HlMO43MxCJ%q2'@BD!P\"j E	)&Ma='AT\nA[kv5\$879W\rQG;\0*{'lLGо5L\0 cdɅ0CMb8\n\n\nˈtt0H0a3b6y\0H+lfǓ4\$YɯI~'Z,S}ą9P/ST4Qh k@)P훿bmJ=-*x-YqʞSkV*rҩ`cM@>liIAa M/d\\1	Pvkx5C\0^00%Mz	}S{DqA~m%?DA%0`Wsg6Jw;'c^&\r8C&~ˮToUL-#Ģ9D[XAl=AgIA\\2,򂉼PIZѕ^FC2;%&C	f;CY(C画^01dr#I&(IjG,QnNsZZ켔vK^ZSudbY6*%栓kJr/&VBY/=D66/Ի1{d-}fvE<)u3Qm; պ\nKuNa5lM]\rn7VTsoᚳRli`#|St-JD~Cɑ5&G͍	劁m'NoF#J 4R}?Q}V~=޺5ZC2vm1RM*F>f]LVmd\n]-bQ)*zVS=*w^EeJjycM΍\\t(W#W^#Lܿg*HW3@>\0S} A_,΂&k=,>r[̉Ir+}xnJ)(\"wp4.mlOnc\" +VEAN\rb0/d%N&t\0lf/\nyO#8%an%\0=>/7SJ4+\$΂0#pЦ,C_	t;\"2.\"	päPzq\nt-nR\$\rV`D6b0l\r m\"(lI,\0\npe\\.JB®rLՊ6/\"fT3JVCN	V\r,/0v)jɄ.AFfJ)财@Z:(*,Dbp \"Mf@ξM1.qKi|5Q}q6\$'mƆckoXͫ4\0e` `@4X0B%Kl@\"vR%VHldVfHN*rP,/-t_\0c)fZ?MI*L(R";break;case"ar":$f="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\r㒞B+\\cY*+\"	)\"XؐeJT*IPFt\"et~&M# @\07M0:#m1C38CҎKz˭L9H4C(C@:t2tA#8^2x9ΣJ`|6-+3A#kt4px!򞐖&m?2XnjP<+!u11ڂHn\"@P0CtƎ\$^#%|\"e͖\$Y\\ERR<:0knB,BةZժjlkR<J#XZjY<ؽl<HƖiKk/#`ch50к@d(@)\"bԇYn1dFVf6>\r!o1lkȦmEڼyddy=sdyZ>l;s ZBE,VMpWP*A0(ΩmCόv7LUH{ٕǌLv^q_P1h1C3ҍ06J+!k&%`*\rEL7!\03`\07P<C8a=@@pu7`9\nR\n9|%^cKl*\$\0l r}Ɉ2xn4D\n}OAUTZ\n@9)%(қJ }U9UjR!J'獁U3oVDAGj߂K8\$TLjj7pK4蝐(x>@\\S2P\n	B(eQ\"ԫun\"C\rP:D|`8eMpXE^\"%'!	Fp4TH M#K(Ô!k0h֖_n~M鴖l00@㬔\r,ןaH PR_\n+1}urjC@pe4C\\*ӝΓL!Y:ja6q%lVK7zSۣ!GR38UI)D:TDfj]0@DoUn)9F2aΠFTS9\r@!0 UA[IJpYA7d~OlV(V8Q0&k{h2VץGZqBP)G>G,AFr9JG:UŇJLI&})B\$FԤ7>fAH4L c~iQ.lkY\r?d{T!dEgLchX|Gũ&Jڴ~CQ^;qZ`1|rja@\$;c6FZO;IZ0T\n	7. \$6n#HiFTVrpBWŵp \n@\"p~&\\.s!v'dEQh{bؠ Pv]p#:P1Hl/qA-n⪧H%dX2jօ~2}kK*6SB+][ѧfQ.L̾Bnț#ABhσ0J9ld#g\n\$r̵QVu<JNtL[d2%M@L4@d\n`L2	Cq\"%\0*4ƹ55;\"-;l\nG\rvZlWk-\\T@tr;\\\n\\;.Q58CzBhߖn>3 E#CȽξm̨1qkvp8d`T\n!Ae0iJ^Ǉ4( (̈F(}G-x \"ˈ'׾D%'X+Nx~!OTybڋ0RS&^W^\\zyfJ#۲ҊM:?Hs\$\0ۻOqwi lv/n ;Mag9>ܾ\\O2\\2 &<KSNv[̒?9hx2?I\"hvG yb01ͺȣ9B\nCCc<<䡋uX=}V.f,D	'dM\nipŠqo?FpqOLh.OdD&ŀ]j:ƭZ2l*B(lLňW̜C0g+zvp1ˤE+\"Vpx\"\\\0Pń&/lOF͌HbB FyH\nPp㏧\nMkPoPq̤8baBOVk1)hP8=\0%Q&ݯVl)'12 DʴC\nb>/POb/e0ob#f^ȐOtCdj?Ԭd4lpάb/XDqVq,F,<L1la\"^mm;\rG!&0qoq\"\r,*!n7!Y-r&q45!\r!s0{8:rHՑI2R9E\"o\"/fiØ f2/\nEh7\0rc(A2+2\$ҌPsvf\"2C\"c(,%r&ς&ΟҨC/xߧo(tއ&G\rR'-*-,/pWJGY\nDC@*K11җ2D>k&W(R.Ec+*V16Ҭk&qmC*bEl`M\"rt.O:.DNB6`g\rV@`tL`x}@Mf\rK\n`\nptHW;Ngo	Fj#0FF3ؓ;ZN_%u*29X\0EdtL{BƦ_&`\rTLI>.Rv`-!F/c3s0+ǃ#0{{H\0-hI\n:6cD4(t\0d\$YCq8DL+2*XblsqIԅDK &Z.e\0BNې{Ls\"Q^bF'Krh .^8lf*:Oq~l|Fƹ\"悬l6\rV7s@qª]Kc~x\"a\$	\0@	t\n`";break;case"bg":$f="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9.(+z>PKƁ>B\"vi>H%(Ypܚ\$*Z@*pBb6#tPx9莎1c300c(@;#7@8P`@O@2D49Ax^;p1̱@]x7IRxDlWCL4V6H7x.1ےГ8S)K;+\"%Ixږ˳{pHKr<Y-b+#=(ȆKJ&BIF4!Jxܥ\$KV #䃶\\Ij3	5yBHh(JrA%Vr䖎76tZa%hE0FVf>QF\"4\$ҩf(?)Ax/R>ؿ7hK\\\"⛝\$,+ye> \nb9+2z\$il]ȳ<J\\]:/rFm/(hNv'sv}N4;-zdswiz<~򵩒?gB #6PpAwScA<Ef8s9˜n:	+EO3=\"H~&\$W\$%Kp\0pd6PK4!E\r%TJE]L<J#ADCNI\"ێ:+Ir~8bH./5D%΢)^%%⃣6UEt@|FIŤd`x}1%TI\"aV3*Sb@:ܟdLK8C\"gS\0M)<Tʠ;Y*xrV*2@c,YNVZ-/GсI 솔i\"7eN/#(vq䛓ɭ!WĈp\\6d)u2T*RuRRV\nZ@HDW5~ё6d8=W p&mw97g\n gmSTw^Q\\/FܩтKTPd,uC`lCQ(he`3@iFêwO!: :e(( jnXCd\n8G8I4m{^\rb=GBYH\n& (-ba1*(\rc`2%=m\r<9T(gJ=:&Czu(@'x{Xۉ@kЊlOH'AZu\rF\"Ó40 gTMC]e(e匯|J\r`'t#hqEII}Pdvn]ɚV(h)Gن<E;_SZbnk*8Eo,`}\$QxDl|SjjY/ *VRQʦ\r|F^+2(5 \n%27ĂJX),Q+*ez`Fcg`\"?;XfwGB옚w˩U˓Zɡ!*Y;#/)t2g44FnŞpY[Cߺjb\nv4R&^%ǌoRA^ofɍ\\BԏzJ0T{ljKʦ/=knҢrD+?2@X.Z'-S^B*	I[iᎣ=,7\"s(rMຆH͚s3KV9Tʝ@uG4X6Fɳ,am#1!Xd]rG!^|6F&vZ\r\\ԹϷb+9i3(qpc△vkx!tn>Ml*+n\$B0).w:J|[2؆QqHC^'\\g&_53KVb׷DX.X<NsM#8.w\\9lU-(4!*@@ !֟TݸM9'K{r('RnZ&a^0`\0|s>,*Lj`R\0<Ȋp+PdIB[r+01Cdn<p9΋\n @ǐNë\"olQД) p6D0`H&|\"ЇD&&pߣPi65,|.!</dndfm<-\"?*Z\r\r.^.H \"H0PJ#b?ҧόJBr@Bj&%Bc+f𐜈XBL_4|N,0ejco/mB!|%hR|l\"N:0p1䢍|'!G),txEffjGj(zJb~}T\n8\"6%-q#'?#Av!\$F\"fB!#7!gm|%Hu-1:#+,,P0P\0RڦI)M.2})*1*mp+VwlȒ}n+^d,W+r*QU2\"#=\"rq/,?/&PV4,fp@IS93u-1*b[SZa+Pd+#jYˏ쐎5*T-o5)\0Se&XGqw-d{.(1Pqi\$x+<\r8j~:n@l/pH<*d|,Βz90q.ҏx2)8\"8o_l%튞/K#juCݓb,+xĳ|ўu7*	6+DS'E{S'.\",~Dr8|pp648T<t􈒲tY9,?͆~7@MEHfͦ](R:arJ;7i6JB֊d%<gA/6tJNm3_8CONORJ2ލ&d+ef|U\rT^\nO4&CoKFu;P4*,zod*D2/yEUIt5Eh=T]C49<pB' %6fipfOUwGDĈÍK\$4Q	j^3u[^4cYv#K\$!GaQU@b iACpZ/8\$?	11:U,/(E\n	\rM.~hHQkkG92TMcVh_vm7n.ur+&:j@\0b:bchtj +h#_U'\r,.\"<~4@\nZ4pY1	\rVlL0CV+Ֆ|2sţUg1ruA/&^R%jP6N42`pW6?u04D1rGPZ(FkP|Krvw/b*TATRke5jTS&vtN ꑿ M-ck*r7zn{zFh@w;i6I}Tc㮤L|׽>yC[Gl.|WfA)FAv3_;OͻBJ\0Bn@Z3\$4BH\"צl%dhFD4	%8vt!/^Y[	\"4Ex6\\[Fe!/玊uq[0>x\rE\0^5Q00%N5TGĸ&u,N8";break;case"bn":$f="S)\nt]\0_ 	XD)L@4l5BQp 9\n\0,hSE0ba%. H\0.b2nDe*DM,OJÐvх\$:IKg5U4L	Nd!u>&a\\@'JxS4PDz.SE<OSkbOafhb\0Br)QWE{KPP~9\\l*_W	7ɼ 4NQ 8'cIg2O9d0<CA:#ܺ%35!nnJmk,q@ᭋ(n+L9xkI2L\0I#Vܦ#`B4: ,X2,(_)7*\npp@2C9@0F+z3Ҟ22KW5bIm*yBQ8|NK2C*S\n^SS̐ l6 x>Ä[#r`5\0#;/^=H; X(90z\r8a^H\\0յ|7x7ㅥjC ^.A7`77^0ӊP}+r\"ej}RPF4S4|0/_B:Nss%P,>.ʞ J4#]INU@B9\rBv/NN7٦tˣSFTP@SRSEqP:y5\"ª\"[6V6.~OzF0J,jAyO10j\0H4L+ԺQ8<]a	Lw)q}.k%DtU1R1nÍ\$7I\"R.rFDF)ԛJTcDg! P)#0g!#݌fOV)HsAzaSA'vLlR,Kbest`L'znGJ{5iIB|\\S1P<&q>Qz.P~ra8G8F(%JSzz#Y\r4ʅ3؏Gw\$Y{pJ	(s@rGt0f\r8\0K2(*Cpy4U|37tָtR0pkj7S\n)T	D_;X\"\"RN0*|rk&Y1bq4E`O[ˁq.E̺R9/Ք`z }@X2MaL26w0^3!ƀ=BC#r^ּ؇IUbIJ\$@Ւ~kMjJl-\n\\tuֻCrly/H#U_\$6Wt`1\n5nd45\"d%EQ d7AW\rb<9NCf\nW9beMK0;H\rXUc:qnR{!%\0ъRQ6\n]\n/QeH1\rT@-b='Ur+Uybxw%s4R7j=P);\0	X{+\rc-fw?4U Vx> 겓[h\rp@RٚK-,WF_`Yxd(\nl4WR,(ޖb0)3I2XY@шל4ID5xB;f,BLk!VHy;vb@	>Kp82n\r+YVzc]BQ(\r!7T!ϕR	KHO	Rl+ i1|Qgb=Vd\n!-پfU\\JRѾ9WUzXK\0\0f,P-j4wG8gxlb+LD6d2)6G5[!PJ;)H#dxRd`6zmᣉ[,)+	DI0҈ɪɳx\r@^IaÊ7Ph]t<)\rͳh%FFhETxc]8#.dcK3ZwB苇\"<),@Nb)q~gPĵ巷9ֿ;2yr>]9[&a2)e*k{luOݜS\r!]J1pS:r>SO&U=;x\"b	۱ r/`W<oDHiB@qSZ4df87s!`N=ie(T#nu.8((CǊ0@*)l0J-nNGnQ()O`e:3N(~RNzO<w\$\"H \n`MV,W%vkj}n~t݌\\鎀#fA\n~kF@8}\"c	F֯8LbIO\nh)ꉶO1	h8Pp}p(0t' \nnfZd*S\0|#*)͞|=ê,OB\n,|n\0S	\$zΚb(gGoe	Y@M\$'*0KRR1Sނ,,f(خ<olQljTG(QibOJm.Oc\"LFzƅQ-ĭ-(E!L\$2lr-5N!4-tt3pP@ja&07(0F.\"J,ꮂfQxU\n-6(w#\nLk)Rv~d90R(pf(#5(*+,%)҈nvH/*.nflN(p\\T	##QD\"c2j#140U6SmguLi/H/0ԯ21/g'5g&bŠPyLd(Ȗ-?-8i0PҺhs-8sg	k3<ѕ<&?9>cae#(=/!:stwi@pCJ&AsΤ2ăuH=sD+Da@,jk^2/JB %	,s@,M,hcZ	4.TcK%>7(?(l*f+X&	.'UAT!^ƃRCNj0f/!GIGNB;xYMBKb؇d\rPb\\!Ok*	!Sϣ5BHdoA\nP~N@m<mⅎ=8/EHNXCHR>@Ue30/)[R}?U3QI<ABLU]c]TY2o[^B^:GAYεUY{A-Ua1a#i8O%a~I\$'Z-+c\"cq!!j; uԵZc!EpGZR^Ƥ{fJ\rYRY9/QC`0m_U@U.naO_6)DD*&(k䤒_\$hLG#e\\v'k#O&\0\0R\0JZH4O^Qxi4kghU@W#mvJ7ilkqhqpeqrul`G_TDs'(2IVq`;u=kvsVg.Pe4`cW`@GUh~4pgSQlaGDEa7oYmz5n0WCw{pG{#{ƪ5~*.FtgQBWNztRh'zGG{o԰@@m\r \rhMEqG?iN\r\r ̕E.`ni\nZx>I74;{7҆NLBK|8Fï|uG-N	JqS)N̎,dO츮(Q\0@7Dduv̇Q3FWhH!1#jvb2(jL7ga	j[@\0XHRf~W\n2-o@m>r!QY02rb8V;S\rjFeWqv	VÉRmrxߔuf[f)C<#@^h\nUϒN2튕&C\\07y>uurp-=2T%2mn S9T)MdTε)f @W汷4urSY6('{+5\$s:#`)N/R\$%=5	=h_{Ogg'[Gup&z@܀=CtYoR.v̑DEd@	\0t	@\n`";break;case"bs":$f="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乷/6f9>(c[Z4P *053*-R 29({T\$((8+#j((0h@4Lw`@ #C&3:x3Zr3p^8J22\r˘ڏ#x|KCHFCpb9X]0\r1+D78Q%L%u7*;B¸C\"2b:!-a\rKcuE\rڟcHr#@kkҿ7 3#֋Qˠ#ünH(cM3Z3?bN:D\"쾪nDV5.5hv0Ahӱ͍Ӣ∘e<HQ5=3thun=0B#PU.P@QP@h,\"')h*cʝ')x¶9+gP#lb4Ѭ\"6N)'(< tCipr;C&@K솮\"87]pC2h@3	LCm7)?\$:\0u UB9ߋ*+]o@ªR2*6:t`HAY?\r.a,3ܺ\ncL;֋prN	Ȝ術>K\$\$@	2\rde+\"A+`.ԐAтtiI*)],优dLɡ5?@`XnN.@98>	,ӭ5n46XGd9<3!is#>jaG5\n`er#~Xl\rc\0a<f,Y%\"(a113Iwr@Ĉr#/!/i\r\0(e9_ă#r4K*8h)5+CVmOA;â^L;u8'D~\ro\$\rCrt!'L])\$鰥 ) ;CdD\nԗ!O&Pa 0CF-d;	rfMVa\$4Qх!`)dÈu5H39'1ē%t54TɔAO\naQS*UA B)T,%Qp  7bC*ɩILsG}ԑ*C\nlWgiHF\nݝV\\\\L\$nX\r lL̓hv#f~\0\0U\n @A l2f	 Z@(L[)WIB:VBKh\ncyjNdbDޥb.t|ų5bgn!B-͂\\36=қP[UhcDs7D>'>*ȀENIS)\"SE'd@ߍJmŷϑL{Sj̱Dl7á0YsmezP\nP0e*)<&ՃS;qw1iޣAlPFPN	7<P%(FRRm#()-xAarKզAD8PBHG7kNr8YABU	9I@̑Y{Dm9<T8GdC8Py:m`7%g'}`\0I'|P(Xz;MFsym˄fQgo./E	\$p=of&ۇ|nMǶ\\p^8(Imx%HaZԊTO*ѵBIF)sugP;#Sd8\\EC(b0QI?\\T!j}u ]-N:*UFyIw=A>H̄|I4%=!z89w'Y[W},a=q|+h~뮬+zk{^#\"aa|V~jhk耠'ΔpXOCZ鐬x0(uLΆ\n'%BY^F/@C/n<&Pr+'N\0%8M\rap,(M\"Fy0D/1VL,Z&p'KA(pAicHd.Lb^zeOJ3f\n>\$>~(вZb0 \" /q\rhԓ ȕâF9\nkBP|\r\nkooPp\rBalX#	%0i~ͥU		\"`h-P`f8#lXp|*\rS\00%i'faN\"	MTa>J\",cNHH`2KQj#a'^T1~D?~e8(dCTI@@#A	 ÃC+!jT?#t\$#Q7i%Z6_qm#`A\\=I	\rj\nH1+cJFm,\r)O*)T:(f8eE:FBX`~{#W1+El*cr=#6\rVrxo+\$v#\\MbPGc\0\0\npqNj\r2T73N24U6F^\$nLT/'\\b10&b 816V3+nH@\rä8D@:B@	\"֡dumi`ʐTE\\2i#&\rbv*;K>*LG-@0\0T	>è+21*,`1iP3pk\n>(0\rl#BID B',8^F\r<nB_0;D;Ib98Zt13@.ԄG,\nMN2P:U";break;case"ca":$f="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]f%3M)pȺh@2:H!0pP:\n0ȍ#Қ1h2e1KV#s:BțFI4+cڢÔ|0cX70@;CI!p; XD49Ax^;́r?%r3^8J2\r:˪|B!^0P2ȣL\"&&\r:M2h 5(S1\"hılKGNp>\0<\0MaX 6j\nHADg#)\\c o`猣0Gò:Z9H`PDP> B^I\r87#`7b|27(pah&B+G`Kp<F\r#LVD03\n7Xp&.(CuaTģRL4%<9c+!DcҀi:7BZס& \"ը\\r\\<@S<T⠂:!ƌ#ɈJP6\\K &\r,!/62F\rѴ*:77K8\nU *\r}	\"3N\r%-C<3+ˌXż2Sގ}'w~R	\"b*0oBSFӀ-ʌIL	2&dК`wMܼCp/@eDADL;)Ff4t8&ungE^\"JQ/D&CpIOKS(r\\K\r1TΚSZmM4@MRPY?@GSt͙5!A:3r4֨{ITU:.Uh: O51\n!Fs	z/i(0a(Fn4FcYM~sfL!o\$p8\0P	AAQ(ezo}ol*mސPo%I+\rҡ&<\$g%nZq<`h&2,#s&*\n7@7CRjnx+qFrR\r?`%fK(tsН\nxy\" ֻ&!\$I/\n=DRK(H	*?(}ofc6A@'0AI'`/cI\0R+ʓ-y[M:Sei]M.*&yIAVnR5*KDbIn83SLA0A.<?Db/I}\0U\n @m\0D0\"d*#Y=͵R(N	1#PB):d)j݊ѡSk	He4D=A1#jxĬXHh5ĺy,ݽY8!F#\\dT\0\$+P,8:h1)<䢒.)ZjL3ga,=Vk2BY⊂uR=.Y:j\0]2vO,5|4Uk(wh7S 0kr-WcC+FX#!hqLlj\"0P:%ɏb@a{sj#\"FE˝M̆]Ј)-)\$h|\"6ܞJ[*#j.L|Ãn8]Ac@CV4ckˮNĚ9 }	n%	5ʭ\$:^+G&*ϸ\ns t>UYO{\",wۻ*nկu7on욍MdOhܐ\"IAXDȟPղ[W)R6Q+Nry41I+.5^Ibsbne\nSzMO/?<mLhVMߥ.B;N`aH٣@yo?Gu\\pEU=؋E/x[:y֨Y&fFV0QaVڔKR[o0TK\"TH`F6VqE2\nra\$VO!tyNyh%EjŜMCI:@R|kX7t7~_3hƆ#-W/?in}*Vj#p\n8ebڠEa\0#\0m\r2keͤ&o0\n-P0L͐R`6G~2@N.C>u,^4)&7\n=dDfk\" 3DS//O%㴅˾~0lr'\0-xlo\$=\n,^mfiVː&	p0\0@UMaKfɏ\$ڰ,4S..Aj`X;M̣\nhMظ-@*2\$	\0QHpч\n1D̍`yɮi*25+9/1jqH[	0h)kN,?Q2N.Rk%QQ1qM1\nL',AD.1!J\$5!	(zѰ@-).IHGŏ\$OqD/\r%XF둁P\$m(&&/T e4\rV\$BIF]O<@ZarljAD|\nZwI&M(\\8HR\0fЄ&Z ޾BLf C?=c1m\$§/qcP&h6F2;1e'BiNfO'0ZcdV(hNP4~781Sɣ| 5	&̌}8\"+_(^Sʏ6&F:@kof8f>`Nc, gJ!E)XSdj/GK2 i3p2\0003Z\\3*Vv%6l8>n: .q\"D.j[Rdh	\0@	t\n`";break;case"cs":$f="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{53T9(5	(持B#Z-((\"H#z9¤0i.6#tC\"\$ɻ.Vc@5f!\02A\0\rX@2D49Ax^;p0\\x99cR2ɨƎF#2Rix!V+2ۏ! P74>:)c[^x6szCmE3Mӭf\rcռ(p5Ѣ9UL05HK\\U<h8*Q P7 P#BH1C-71b^k%\"cp޿S#p=C=3P@P2\";@HFMBb`ȈCd7,(K\\q*U(2wvŰNsQӍ+{FR&yRâsFFz4\0\$-[#lnňƿh]6VPP!C9X1P@*Cҳ\rn9Ҡ:4bFMx\$>ەQD9V8jqp0030̡FIX2E0#ejm4#HR9aC[M'^^؄V<s\r̓l	xy~okz_`a_\";|㼓^`y̹\r=Bk\\?@ Mՠb4lce̢%lTVGoȐu:K\\\"êOJ))pTR]K1rTRl@>D\\9H*Pt.rrC0CjOp47\n)5spXqFII4Wܼ֒e (&䠔VK	i.%dFQ9&<a:v	5b-șL*	<o?tpg<X\$\"RJ{HՂG]ESHvohQ4!qPVR-|l8a|^IFN#H\n\0yQ[=(*\0:\$H4b0C=\\h^єޘw#Ijt.خ,u(͆c>9	9))&ŪH.qO\0C\naH#HgvN;oI9\$!˘*8`8L]+EW9NM7gS\\h_1錁ThQRiB{ &R@5`5q \n<!@'0P\\h(l\$nyw0iټjW\nŘ8 \nlrO}@oDx*C|*P~L\$\"		XC\r!uk\\Y)5d<b*4֑ryo=\ndI	T7DUS,\\ʰBBd7&\$^H\$dU\"|qVl5W;JZم=\$6sCJ:-*LVui.ˁ/ + 7TӇ\"кh*6S[o9'*C*6	uD(ǌBj_XOt54Y-AN_E_;e,VMKzu*AZ2/s	g(C8J\\;\nfkj.d7z	EE	LoaA%.gT!\${I69@ߓNDK/U?^W(`bf_\nV'5O4pBm\r%ƕJO51]mU|&leڝf|e1z1\nuN[s	s~6arٹE=uhRz;f2t	]yxW=:׀s'Sؒ0\$i?iYH`'yrEUd0*דW1ij#ᔔx7!Ɣh(ߚ>?(\"&pJ1)u}nE\$^oxCΕY7PF0P'_0O<4~(:m^NcK\0\n:J 6HLTeI7\n]ظjz*\nE4H(JwxFUfڄ'`U@]eMb+)\\i\\殔%eGp+/\\YE`@\re`,)K\0&2з\rELIT#P7\"Vn\0=@\n P<\0dDpOp\0VĜ0#JgD C=n4k;yк Fp@C1MZ`plyx\r08\"3.Yi]bbAI»\$UX`I<dI2H:F*28ۣ̤LBi}#N+CbA1x1\\ٍxEjd<fi\0lQYXQuܱf0;\"!\rцƘ8\rZ\n\0/\0PQA\"O\$Z\$#gHg\$'Lf:=FE	b*2kӅ<A-%0P+0&+?lo\r^ÚFULl{-.ɇUP&BZ\$Dg#-1\0\".4ͯ2΢.-'M2:r?&R7D5\"g%R&@5\nw5;6-/r5\r	5q<Qp\"n˰mЭ:nw9I]9ӑ0Ȁ#S4s%`#*=d\\C9#9G:;ξm:n5f1Q?7?N?.(\rV;aƆI,@i?oNj1BQ	9hl\nZ\nऱS@I]F ntt#TqGEl3@T\$j\".D@FlURhB? YbE#/{]ņ8\r\r(N}KCo,Fj˴k,\n<@RVAPV(+O!{O6nnC@-̣	\rQ@4Oe1({\"jVS#Ss!Q5H<CT5BF\0eEE*D?\0a5BG(rN`,2O\nt\"1Y`2\"UoܾE#'U(rk^&QRr:4zȦ?]6S?[\"4BD1p<!C\\Q ";break;case"da":$f="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX')jR(Vñ&oY̘ BcbȢsBO2\rZ2\r(<-掎\r>1p1?4@:#@8?\0y\r	CC.8a^H\\(γzƃl\r:0\"px!N+0cj2?P5d3HH;ϓҎ|	B\"P0Cr3hhTp:\"Xޏ(*#US\r|J/`7ƞL0264#:SaM7B2+<\r3+0*U:R;@쳎k#4m`U	L\"\njp64c:D	6RmM-PZ9l)\"`Z5D)>PM8hK\"	\rc(a\nE-K6ãk=^jd,SEET\"S):ZZ :<&r\r2oD.Tb\\b#A\\8v؄^dk@bOb^ϴx3_O6*\r<DC5AX`3+[rl`2S\n\"c:\$%m:m&QǮ\r) HC#IT	I㔣)d7K!R<DV <5\\.Zp7_C#,BN[2YG:} #|EH\$; rPJOas̏>i2D횪L&|ІrtiIUɈACyXλ4޸ EfNfNzuL9)h֡WfmL9spT\\A\"0\"pN@\$\0[	>(@R.ğN)d4fˊIrSlD2gY/*pK@fԶMF*\$e E|7`Ѫ7Jl;D\$-)\n&İҠ3Fkɂ)Jn(Ja.3b|	#&:o_[?p	8I\"!彗7'EО?1%L@)BO\naQ\"=T3nHm^9RRjZc\rĐ3i <H!9s'\r90Hg\n2P(CjܳF[RB2'(\\s(6!K'@BD!P\"\n(L<OPRC)-r\ncjgP&46([g,?a534%EEPHQ\r\"jmM蝌mre5s=5TS\\4}6H\"0Q	.OV.uo@S)J8p*(qsCHzURA:4dW2~KPmST`	+/ E_Y%^4aR݅ګ\$mZlʨ*of#Ĥ	Ae5!Y1`ֲDhC*hYd(5ꀘPp7)@ʲ7,6b1Oa,\r	١	-,cP!Ȅ\0L\0h=BBE#\n[V+\nAyT3H_X.Vgɤ'	p\0Xo)xBI-Nl\\l:!GU9OU\$C'ͱ%`8OərsBᬊmо\nyc-*K\0(\".\rdvܓxph%Fp`ո@͸ܹәn﵎Iwyn5.q/\"`&C,S6EU(L^=>TOe3QǓ:*^ R,E|NhAm#\$홡f@q\$C96vyBxFOBϹJvM]ts\$oMBG|eóoIFv&*7ۊsJ}?=윗2C+80\rucŞ,qjKUr9xDhpr98\0Cx\n=BbJUa<TXSdh ٠1780;POpNeHO<Q\0L\n\"N	g=\$<J\r2ͫ|40M\0~`F(RȚX/0|BP)qo'pDH\$ezìD\"R6О|LgêOET/dfάUlj.c{ZZ-,aiТƐ/NO`x0\"]l>0OOڕ3C\r	T/2P1b`\$Pl,KFqHDBuQOU,e-^ <qvQzpd\rV\re\rmFL(PE\rL)oʇK\n	;RN2OO(Bfܷ#	|'ʎI7;|!@Zp1mOU1->+ڄN.\ni9'0EFT2.Ta2Z>k`f;6_'NaRl+'0E)'N\"b2+)&H6Pe2[jڦʁ	%r^ҨB:r\0Ccd2\"س\nJǢFzOqo&{<_BƴTҊ/P@-7#\n:ԞQ>?p&";break;case"de":$f="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$h0H \r;.,(3(#;C&\r:1J j6#zZ@x:fij7b\n;C@IÄcC#Z-3:t#QC8^E.xDl\r4J@}1mIS:Cz::b;Kԥ%NBp:ǌ摏@Pë`懠b!-abtU#\rhڎ8 xZ\$NBѺC){&˄b\$\0PR03w:eVJ*.RT}\r̙T6Tez7Zރp(hh(߅b)-1<7E#][WNBsuL(c۱D 5Zr5-X	#ls8OX<jJLG\$Fl18]XAIݸ۞Zi0C\r-m{lTVBC8h´Sڴ(3dv#6#l`9PX7Y\rh`X\\r:8A8. bj \" )== gr3}~^#*7Hz\"C\ry:\0<w2e5GF<&(p\"L`LA2&gSZmM@䝈/~#PXG\nQΈ(b%Z^T\n/ia:bD'PܡF\0000XhLi3؛pG0'XdS#7'\0Co[yD }1o1d&ԬFkG92ըM9`\$\0BdXM='T(BJ^d68oK+d0BcQ\$膖>_PT20`	%`N\0B֘ g\rبtL;9#C %8:8KٱGOC\"gsIGAAQ 0h3dˢCo%ڮ0Q,Y)\0007ځf,ID6(XmU\rW;2WC !,'dNh+ru4֛QP0 \n\nF/))E~(Ƞ@<0QHgGM!5T:2rM\n'\0RA\"_ÓM.*?AH!f+\"MuPޓVEOMNdHh\$S3\0 -],8JS50 =5l]G(\$J!}ô~DO\";cW1PDv2\nQT035ܽ(FQlG*BEQ4K\rW\"5dKoF[x04@BD!P\"҄B`E*´Վ(u'[ja<8K	=&L'^5{sѭZR?Ԓ) wSŻ#X>GB50;SYKM+gQ<˄ÆrWkD1@}tBLK]&XMlMY B~\n#8TlpEAo%TRqf1fgTgHQV[ڡ\r9X,@U/0\0Py`<\ndpA;LF3&.;@ëmє)a\rf6PWU`%ug#2,reL*\0qݜ:8#]+ȔuS3YFybj\\,Rќj|S) KLjung*BtB`Ag(2<q]L1A.O\0@֒kęO6/a';\\ρ\0[ԏ<wsyʝb/,7K30_ֻ\$y`3CH_\nYnt+ˍ> RLTr&RLj<B+ږSņW()4XuFx\\xHiCs}¦h>+(6Y.;7G%?og/+ro[PƳf|`whr1_)A]]}.Ī'[\\B1EDIH0^t+f[lGXN֦*Y8( P	T,BgOɬ~PF5>B̲B0Flrϓ%\\n=`nnVzoj/dd0~?P\r	N#\r6w/\r%P0l0rp\r,0\0V\r~0\0KO:#>6pBfYh #ZGZDC,Jzpbr y{R >+'-M|vBlFhf-f9Q4 Ͱ٣1DIppU\nTpPq̮\"є0q-(j7C*7̮\ne\\#`	Ijlt*[\0hۯ1g!pM\n	1e^\\`AR:@R?\$RH:T1.6 2 \reWCil-+{(4ˏ(y\$ҒG^æP܍)Cy(+nE'(&CR,R#q\"B!`\"܊=`\r&S(X\r,=/rFIOq/&`wfiֳ>DR`kL'pne0\rW1j֓`0I+\$m,1& \np4ޑK6&p|p0n@ɓP' O%T+2m؃RpO`;/*?nD\$\"73J0b먲3U'bfH#'bEkB-:EsI:X̒:b PSdH/H@wAp)Co@\0PBM]Dɓ\0Q\$u)~\ng4=M@x2\"Hkjl\$x0!N`5Ţp\nR'D&225\$.	4S B\0Ÿ7e_5NB4,!FT&N=fWC\rjg\"M2vO@BY@b84\nB  ";break;case"el":$f="J=Z &r͜gY{=;	E30\ng\$YH9zXňUJfz2'gakxc7C!(@˥jk9sVz8UYzMI!U>PT-N'DS\nΤTH}k-(KTJח4j0b2as ]`株t0sOjC;3TA]ҺaOr4vOxB-wJ`#k4L[_\"h-2_ɡUk]ôu*\"Mn?O3)\\̮(R\nB\\\nhg6ʣp7kZ~A@ٝL&.WB\"@I1H@&tg:0Z'1vgʃCB5x7(9\rQjA\"╷њO9¦sLJ錆M8l(]43\$%ΊOazᗩF,⸓YnRa,# 4@2\r(K<:[#Yu`5x:#9\04@:ׁ\0ec2\0yb3:xw\rUVLAt3(㝳m\r-V(c#x|5pvg)Qz\$PX/;oD;:d4e\\fSV)B@N꼇8RBg%B9\r>\0<(jeKNv/!N]<MgB+Z6-DF2C\n,!ZQ5b=VA0\$Qq7rBŶo6'l⬔|)IuBg۾Elm9%H<P%C=x7lBf[V5ԧр(=<@K kɗPQEȋ˝} ܊8H\"SP/\09}~PUq&/(sCQs &\0jt-3XJPa J12>ϋ9سK L7Dh\\IᬆÃwE'B+>\"	r_'ܧi \$BJJT3ܘVBA:\"@\$	D̄{MQSM_|Tm8FWS0ܘ;HJ\"EԜΈ)n@&\$[̸c#\$z:FėV&OO([/xRJ*hY5R,)M˙vԾMr5L1Lb ː|n1eJ	((x@Rڳa!UUj9-HdU|.ƹW:]kwuK}aC\r_`RD.^!	H\n})EVODlI:ϩjc.D{(i/J5F|K!ݏ* \\ˡu.ܼ^|b3`pvgǐR)e>*@2qpL**SvDEqV1VEB`͹M\nJ5%a:	)!Cl'?\$(j\nj,9g	Cfk409U|0u7uYqV Z+6\"@\r0ȲH\")%qٕb#䝾\$5eay4dBF-_~8P	@\nIr>Qp\"JK)7n[`Õhc4BHv3՜DV^\\tsءID3/:\$דoVk9u~.8-Erj4+y\r%(\$CFE|044MІ\$Q4vzN3)9Q`rurT@VL뭵L.cr@^DJv){ݕSP+B.a?nR4c&LQ%EOy&fy&7	~Yb\\Va:20 \n<)Hh=PoU[R`ڢ}eZβP:C_Ƨu<PJ3DJ&N^wM{͒L\00lEVKbSx׿/{gX6Sp\rv\"Q{use H.\$N9\$p%\"XgS&\\8.mtgAP	=1A)g)Y뉈4'?7gTm!]՘h-IW|d`k<e)hJ!fP)).~.	q?iHЀ`bY7S|NA \\c~<|RJɏ[_C1)'`\"h,(]>`ot,)9ǨoLN\rǖh>v,BH#m2!axQ/\08x&DIJqKV;+\\poDf{JG>Q~k`E'ydڄ4\"ws^~cj/nhE;t&D7h|30<BdtgT(T_	z}pnO\"IvhGcYа|㢔hOf\n@\n 	\0@ L@VE\\LvV˪W%vINF)/D4JyF@#&9b90BBJ-G卐5\\4h|Eozb,kO	5q+Ѵ.q9@\n5gbo*1'ì\"	&~&ȔbZk aQ)qnޒ\$)-aﬀyE~BnX0T/\"Zb%r4.24O\n~Rh\$G?B'⒘v=Ҷ%xU!'ȸ@NCVF\r0h:OV\$s(kO.*M/00|3!-쬏ns3K(D2,\"IriPI.\r,B!\nw5pC5Q(GfAk6:i0DIi9v=,J\$>j~Ӆ6S|Ӝs'7:;e:1hX?ӕ;l<#&iNIө)\n,&pP0{.'@h291)V-p\$NBCT<;ς~}/MɩD¢^3|s6isiF>؛=N%n0Q\$d7=g7T~oC\0w5R2xe؅В*_\$&KuKL-\$!~.#1tM4Pq/MBct5rPp>)gtIw1hw-U0U;DSi9i	ÈEؤ	BfqKN%oH*ó2@MCȨɸ\$&4q<yx5eEz&ЗWUBeHR-TN3T\nITpROuL5QsCH1FAh8\$MQfew\nuVgO[RCVDTCJ_Hf)QHU!KUc&yUhE]IPbPby,)\"M&tp5R6qbAJԛ!g1gfYe5eyh=@ai\$6ehZUgbm\r҅\rB(?#3&/&-+CQ'*y+hy×d&4g{GTNWSgS[6pUil=R';n1(!=3@Ѐn|kt6<ctM@WeW?l7NS<p6T<*/1YuL3g\rd@:pH3b8SyO)Yw-qj~+P'Vk+v(+56OOĭ2	ywdv71.չqc69]w<m<#%wRz\$Ɉ^yn'䪍J@C/oNjr!j+1O\$I	JFR5&*N\nL534O/\$\"8SqCx5IO\nó	i\n\rV`֞B\"\\\$mh<Ҏ2BfRAx&H \np(IܮlfHIqMw󍒓zE|1ÄR\"J.\r|o7Î6.DzBFCsJ|.o0c0c\riRwcCGYn-.	EҤ'\niz%c56URGv+*oBe-NyRF@Nj\"!t0On.Y_0&΍V>t8m'UHSޚ?u6z#EYCCJwJ+\rwG_= .ESfOD><=gof:R6v5v]J\"x(34aPq\$ژw	6PYDΎ 5h+RG73ob1\$ۇ3\nwHjڣ	s@q%\r*DGoR[Z*ę',IN0㗜ltJ.S]:15@`k03ZS+˝bH/Rb J1cqg׈}\n";break;case"es":$f="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9`\rKpKD>+ݽ@n 9@IP&\r7SD,Čj?{R;XF1(Ԗx\0\04C7k; X:D49Ax^;́p3^8IҀ2\rrDrr8^0ɠ4m=7:9S7&:c,\nåM*N0L#߶:8++B\$\0<\0Ms]<\"6hJ8B#kP7le'B 3[Cdj;.ue\$l@:ڐx܌,[XN#1&gjDB|漱\n9ۊ2+-R@]?11Wx؛i\nvh☢&S(ݨOTT3\"N8ՏXR2hp5P4Մ<\$rP݈ph-Q\$j 2/p*Dn*z<3τ\"ugnb0ʗ\nb5!<ֈ2C,&aݳLR\r0^iBR_7[xQ1z3`#	#0.A_u2R\nh>0=38@a*\nOP\04^cU*`LI;g}rkM^>(%ӵ8IL>I&G%l3=%ZLԑ~/84Lp\r&02䨕BXu/ƙS;с)78bv`Bä<,`P '!=P}8q#\$F\$>5\nӳ^DeWF4Ĳ7Vr!g}\rx#b\n8Pfy818꽲*xWV?8(FH\n73\\FAJ% cho/9\0&-d+pFD-?dr\rZ\\<.Qj(2.ZNq>dFGI\$M]r`KpK\0Oh6\nv01|`l]	\0S~#lH6hxGU(i5n;]#Q9\"㌾!P?II\"a͟e49hƖ@	\r^&hxS\n!rG91l^z0䬽ɒtO-XpRc\$( J&X:@oŗBA*K:H'\$h3U`B̜&'%*  U\$-blB	H)\\bCj6b{ta`P%\$/>q('q2 TJa2ĵ\0M*7lR)uaRH)z1<q\rj7f4t:	U C'*\nA rJV>ubR)1az?YB18G7|iT07۩LB\na=1>ߌni>yEBvø\nPꎅ60k\rݠA.pbs1Ƣkg+O!8!DzW%RFLFOubyNl pϰf%Sh	\0R6lSQI`e\rN=mIAW@ezW[]Y/1{4%=6-Ӯv;3ͶF[RFd+zlU`=U+VcqnGÀweG:/8{ԍN&l!M}'5<Uk%jIEE<,<6uQn1%@&i.^VoLfiؑ_qvu\n?b?\$+[#-媃yVD[=T\nwC>آe0Y}\r1x5OoZ0B-t.Jʥrr<`p;-o3V%> ?v54x\neEeJfIj9}luR(xlVc0#<>@y\$)*O7yVpaL\rg.(yBe2ݭN,&Fm#\\jXX0p,cmJVl|&.>-/CaH(/Cd/e\r(i\n*bk,/O0D;Xu8\nې\nK	̅P.'|KiƊTD7mLXZL8l;Fo8u,mS./g A\$!0ZBмB-%|%\$Bkee>J\rV.NE0kq&*hG^/op8lt1іa8.]Rj -i4Ҥ/%--NUAeq7eimhAPE q/.LZvW?Ce.6L\r#!#%t2C%\\QW%BViP͵&h-&(Y&\rV+Bi0xbh@\rF\ny\npÆ0b&\0,oߣ5\"8#/̜K\r8G/-2j-NDBD2r~D2O/BHKLj\nDD.qE(/Q-QJ<9R#G ).\"0J>Èf/&/J=62d\"7C5J\$E̪TBPrhK?vbb&b0\$PGjKΥ>\0@X{ɂJ!7e^ңvI<J1<XB(t1\0޽-1B5j>XO2v: 	\0@	t\n`";break;case"et":$f="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfYb΍~=(L3|7\$80( B`޶\"	Nx AP9 ҳ*ԥc\\0c;A~ծH\nR;CC-H;# X90z\r8a^\\:x\\x7ㄍ\$C ^)(P̴4px!j+\$mPM\nj~\$,\\\nH++߶(j9GB~CP\nd\"**@MtW+<N#Ã7A{fP(J\$2P(#2C`Y.:#tA%ZL Pw,M%Ic\0zų):B4K23T4cZ4v.#\\CcL 0cx1a6ncxrJq4,%VBQU(~	H\rQJy\$Jμ!.O	?6bPW6IJ>A KHAX7]\"k#M'n`wԸ6㜄!լ/Km#cŢ+0̍-% .;7:Ʊq/9z/0څo\n@nvyS\n:Z\np*rNBLRX>HdQ&XKIq/&N΢fM'OL?h} g͆uUZj\\Ǵ6<Hٗ;C&\$2RnaOzE1)0.I9%4[K/4ę RfpI¦Y\n@\rӻQpp=䞬.b`%ABxu?ij@\rxưO!\"LKcДGi'4C{\r̚RSx#)2\0_0iz*((L;\0PCO1sC4FܝH-GQ7xrk-)AH|T_iU(ԍ5Ĥ:Iܳ0qKZUXH6dmxb&%L04!&K~\r	òx4p~q=\\xu*1ZPڶRz\r𚄒(L)q@i2\$%RP0c_FE8J`MF\0 -mjhܚ[\n GF\"P2\\LzڬmLR3ja,n73\0ɟa\\`-:uk0>~EP\nbXdʂ^rp(}<3֦U	d2Ĺ\0U\n @@D0\"冱L\$%I7NZ	a,QeLʣ:'Lꒅ\$t\r2\$WP\0ʞCa~.)	iI.~YG*PBv]b[ t-H]Etb-J0H0h¤U1	\n,{FKyq|g0@bcw3;OLlAe\rB[I'.}C	ʉ1!CfUTW3Z6-lgXLR<ň8(u%CMp89=zI\"%BE:vɻyxP'9WkR\"`ST(B@߳PQA@օ@@ lҺhQxp_6!(%^-W^^MFIa\rݟqTD_I1k5C\n_|HFQou:.>!܋7HI\$׃8St'\nA4j\r52}`fl#Y4ZWߢ4~xPK܎.<kKß&sALɸjBw_9|[=`k\$%h>y8wbnR\\t72!lu|a۽*h8|;_ԸvnA?gΌrH:x?C\"Ahȩa4o<^ɧ4H,[=:5v[QߙG,5/M=Cv*QNZٷf@D5qq|O-ψ;EU-{U'M}(tD401.i.+mWjjbNbN0p\0K0Ê/)\0*θJ	J.'D3cޖhčh``Drk\r\$èf= č7ͭBG#BqL4i%buO/+.,ZhVk\\;eS)zS>0\r*<S<T.0%0\rK1T\0\$\"2߀*&Q%\rqƆq9~sʿH4 @Pӭ>\nF\\΅jC	'B_ZÀ8E\$iJQKߌRpd]0&+\$QDg],,1&)-L\n1梨l͌b0AH\\0VVOJ1ʬ!l e%R%P\rЍA9qY,@7.\$Wq=ߒX2Q̔ P	_`cgK\r#R	zWG+1h2)W `Yo~ۆ+bl2VdqM{FFe#9&  @h`&eNs\")k\\\nZ\r\$M#~`f\\|F鍢\"`@\0r \"9d}l03Z9-%\$y6;`ݢ>;pf\nT4Ļɂ7f>oZ/VQ5l,`rl.:!\0ތFߒs<\rB@34%\"L\$2L PSX^Ej)LϮ\"RˊOi.b9B.Pq\nOɀ(f	\$Ŋ,&E.O 6a;L<Cx5eAfYsU@@-CXA|1e>C&_c<`	\0t	@\n`";break;case"fa":$f="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx.*Fɖ(%I&Т:_+k	qBk,`Xk2B\"68@2\r(@C6:##!o`1:#9\04@:Ɂ\0-c2\0y*3:x?wpPp_3sLJ|6R3ACl4px!BSj	,Z;d\$jB̻^ϳM<\$kᐌ	DΈ\"9\rҒ8%~U6dBOӆ\02k\"V_k\rκ?}X+ImtԵ:LZUqq{\$D#Yc\r::55S\r<,#(0(/o%e@^ma\n&0)RBYcvVNz__C=*bWVWwvMj\"'B[zȆ*Z0%w^Hɲ즊i񵅎K?x!_TB 9#dT7rs(:Q2:9KIir:hR@<^\0'esª 5\";gh^\$8H>C(fC6I)D&&OBYVFq\\,\nǐ(SXn*2DF(VA&WMJ[{Ww>Pwƥ'3hoŴߋ~9r?9-s_DǜQXI][{ (*@:<\r67NC\">M84{O;(rP\$8@+)ڧ	[Bmޙ;*HWUFM!7ZX[66'dh@E1,k#\n[cz!Bo\\6q\"D|OAC2QNMHX!)leW䒪%h굒\nױn\rXTc![h84HT	*3ԛ^\r!6\0ėCA2P\$3a'%\0fl\rM\n]r4CtX!8W̡Q|H5ڙK:eBhUUo(\"3>Ʉ\0((`ku6(\\ac:IrrdܚD\r2n 9ʨcւ5\r%j ARRsL>YYCdLɡ5%@ia#Ν]0PPS\nA|֢_	'Ԓ3uFdd\$\rS&eePp`[Bcƒ&t<	\$h<4*RFKjuHI3 \"z>(1\$>+CLv\r.J#nX¦KMhQEVJ]HKW0(I\\(ڥ%.qfMzK~=g磌)m(CϘ#J?TynHxڙ/QNn?»U38~ ('@BD!P\"|(L)Z\n еLd2?\nUTIhǑuH%-bAg~I\$3n|DiJ̤+q7iEGTmGDvtкUVʾF+щ1ttz<p\\J:oR1I!k*#+k\"F/@ aD.[mJQVsT},|.3Uܬ,gSD6Kjv-ؙQ`l4g\$`cK7Nɺ-cCH1Z-80/l\\|Lğ5>G{~K Aa \\RT#S8LjZbF_wNBhcp)7YԲŇ).BÉ/3%}b^Mu5[]SC\r'kU2vIʹY;JM1Q4<٪\n IbBcq%o?<{'zL`;zn'_l=W|;f|Gu䢛22~`JK\n+\$/8sGZϿٻݚ><B#a}D80gV\$j PPYm\0\rihC&[!\0P\"n, gFހ,Em8~3~ql-4φ;8X\$ong\nϮڕ4涳ϰ.C\n(L0,Te\"WOŘ\\¯W0#lJKopF-rkDPT2è^A\nlAN{?'\0lϢG(d\\?l&lLƸ01,[΃%	Ў]hm~Em䅙qQm;]PPMe)Nn0^,D@\"CpBcLpPЬ-O)Rqui~'ώoPl<)-\$:,C)zm`PpR%Q	&CE#1'bw\nvNY#)(kqv7Bk):7qo\$<kM,JDcBV<bwn,\n\rDx1&+:3\"Jd0W-~5poCN2 r-	\rV\rie\rP3f\npV35\\/)*TJ۱O\nKEjf%BS%㺘\\ }!CM:7\"^\\0l@ELFɞ\r1b~O0#&ZoDBVmd:'ؑ??	r#	q7\nw6\r4	@ҌѪj;@7hT0zSwlcVz=T\"`,dÈJ0GFˬnPi}~h*fؗݓq;@j\n3D%\0-7GeTA	JBFc@t6Mxo'H,s)et\\@";break;case"fi":$f="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1e#Q4p%ɂSɍɈқ%0,{4:BBX'9-p0\r2@29(c\rLP(\n%0@4Ry	Лn0:h*R94lj90z\r\n\09Ax^;́rOap9zc;c ^)ֶ\rXx!j+%;%@a7c(Hܶ\rc魴R׶,@:k/T`(#[:!#^;HK]%5)@#8AX-.%p V{.hV!XѲ4#=Z7c80vD#\r43ZX	Ӿ\n挨:5Wp2\$Jӧ&Cu2SVr/f\roKb6 BR6EL0ĈiNeK	);\r/!Y'1\\=bX}+6ϡ.P%H:~O0KZ[#Mr׳y)eÿXmiJ@0K4Je'g\\\n\r-߄>	ҀނvԧN#z1([â30l&2č#L6ʴzR)j44U=Z-tW(.DP-II((:c_tMK'4w4hQcacϡ~?hp/όمPF^Z-h]#a䤥\r` FiĢ:\\KɁ1&D̚Rl`䜓v\ru2LZuVՊGI5	/R~Q;2\0w0HH Z*lΗsRHIu%(tL5\ruN<\0ܫJbP,L)ؠsȍB@uIK&-*xvT\n)EB6L<3*C[\n'dlGwR47x;*(/)EךwIedvV,'zeXri~o0@@Pq8()w3O=K\0S(e-,Dh\r(!4>\0ܝ|~Q\nGM=`مd8}ɜtESQWaY*|BfQ(Qm(D[DQt}Q(Rp 	XBvdMδR\nK'l Դ]C?f<jKBDS9\$Oɜ .6UJOTMTr|<6liD9`iW˒pN8O\naP)D\"s@uЎb: n3D	FnXII&2VOnJL*\0tO39B%kD^JjsZ4pAb\\a<'\0 A\n^ЈB`EhAKyYz:Q̂\0XA[A:堓gr ĉd9PlG\$&ґ/%f̩3cE)%EUZ\"gfuSHllƘCk%D#9Lnz%ޙ\"+ydKfN)A,I^frsX0&Ì.nębT`)IMcɱA\$71GѲt23Uniis8>rVb6TmuZwՏ)GlD\\aJNm	Zep\0KZ@C(s3HZRD<풮PNC>mhc/\nKY үё\r9r+0i㻉	{{}%{曀پР͛T'Wsp^x5ϻiliC	p<vk?htE((̾j\"VKn2fo*p|s;roQmstw#̡\nHrV+4L+tӮ#*e+~(^\nLocHwАB\rQ0xH9<Pc0|K2Nbt\r/[7VֶDT\\rhPu*>r>u}lcLp2NvuKxRq	 Wk\$Bk צWlܣB_Rz=dHj(YV	n9'}]fiF/˳~Noo	cDRפ|\$ȮߧN-xP.|p-#N.<\\B}o>gOʦ6 6E4F \$vکlp-YLv|U\$`:'o\$|p йN%(J#=E\n<BP`@f8D\n,_pxX\nWoTNF/AUOZ\" -!OVr)\0X+ɎQ0Ft,g `bhb&	 	D&|#%P&R&z1op:\0]%֜BG~\".ѠqCr\$\"E4w\0c\rZq^T\0K)PYp\$1J a1'lqm5\$p:<h\0/MrD@>Avʯ{##.Q%\$_`g4q;&\rnp6ft?ʺRŀU`*`@cnL8FtHx)2R\n	&2r];&MH[!/P fQB0q\"+0)'f5,/cX5\\\"R61+,Ww\"d[,cmnPB-ClSXm/cDn^f \"7G/7p∙Q4L7TepDDvP/̆	(ثa\"o\"&QV(l1<\\F\$L6J7,ąC6J-<<*=LLf(>8\0%h%(w`@qХq*,NG0\\";break;case"fr":$f="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏*X7P<PBHcR@P#0P-c\\9P%(̚2Ljk\r/Gڵ;-bR j ETB<4XЃ)Zpz420z\r\r9Ax^;p&\\3_5sh2\rrPr^0Ђ`;QQ6':7K1\roTBr2&62o\n7KJ2xƁMlm:!da܃m͕6t8\"2222ok	Yc-+#;8[U\">W&{LJa P9+VTc{9/6H:(0)yM	E`9N5~eVD)\"b:C>O_)z1LquRT{mf Pz&\"9޻4n>E<_@P.aP3hBǈqt8En\$\"C8@[*qhJ]ثpbiІ4&\\£012%4oZoKB;'|kp3FYZ3Mz§B#&a,c0.'ee8UN`MR8-P#1!+}'jZ\0K'\rG[x\0j \"\rQ3*A , U\$?&@a\$)%u9SxOI?(\0#D^`<	S1ڇ(Րg9l0`UBDFzϣ2:#Ĕ}OABgȰ\"r^E|؁\0m{)M%&FT7(يA4L5vJ)H.;id`1J\rؔƖØf372Q>Fp0eJJ9(;i*K	ck\r5:S3@\$8R.E\r1_1̐Cܗ;a7P+[8DIAA2B␑ڜ؃\"tr!*֐6n&ܙ	6%<C\r6)-7pS\nAT\nRNV\0\r\0%3SFyxT2E%P )<5dS3`U#iҚsRjY^\r\\ɐvȌP|EJhzSG%#ȍk}.|\0¡>~ \0R;OR66ql]d'94wYa;K}\0&0P4F,sW>2ne\"VɃT	`=36ZKet	{7gXH`cV2p \n@\"o&\\W~'as>!Y#<5Q\nzNC<8)Vp}Y=iO[e9DhHp\$\\Ɉk?((8lr21d?*gVe\$FИts\n7&Fcl3;r /PHS4>X)HH:vܞY&%v(ҏQvU_A@=wl脔'gK-[G0a\nJ2e){	a\nv|LhΨ*N<RC\nmJ\rnDblqD\nI}=E/pM'i.^Tq83+9\$HbitГ!U+m>vT\n!AAJZD)GNr2{b_\"`VL_8e[aw-dLTdMHc=4R4`O;+EӘۇawZc|p9,\$oԺ?5+tP]9%+>J\"r9cٚNJ϶e!22|0Fr[M굘\$6ckp@(bȻ3-؂tζQ:quA!'Oُ\nPA:Y/\nu\\*gW}O~XҸ&tlN+?jL2&OA\0E2pxL%\0dRO_N+efYb\"ZC`g\rha)TMPTS_|3N]DZ%iZg§0*g#p֧\0L)\0\0\"xmbp\$]ФllUқ!0	p\n\0\$Ysn`\0\niԋp bmfb!PP̅(/Q\r\roS\nB8'kd.eRʮެL2&(P6@.en3t!1d}htCT\rEE<\"q'1*MJuB\$Rof.2ͲbQ\0E{P\r̷my(rr1]\0.RfPϹ/\n!Rc'\",\r6:G\$!FͶ32K\"NYݒ_#<nDDPw\\\"º_L!EO\0Q\nIY	%9)p\$2Ყ%%\0002Xie2e+=V^2g%b0e,n,2^%]f2Cek+1\n\$r}ms0D[03%C˦ݲ0ݒ0.\nO`R=&/ᭀy -41ҩ13ZC`_\$`?f-+RY4 ʌpd9\"F|%3s)C1径!X3^I7%\$N[*0\$S,@k_c5q-\n8iA\0r'bg|jJ3@Z6@N>0CbUBtqD\$TD+^hdcE`@@nE\\iM\0EG\0DG81w!|pvZGFqT!U;C<4;o)PvQ}9;&\"!4Delu\0LN;D\rM:5tM)L¢Th&;dIآ):cF:\\O\". KҶpT\"c͞#5͂y#ɋĦh\0\rBt=/c@qNldǳ\n\rpYC\\1ޗ e	\\BZ=>`A`";break;case"gl":$f="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M\nf\$)MJʽΠh#.Jᎈ+dǊ\nRsjP@1@#\"*L(8\$cph0º9#4\rlG#2\0xC@:t㼼1SxrSJ|6.3/)ʜx?C*@1p:03ޔX!-7+pԷ@U/Lx\"cxC(BP\r]\0<Mi[W.7ھBҍXܓO#\"1vT+Hz|P +.5o(c4L@\n07PfQ;630:c0߉3\0Ǩw\0c(&ej֪nU\r4p_PW\$dX(T~WM4PC	0s#U76z6:r24X5KE)\"fcjC-Dz P!H5C7#\nR>\r+%Ci0H1UTXDaoOENQBk^߳G\$2cT:2;ڈB;zX֪ɾ0I\nS(wڠOzꇃ~\"Cv\$hAkQ]5\"_	c|F#ޚ\n#)_\"VRk#@C*SJ],?)4^T{BzqɅITxr[3NJQeeQc\r(Td\$䠔VK	i.%,L30`N	ɰ@)ĨRXMgJÂ<J(a1\rƬR`\r	6D9RCUj0cJr8a\09ؒiުa8^C,x'a.@\0\rF\0PUL eLvG\"o Gт<;ç,'g/|.vH-)v\r<?`f~i#I#pH!6&	ph3elHC_O!BS\nAPC@ ֮1+xd4glƲQ='K)e\raZNF\np}i6\$a_aPdH.CPR#QS'0bbɖȚu6AS\\V|4^% .UPSΆ#e(䭗a\r a'\$S\n:툓-֨tI	+2hs4_EEP՝\"I+	Ȩ)Q 0BL	!h )p \n@\"nA&' yo=&[veYa,LM( jF\"u(d8YLץ9GuLAz.zC^ Ehǳ\$+E<1Vv\n;(i()U,mt3|Тm&S|Uf*#,|W.:pPSce`-c̒~1f1b^lUԺbXȝ.]C@2\rallH\nx§mM[zqb0i%RuR8&<0z@NշEs]7-S^޾F495eORLvL!ͮ堀!fJ*0*KN/F<ތL4ls\"_a3]@!ԖNjt\"C4aIĆ.<LqR*0!yL,46Zkvw+0+\\ε|eiV>\"Sr~3Q'FC}!Ӧ\$?lڢ[ePڼ~!\\kzr2h!)u^\r;'4\"(QwC]m3TJcrcbZU]S#;&DɰASô]gM41&7oӢKw<xtP{MȅC<hȰ U.0dVA3+GcoXfJ| )\$\0uh/mƀQBhUol	m00\"n@D 0r2BP`nXЎ^ƎBpE	)N82T>9#\n\"BBE0gB]Fq\".3p\n@v%\\ij\"&3&I	<,PBe\"\"±05%ذG#m	>XF1,bj?\rL10RP8\$ЙkO~SmIj܄+	7QʅOUg\nf%1{ V%Nc@deR7>+4ިb{hI?QFʑM\\gjcq%#f޲NET>͘C!͌=#(٭/2\$h#R,# UE%[P\r2;	qi%Rf3`@B\"`F\"2TxWr\0j|\rj(b4.)#Z\")ʨq1v*\$w+oR{^Dxpw@A``Ơ`ƙ@ġj\\t1N+.\"Ɯ;	%4bd@Z\n\$i1NBDz.#\"6#9FozeE-0\\E/f=nmڂ/l-/-;4ˢC 87<gl~3>(3PL<,(n]#	PoicC;;=:	)sy=;G@_r>.FbPPbo BޚtB.1>l1A;!B(+:bd1.Ĩ^HV=LH)E~\n2>@/C-j:#~\".lJEB\r";break;case"he":$f="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9Blwq-m^|_|mzS;Iʡn,c0N(fLקJ# 4@2\r(;C2:#\rp0:#9\04@:ā\0c2\0y3:x+%\n;s3(㜃!\rk\n#x|@kzHJס[H2	Ѩl#n↠jjTB9\rR4[AZkEt(\nfL947\ri\"k?S/s-p}'U2A;dA㠿).\$'Hm\"	i--zI@B&Y\\5Ԫp?TшS']!rin3qEPuYMZ)6ki6y.ԻLlB 9#dj7i:\\7i(:LQL9ω4yUpȂ^Qlս6)5u6C[[2 O)OL'vs:}\"Y sH52ko\ra'm@2^\rP*9W]ug޲4%It)Jˏ0pƠ:ND&rLN:p ( u<3,N:\nIjOJ)M*pRK0&\$M)SIأ|c^JwLŘrDl濘`3Q˄rN{\nWi\r\$jqA2a\"b`l\r\nDr5iP4!ѯ4!5@B(\0P	@\na{(!d*nEa7CJ*F:\r%Arh:Kə+'!ކhsGFX/CppG \$ Ch\r!4&|MF1㝄\naC?rDthRHwؚԵr!ݙ%o	\")ftBT<~C\0Z^#ZI;+h\\&O1HN('\$8P2DAё>\\ُ<zRӿRBb%I/E<Y:Κu6 \$@=\nH9-sI5Ǹ*{L('\rv,es)uB&b`M=X&(djʖ\\HxlH@g\r-g`nZ*6ؽ5!6zOv	VW!XnIi %GkArF%n!\nZZ JOI{#ds9Mҏ\$ȣV*AAbHޥT[bJ1lż,cXՎs\rzX0U,ə+!ciN 5v2ҮYU1nC7F\$\\T\"!P*sg\\H<>19\"ERňcmzs0j	=%dᚐyI8el㙏ٝ!d쉃P\\R:!^i]5Yϩch,)/7#q@-DViEmUv19aCi5\rhۻUD	7\0[{k=EJGlpݷؘ@WGĆ H4Ēz`w^,6oxgTDQ-rk\rjB!(93ZpD׌{*fEZp%@p~\nr9UƤrKPQz)gݞ́2s[QmQ\\%7DttI*dBU<rpU9asL	8Â\\Vm~;+?}vnfk쫗	k-+N.3{'WMbnO{8@k_53*toS=Bif;\0.B!`XZM0R,['^߶-N?3I>0?8}{f?Z0H_Z:t\\|#{FMQjv|݆_UR?LԵK.PPэ74X%p0 \$bP<6V9>M/pDn\0.sF-lR#gԮ'z%J80xʐ|Ȭ\0ߥ9m :h/&k9^k-n<='e5Z0@v6nL-(Hd~n1clVl4횄h.bGq,䨆R*YK/\0E1r0*@]\r]-q&2Eh,!^nE&3l:1n0'l^\\#ȯh0ƾpϥ -[ލ݂<XqĊِWP~gFG`4ؽ1몺[!Oo:xǌY2E-QIg#b baD!(<#k	C2\0BY>@Ef?g\r;#b+\$^*>n @";break;case"hu":$f="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737J{z:H(XCTf	IC\r'|\"PlBP\"=A\0\r(ڻAH@Pݎb0c\n9Ʉ|8Z;,O#; XФD49Ax^;pǐl3@^8KR2\rcZ`\r#x|퍉()5Lk'*i /n/QUUaCRB0\0K\rr2h:6%YTN5PS#^Vɲ8žcm*i[X- 3#R:PٿB0cL<58Τ+}.5[CCMb\r˝)X\r5Ch7S&Ԡ3b7ZCc0آ&K#LʺK<&Cգ3[SjU(%j➴ˋ1{BN%EBd>8:и@6ȴh+lFѬNzvY=h\"(.#lc>7sMjs<+#tGl[5~ZP\"\"(\$2db(-8ʒ-3QK5x3(Ro}k*\r}ф\$c5\rU/ӣ`3+AYQq@\n\"YEEJPI:wh0șBjM8tH.N7H2P Ԃ85\$BQ\rO:%*mr3Fю9+!,4L\r% 2gM)6ߴ!iӺW	Ts8hn!>sHe@ф~e('rJy؄ʁ\$8 I-FR9r*d\0J@X'`JJDHcr&%\"s/%C4p\ri2@1CW1\0%R4eL1ϘdɾVQt3>|H \n (LX2ˑE2G2>M!R&ǃblͩX\$L%\".DaW  Wdq~d43J7-bw8!4 Axi?\0FY010J95qgYl\rbVL4>a\"I>(DG5JTR*G`J+J3@t	I\"!ӣvkJ,@(jfs\$1xS\n@Xdg\$9P\\j* CV':2ʳW\"<H\rڙNi81Q@2+`\0&@Xǲe] (\$9\"Zi4ɕ\\\nj-T-ѻIjT)n*Z+zBPHf!i\n.iҜ\r\0z/%\$P;['jX؊\n\nqbfSN\0)2ZmMĶpUpF;Mv1b̈́1)*\$!=Wb_aC\$MfM`/LIEF\n-)-(\n\$50\nX2r:Y\\/1yxkYVd\0CgW-sMкD`\r\n#GLU ٛQ=GCp.cD[[CK<*@@ =\n+g4m]cD\"d]ǹYmƓ!np´_Nz͗rAp	dż*oþ6(n8.y ⷸt%/s7	bq\rQ*m-\rݬ|S9'U b:T:I2%09D\"/lO4TYL`=E&ڵ&0jGFO61m\\ ޅUCxO8.a1GN'\nwx	Xl5kg~Q^Fcq/jAϫp̂/+YUŰ[p^቉'B3Kڪa*bfQarC\\G7`R-XGK-+^v@IϺ-;妦kR'0D/ޱcv9+2jCbV58oj&2`3%A!ZFnLnP\0UnJ<l-P]zH0j6Pn \0pS	 ؘhHpM\n%\"z+\ni&tHjd3Uaul[\n\rd&0&t Z/%\r#!P\r8%l^AA+I6H+\n&M	V&&~O̀mBrEMl)0hrW|TSZqqhF{'l)#O|Gl;q`;+@N|#\"EBN2>3+o&S[`Fe)KX`F`gTU\rv\$o R\ro,^k'\"/1E\\\n˲C(%*-:G\nS>ѩe'\${!E)&h#&|=+w\"ֱ4o&7D:rkҢd8 + *mz*g(?7E^Q\0>?R5oaQ#ƨrP\"ƅq2r03/R	r@%odX1YO:gNOS3Ђ-3	AE:\rVoȰI^Z\nJnv\r)H~@\nps#7H^&h~fH-sps/󢸓'R#@\$BH\$J_h^&/dv\"v\0EaB 0+kH:\rM#Vj	%R҈\"(mn	޶e\n)x NcC7\0\\cUd>S*N\\nUp\rJ-1ζNv6Th+v|\"5For%*8(5cZ GlG\rFb<sHtxcF	@fnMfmf{%F5Ah\nĐ𾴞^?#\"hR	CVUuE2-atp<t~+-cUQт*\r.d+\"\r9\$wc:ۢl t\r";break;case"id":$f="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9jNznQ9<)LdBjV:p	@ڜP2\rBP l#c1tVKFCV9@4C(C@:t㼌(pܔ@z29^)1@Aj|ҒĠP5H9@J5l<˂t4ɐ\nޢ!(ȓENh7{%#K+\$1BxM#T#؍:4B2B3ppvO8nZ*΃\n\\%or5'#:2h&lrQ6>P.	((P9agTK6	(5Z\\:8>a^͢(3r\$oE	po#wP}U	\"@P]B\"ӱ@@hl2\rܽc]C\0Ε\"VGv JNو3TIrd-42UfJd\r0̴ihuᏈ70[t\$0?Օ7@NcʄI#Cn2RZvad[雪ބ|FBqq r,\$OL(\rxȲի,w3̓2QXĽFe(	rI|r2ѬoG!H0\$B̚9I򎁡h9f6\0ԚYl!\" E~lX{1J(@h1y15#.	9%6hIzD	Q2a1):A[4`_-H\n()\0ĲKBeIa\$̹MBniPB\rd;ƲZW	*\0BJ\"e8hn:9dt|M!َjō9\nC\naH#EI(K\r&P6hbe:\"JfzlTSZ5R*-OI9|H93CHk(𖄒LA;RqōviQqWc+]3%157ɹ3PQl\0T[ȢrhLOH 	inJP䞀rʁ,A3A3`H0fM<JBRy{A a*E3r#hrr {b\$!D*X*	8PT*\0B`E@('CPTȺf`ݩH|Xѡ2M\$Mi:YK9c.N]sM\n퉲Ӊ`v\"Be0AXղd(\\:\rER3զ\rx{M5^[,zW1ոf#\$k:'N (aMRfX2vMMPj.HE\"%6@zxP>hD1wJ2	-,\n*dFPR6!B[cP#N(\$Aa N%f9\ra\r!:N%Z(Dh&ʿh/x2؇X_ʑnУdN(bs)HGe\0oB\$lr\"xF9y~H3&0cr{GR|q	i~\0:G0]	C\r-L^A~.1\"XԎ\\еIjPUqKK(jS`NVꞶrؚ44Kjd(*Pajgx\"pPP&EB\r-Ez-[Ef=յ)je\0ӱFVSykh\0(5p{ll1pޤɞ݈-z|Kֿ0NW_o}X~5{ZqOXaV?wޞ';n|qݍ{lH۔\0C7u	{x\n	N܎A\0jub*z&=b\rצ;ӫPtmZ:st+6d6\"sX-(`^m9&>;yƜI|yt\nGt;u0e \$Uз6Gc*0W_-\\/pA龨ϥ6/N>X-cQ]y2vGo<O	0e^{}-^W\\︅KQ QoX\\>Fo;\"hDTΣ(iůփ/,Ќ%/UbdӐd|\rRkBN~d\rV\"ʤEjVDnEBZPȅ'\nZrК#&8%Biް	%U\0C-8,ö>2k pxb,7\"@`%)\rBKdr(c:Bn4o6rvق,ʯ׎e1Pn&&1UnSP\$ـA`Qr8O@@X잠Hy[eJ'M\", b^E&Cjl/\0V\"/\"b^@0nS,\$N\$%\\5m\r(4,(fd I jjO";break;case"it":$f="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9ZY7D	C#\"'j	 !4NzSfʠ 1c0x-TE% \n\"&V3Nw⩸#;pPCS2u,˳TAE	h2k vI	zԒs P2\r[F:!C1p@4V4212`4C(C@:t㼔0,8^h\rC7Brݤ^0h7=E\r35h7\n\0/K`*sMb6\r60\rr\0<M9OT\n7\"\nL?S\0004+XC{#6C`\nt\n/3c03ǬmlcpaB|lKRP\ns3,*5YTe#X_C\"0)\"`0L+\r@Q1ݯP8I6ΰHK9V.2Rc!NAf/#T֤*0@*`ĦZ&2jo3]x\"/ۭUtN#z)2HB73+	V\r<DFÌATcpoeG\naJZ%K{7).'czZ*2W0Mj7'0QB]ltǱ!Ȳ<%ɽ9JRLtysa3M4Jrl0IbR6*lƴ8\r1G1{ HR\$\$IC;y/94R&Y=@|QM[gF\ntГpP\rH=JИHN;@)0a!.d|bj'o58]ɂuQNP'n8Gh5nW)-EbI		GPaJ(.xVA\0P	A[\0((Ȯ	-j24LhX)\$yNVjr!Q;N8F:G4էi%)|8 f-5,P!U؇!ģ7\np(C\naH#I@A%\nA`L[\r+*	!}d.^D]J RHXy2\$N\rDGmx]\0B򌒆5RpIJyFS\r\$(& rn\"HF겛 #ԆMz7t\nm̒5RQ:1Sf0 R6/Cwp{cѩ9@\$ʌ+'@BD!P\"ڜ(LPhR9DӔb]naB\n\r+C@PR&J@T\"̿NXyFΛ̚dc`\0nLtb!@5ȳc\nFhj	9(_M	\",Z\\{K*8kӺlҕtRA⅝)sTZ/ḽ)*||xsHvL@I`y0\\-84`6+L2bce0[T Aa N\"g1H!fxa,x  tEcUn:5R!o<%Ge0\0@Co.\\b'pvbhڱ_`@G/Ty?h@St?,m\nI]_tA!7͔]FDf#1jZ}BEAZ~çpŕ!Xotd{y\03-y/\n(+aXO\r])\nr}Dܖwovp!,U;,Y\r\\>	vMzIO(f>VTCk%vg}Jw`w[Jeyoa'NkIT\nialdGSyt@HH#tsp:/MEAo PPRĨuy0-y֐\n\r1ba9̪BLf{tI7zoPo藻 ==xh?F\\\"r4TΦiH}\"aTtsFDD<s\"ȩ5sv[)\$vw})Clx/>y\niZ0fG5^g>3bq>\"+|<.co-C/!k+L@#v&Ďp%\"O꙯bGpZ DOf:Yp>5hɆO4\0AY/\n&Bpx.fcƧ[Nۯ\nKP\nЦ	t]ꎚ6c\ne\"ZGF#͸ִ̰DJP\"Tg\"-\0})~#W\\kn=	B&W,)C1<&k̋(Hc\rV8BI[ U.@%	a \nphr/G`%1ħR̍-(b&H(]pfL\"N0T,e~;#qZ߬1nZi*b0X\$ޥf%Þ>/&B##\$1_H#\n4,b΂] ( \$3.g!3\"\"\"r;^@5c(\"\"vB~oQZbD&\r&EEN6\n(\$HG\r\"k+JD@j庢dN\$-+\"L8cg!T\0ޯGF-OЏr>[\"] e2PD\$^\nq\$T	\0@	t\n`";break;case"ja":$f="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99E8i\\A\\t/>B ЁlrjH8WA#	ʨEYp\$r?( h7A\07-h:|8Ar1m)\0+8.H94a7c2\0y53:xG)t3(9xDlJc46#H7xAkNE\$ЎhKJ	se*WXEt)M1\\rDDb9\r@DK\$E8wvץJI.Q @>gI\\StJ\0S\$CEiR9hQ9vs}^72FڌD:K6J1*dNB06\rےK7B&#='&X,E3Pt!	p-V)Ic7З\$=hj?&;y_'ARq8N7AFģfDoFЈXf6*!:u}H<8CtWna͚{fJs,r8UnڨH*A?w㜷6HMTT3e)ZǒbRADP7`<l:̓0ͣ`ҘsOuR  t N(`\$PGj\nTg\rɥ(@C\r!*P\"Q\n)F( 2ReMwZr@*FU\rBz YOF^1qbš(@(fa57(@CyOh<\0Ҡ .O(UTZQH4SJe)o I\r4\"@>uK'Eo\$a\rj.J(I1>'JAλ]@86k@U94@dP~K.r]	8NG݆X<IpCc',PQx-G0 B\r:aIf'@\$9dtOB\"\n&s؏ʲV༬%,˙{>MCUP1Fny6fۆUҘt7G-&&ý&9FaZ(3ԋ5|~bkju2q@nA;>CaNΡ9Ûӌ0TL5!0F|9D3,qЁK+¤r_Ag'\0< qI+a-45ORI(!	#xԼH4,_\0dt.>qM҂!ܥ̂h RTpNxS\n!)PI&bHd[sWU.\0cT\nh,mگ%˺i?\$=V\rH&\0IMa*Hii[mCAR	a [x.SZ9E&	8PT+\0B`EK\"#xϏhczQB%b+r>2-Fm@{b,Ep9&t,5j^3ٟ<7fT%&!s}0ĖQq-0^eEugqZr	(y^^*%Q+\"lXXrdzěy˨gg9\0;Tʢk\r\n&0Ay_VkZLFȅMyMeeOV#{R<7-ixEū2o[hk0&Ƚ̘7HBv4\"1&@@ h#ok\rr\\K(i`Hg*I\0u#7:wF鍁6 DH_T.{0Y=iuas Dw0s(;{QJ4?Egʵ<dA\$ qBN-nșبt,A\\2+}m( U1f\"1ΡdQk \" ER,^YC[#Z زZqbBG]\"+Qk-bY'vG\$oib20\0/>rm\0nr%g(ɏL\n`^VF\"#*pM@%?)^IM\rmP5B\"ݭ[G^frgBE\"0b\\\nLּsE-&mbOΫ-[1\rЧ0\"ق*o.OP찠ZPPnp\$\08	Kη1Sb>e'>/>E]\nh\"E*0@,Fpm\n0b3p+107XXH؍omg+,ʮ\"m܎GXQ?_X]X1@2\r11\nFfaWbt26?\"\00|0Vkce.K7&+M'8b\$ߍv8mF([rs/+D,#ѡ{NN qC215\"r-\n!P+../#E/x 'jl3BM#1e*	ޛ&҆pG[Aa0=ap'')!ȳEj&IHŊnec\$RH/qn\$c+3i7&`y\$m%\0000g\rV\0`uDM`x	8\rdNc \rKj\npuRHF9gn3a#g\$ +F9\\G*c1&֎6q%B\"2nڽ4&,B^W#DEB=9Dm<'9/O <h<bm'~Ɯ8R@H6vIp?Iƪ#)/R	J+\"0'\"`tt5#V%4u@nHtYΕ 	:8ݴ>^o'0U\r%qpu.лC4 @L`G\0aKe\rH2(iZZ.I]ņFn#h\"Jgtܠ@6Cm>'!c*f\0xҍU!";break;case"ka":$f="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-:%/(iZdbMR#3\njsZ=1hAM܇\$ˬ:N[pD6D̓j*SS.# 4(\rI0)('r<J3Z\$Ԣ,\0x0@2D49Ax^;ցpAP0\\7C8^2x0c^xD\n?)^0\n=tjǮT/\r1R?-9Dd;*Űe]sy5ףO7Q+v#v8\"J˨z>_Ҕ'1L@A3202	;[,*U;J]s,CFq#dW<BĈy)m]A\0/OKN(\rċ+(y;oBJy=j6nH.+3Шr}D)\"ފrwh,{+*|)\"e'z(kw3zo*cNsqeBzwSk-'v'ގNEü)3%)m-\$dI-=>|Ŝfzb?;w}T堿亼9i,\"UK2+NP1f.@ӱtADaG3vn~7P+-@wi9K+I-fM%2IeoG3N0:fzsXH*Iɩ*DrZqT@&0ޥJ2K!`>BNy^bD\0r̢;]OPrweNω c)tJPjCHcʪ@2\n8E4Qd(1?ܡGTjSVUzVj[ȵt7LYK6'hQgMIj##rm5NOl̏F&a9J	4bgeKn|J|ApG'RA1uS*TrVJ;eq#ڽW2X+,9ȈubYYvs`SV{9w5?c6(9F|u^(h 	4qfg9W1ʫD&TWMq9ʪ[oHw2׼k%ڛ:\$	F>ɅRElM>@2i% A_&2/yj|ZnIxVbi&ШNu'kt%/gu֩thtkSd^G6XM܄Ey@NP{iƴWkK%6eLRΎ߲&##J4=Rĭr80'99\n\"bK(;-3BIi,˩h7͇9KE|܋1vH(0i0W_trs6#\\zcZ\"c:4(*kCRudV85Hg8TsvAQT25lgU,ZfC8X/m0n96@_٧\rwIi#fǾ*b0T\n3u/JMg]R	^*><0ehsx,JOi  _(\rg<߳n96P2N)^hnl!7]g/X^mBloE#lk;GmXK#u9d3OEqR^f>Y%u̳=r0tKmRAF0NO\07au7']A'2#W+l16-!9z3lFg(i.a[e]*z(wv9A{rG{Hy2{vd\$5'3Cq5tDE#l{}gKj-tzз_bJ\nTQܟ<];[=`RP?{\n.+z؄Yt\nu>=J։BT!\$:8{&^AYyG=8sX.#\"y|ͳjMl\nEJA(#\rn{J)\\fYå%d^\r}CN0^Fwo&>'ȎsMϪL@**ܮ;N|,Ӱ&nnGЧ\\φ\"`/@GN+72@LC(\\ԬvВ/1	kHx(K1>L\0|̦nJ2Iu4iZ5O-,m\rsZf\rւ'szpxJ\\9\0PZ>hf昏)/8utn\n]K§\",ާ^=h;	0멖(EmjR{NΦkOoꀧΔc\"\nק10|`x30_\$ͧdO/oq/ѳ\0,ޢr w^hεfMnJ<H)RFEQOp,\$MbQj4JAJV+t\0007khm'N&)Ҏ'\"hipy)qBARdrxpl'\r>}7ZRV\$ZҺi*|rq*څ	OT΂zdl+&0N}rJ) .|sE%}cNO\"Hhg~o56p4O7k7\\Q 	7'='M9:Cvߤ: V{fhu'mDP	r.0W	m]!>2%8%!ș92@\$\"\$:S72d(R;6d@A<p2#B~y'<?C!	.CQBio/+Qwn*@Q]9qİAR/55Ө4WH;TF^n3GJEBqFb2dS)ӱkVHC52M3+aBQ&2wLMEM1IQJ!f{@A\\N0@DYyQ78#X:4І)(b5=ϻ2ї9E#&|GCF욑|\\Bh^\rVN?A<mSS0gRQ-aXJg u\n`pU\${/K(q!1rO,OFȨo,\$r{K>tێP^PH[աcS4oSYK2y;ff,V|L%BYJ-kS ^akRO0ppϐLv0\$@)~H+&5=|E΄J~@PMref,쏪`&	,HLUfo55)M\\D?XLg)Ri)LMSU6F+jdrfk,SgcK]_(3)G'NPi;|Z'm(n:({gl5b'=^7Msq6pDWu}2Q=h-(>4ݵ{hefDLu\0\r* qr\0dTZk܂DQQU.\$6jf4";break;case"ko":$f="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠝mvBZ!\"L:dB@0R\rM/d!DAL1pt45E6Nga0@EP'a8^%ɜ\"X2\rx9Pc8BS81s\00#1#H4\r;C X90z\r8a^\\0˒'	x7HEѡxDl%?4\$6#H7xBy<BiNHEIBj/Eh*LI\0cټŝY](9ZuEKSIr[P###X6y\$E0PBDqaG(LNπJ#3:%gDPv'+:cA+TT&8JeX?N)+tec6OEJL> H #c`A=Cd9c\"cU%sjncX4}\r\$T=s].vE!Smtû=ok߸G{3+۰Alݰ8~dqt7]l|wB|ȔPeH=ʜ	Aw?䌣Uu\niQcO\\Xڏtaz،S\"V>90JFJ̐5nT#,6AB\rPܚSrxϨsQ9@@	h\$0eDde-H5FYk@؃ZdWA3A<1 \nMJu2T!QP܃rUJ0`试`\"u^e3bV:\$K\"zrJ \$(BtDZZ\\&ןrL	\0ҥ .R\nIJ)e0T\nRD%NJUO9FdHm\rx6!A \rj3\0tiCMH	r%R&PП|_W\0004ƴPV :h%W\rP*\rteh rBWDD'HkH\nPUIv0:~+e|B<YAj+8A5XlA2;tAt4.*JldND6T\rC(\$Z\r1C:zS=H0F ft'l4Gj.cZD)%-vvܚ4GLJ2RaFDțuGƐw\n	H)v\\u.)X:T*`3-dRŒ4mY/r~DxS\n`O0-b׈{5kC4F`/u2 w4PP\"im=VW`@)(oȦ`/=s ӊVKIy1DKrEĜ@f'x&EExϚqߞa*aNtuvGpES`Ls,(!/<tF82aD2%|NY/\nu1svhuWQn\$v#~34,߬dCZ3zջ~Z8\ry(QFAJ/EBhXIT%􅿄h9Zv2׬Pl\"),\0dl<䅐6Lpmע&ؒybD x\\.U4=]\"-Hvp7bN?IE)U流qPnD^bvE7%\"#{_*@@ <44-MiQ~-EL0@=́Q6tx]qx\nd갱/^&W%;i4;Xh	jתYiҮ~ш\$aDsDU\nDtKZ@|0R	rt9oUnxhٜ	fLٝe+z|^K̓,Hc7<fNu45蜭c̏ksgr`hJ4sTEP4\$|=\$v\"#F8a7H*KN*ɡa-֨poʊ}~5R5:FghΏXюɋA|3h`PwkHZp0C{n3n6/NF䢼0'- J,N,V ΃pJ\r\r\np\n0\r\npc4<ס%p)&\"8v'DD8/̚/xM, =\"<fpq&+,!*<p\0]M Pp\rF1-PIK	gY5eѭpJ0؍.PLylq<3BZ,nd\$0/\"clmåNHWk0 ~l\nTM^8\"\"GG\\K	#r@t`\rT'.>DBD7M%&Ihl22%\nzr9%S&!G5\\Ef&0'hҙdTbRs!pΩ*CO2	 Prㆱl-,nemL J\nK.=B?b=H-Ů1!jb>g50+0%O0Jh(\rV\n\rgAd&FORV\r ̀( \rLȃ@\npx56<#%1Ou/YmƲ,4\rpge;D;2psg#_<A\")i+\0kXno\$%2Ft#<3(+Ȋ;@Nfg&8dfpk<\0@v#Ɍb:6IA\\!QE:s+E/0k2LnVy@#F#QIStQ.G&Ff/\0p`ϧ&fC`0d?2&QtQDmTraj[0rgJETF/ftly\n!\nMf6F))Fin\\Ak)a00Fe<!a`F\n&";break;case"lt":$f="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9X:9V>B94-\nc`8	_\r\")#jHBȔC\nB;%2\r1+-B6@l4c:1K\"c\"l0\0;c XD49Ax^;p#\\z#.t\r*Vpx!H \nPR.bckx 2T=T.6͜kP8Ά\$:B#b*	eK;@8.j>|4@ЄH1*@:bX:U)K/4L5qކ#;3ъ\$*c9B4*W	RTh5\"bTBʔ\\̆*9hm6\r[Zʎc7;%4c.f<BtC8hr4?اQa&Ž\rv<>K;\r,;!H!APoKAj3nK݂'_(5roћa:>7%4hdB)JrtA^׼5.JR91ʍ06G4D:*\rV7:P:Hx-zK,fGu2R	U\"^-bRpuLortSHGI&D̚RlM;\$PxOAУ!`\"йOٟo\0=B	z尔@ 	44+FIQR:O9,`/Q&5JkM88+\nCyOq]Ӻbp.BB4xt.!D8D]k,Ӱ<!#eR40	M!+  zX33~ß*~|ԑ>6\r;`!\r^`\rԱi\r!^Gq\"2DB*PP	A8.GV\nJc=4g\n!zE.٠ol</%BWeTl?DRC>C~KVM8OK*Ήpe\$<P\0C\naH#G4ZX LĦp]E]#)jH d @o\"ɣ\$ZK˃HBeh6ӆCahI5>'dʓ^BɐGm!\$D15G8CGmpPQ&H{6'0OdFll\\_zmdmB\r,\$PzRaՒ(YU!_cYsf:3hsI\0ψU`5)oi\r\$@^Hb>漮7A)'x@*Dt-ՍsJȼˬ)j0ʭW8~osxlVCr,\"Ȭ&;'n17\$}Eqj`4G?\"K9ԙY[y\$mK^DKC.P)}eVŪ᱆G^,qء\\\" ޒn	\nlh'\\K@AtdGsV`:N20Bw˽~PLjݸoo\0	^z(JiuTW9&gt\0(	d@\0 ԕn SgH;g<	,yS\njpy2\$(P]fJ)܌%_\0W3qYq8U\rJ;a*@@ \rڐ-ܗК s)KfVM(A^p8Ng3dt3B5~>zQ\nu`\$*V)Ӯ@Aw\$\\qIcq]*X+y4| tOyO7+3{_\\39UF9ՑCّ1:a=KO#KPdɺ,0WpΆ&% VdxŀMg#}N0*F-ZN,/gTazOz۞,_/=o\"t;r-0bYYD{Z_k\$zS>^{ؼ_zb\"Y/f5Il;|p%peŃwFg /6bP\":58%8\r%[ @T&RƯ+2q#\\TLm\\@/P8a.W\0&\$	,0t%K^7}\0[0?-Q욐pł%rB\"e<jJQ=\r\rlxp\rpdRxi7:հT\"i,:\"<\\\"#z#}^jg#`x=DӮ7C@(bRK'σ,.r-d킪V@ϑ\rҰMQUP^zc0-/pۢ)PRUn#\rDNjX <RdZi=Џ\nі	1\nw ѠoHkbc\"\0R!PTÙm|\";2#8o׍PR`@prm,8ؑ#ҁ'Mi;X@)NABdj Ғ*\"Hҹ-R\n g0,>TBY3\$d(% r!M<#X8~*6q]!DXȘa	0Q_P1s\"0,>\r31261ne*\rV\0`tCE2Pj;\"z@*:~ \nps0@\$,^l)!3#Ӕ.~s`#[İrppϥ\0@B&\"\"v8Rb,b/dp8@Uc\0B3Cڲ96\n٪`޷E\nJd48B%\"O|FXs^3n:kh!BB)\0R?.*\$J4UF/ LBƀs\$z2dtD dm\0`/:E[l\naUqF1fe@hd	'\\T Db^4RnҀ\r	G6=-N'bGl&Ɩ\nME\rd>]:\"KeJlv\$CQ<\ri=͒>,%\"@! ٣\n2)O8";break;case"ms":$f="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7rf\0633Pj0؊;IΠ::`ޜ+	B6AP2\rK\r(拍賔8z,0cL'\nu/CH4\r^ Ø`@ c@2D49Ax^;ˁr΀\\z|\$\r|vԌzZ-!^0(4Dh* KÇ\"Pɽ\rb	.zhP0MRp#\n<MKS舖7蔟10\"Z|7Bu\022PK#8	\$RzC0\"@'ibn0j0:L\\\$(ڮ^	-ݿpROv)\"`ߨ R`0+(wRj@%)cȉ4zţ~[MJV! \"YՒ@1\rڔ=wiQ>Þ7&K:'V޷]<)5w٪~-n0Pٮ\n7I3lQ*n#o1YU	NR6')\nG%&\n0A/V*D(2s}sP0\$S5`(HARW\$ͯY@74HܘI҄*Jĵ.0\$7\"Ҋ+L8'#Se2z@X|22-LB?`)GrKI=(4[K}&0S;Uje&0:5@94j3T`\rwtL#q`hGh<z=!:#8f9ȈTb0u#	xB?GaޣƓs.!o\rRD<@@P&(\nIшeҤU\n~:0AtFJ'\$/('l\r\$'4N*255K7RGJ;B!Qȕew0\0F:UAfA7Bq<ra(؝>P4ĲTrQ6&!8:IBQ dJ\r&vI0!l}0\"7C>uQ-g9B\"<)H'tPe\r8gBԤ@I,lT'D敻IJLF\n#&jz2xdCF5`Qh\n	8PT@-rX0,+V49Sb\nRI@ %GQl@X\nh@ك%ў8	VCj78J肙媟SAhD&zq6~>T+AXDqZ6GBn)H]!R6!\r7b0Hb/E:H\n	Lpi`%~PEpk:9lkYI 0؈j_r\nd̞OKlؤej\"#cdA\rn9>ټAI!a8i3\\tQ@<S'erJ 8HZ8\\܁KـIJNPe.6BA2#yFUWmX>Hv	UmЩ)\"dVY#Ԃw6PnfʔJ^?66kx\r9#@֋^`j{W%^YLT#L'~'5K	\ruK^7R߼0G;~ԥ	݆6IOӼ_m-OB.GϤB4\"<FrHxd^~'XW+g!LŉKji\rvLZv#)\rz.Ќ'5\\>ڎyN&ON؇czkxt]_x±{me(Ki\"yz}~E`'>&(\":1BF<ș3*yͲq0A7dB9yQ sН#ʩW@]Mk\$tA}}&{_wnTtߑ|7\\O'W\rK(Oa:^wá%ONgi(ڙ[B>FT(viO\$2D2RNʌϲ1\08lɰ\rȌ%F-ֹ\"ZQ\0YϦP<\\p5DN\nC\\ƐZkul Yw.Qǂ\"Y0b/̢lh@s		khMnBUp8(0%VG@ƅGD:*|!GNB\$k`-r(5B2\$@\"%c8\$nlު\np\$6\\DBvi#m8	mL8H0++\"Q\"30X켂Xʝb\$(RB\\\n2pROn_[\"b1\0oNl.5mУQ6&n*6REJfu\"hf`\r,'*BbO!`@l8ʈĞF\0`?##z_V;4-?\"\$z;Q&8Np@\r:\00l㒶`Pm@";break;case"nl":$f="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n,ঃ	Xn7s4'S,:*R	5't)<_uFĜ'5>2vt+CN6DϾG#U7~	ʘr({S	H<\nhk=oj9n4OP7%;ãR(ڎP2\r'@m` pƒn@<m5O8x3(:7A^\\+zft2#R7˰ڡ+x!j	.CW+9jĊe:++üͣF67S'+í44p(JCVilBXޗb8C6crLEëT\rV0̮0b;#`j,#uq1uȋI	!3%\"PÌ#!i(@\\]sח#6`1&{Z9BP}28OT	ܐKMeSߐP+ P2j\$<6cȈƃG22.E5\"ڮJ	* Cj*`#\$04k	K4\n7\".K3(+\r5&YtpA=	OCHϿҨ̶paO+ˣn@78ɵ<㬃|ʆ#4JĴ˲;qe3SL2,S8C:;O<**|Gːt2Jc2\0uJFpdR[{1&GBj\rɩ(dӐs%%>kNlJV{L*\$\r9f	~͓*~xZ0T \rs!!Yt.9PEI!E0`cJeڌlGPC#.@\$#\"!#a5SAUw@)cb4aҚx(hS6h!@b^E(A\"dx2*Q6\$T	\n4m+`V\$g) OX.E(q9dv-Q5&䝓P,8D+6l6#mh(Lz@Rg\rSJo S	|s(2^͉Mp\0 -iԨ=k.Nșc_=nFx)4kazI)TI@^Leb/\01@ia:*HbTZ<`z!52C\0\nzF\0U\n @ED0\"ez:@a@G`3`tܿxۥFm7\"synD4k3P0qK4f!4Rb(i0(FI*:bM7!2f6,I:*E9g1'1cVcq;IE/2Q\$\\yNa7Qq؏RiC(wRf4<XCVHB)0\"v&9zz]i'f0+80Caʁ%{(`*ކ~:fBaFxwPBH0\$\"9\r\nV\$r\$@AWʙUgCTHc \0C\\&sJ)#b7b_cbf#(pW9#DIgZה\0Z|9MNX:cs\"Q)܋KU10_:K6z!<Z	V\$}\03E }5~;-2?WX\nQ'l`K/,GBRT2FrWxIUAS*e4#mwZ\rKU	_vƱk㷦Xd68#l0SZ!*Oht<:niňB'SaʨW ,5`	(`sGZڦlAΩ?\rvtRs̎J\nd_&͛vqv٘߼}^ø}u_VxVW񝛐\$XkuFt5H[pm#8tQ!L`:DzRY4z>:km?~eo%Y C8X/[5`dT+l6'2\"HW|n4\r#jTfJ9GDnPb<_q:0[B\r#ǎ NYs/\\̱PL[l2S#ip)o&]vê饈L8TĬTn\n\nRe9P\n0]'D;,ADg\niR=LAp\rWP`3 Z\nD!bf/cC\"!eW#G5\rϱb\r\$~!vCTYb\nm_Q>\rNUR*p_ R jT=\$krz&B1C.ʠsg hv@\npn\$R&\r& -J\0#ˏ #4(\">\$/⠶`gb%l<> @Q\r`DbzC6XZ;bj	iPJg#xȦ#(\$Yf:0.B2PRVB%ß#6%HJc%Q(f*c838Q0'KCS\",]v\"8DRB`k`ΌE&\r, 2t#BE(@k'E*QEì\r.*R%.bV/2l(dlD,r*d;1:\"}(\rZ.e.C|%F	\0@	t\n`";break;case"no":$f="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+DyٰG#[NQB<ΎC#0<2.[z?Ȣs69k` jءx<p:kC0c>.A\0@2H4\rN`@EB|3Лt㼤1p.9@a|z9qJ(|63-f7^0H\$b\nʂ\n:<#X:+RՎH;T3T@'.#\n7-8憌\0<\0HKPi>%-\nUhڥ/\r`֟V269ò:3B2*S\0)5bn;-̨0~! P#BC\$2\rczc\$\"`Z5:4Â.#C#tz\n5C+\"	-d0D+[\0\$BeLH\0V=A >*r/*#D)z0\r&2	\0܃N@)n8'&\"@~ަp\$e3p#+OǴ	1\\6PA^~RGc5B@R¶0%C+GC(P9)H:B:0iH4^؀c{JT1KȁbI2X&*rĵ.\r|:HD}p%;9NILP\\xpZ0n`*y	nTДj_@\n bCHĜwJe`lM&fxo/@!7Z0٫19Y\$  :lFiճ3p4̢Q4TDb\"nCfo\$:D+v(g\\ٌ9s)DE'H!P	@GO	i'4E&M톖pKYDƉ?\"\\lOA}wA<Pcwy5<M3&?\"QSF7t@F40\r.=,b.7) Cz)0dfP̒VSy12HؒR~C	k9Eb>d|ҋՉHI\"!C-ʡFE1&/ABТ3f2iik}˞( /vL`nHE࡮O	)hӔV	0gP|s15\"8G\"\$ҜAi&`%`gJS3U)e!`FpܸL\n@\rP*VQc E	ʑ5[)?j<eHYhZ|L8 :\$hI]fJPU#bUYL5 &a\$1>'!h\\12lٕo*Sr9tJJIi*	wk~B;%<䎔ig*jyHzATkPD=݄K\0QJ1>탍1(阼1a	d~L[rҖMa		-P߳,1P d)kԾ\"5]AI>U:f1(eAa Rb#4) R-\r&ŢxPKz\0#2\0%\n4A9<%-b@Q!Ȅh.@JimbTzvC\"yr4e!H&vGG	HK܆4s`wS%\n2:Gԭ[\\U-@P#`L\0Wloʈ\$ފ\0001f%>+j'_(Nɋ3,@RXI81u8_⻌lPlS\"PZ土-/&lZ\n5*h2P`0\"j02\n@]4uOl;u+%-{tVJϪ@\nь-qeTW=]*SSDHứ)vLo@Ps-V\\ۼkY4ڭ‟4Ftbܸz-*vOl9G0c\\O{'Wr7+N*V_+4\0Ŧ~bP/3D\nd-|J\$0&her7,-.ĠoƠQp\$!87Kds\"Sp̬PTBOhd#V&V)n4]@\rt]@T(\r<0.:NB.S2˰n\no6ph#L<?rG( qe+0Z;k/#PV8NbZ\0004Pl0m@z0;쯆%#!.m\n_3,\n^gCȂP)0mV(jPf	e\\T	V EDO`ՍbQ@P\0``\"ycJ4Z5ڂ#Nf\n\r%1m>1\rc&x\"`b)pͮ8J/\"H8qΩ.K:j(m˯\$\ni.KfŎ#\\olDb\nrj#'ضfR&˚'ʘ5Nr撡)2rf2&!l7FEˮ#2 \rmc#lT_ܥ\$2Ze2Bڶ\nfJ!GuRx]@(#%\n1Ҙ0\0ޡ-+i ș:A}'%!Q`";break;case"pl":$f="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7,I()h9<	3\$#R7\n7#ݍxcK+5\n5DbȺ+D7`:#13¾Pʡ\r#7c2\0xC@:t1xOx*J̘^*^7p7^0ʘ5)D-9[`-.CBCM;@Ϣ2C\"40H\$\0005M{_V}\$	cx:\0*#7B#p[.\rn9)JA6+UHP:-: ( L`P2Hz6(oH0Rz6a\n1`Һ:R:=փL 8oCIcorH>n>\r{X(Tn;=]E\0N]'zuZ9ItAf#R>CL6*.^Ao>5@P6w@\"[:*J垍j{S!-YĐ@ˎ\\9s(\r9£\">ph@H:Ԍo3 Ѕ72-.Ce.:Ό2E¸3dniZZ:0jʌA;S_C)jqO	W6,KgEkv\$1_/Pgp5 KG:%hv~CɰDa',Eے\ni-#\nxoGuIsڒ[	t2*gM)6dp\rє>4e		apА\"D&H\\(mez2RB%%3\\v,%bL4&/Sz;F7LPnOi1KхH dFT} EA	aA DAVZW@ oEΆ(&R+5!\0hhIh3a&IjA%f {&\$U8%Ikҭax/Q\$=\n6C(s6Ux(7\"^LIvb#S.]pIh'.\\k@)A'bgQJ(4rt,g	b@b	N	ik9DLCiL54l@,R07pÚUJ4]C:bU0[*X3jy) %BƲ;Gºhm*A6\rgvNI;ԃ/-La2NP&(_MVdVF E\":Om>A:|ySfX2N 1%pvJs,+C<LK๪jHź#W·jZLd^G,JH#\$wR R|r<D<6`LHK@oX3R!\$|lSn:-?7	ݿ+9h\nw#L1,	}sΨt:fīfgi(2Shfdfq*(Qg *3@5B)gyej\rJƼ)|ү\03PސyiJFBo39!AC\n@oZ&1Gy\n`2Q^t5٦i]BZC\":S#h7!eC#7MXЦN0¡@Q6 ߜP\\xb(}D274\r3=!HϝL#[:|҇P@L_,l˸T|g` @BH#uL{TT?pu\"j冭1E+6}@Gc\$5]_ewz\\2pg{=^C*?;2vv<xLGv{OР;%z>݃7719իy#duF\"F\$ʞ#K8-\n׉T\$zdl*͏CKbΤl'St8\rH)#QI_G, )yw)&0C\"j%&ш8CL>	~4|\n%jsaFfu(0N(DbZp[PaPXpJ\$\"&̞G6\0\ri4h\\\"KV]b\"@W4h+A`004`\n(o@w{ZYZ\"\nV,%D,,ѫlq;pk117x `ڴH9D. JM9M1gmE#&FH{1[peKe0Y*Iq.QܹBlMvFdCal(+4	t\$F_Vjf-dGb%Z]mu4qv#YE\$@)v-R!CK\\@	Pm((llm##	p9%PQaO'k'Jܬ_)Np.U#8Q%q.\\('V6o,2+a+T,,R%,p3-rz&HZZc8c,Ie <K).^n\$vǔ@`nq]Q0-䑛)M3sT\rh&јG*5_6ƾHETჺ{D{N)8a_9mr&Vstl'* \"=R;A@A96q<=(\$*ӟ4.==O9㤀)dgB2њ<\n!EZ3c;AOf/\0/#j!BqB= C#7/Ϛ#6*\"Xi<EC2!8-Fh3qOF#(&R`*>ei\$)ú),L1,FtQ#B\$]imIi\nZlj>%nGtoE@MN2Һ~JM\r\$Bb0B;\$u6㓌`4b3%'Mt9H>FjCMV{0E9d5*\nOFd%#3p;(U\r\$&0zsQ` L0%SX͙WP PXEO_W)-Y-bpEZՎa);{R(In 5v|G6\npP6p__\"'OY,T kcK\\(1Ɛ -u&0mb+\"3Q\n-{XayI4\\GdF#X\0ͣ>e6\"\r W^>l!`qگ|;W ";break;case"pt":$f="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stL@% L4\r\nh:T8s㫞pȔ4TX.pǉ\n4n' P2\rT:\"m< c<ܰpP@;#\rIC9430z\r8a^h]#r.8^A,C ^*΄̺'{|B-xƸ0,NLJ\r]21+ѫűU<9T,;#\"<̶P\r:(\0< MaX!`꼧#J=erL΍Ch09\"0:g%J15e7\n	P㋆6`7؟>|\rm(3xbi6jr {\r3157Zܤ&LYRUlGIqEWR焾BWictS#k0\$Z[PŭD@!L>\"#2]N9g.{e%(q:iպocXRKŮ,.%`U4m*Y0I\09N.S&;ޠ'Agc؎c5ak%.<^3+\n42SHy=Øx8曧-;Ph\r=GCs2CLKRL)2tҚhwM9 p/)EAD<1G>xep&0ĆRphb3#]>,BMN.K~D̚RlM@䝓Ì5?\rz9p8@R6o\0005tGH;2[ 'vHW%\$	O4[T&i\nVՂC42}/gR7h\ngP1%ac.\n~!&H@IKqaMƄ|@PH- PTI'+dŇ2<I l'07' s߬[#;ٍ?I\00L9굒7ؙCzA%a ^EpXKI<(],y9WlaL)g6&\"KB]\n\n'I PJE 06R?!A.%uNI&~ٙ7uPM7N()\n\"R7X3`xS\n,\"Rx㔸 譙`@ u!t 3&?M)j@n0gjEM{Ê]7'e\n5@FaȒ i#Sd2(L9('@BD!P\"KL(LtsrB9X0X<d 1jL朣X0řD(ʎ4VAhGiZ0(U7FG43dԻ=nVsZkQ/\nsUVҪJ@\n\nrEs`T)i}`\"VW1F Fb3U@a\"0^+1eW7@nLzKP/F8ո1Ɋh\nܰ!u.^[T~\\*@dj3MDS6FߞH=O\$o<&3ᓨr\\1tALRHsD+-\$7\n!@K>u4)#%%`rcp2Ƃ׊p@CP.knhf/6=U++jBR{|;N<OflfpM|\$9rR60O{	\rߕ3G)\0r)ˣgdȫ-<B120Ɣ0On\"ˣ'*1rfxbqG<q7ɴS>A<NjBsbfc)!|+V4MzdpGtvu`/3o*cxٌwtGn1\0( L\$^>5SiIpqD6c1>OmE0:E2_GVvsBHX\$^ZAEecUyQ%dw;%3򿑀/}QX>vqclp.\rMqBo/\rܔ˚f߮v\$)don5,\0+[nʷn`JC?H3cdb6e\r@/jxbkdTnY\"<#-[ PRj-\0\0:TNƷcUN1 Z\0WZU/jӫ\n},[\0.#0i*	m8 +!Zd̀\$>(܃*J(' :\$'p}9E+/FTp%\r-)cyQL;FZ\nBkq\$oON}br:Q7'OО%F˖b\0\r:q0\"p\nR[]qB}0d=\rJ(XVB|@\rg fRr5H0BX3oJYc\rVca+\n!D|}`P3qTݢN@*k\rH\np\$T/\n0/):#<I	rFk	Un	th\rqk |bX'\0PdLDΩyjat]#bFh1W26E?rV!'Fe1*Ebk֎'\0006O0\\Dnn~'q(|v:4*\r9rI2U`b`RF/3*0c\n\"ˈoE'@T,Jì#&2:2I6`͂Cbh.i+<4n01+Y+ .6*frM5\$K Xg 5 ";break;case"pt-br":$f="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM83@ij;êBVB¤+92`޿x䞍Z#\"\nKn؎v\01I\r1B\0(j0p; X`ьD49Ax^;́t7ar3X^8IҀ2(7z^031,c\r@P<nCA\r4@%\"7LSTMJpޯM\$\n\nx(CUlہB6\nt45A*7m#jƽ=0:!`CkD:`e9Zבhtuӌt(0I\r	VC6kn:7*W\nw( 6%2ji*&L[>c( ([3F\"B6!}f5Wl4F#lpB(񫲚\\Hlh\"foYC,ϸŏkA3/DX0՞Ӣ#}&;/t*Y+Ў2LmSXx3\r\0,t7)X#6n_)x3/q|2S\$hHS\$ާ\"\\7`:q[4R)Թ/L;wMsh,\rAoJPR)MMɂ2ja\$&4IrVpPV})m.*g~i9&I[:	;Pm`t@\nbTP'Ȩoa!`ΩM@ɔ;iCY0h>QwIxpY\$ѡKc#&t43ߡn#L:nn!^&(7\0TYqdbPNUnE!srH\rP6ͫ[?TC0id,d\0P+'Q=(R{	8\$@ҊF8!4D|d/qӺS\nA=C4I CĴ(v!f(E\$Z\"D􊡨A@rp!\$VJ4\"Į%phfƜ= c_\$\$hP	L*3sĉQ3ԇ' #FT˳6|s&		MM'd'ݯ6#d2KK\0F\n|+25ҕ\"N\$`Hc\00\0P*[, E	ΑzXJA`K癇.E.(G*umŰ\"^IGU\"jDt*ͮ\rSm&~3zo]ij5TvQXBIYr'h+<G\n:HS\\c&N*\\.Ct8ͫfa:1f40\njqYi	e3puMH_	e(+Ŋf'CFY#'#\0_j\0m=jL1|护CuRS,T\0s\nlؤN09 IΊqM1TQ`T\n!@3t1#ub\\3JyCzVzUb*%=Z12ǹF>^(g5%F8ybɮbLZbRN1X8` Qu|PC!Z!aӇr/&expQl,nb&黩G\n\n/?ay01DV6 +0ݺ6Ɏ)xecIsX%\08-/_W(db0a>O600}bוO`\rϱ'Fn;)3`fAǗ{xHB]4b8}v,f4f8@&YZ;o8v+j<S>D+n2fUFoh#\0j!fė,kTA\0,Ywg]0o{/⼆,^x|)T3K2(!ۧg.8?Bm^'[KaO6Ω~̩/\0\0,\n(-Wf/%cC\"˦\$\$<.NY(\nXJh*od%D>0>,bPR?#h/oQ\n=+\n̸?hk2Id#6]@&%/ȬOA\rC\n\r3oѥ8>Zλos悌о	:+k@(zDX#8&6e-IP/PfQa,&n,.\"vZ*:z0J0\"\nhfžoF̫͂l@gFd&xL\nX&bμBBQ 'd11QbXIbzLш3er\$i%4EQKD*ڥz_#b7#0o<2ra#f\$u&Pc\rV@_B,\rOB9qLۣ2`Z_s>\rFx`\nqŮ2L'-~O\nA	-'ok-%	#<\$D\$\\%#0,HE\0!/\ngBC)I@\"g@[/rDJO\$4=,C\nDatS\"n,6>qIP<N\$ojR\"7oh!gCj71LZk7p!#Dz9^;Ӕ?*,`1\r쌷`{BsJܶ~pxh]\"8a`4slG`꒦;ct3/82X0ĹEBbIS&QW0k@/V*;\$G\$@~/";break;case"ro":$f="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)9j6If\rBpK\n@P0`L#1P+>:L7\"p8&j(2L肥i@2\r1À+CƫhKHlS\$0!\0\r\r`@%C3:x;RAr3^8L32\rp:\r.x!6C)<Dh̥C <o-UV\r5sɍ\rbANJ+ăr3h\r:!-hh(k04Q :ۏ\"`hCsm(2\njtm[bF%1,;&bL;V5h|@)E⁏	{2blȌLΐ&9 V415V!ňiSV4-:Ưpʃ(7M˒bH%C:\"魴(i^в@\")ZpZ\ny**rʄRz)	]EiaڔB\$_?qB8smh6F\0Sbր3\r\nz\$*\rt<'̡3Fak(aJm}^5Ҵ枊S^H3~ɚf;npÕRM84úyH	?zD/P(}RRe@M		 !	L>3SEIMK0%ỡ< 3ӂrN<'SP,J>nAʮ\nC'UCZ+H9#hf2 LA%ܼ,Su-ldɸr(egP{ρqheҞCwK4e9),چ\$od9\"KnǨ'乃r;iLn\"oE8r8̐\\SC\nq!ǚܻG#jijߴ˒X!W}FH#څLh4Gy'үBOBS\nA;Gy	F*'L\\\$QJ9m\$`Ffg\r4m\"VHs%_Ry\\<\$V|4!gsyX+AJ<t,✡\rI+50Thy)dH;pd!}BRK#\\BlI2vAƨſ']\nl쭳cvK0T\nr>US9FȜ&2Lo%dѕ3ɐ-]vubje]R\00S~n*E't[>IN)8ܭ.gC0H}\rjNțVxAYuK*tmx ta\$\0hʒ~nh>|1iV %8t[ͩ0@!?Dģ/92pGeVk\"=S[mQ\\raj:D2V.lWt:E\\+N`LRa?0 1mJpWm\$R\"A\\2f`KX3SRvs_İJ!!P*?&StpL0x/eQh8A)cXkUgkPQg`)\"3Ը[W.;񻌎*;nwGj-:Wh'z6+}quwweFT VWD\"`q*eoG䥮4&|G:Me's9qPx+\"3OaiEuݨeY/nA[ٽͦg6*0RN)b\n3W6n܇+G22&J`wJ:yyIo|ҺxnS'UJ.\\8y{`΄DJS&յuɊS2唶kMH({!CuBd0i<\rpX*}\\濏L*p5Y\0Ly\0´oG*: lnV,.եD.U\r0.ND-:cU@50D5L(lh:F&cpHoptЏ1,H\n=CP|**>v/¥<,cMc\\\rc;'D[i	pxo.);elFkLGϨ[3VEhoDLej%~,j\rxeaL@lGL OPL.reP<oT)F F[#ƶqBOBB:@aDCob~S\$:c:ZYFaQo:-Yq:-^TQ\r`\$U1WP9%D\"M{F#Jw<E/%\"єzR@o.Dp>Q!#FBBbom%B\\fQnh@(\$n?id\nA)[): 2d'K1:\nr3D\\ NW\$/T?d!b@2,hFqgGcX/Gm!%pdCE.R	S1m\\5F\0m*W p-Fh&z'~fڀb\nZ2\$>.Y䥅x|#,b:#B\$gcGfj̄<#4bOo4\">[B 琬,Vp !bzFbm8xDGw`_bD+Ed_cW0W12, 4loLS(QƥA40T826l2jd Bmgm@/%_NƼӤqF8eRt`b:Ed.XF8/`@ZVp,/:% DJB:nn4\$-0\"fPjt@\r\\mhxQ8\\(`	\0t	@\n`";break;case"ru":$f="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$(!y&h02XE4\$n)56d+RC<%NE3# 4(<\$5BϤ>Bnrb_EV֖S MV<*\$xX@4C(C@:t㽜41Mx3(9K|h5ihʵj)*D2\\x.#ӴֹN	a\$̙,dO!iDEdnG&γ!6]C L(IcH9?3Ά7:%VN{օdk⌮~Kʟʆ5 ijt\$;7voL67l~Խ*|۳@\"]bR&){>3zD|꼴.3GNdvJRDcBaOT}6#\nM{m!\\W!%t(9˞ݻYA\nb\\\"#)+\$\\F,/=cwi2	W%Ac؆C%P)0,^4Xx繱VM)ёZpda\"	#`#?9ؠ	˕DV@D\r!0 KsX-k\r;Se趃i\r9^RÊH\0004O!x\nkEM1,hq5&C\\=ki6@,I3M_QTDochsy|yq0=gUQ)F xH#uC*ա#C`RċlP0YBt,*19%℀SN\"Dh%VNO)E!;\",IK#%F7%f9K)	%=3ЋhGs6Q.3uwCb+\"JaNQ~Y#xV>LZ UUK9'(-']BǹSz\nXd֍%ZYl-^\"Xa)m%h>9rx,颙ZTzN(b.mS?L%\$\\=4E&*4\nIGd-QyGUe+Nu\"Y)f,&Z]lEL\\hH]ZsRc\r\$9y:W!GUID|*z\\ldիBQ\0zŒ'XYJ;/e('ĎgMlYHm(I\"weQNۢ싩<DN\$!Sݓ,*\$\\#衪zd(.@?rFnTBzCkcPHLb\$5Gj>}5Q[11+vJ(Y˪\rub}AwJKY.\\ٕGcw^@7 FR֥3T9ǧB~\rPQBF\"GdFtJR%tdҫ9K6T(%Q*S\r]r_a@\"	٠IZN]->e\$\$g췑XͧpBFW\0£Uf)\"&*k34DU[@rLRn]{&?Iy^4`8T*kLOq5xu\\&A˧o%]^-b\0O%4ӥlh8[Kvd+_ȝAnVjHg9v!~pA:#zoL̆ER#i*ROd}GJ8]8&~)L!9>.Q[`p1=	J). o3;aPd'Bv\raYڐxXr	d}__ZrP XLyƧBLJ!AA@\$	>\rC:.5z)',Efq̆7:A~CψMp|oJFnO֯ƛCM.6F,c-@bWnd\$'ʸwBa@|pN0gcn(LLΆb|\0H=Bk)&Dj/IzPbKn@/BЁPf0\$e\n]>nH&2bmG^aAp0ATC+n/NelN\n 	&L,QK&NPJs z\$g^1Tʴ\$ک1_#&;H̦&+z\$|˰J\nOt0aqnO	Frzq~1Fre,h}MX\$qѸ8K(#cܖ(*޺Ɲf2\0 /Cur .\$rdFbv@`Ql%&\"XNT/xv!%\"C%b%n/-=J\"¶0晄(2hH`刈vbHLic3F'2P,KdmdJƠ>2ЊA1nG8N,cC2lJ\$%/Co)`E0K3NH0,&.BFNO,R3[3=sB/s4y@*X@bdyfLB)P33FZo,o\$u.B\"ZMOa8tILB>%i-&pLw\">PCN\$\0R3w<&65i/2`lL4JC2JFYAߧU4Sl5BEC=q56pD3i3EfWr0QBsY>TJ	F/!4g\$FÂaAGR&e*TR~t1HtcH7L\$oIaIьG}J\"%DA2l}4m3ΉMMΒHGN\"CN>BU:Ը\$*,.jSk,I8-B%%bbam͸!j!̶P]?0T\$4?LhU0ibmˡåNV>gH00е7FB6<tdЌ!f:딗4L#,:f3A\\r5Au1Jo^;6]]Q\0^c]]z+O h;2]P.0S9bV<)|j\"!A\reBBg0\n˶E@MZKԖgH0VfPgLQ\\A{3+hUK56c&%+puֱ\$DQIV&I6CkBp>olhadNw		RPNt.В!tMpaEpqbcc~[oЪEqq\0VHGO*A/O40!]WRtpi5vN!vworWtK\"ShKtx+2l}Hbыt2k{41{vd\$wfxʷn=jbNuEÛ*sy}hr{qɗLt7w/tw2G{#0dB8h\rVS{º]ae9V,%N{\\Wk,#2'XUp>UVmZ\n`qrl^UBol	ωladXlUjt=ы}{c	.V-wb?ckx'|p6CxWsr\\Wۅn9XF8P`\$hvAv.'e`+5f3&&PL(o>)fl!\$qDƴfOtH;UH4aGbR8q?IQ+-9|y>Y5Ƶ0Z'Y3;8\ru	>r3S6C~MxfNP\"t::\0M>@\n`Ko\0\$u\nDPm\"\0003>Z?OGG.2\0AjGff\$}dPs.a]YHt~j:Btz-SbSZ%n046\nfՑ*TN%";break;case"sk":$f="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0ɾh\rY83Nbp/ƃNbaaWwM\r+o;ICv\0!F\"<lbXjv&g0<zn59\"jeHڇ?\n -~	\rR@n0b<4\rp991	R4D#( j \"x5#Dcp0\0000j`4C=\"E;c XH2D49Ax^;r#\\zrԸ9xDj&.2&H7x%\"8<q*2&7c@:\"\nC6\n\"44'WVmP'hv5â:7<hJ2:6=e6me\rMh!t8*RP7ՃuPPbքH1C-:C :R:T0VL:co`_/P5*#(C҄JŴX\rbkFc^\rc`0	1#r(bV:&|:&Vl6PU=\\#-.J ȧ=z\0 P1bCH!^(>{Z\\;^;R\$\"6ʘ\ns)ZeGGiH2de26q6Ɏ4OI۶K`9.8r.|l꒎x3\rR'qCސcp`#I5\$9/0\n}tu@C\nbCeD;\"f)\nEIIh:\0ibQ0ƙS:iMi7ӲxOAfTzй\ru\"ʊHQw\n_E쬔JЊvRJ)O-J0&%BjM8taBwI=n/8n UTǰCZGp9=r!Tm	yt#\"<MA\$X`6Y/@Xf6DQ>}M*8EU` ^zCL{/`ƼV\"2	ĥtVM|\\\"B^)0\0PCQ`1ԕ#Ԭjͪ=H7v<JBquiD4X1L\"p-8_\">w\ru@w6yt(LgD2\n~'!0:*L \$\"o# o8d^ǢXK2{dj9.N&Wǎ./U#@%9RHXy3\rONVBU+8²2\0vRRQ>R<\$\nO\naQ؜n<4ʊpIU~6h (!30qDhe\rUxt ql@_`b.`)\n<{*A.oו[A%!:@3Y?\",3]Lm8PT@-WEŲj>XIYPet+T}%9@S\"+/0\n9h6+tLeP\",C%(eDkg794|F#IŪ5ߎ0-卻PXoHa#1bG@\$\\8g\$Ld\0o9#Fbb\r@\rɸ	mL4e:Avݎ)0X0ʹ}X0mvfNubSD\0J1Bz<8QS#V96#gh4a٠\0PFQjue&<[hU#F,ZI#A#cP\n!A]O1TB\$\0'\r죔|{ygt֑F₵Ah2\0foRT%S\njmQZ!\n&᧓2w+ߗs65XB9Y\rlr	IyF]slHQ3+9˻?<qp&YnϺN\04NQJ\n\n=.jAM9VL\"D%Gu+(Ҡx9f]p8\r(e{BAU̟3\$Pt꿒d쇓@˵x/:Âéгl~/17rdPP>#xIOO,|Z.oFDl@\"~o\nͪ:B6JG\02  F*Ov#eb>m\n#p^Ĥ(@ElnnzRE.Vl[Ɯeo0ʬhp\0Lt-ȐG\\\0жCq\$0pP	n\$\rSt\$ p.HnT̞\0H1/O匞0_m\0quЂ1\0Pmt׋C0HLPU{vURi*% \rExEb,\"[@\"C(&`ڦW.KfYѴFњ\"(Sd.ةT*CVS<\"Ѣ\"®H\$q-~+WBg\0Xm:փ&n9bźӭ>Zp]\"c#nqXo#!#6kҒ.:(BR@ǰC&\r4]&'/\$\r<|1Tl#)1n48eQb[\$|SӮj'Qt p4B-SW&R'p\r-+҃'f@ɆU)|F/)-\$n\"JZѱDؑU&o#s,b(lM3|Pڱ0%k4m)f5XAgRvrm)A|425\r:ݓrw\$d8D!7s48n4.:A<do1{01TLr,N5Se\$bEH(\$\ndWƚF B9&лeJ\rV\rg?+8\n(\$T&He#\$% 	\"G\np?#cΨB&Zꎄ'nsy3too')(#4#<\$_%Th\nFm^f@	\\6E\$0<\n79L%\0	޸O4c[{!B4bp-0a\nQ=*pRX-\n-G'&(~0,\rnp!23Q[T\$5c@'F''*FuVpGր/K\"'?:#\\\r\n(2~Y'*ɤFT5\nN'K^mp%\$\"g51eJc1LҕR-^,@lF\$\$nlj_4RT2c?#dAg{abvB	\0@	t\n`";break;case"sl":$f="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(֫K (a֘y2B;4B0B(0\0*5R<ɍ0d j\${4ȧ>'1C&\n0h\r\\J`@&`3:x'ʹ4Ar43(v9xD\nڔ#x|k(\n[X\$֌)+<;.28M.'\r&2#(\n\r:*\0ĘMQUU\r]TcRKY2%C`2`P4\0P7k## 	2OfB\$0bk\r:K:+\0C ::J5Òx8Kb7ڀP4K7&*͟k863.h[?7&-C\"mc]HrMUT=%\"E;9Mu\0AN|P{ZN(\"@P\\K(4K[\0@2MÚ^if)Ay\r#fh#CP*Q!dSÒ[TJ3'J^'bMC{%5=<R3[@9t0_)P9)|\n9<s#=T1)QǸ6w 1,#IT'J7*̶2Md1߂<Գbj*x	cz-ش (	/	\$<l8\0B|i\$úQC/+\$mKM-0Hm]d|TQ	!=N-GO7D`@b\$dkey2J3bHaT:Qcu3F@a?1Hr@޿u9	<2`ICBj)@\0()\0d&Mo%\r7̊2aN'.f* E\\7u8֩vA@ɴb\\g1Q.8pw%R c(h3x4ǘ\\ĴgaL)h	7F Ih5؜L	4X뷂@eAF!dJ1\$IjU@C؊	S4	V6Dɋ\$v]#M! q@az?H)t̼\"\nNIO\$InxS\n-:@u4IvIVo	H14>H\r,UE2 K0#I@BKD̟3J`nGR1Bȝ\0sf̤8!H2|QH'cA4aY(7uuG0R'Enb9~b`f	1MȡfyfgQ]b<2a;CtXz6\0 )#\$R~  cq'Ù3P\0(-Eb2	Y\0\ne` xripN\nȂtI>(8_0TA&^͑nY6y\rLE2bLLܐYk[/{\0l>&%q:qHź\\PFMD>Y^O9>'w<'蝡pC	\0.T>i*#_%N[&j*^Vy0u\\iJP⫁Y㼑Cu@doH+[l⶙F\0uU9Տ 2%u)ϗ6ϊu7Cغc9uR\0k6K{gblcga֛-Is4s\$Ր)/nnzGx*ut\r*8IyN\$d%T8[cbAxs,\"8Jb#يsi*f/BKض>P|2ӥGgϩ؂cCsAH<\"\"0y>/k`K%bND.Ϋ_\r©dSR>1NFk	xtÕ*stW%nƢJtfLhf)^IV\0OZq:O	HL,9\0^|Ƙ]z6cX hvP_F\$\nyaQk</ONFt@'J(c\"%E~\rm-{x9\$lَ-80=Bo0GJNKMm<0e`LMPV0L!/@7p!/Lޏ\0&vNhr̄6K>WҋSL=갨`訣d\$`*b&J6	ғ0δ1*\$Ȱ\rC\$|CKG\r\nlL7~LRlzW傞\\U(\0ť\nC\nQ\\p\rRan(q`oWLv'\0QZlѐ(c%MŀO2fKw\01eGH?/1ؐͱLp\$X]\$*fK\rqr\rejPgq0X#\$)+'p8 =\"k\0q&J;!%p,rL* #Mn/ϑЍ#'RA\$Zx/cb-1!ʉP/8Ɔp~Ǝ+g\0Bn&#؎:3P[,R\$_ܱ\nqKvU+So*rT3,1Ps1,S2gf\rV@'~7(%(i6\npl{bTi/E0vc8ٰT'\r8p7+ӆ#m:c&@X/` \nOY! ΓVr?)7&&k I:\"ܲN0^	ޭ\$ D\\`7>F<\08\$b̢f6B(bBrRKvCϼ':64FPs\n1E#PC2\$4EIQE)*2Oho@Ť/*\\<	7IBt'\\CਫƳL\nLFƷ/\"L\0+5\084B&/#\$ދ*7D\"XON6@2;F;4%pE&i";break;case"sr":$f="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9<12?b0QȧsֲσT\$R&ˋ`Ϊ\n|%8	!?/,nLS L l% 8Cx:cg;#p3#;.w>8H;c X(90z\r8a^H\\0ͳ|ix7%JC ^-07^0γʋjh#,!]\\(\0Tl]-򽢂)w¸9\rF#>N(aa,\">S\$_R:^HHH'ixZˈ¾Dd@N#;:ZMyR<C&3܏k+u\\9s',̒wlC;*	sm(̒܏H&fyHYrRsJ]BhX)\"b	5*銥I^̪n+1rqQZ5WI\rIy|J	۴J%޾ԪJ~|zϭ{'gaMB 2Rۼ@AwC\rd2(y!\\[SVQb6\rؔ4c&N(\$Yr7&B)0lMO/4Bo87@`uO\00033`@xgBAK@g(HEFpu:9>5li\r͹B\nB`6E`\r!8)zTJS*T#JYVHR-m2xk_/Iłe!ĂDuザjMJJL)\0\nTTuVCr0Y+H\0\$W\$6Ut I5<%N6`]!!N\"XJi(y(j\r>`l\r1|a!3KEq\"%\"vN\$Ap\00igP!(!ב,6#yq\nH\nӗ#^&4PȚ!H9qA9yNYYD,fnjmLc]),COUZR2\\0vha3(v)Pcf**跍d) 4[04.l[*D\$B;*ZeTJ(;\$湅ZTn*>Q-TzFJ	J%yh(A\$X#k\$Jt<i3# &pȸ1ąJkR9ڣNPHP	L*Tn[?f-1#eIbY;R[)̒ڙ)uܛ%CL<4HUY@@f@P*Xa\r\$4oea#CL]odnäp \n@\"A\0(dK\$CUO\0R@ &\\ߜsZ\"Nb	tDZŤe>+[ZWڲ̸73XІ%k\"68'r2\$2J5\$h:ׅj#5lØ#|RZëX	 P)sHjZKiwt1iEuE?p<1>2Ƒ(U#\$2\\(򰴑]SR`&eIw#zJCS\\Jo:<&ڶcVPxiLشBe9urnƐٯC.vNHei5hǹc `A:HxI\$Lmp,5ɗ\$Ԛ&VmwڛކawF%*O7h{+A@LꤢNv)hZs9LEzXMaP*F:03pӸsO)6Ʃ@@W.a8y'P@ny%\"2Ԍ(	UR?}U%Bیf7Uk*ڏ?k4/n\\@ /x&FOAʢ]4~&Rg6M-\"i.ïOIOǃP >O/3Yp^~+aBЀ 	Q@F@\$bJ.,)Nkj.dFOni斠v)\rHo~D 0\nv_!.%rߥέk~,C,C\$?/[0JO*\0ƄBVmK0Lq*d?'.0*n\"ooP#Aqx?Mpbdwl:*#7kc:M*K<ON@F@8ll.@֧%	Dۑ[\$Q&1S/z4p>f d-)lN2g.\rm|t&GͰҧ%*ǔvCM&D2k2pm­&''pl.5}(*\\{l\"`>P\$e\0B2q1+0R~pޯ6&(,\\R\$R)o,04<,C%E,n(R!0\$2^Ql\"@DF:.,B>\"q2JRJ*s:*Ve!61 F2ZpFrPLDlۇ`Z!-[7B00/3cN9gfxƷm-pxuHqQ1CIF6֓k4?i3(uO8S)1q2`k\"sB&.QٴB5DGL҃:{LVHcXyG5\$:J}Т>-T1*-3cCyIRJg(fJi/o[5PuJwXhMMl\\vK&@BI.iPC2\"NAMKC\$@Hwt8uI!%\$3BfH\\&u-u[VU^U)\$UR2K>1-JBDnڒAO`Zb\"<_[a.0i3Ԫt\\u=oBҿ./\0pu`u3.CL/`5r`К\rV5~.T*n@`ֲ@Z+BbZa-վ=g_ϣ/+fN]]m)5Nβv]\0\rY>.9)cM:ޏ=_b!/s.>&:j]6{1\$ϳ,dv0_N6\rF2\"֕p{41AvnHf\rqq	d+q~ew;pwO)֍njuSΕ2\$50B\0nEmҕ]CI)8D?83iyt*@OYum'ho3Z6tqj¡=sr)A:/B&v.&E\r464ʠ8Pm~^cPǧSj'";break;case"sv":$f="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5dymE8Ye*	(8Ю\0000R:\nX0ɒ.h܎6z(감4((9v֧A*]\n\$9p@%#C3t㼜\$Q*(8^9(^)0,&px!h+!`ԁ\0P4j9X:AC\\\"p/\0l4AM#X7ů<\0UF6&KC<)\r \rt:)o3&2<\$x2ӈè?\r3K ;	/C0VB< 2O(];(:'\"d(O=59p)\"`Z507X;BPiLh1A@RݾMcFBAķBp0&,\$l94ÒQk\" X3:<:B;\ndd N8#ZF3Gx-[K'ckr8<-V2(0\r(x3\r\nh&AL]d3\0ڍ2#2\$52ac<[H9l0#ssSҔ\\\"7#ɔA-7΍ͣ]t=Kl*T)'\\ӱ%\r,].0^ys#E`J]e|)M1!Ȳ8\$rl(tp/YS)6 ʖk2D`h0 }%WUS& :` \r&` B葒BJI8;ȔrJawRaf<``>kH*I3~\$e1hZB紀 Np)4^ܥ9TQ8H,ֶ<T\$BR\n~-\0ZB1\$08H\n\0L\nFꃛ'D2`PSIIy}|H8IED5@eɛ\r&\nOv@b'FRfzs-5޹\$IdyRUQUfa*E\nȮO\$04\r(\0K%&9N*xЌ^c'4Hem9p^PptS	Omve0\n}A[R))A dUX`s\r\$\0 -FSQM#/v@Xέ2%bFd(	0b^ i%!*sY7ʃBFl1rtITB  \n@(@(R	!8#BxR\nP pjjT|0`o]Tp+tO9s{h:Dd;E^HF\\>w'0 PUH&M~woXבFůB\n@X3ܽBP[RDE7%@G!eHmT&rRZUR\$pGk*(.vȮp	p<xM\r.	bA1&aEUIēcr4\\TAȹ:_TIe\$nwEd!*\09QܿB\n#xtL#&cBƑsAQu(;?}_fOmHWaVD<wi\$iH\$1:M1]d#nOj9~Fۻnjj{O\nZQ5rn)^I3Oho5v\n{gϣa,\n)w_A04{	M^{2T\$ɱ5\nqW5\\SySビV[~,h1PE\nF^w{5iH^~a6JEBm9V'Qtq{4\\ϓSߘOm\rhUI׾\\Рd\$嫫oO]0Eb\\/4LW1\r\0x0Rmq:缰EED aUwl|c<\"@\ro'OMB\nYOE=)Ԭ&²[s|S\$ii^{v'v\rù,)񰊤j6)tU!u5}Hv6GNai,ma\\	h.e#kL(MB\$荆&HPϢ/\00FB\"',m0FPH,l\ndZ[\rE\r\"5aJ_4\$v:#20\$/Vϝb}eZc.:@eYI /\0P>WBt\0A0,8V,p;-lXi\0002e\nż<G?q @q#4\"DC\"\$zL|PU\"	2C\nɘ[ؿ0{mB\r3_n2b'j@S	#SnnxQZpR11Aju&O``q*)\"Xg~0\$5)*ڞcP\0\n\rɞթ\nұ&x0NUmƭ\"i\"Ͷ}x#4XN(n:cR\\Ģr	ܥZ Dh@=0j'Bj/-ā'pE@ax1t2Sr*-	\$4.С*7(/\"r=,\n>t>bicM|ib%.2~0c.\\+tɢ:_*|0k+xF\"Th4+2\\*e⒤r1\$'EU\0";break;case"ta":$f="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx\0O2~)#6nzZ*ʜӜSU-I\\BF@92/\n)IJ6l\"D,mEȌM%YVAC&E\"lUB/N l3 cx(#g#r@6K4@;/˹j<;C X90z\r8a^\\tMC8^2xu]L\0|6O3MCk4px!\"4\"T)Ju6)M4[5Kcq`GU\\'\rwŐQjSQwM6ʚA8b,62h7[IJ2FZ\\ّNeKQV)m1\".3Ћr)gґmڢ\0T8z#g:R	Nf#p:drB*g1)3Ϗ47g/OF*|ku?#﵌(DEoEh+G찀R'Q,PJywn6{	\0c!\"RK7du^;Os-Aoƀ߁i%7\nm5_NSW֓k.GPѯVؤX-(@#U6MCoF3]ph[>nax|`:=K	T(	&ig?]I\"S!hp.DgUG	DU4hU@왃9`<F\0&Q>VP}h[I|\nt=	%C=q\\:OM^UXE!&;G-EW\r]\"A UQF #PC,5@)Շ vv<A3`رqM6@+\r;VΨ0ΒKq礀AG0S@e44-^\"EQnHR`c1%x*|re\$S:llEN^}/X魄d,PV>Y%M\0[ԅI43w\0%\"\"sAsS d=HdH \n_B\nM\\'ޡ0jf4@`j^|w`kc1l6*{(FJ +C[Y3Ы{ZmD(\n@H*V5Y\r/+OAZ2@C⹁ʠC5ZF8E?'\0<\0c4vg|mhLKip@td2c\0\n\n (Kps>锤LfwhSzOYi |Z7|/'3J4nؾszoU=Lh-ֽLHMb-;.i_xPuRx!0A00]:fZ62]!3`úk^jǈӁ#P-2\r-l4WmёVyMEOD_x5~ABXcef*Zi[]uS'Ri I'qdyz\r]v4ڍk5B͉15~rK=vTL\0¢^n4U\$fF<v-	83< 6z&PgC.;<8m:76&RP*Ϲ8 =Kt#LKi;`@uqYg:.o	v P*^ E	¸@y~p^f|͎r5(*Uy,NŦp/^2y[v=ZiB+/y\nE	?]O-!Bd;Hέ=c49IF(c'6D__t'=]yTHxjDv\r ۨo>/.Xm/\\Ƈ\nׄh찐ʐsDNx~\n= JXD%\\%0\\,@5n\\֊snh t#M `@lJhx)d8Rx}#\0l9DA\0^`RPf.\n`GbNgb\n`=~g*8\$oBpnkhG..pLR il(g\":f*.b`B1ujnQ*BoY\r\n8Q	IMNjVrEhx`qf\nJDr+,hRB\$:>R,\$/`./֝PD)-	\"mo=hÌ 	\0@\r%LZ\0ȣ {\"&qCz#fX/apF1A1.ʎ^DCM^GFpD%prlrm.	)`\\,FBS i3q(͗)j)PlHW(y)&Q\" \$r␘ѯ0\rgRRl>;2_+g2,\r,#,*&\$\$/p,F3P5M`r4](28E熒Mr惪'(Ӂ5]88NB(S()MY*K\r%R6O)hm%l&4`ONv3.\rq9[7.fm4*qbe6Q,z)3TseFA4o<&Q~	-eD06bZ\0=PPp-Jeㆉ\00`ORI9m~%5,bsCHҬ唇FIΏ NeQ}IB<q5KCM4/3ԱѶTFiӽ/\rMt\rSGMHVOJM*ΑhǬ =p7؋!NRuns2r M B5@AJ#RZrsUV, %sgQދ[k-)4YNjAHU	Xc*\r4u\0+R	F\\vD\rWUmZ2uoOI+ڭiNM*1OJ2^X\\lmȕO;PN_u_YY]a\rPz+3T]Bs`P1R\",-Ra-JVY:MGv7drmӱ^L]^0f)\"q=\nuCЂHk=%2.&S2nUb`:m6=VAK0UV!btzմbLTIqcXq/ZIfdniZ,adI	g|`@rH#~hA6rP/WGqDgssQq1cLqtw#WV5g4VSO5 dWWj*'ЉFawn1nu)U`?H/.6ׄױx1zt@qivk{V-luyy	`dx1c~#!V)K+LXE0ԧOtbE< b~\rTe7t8-nxsgxv8|ON(umC7\r7}Xi!na##e:w\n渟Y88݋e쭅4hHQO;tr'RP/mhtJ-T|\"QiVe;}vaNL=hi2gӈAfXe*ߏÈ-tXDw|l2&ykWY|fC!!i'r)ٌ%,';%~m;oxŔpTȐ&YYd6ߕыXQa;˅+\r42e0C~/Z!xWqaR\"'Fj>mxUɵP8;qpO>y.xWZ\\ zIekzY\\+MvEF}0IX'O17ٷuAO@l1,B!S.o5ZE6ȱ/E&B&-Epg(:rZ5o8ҝΎ_kM+߲o<ZogUi\rV`֕[Zu ̡+ E<\nZ	^n~I\"ǝ,fW1nǋڽ9P{Cegѻ1:ktNwC{ {3ch-~P<S*)ҰF5VUӷkM,J\"&#}WG#8yA\\3qKȊ7w\"Į?m;	F2[3[ZCT>6K=r7뭮^h Cw(GzR:PƻLۗfkZZU+mmˤؑkٿVՃu݄@C;ϠaZ5uu	ˮQ1y/Q63O,A 	Q?AzI%zQZS.\0^cj)XO\0\rcd'mƆ8x @rG8*0v[LU5yqOj'\\>wI@Iek/P>}/JP\\P`\r>-cзnb=wu}LD	\0t	@\n`";break;case"th":$f="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\rĐZԻb8+q1a80¿/\nzL)5''Q  Si'qyJS{J7(\\1圔m<W;CN* l7 >xp813\rALگ94C(C@:t6-9N#8^2xuݣL@|6/|3N#l4px!,,Xy\"mӷJ!riJR\n4`\\;.8/iLƎޣ2<R[Oe=#\$Vr=p+#miȓ9P]@ 	Y,ÉhFP+R+4v3qI%Ɓ\".	ܳY-sm<Y6\nں	@\"^6Y6..B1Gq\\i*ث\\.3:D>%Ǝ|9Vũa%QZ\0Q+5󺞧z:{qcR|浗ZB7F6?ca\rψ\\9*QH \naD&5PR+ZjȈ𩳄WYjQ%0ѫhb\0Ǌ<TŢ.cĘ2z{HQC\0	?%l3;#3byQZ8F0\"ވj@s%m\rѴß(x@m2\ni(zHHAH\$x;e3߹ 5*Z8D̃4 rG60f\rVWhh܅@|n :ft`6ΕCaR  `P((`Zp<WJK<֎,pm rbh?p9LEěɹx8C\"^Gzu`,\r6S*9F@A>}+26JV٣/9X\\6\"Kb.%),p̵ST@/x\"ǚvɷQ`&\$?Xxs]6Wdy`;Fp.a,-ǘi	!8&Wu}!,\rxfʪLj8@Tg.[2@CcGÇ)]xa=hLuTS=6.Ts5:^KP#i)LLc-;.s'o\0\0(1\0!HOu%%QU*(!g>G[zAmo^I>Z,ncGo6&l@h7	mCC:W'nBK\\  aL)fuKIX[C˪`cB.UtD=\0\n׽)RnX,-,Wf\nl.eSsNS;^:ICY4#`A^ԇ5m5db4jc2C'h{sEȶBi6yU*\0!ĳQh.d`cu|אcZ[֞}\0Sbn<a` uM4E6'(	;;&j8.\\!E2p \n@\"@W\"Gy==Z^sN\n~]YSC\\FBӸkA+.BkXCJCuaK0Aw\"09G[aB<+2\0Kj*YrsѮ㦆ʒWk2Zظ]~wo\$̖;^KTIƖ\rԓb\n#\$'>2.gV\" ׀EV&yzҎ3mCgēwL!^K3CӪp:R~l\0ij,Ko>;MZ-\"L'cWQsP%p	'~òqmef *|਄²B~oO&>?iTDF<'~vo0;DM1Z}hԝ\$^(ÌnEV+q\nn\nlF fKރ 	\0@҄\r%Z D\nHڇj\"1yI\0^3DWbvi	\$&pā8wx;m̃~)~\rL-PZje	&+O(Uo0	E\0	\\@N\0mCh+e&#2}n1p΅K \$	0D5|pplF\nE߅gȑ&1D&*3x 9vBpl~G#-\\6b\039N^!hhfD,9BBk\nZ|)\rbH\$ǦB~-<Vd;\$2b<hychez&rQ\"#\$P/fҁ(82쒌Ro'1r/He1|Fs Ȭvd(oCh+fj{Rb\0PQG/r0\$|E1\0.i(8zSBF)32H|.oJIN*+\\S+j3,ЇK\$e*(.s\r+/6wM`ʦ7S\0hT9899	C2s\\93Gy'i0/h?\"_f;p7 Id.PDUHIN7s;@:T;05ƫBҝ\$@Non&ÍBf\$#Q;N8&Hs,sLDG8{'fɓB3<;jp{w<PH\"3IFPTEsco^ooly=׎	@L4jǶtK)\"4iG&o4xi*h\$DhSPWA;?N7Eu\0;LlTR.14rpxx јE\$ӧ3<\"T4A\$M::3QSwUQ[RRTӬhSVENkuRk5U<\$e|:#h+̂Xjhg\r9Cȗ[5rR`]'uI7Um]]5PӱVW^<ң9tSC7)XU@@ܿC2UVv>[\0ꊰ<\$vEN5cU%9pۂF	4뀩A`ssAumg,aguL3}a-2gEhp*URVah3a8cҥj֕1DGYW5T9	R3<PjB+\0	%Sm3	VJ6Q6gm	\ro=3\nnbzP\\Ek>ĔoW2HB _ 6fmyG8r[s+1a<rG^39?[oI\n`m@\r \rm1S8#Rۧ݀Ɖ\nZ[q=?5\\;bWDmY5&N})5f@	{(^R 9.gyEnhK4UNS9ҨXrVnfN2b+\0\rc[xI{p'gη-,nwC\"t.ua\nh	dDil}sHLg!*;x?6ԋwإK^6}_=`a\n<Xϲh(FP3!]D+vv?Ks75QI({135|qDIhFKn|f\nŬ\r\rONRB^'=Rg#N̇ǩ,lOCE_1r3p58NF/=έ1\"J\r@y&+kU轫vgBr\0	\0t	@\n`";break;case"tr":$f="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78K')NgI,n:]gn|c7+%1>ň#(Ħ.80 ܏*#x9\n9Ɏh03.H4\r.8FC`@\"@2D49Ax^;ʁp\nH\\zbǑL~9xDjJ C2J6K| 2`P0	X֏@ȯj*cJ:A+s'IҢ\rlba(ț0CUUR%듸*/h'|J3.uN)υ8#8#Z6OUFc P#떠(=^.4-Hϥ0Rlc8oȦ(P>-;w<<\nP\$OҎO\$VuVOITd˔2RTBR\"ׅ\"I(z6Yٙ䙨OY\"@Tg>S(\r\$[t<=rjB3NeTRք{=ObB-4-ϣP::fhɥ{I?,\r|0\00ObUZ\r. ˥\0\rbUX\r5\"`.<I=P&S=pྨ|05|2ͥfv5utHD&I҄VK\\%ļy3m*P`|@,8'keQ7'Dj\rrfCB\r:bbS#%GK:*#bGw02P\\l>\rZ	c)%%ԞRUJ\$+p&-&p)L&qA|+ \rЁ:ԉ4&|3`d!&rhCk36r`Gɮz}E|!7,\\S|փy`4C!2mpr4I\rBP	@Ku(\0Rz)82 ʦqXݖGP*E݂\\ưH	q9cG\"\$Q6\$:`plC\\9&fH7M8\0 1a65M08GZzwL0FϜr\r,2a'gvc^Ag3ZYd2BTr\rI<p<<#\$mF1DfW\n<YӈwRy/`(\ri \nsZwEDSK#pC9jGCeMPR^F%ɵqsɳ\"LU>B >=5k#\n.Bv-m)07BRe8+P*YrHyG@@*d\nnu0\"[vC5ۉ8q5Ve\ncW]B\$阢9(N	×(,[PeA`pbQ OMAmg6@3G\"-CihK(k/j \"GR\"6eԼra39\\,U;αpːnS\$+Uɩ48A5Bp *\r-nQY09KCumLW*\rym8\"͑-r\niJ'BN+k\n(+v\r|	Kg\"v ׍I;6Aa E%M9!t/^UՃ0A}^U]A:75.]\$+0}dw>rQoO3wpcYx\\{ʶ񅐩3RIՃRNJ\r([Ӄ8sy:g35aI&oK>Eⲹ{;y;PDyd#&`Ca+5YE;?yC4 .Y(7\r@I\n2pə^	lf1κ~ʞIUv05~SRYK1g=գR md+`iF^S/(5ɓw?CTHJtx@JjpfuX:0zf^IZ?GJ@d;(lPb[\0D%tHp\r*nt`PnBJ-Es?!b:&J&;m\\aOP/@kխ^q+b/h-Fp	\$VPED(iΆȃ:jDD	\$	g?9&ò=\n	\$>ǨТb0BՐdt.F\\eRR\rbQ- Ѱx@\"QkЇ\rpp͖0Q21~ّ/H&U[FÃpN-#p\"Xv(@GaO&YAQW\0J[\">O4\"Dш[C\"WQ=sO@b`\nmlX6MooE(1-gQn;:>mo/02	 hjl}?{D@O22keݣ2crR,wx5F2Ǐ\$4O,?łϰ*UM[0U%Vn>pZo@؇\$#.}c8 c`%.\0re/圭\0Z\$l\nɨa'&)+\$(-8j.ln&\n\"Rh&qlmQ)e0cfUG<}\"|+\\\"Vu/\n+V91on0GVk^W,@O	Ȓ%2	217j^h^e6__8` k\"AB!m(.P7QP	2\$OL\n6O*:Sjo1 ނf8.o|lWR55',#@Ô.@3ig&10xТ(s7-4V?k\0#Rqs^-Ч";break;case"uk":$f="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвPp`ͶJbDbd*5\"=[ލLZ\r>ɿΩ2\\Jhq\\V^0..P2\rH2K9Ţ^媊yJ:D%rcd-6k2xX@4C(C@:t|4%\rDx3(90K8}1h['B/|\$i\r͈Ħ0'6\nVTM#eijLXtWr4k\0BbK@JRD`J2Tk^LeF%_e,)#hH(D@;K#D>hwf.8l70j0j65^ӻ,|LE\nܬƯ4R5hjsL#lD_h`Zݡ2G2hæ͈~-4\$I&\0J!J.8!zzn&B&k:fA#Nls9mS!Г8'~pOvo.BB )FN^+(T(mi%^#qo\0h=`^*6'1Wz!<ڻpD\r!0 K0s,;#Q%貃i\r9SrЋPӑ2&L@8N~dʝ4iA~vrm'\\CaV6IP9BhIދyTzSs)ɔXWx. ;C46B3(|]`\\^de7qF(pq1\nAP܏=@XZt+A9+-d\$JLfiUFAzRyGiE\$\${~T)E=-EaB %..Y7E\0Q|ƈ5u&r\n\n\rBpGrE̵XV\\+xXSbu\$3!,D1q.].ԐϺ:ͅ0HT\"5B2G\nA)HƜtGLTK,V/JY]<\r:\$cWg4AzVj[vUc,at0Qk\rLB)5#`|A\$g7pxO)>JL|q|7R'I@RTsYM&K9<KNx2&cX|ʍ9EС*lT][zLbHN29 :H[#\nԲTs9b^6h|\n (۱^1pSafqT!UJ( k5[4@\n1-#cRmTTK\rgh_]RP̴(!ICos!R\\عJLH\$^w\"K:T4}6fI>.P01植^R]'	]E-Tm<4C_Pŀ'rA\rf.ﰕ:RWM:-<!-bXip(TM!7B)%qAN9(6U-F##L_O:v.!R;,SN(<5}PtL~%P;hѡp\"qb^:l/JeN;t&=d:%l]\nR7ZxX{wP.oWpՍʕ>d5r%c`RהG24܌r'<4PהԗJ/9Fee*b7r@IZ1)K}Ar|I5!\$ݴ&ۺ\nM]%BZJzٸ-nb=^N}.6^rd4Qf]q?ԔE姿b\nwma,m/d_cAH7Vu\r~\$җvD.ôg-*s\ry7ĥ\02ʩ7}v;s܆KQ|_;@\raDl\nm\n(`8Outl*2&|RJsOܪcKIhvg:8\$ŬL^&-\\>d*4XZ\$z	Kk5\$\n 	G|:E,G>H\$*w8^FZEaEf#qs\r,A6w)\"N\"⃲g0q\nH	_\"pfjcJkOOВӑgeAq#9և,w~4`'Z1l8P#pӎ\$_koQ>ðVf20sl:챆6067ڗ\r%|mw\r\"b0]Q,qXl>Jm-v'FJf(Q2*D,1>VcHLGGX^\0&f2'4j\\KNF*^&D@DȎ.gN,8K^p&(X#B,b#\n/bo(DRҲfgҐ4DcǰD*Q*nT\"%*\rNf2lFw<>m:D,\$ez#CL&['C+%3,kPoqB2*ǝ)*e2{tǼBd(@Qt)r.m,`IE:(``eIstlģ3||sOms7/87,4NzSӣ+͟'2\05rh1\r.hUq|cd8ϋ43A3ʵi,*=ex8S4<?S?a=k=I;E8Pp2.23't;IC4'QyE*CCY3|SEdlL0k8Gp,)(Fc+S/T)<L8~bHIH~Cp`qJ\0thn72͊rLKlH+>n#EQFE\$^(F{}P#5FL>S4ORF})9RSGkFh\n|\nBKS=DAE1rSA1VmVUJ;HU~XPP5kD*ZhBd>~+ha'{2c?=DE\\!T\0^7V=UTuXST&{&xbyՎ5BrYUV_	`fV6|V\\\$_\0gHE䪤TsE\n]OVQd-WU3T6YUOFM,U{`beϏU/	b-dĮvF=WK6vPiq*tCRT6.?_yT!J>~61_1Q\$+\0G>[\0[Gt\")ooS{	oџp-'pvo8pm.φpgK]N[r11ѽop\$<vkSr>qSF1!BKv^uUB~@ pHl;lQJua67B-b4j4ZQĀ\nqIs`Tu9,(_4P9<7Ps~MCK}5Qq&Ij|.mp\nv\r;J:AdO#t%(rD ED\"ǖ!␊9,@ve`-.,2yLİOxi3.@ՓnR\"Pj<%H1e*88Y,DXԱSZW|5{ы8Ui]I(ҹc>p\0h?oTbyaP_x,LRPǬ%-r\rt~hAoL\$ \\&*-/1&&n\n`X澯%.iP+sLixP{D4=\$j\$qT.:.sMRH#XV8<1u+N,&/NIS#:-#\n^ReLCH";break;case"vi":$f="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7ĊlԶ	;l# \\	Z:\nzT\"Pi>2AQtV\0P<0P6( 4#p k=cx9c|(91cc :#9\04x*94C(C@:t2,?#8^2|9^)̮7^0p2oc,6F;r\$V( ƀaHk(jxed_3C+#-(ȼ#aH!#t7%oh&L4h'dH+`=#\n:UVnv'Jv7]2pJG+5%n]7Q7,tWëZ^i\$T2H;FR!	\n(ܙ7(Sd΄[46)8@)\"`<UPYdH!b&WiX©މU\r\\WCx5EXMJ<1TY\nP:P1pwL܈ǲH0*?!!vgsیŴ7KU cG8]=~H/A:\nf9@\0a\00\"j23PAḥx3VpʥCq4@xũ\$:RHS1|454vtـnN\\Q4xrJo䣭pPn2\"QSIBRwCZLST]\"F~:7C\"HN<'P;rQD2*ED>QL	pP\rA@tM'eC 'mbEw,JX%5	!D,.\"|(_FnKSwO)>*Q0E䣔xJA0=DP(b>}f>\$_@h\"TH\"ieQ՚Rt4^S(p>6UC2چA+̾HoG3h]  鄿94܄Aj8 --TAvB\n\0	3DxKpI)!R?`0to9C<MQ&;\$f1.9k`>u&0曒 ;s~joN!kx)0gO\"5#mcA2PۀR4++34ЫጡHݺLĎGSbAp d.z7+%\"Dȸ8OuW*e_ 5D˰ܵO&%@~9Qs}[ޙ(\nLMdDB!/d^xS\n,s\"-We틮fGk:'nNäuJ\",V\n#]K\\Ux䀫˃OmA#J\0s+%=D8r]EV5ZMqH\\ŵe(Nb%jr>\0A%MNzaYaF#tE\$	|\\]ԏ@YEs2BeTyd؋[[s\\\$=D1Y,g.-&|&tW^Z?xrw:Ȅqg(\n)ӞW();tK0%itHktZK +\0Fe-a2.kCY\$N9X]iO*H\\try43~\\7N懴&7`%	{t-N7\n ̀()& d![dcn[oǖᆄ`A\nP 0\"K}Υ)Y!\rq@KiZqk\0^rL2IfWC.ŉ;;)[ə5&4A8##YT3^|EjIw ̓5B\"Hb*Vi#!Cȣ}6<ch]n\$PL7RaI\\e|bS;9}ﾑ\r`\nSx7Nލx	S[0(e]2#n0bЊXtMOjK^|umk,Pkng%8D斃*\"G[ϸֽ2~#Vьb[?H T.+ꈘ)va|ot6͜א8\\:Fjz\r%l;f|/Bl0N(nnB\\<\\LaMHm:H%,C:>cO/9_G\r	\0f&<\"'kcb&m*NҰc=rZÐ-,Rd&@!*\$b	ppp&Zm#\"Z˽	HHՅXu	{]0\n@)ls>hGLEkq-^0kWь]mt{!^BlrcGe!,\rm:%zNrEvu	0pMd|?~юq_|cn\$rs o(gϴl9Wy\r,|\\N#M	NL*\$T C5N<%h%GHζxANfAL;%Ry&\$(gҀ{\nhА΍ep%PqX00rHN:C̋i|#Ҍ;\$Z)r!<EJb\\	TbИc\$~\$r=,p/O4B\nZN\n&C3\nֽl.U@*R<{6exITm/qGϲϸ6U5Ok5e_5JH#f\\ZF2j&ıU*iw;b7FvrilqRW<E\"|\$pr\\bъ8F_5r-\$4Cl7=\r+*k[BiMBh`!.s@-ttY(Arb\"C\nMx\n'gqP\$,9U#FwH('3ֱ@\r>8{\0003O'6 ɍӔxjI\0";break;case"zh":$f="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3W5.\".T{D-(Js\nZ1H)tIvrs	Ap2\rH2GIvL&\"s| K̂N'+\0BI1g,\r3:x'1\rCp9x79c2:e1AANI|GI\0DYS,ZZL9H]6\$O\\ZJ3qreR+ZK)v]P+V)\"E! @AA.0Y<řQ9UAUQPrDG0Br=ϥJCMdZHv]\"^9zW%s]Yx:DaJ5	CL!XMrB\rDm)\"eLnI54!P0>D\\C^Y7OTV;dd5SGAM2l.rF]4piP,uOSo91K!%~:ޯ%IXXs22YiUc\nRK]Xմ]^D`!A}\\#`9%	S=T)0\\'Ai5:eUV\$1I-9#e~ҼkXOp^ƐXXC69uyntL*&ed} HR\$\$IRd(J^t+2^2\rp:\r?1LX_!A\"ŉ<\"Z:(`;x&7W-x(TpTN	\nCH\$úQJo=+%(xl9ThzL=6\$eJf+r\n9D`mBB4\$\$0@WHs	1AReUެ>br! @mϻf)˨1EDF΃qD?\0d\$GPJ<	h\"pgX\"YAWQ(iF\"@S@K0qr˙4%P\nxqjj+WD&&!kR\\qS\nAqI+Q+ueNKa\"v5ݒ-h_dJRlN	Ҭ¸ZRjP5vX1HN#jTS|:,D0B(\0,*@'0Q\0R\nz  (\"E \"ŢtUҺؼNs  P(B(	VP&|kX'&`PǕva@|xA<'\0 A\nЈB`EeVz-Oi	@Y%E:<D:p,7p\".ԖQN.΁է&Nxڗm&h~ࠇ9@o&[	YDQ	J`\"FNӴ}P͡*}з%s8Kk2W2M&rm:2E\$⎐RjT)(4<\\\"KEА,mhAb*W*U('\\1tN+>M&HҨLZ+Ae0H\\%\r5Ab~m0@@<gLQܶ+E<eT\0^3,%|QHyA`wH#ĺ#7H^DQ1\"%լ/uwDF!}ڼH(B\n&_\n|`\n\n1jc)MxHZ-scnr4+W	'B|zHRb=aqmy/e+m:z=Lќܘr+FpwX(Gpp?Q\01go[tRb1D+Z[݌Xh#nZVii{Haay?K*#+sBd]\nhZxYpv갂nዟFT:9xxL~g:gms|#%77B\\\\j:Wn7\$ΥYXF>	,V-Bް|#.GrszFD+;w,kJqrYZ텦bF;fR{`G{>%7aOJ>䤼vϦszWcQvWgݱ's\\w*9?W^G\nZrL`hӌ\\u3Ba<N.|	ŏR4P8ߎzc#K\0p=6p@moB0LpL:£/b	\r\0K2A>-4+-J6+pt!\\'^в\\0m:ϧxag\rzg 4.pIv\nZlh*nb6#~OæՆJa!(4!^Cp;' Cn/riV!^mLHzZ4uFj`I\0\\\"\\&l%Q*2獬yX10BunFѾIt4i[.\nnffNROjɁ\\Vn\r6dn \rn\$1\$Ql4GQb?Z0M\$2FR:`r(q u\"a._.n";break;case"zh-tw":$f="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ[f]b*\\gA2yOX#vi`\\\nsP h7P	ZģBGTr{4Ǒ0&Q8),ha!\090z\r8a^\\01\\Z\rp^8#;̣ ^)AT\nt[Tex!\\\$	psd<-D%yRP	 s-~WFJQO:(\\1|FMZS\0<(P9*iXB m OgANQD<vEMQd֭TMF9zr}M) D)8!v]!bbsēs'UEs݂8*\$nuq\n/\rG~g1s\nbVI&t˃j5-;#OTԵ1tV,Zx's]%)ϣ\nƞi0WDQTaT)#@sxOTah1PP\$#hVd¦KJ12AfKG#V*\\\\*\r˕I6Q0D<C2\$7%B(J7\$rMIGF')C\$_IF3-'V~Oa:=OdQE)\nW(1H'JZKy0>ƙS:i7L\rN`s.+E,!8H@*\na7A#\"9>CCX\$,1xP?RUJe-L4&\"Cps:߇(7,L2T>D+YZElQ\nح0F!ʱtO9ێa\$T`vrA'Źvj0W)3]djš5(ě	Q	T&d,MP_\"TQ1,D0a\\p!!B>+eXEr9\0IIϟQ/G0G2Q&,#JrlS\nA@IXFÑ2/\rQ1/ÔK\n-3%ęG9pwY*''YA[i\"q6Aa<'19fl<rD@9äKh\"G4N#,xS\n#DvPLem6V訄q1(@  Q=Wi`	\"e\0,R	Ñqʂg;E\0KA|h)P5p \n@\"@U\"mHHLpd5u\\kXc+yW*sΉ:슋.'htP,yl\" sxmMrzH!1P\"s\nHHB\n3At0MWT#,]Jy{,Swo\n7IH3`	.E\n+[Ӝ2xfxJ	b*\0TXqh(#g'ey8B@+&TҦ7ZKKiM<B\\U;>͙@J<B;/\"\0].g<tضlK0_VtKolɅ\n!|SfZ|Rz>UrJ)5 	-%jf#d	~bA,]I'\r6P.ykSn2 <mAN'DdrrT7a#I9D_:'AX0P8oB#n*NXAo+E.OT	I)MT}&'vSEz`YHlB*]{w~SNbUt֎Z(9Bz<|)\rъ>ȩ1|Eva-@yEF岌l\nǧDo&+!ev{q]rU.'B6\r]1	wa\r>w6}bHnM*͠=<y\\OcNKMj~4ZGfЯBHePk>1엋s9\$\$Bd\"z_VG\"]NY\\ޑ)dzFD6T/&hF|́<GDJT>T%FvlflG3.υ!s\rTYFlf\0S&^\\ {:v*v~l*a!	\r\nPX,S^'\nn됸\\e#qYFΞYڣ\nvpA0΂0\r\0ή(s#MP<	=&T*0q.2M#_\"4fKؖ\rƅX*؏0<AHQF0bi#k3C\\%`)mF gT\r9>'\\[@2bLH6\nZBjiDB2#b:ENd,Q\nF僌068\\&%TC|x#)ǈH)q\$&bbhJfDb.z+&0l-n'\nGvE(&o̖ABi]%̮6/B0+2BA,\"+@ \r .\0 ')Nި̸SH):.Q%ƹ&RhQl1Qo_%®,sLA";break;}$Ug=array();foreach(explode("\n",lzw_decompress($f))as$X)$Ug[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Ug;}if(!$Ug){$Ug=get_translations($a);$_SESSION["translations"]=$Ug;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$c;$Ze=array_search("SQL",$c->operators);if($Ze!==false)unset($c->operators[$Ze]);}function
dsn($Ob,$V,$G,$xe=array()){$xe[PDO::ATTR_ERRMODE]=PDO::ERRMODE_SILENT;$xe[PDO::ATTR_STATEMENT_CLASS]=array('Min_PDOStatement');try{$this->pdo=new
PDO($Ob,$V,$G,$xe);}catch(Exception$hc){auth_error(h($hc->getMessage()));}$this->server_info=@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION);}function
quote($lg){return$this->pdo->quote($lg);}function
query($I,$bh=false){$J=$this->pdo->query($I);$this->error="";if(!$J){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($J);return$J;}function
multi_query($I){return$this->_result=$this->query($I);}function
store_result($J=null){if(!$J){$J=$this->_result;if(!$J)return
false;}if($J->columnCount()){$J->num_rows=$J->rowCount();return$J;}$this->affected_rows=$J->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($I,$n=0){$J=$this->query($I);if(!$J)return
false;$L=$J->fetch();return$L[$n];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(PDO::FETCH_NUM);}function
fetch_field(){$L=(object)$this->getColumnMeta($this->_offset++);$L->orgtable=$L->table;$L->orgname=$L->name;$L->charsetnr=(in_array("blob",(array)$L->flags)?63:0);return$L;}}}$Kb=array();function
add_driver($u,$E){global$Kb;$Kb[$u]=$E;}class
Min_SQL{var$_conn;function
__construct($g){$this->_conn=$g;}function
select($Q,$N,$Z,$s,$ze=array(),$_=1,$F=0,$gf=false){global$c,$y;$kd=(count($s)<count($N));$I=$c->selectQueryBuild($N,$Z,$s,$ze,$_,$F);if(!$I)$I="SELECT".limit(($_GET["page"]!="last"&&$_!=""&&$s&&$kd&&$y=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$N)."\nFROM ".table($Q),($Z?"\nWHERE ".implode(" AND ",$Z):"").($s&&$kd?"\nGROUP BY ".implode(", ",$s):"").($ze?"\nORDER BY ".implode(", ",$ze):""),($_!=""?+$_:null),($F?$_*$F:0),"\n");$hg=microtime(true);$K=$this->_conn->query($I);if($gf)echo$c->selectQuery($I,$hg,!$K);return$K;}function
delete($Q,$of,$_=0){$I="FROM ".table($Q);return
queries("DELETE".($_?limit1($Q,$I,$of):" $I$of"));}function
update($Q,$P,$of,$_=0,$Rf="\n"){$rh=array();foreach($P
as$z=>$X)$rh[]="$z = $X";$I=table($Q)." SET$Rf".implode(",$Rf",$rh);return
queries("UPDATE".($_?limit1($Q,$I,$of,$Rf):" $I$of"));}function
insert($Q,$P){return
queries("INSERT INTO ".table($Q).($P?" (".implode(", ",array_keys($P)).")\nVALUES (".implode(", ",$P).")":" DEFAULT VALUES"));}function
insertUpdate($Q,$M,$ff){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($I,$Hg){}function
convertSearch($v,$X,$n){return$v;}function
value($X,$n){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$n):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($If){return
q($If);}function
warnings(){return'';}function
tableHelp($E){}}class
Adminer{var$operators;function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($O){return
h($O);}function
database(){return
DB;}function
databases($yc=true){return
get_databases($yc);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$K=array();$vc="adminer.css";if(file_exists($vc))$K[]="$vc?v=".crc32(file_get_contents($vc));return$K;}function
loginForm(){global$Kb;echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(22).'<td>',html_select("auth[driver]",$Kb,DRIVER,"loginDriver(this);")."\n"),$this->loginFormField('server','<tr><th>'.lang(23).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(24).'<td>','<input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username')); qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(25).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),$this->loginFormField('db','<tr><th>'.lang(26).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(27)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(28))."\n";}function
loginFormField($E,$Sc,$Y){return$Sc.$Y;}function
login($Fd,$G){if($G=="")return
lang(29,target_blank());return
true;}function
tableName($tg){return
h($tg["Name"]);}function
fieldName($n,$ze=0){return'<span title="'.h($n["full_type"]).'">'.h($n["field"]).'</span>';}function
selectLinks($tg,$P=""){global$y,$l;echo'<p class="links">';$Ed=array("select"=>lang(30));if(support("table")||support("indexes"))$Ed["table"]=lang(31);if(support("table")){if(is_view($tg))$Ed["view"]=lang(32);else$Ed["create"]=lang(33);}if($P!==null)$Ed["edit"]=lang(34);$E=$tg["Name"];foreach($Ed
as$z=>$X)echo" <a href='".h(ME)."$z=".urlencode($E).($z=="edit"?$P:"")."'".bold(isset($_GET[$z])).">$X</a>";echo
doc_link(array($y=>$l->tableHelp($E)),"?"),"\n";}function
foreignKeys($Q){return
foreign_keys($Q);}function
backwardKeys($Q,$sg){return
array();}function
backwardKeysPrint($Aa,$L){}function
selectQuery($I,$hg,$qc=false){global$y,$l;$K="</p>\n";if(!$qc&&($zh=$l->warnings())){$u="warnings";$K=", <a href='#$u'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$K<div id='$u' class='hidden'>\n$zh</div>\n";}return"<p><code class='jush-$y'>".h(str_replace("\n"," ",$I))."</code> <span class='time'>(".format_time($hg).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($I)."'>".lang(10)."</a>":"").$K;}function
sqlCommandQuery($I){return
shorten_utf8(trim($I),1000);}function
rowDescription($Q){return"";}function
rowDescriptions($M,$Ac){return$M;}function
selectLink($X,$n){}function
selectVal($X,$A,$n,$Ge){$K=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$n["type"])&&!is_utf8($X))$K="<i>".lang(36,strlen($Ge))."</i>";if(preg_match('~json~',$n["type"]))$K="<code class='jush-js'>$K</code>";return($A?"<a href='".h($A)."'".(is_url($A)?target_blank():"").">$K</a>":$K);}function
editVal($X,$n){return$X;}function
tableStructurePrint($o){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr><th>".lang(37)."<td>".lang(38).(support("comment")?"<td>".lang(39):"")."</thead>\n";foreach($o
as$n){echo"<tr".odd()."><th>".h($n["field"]),"<td><span title='".h($n["collation"])."'>".h($n["full_type"])."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(40)."</i>":""),(isset($n["default"])?" <span title='".lang(41)."'>[<b>".h($n["default"])."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($x){echo"<table cellspacing='0'>\n";foreach($x
as$E=>$w){ksort($w["columns"]);$gf=array();foreach($w["columns"]as$z=>$X)$gf[]="<i>".h($X)."</i>".($w["lengths"][$z]?"(".$w["lengths"][$z].")":"").($w["descs"][$z]?" DESC":"");echo"<tr title='".h($E)."'><th>$w[type]<td>".implode(", ",$gf)."\n";}echo"</table>\n";}function
selectColumnsPrint($N,$e){global$Gc,$Lc;print_fieldset("select",lang(42),$N);$t=0;$N[""]=array();foreach($N
as$z=>$X){$X=$_GET["columns"][$z];$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($z!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($Gc||$Lc?"<select name='columns[$t][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(43)=>$Gc,lang(44)=>$Lc)),$X["fun"])."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($z!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$e,$x){print_fieldset("search",lang(45),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h($_GET["fulltext"][$t])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}}$Ka="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(46).")"),html_select("where[$t][op]",$this->operators,$X["op"],$Ka),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Ka }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($ze,$e,$x){print_fieldset("sort",lang(47),$ze);$t=0;foreach((array)$_GET["order"]as$z=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$z]),lang(48))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(48))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($_){echo"<fieldset><legend>".lang(49)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($_)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Fg){if($Fg!==null){echo"<fieldset><legend>".lang(50)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Fg)."'>","</div></fieldset>\n";}}function
selectActionPrint($x){echo"<fieldset><legend>".lang(51)."</legend><div>","<input type='submit' value='".lang(42)."'>"," <span id='noindex' title='".lang(52)."'></span>","<script".nonce().">\n","var indexColumns = ";$e=array();foreach($x
as$w){$rb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$rb)$e[$rb]=1;}$e[""]=1;foreach($e
as$z=>$X)json_row($z);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($Wb,$e){}function
selectColumnsProcess($e,$x){global$Gc,$Lc;$N=array();$s=array();foreach((array)$_GET["columns"]as$z=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$Gc)||in_array($X["fun"],$Lc)))){$N[$z]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$Lc))$s[]=$N[$z];}}return
array($N,$s);}function
selectSearchProcess($o,$x){global$g,$l;$K=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&$_GET["fulltext"][$t]!="")$K[]="MATCH (".implode(", ",array_map('idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$z=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$df="";$db=" $X[op]";if(preg_match('~IN$~',$X["op"])){$ad=process_length($X["val"]);$db.=" ".($ad!=""?$ad:"(NULL)");}elseif($X["op"]=="SQL")$db=" $X[val]";elseif($X["op"]=="LIKE %%")$db=" LIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$db=" ILIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$df="$X[op](".q($X["val"]).", ";$db=")";}elseif(!preg_match('~NULL$~',$X["op"]))$db.=" ".$this->processInput($o[$X["col"]],$X["val"]);if($X["col"]!="")$K[]=$df.$l->convertSearch(idf_escape($X["col"]),$X,$o[$X["col"]]).$db;else{$Ya=array();foreach($o
as$E=>$n){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$Ya[]=$df.$l->convertSearch(idf_escape($E),$X,$n).$db;}$K[]=($Ya?"(".implode(" OR ",$Ya).")":"1 = 0");}}}return$K;}function
selectOrderProcess($o,$x){$K=array();foreach((array)$_GET["order"]as$z=>$X){if($X!="")$K[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$z])?" DESC":"");}return$K;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$Ac){return
false;}function
selectQueryBuild($N,$Z,$s,$ze,$_,$F){return"";}function
messageQuery($I,$Gg,$qc=false){global$y,$l;restart_session();$Tc=&get_session("queries");if(!$Tc[$_GET["db"]])$Tc[$_GET["db"]]=array();if(strlen($I)>1e6)$I=preg_replace('~[\x80-\xFF]+$~','',substr($I,0,1e6))."\n…";$Tc[$_GET["db"]][]=array($I,time(),$Gg);$fg="sql-".count($Tc[$_GET["db"]]);$K="<a href='#$fg' class='toggle'>".lang(53)."</a>\n";if(!$qc&&($zh=$l->warnings())){$u="warnings-".count($Tc[$_GET["db"]]);$K="<a href='#$u' class='toggle'>".lang(35)."</a>, $K<div id='$u' class='hidden'>\n$zh</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $K<div id='$fg' class='hidden'><pre><code class='jush-$y'>".shorten_utf8($I,1000)."</code></pre>".($Gg?" <span class='time'>($Gg)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Tc[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($Q,$o,$L,$ih){}function
editFunctions($n){global$Rb;$K=($n["null"]?"NULL/":"");$ih=isset($_GET["select"])||where($_GET);foreach($Rb
as$z=>$Gc){if(!$z||(!isset($_GET["call"])&&$ih)){foreach($Gc
as$Ue=>$X){if(!$Ue||preg_match("~$Ue~",$n["type"]))$K.="/$X";}}if($z&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$K.="/SQL";}if($n["auto_increment"]&&!$ih)$K=lang(40);return
explode("/",$K);}function
editInput($Q,$n,$wa,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$wa value='-1' checked><i>".lang(8)."</i></label> ":"").($n["null"]?"<label><input type='radio'$wa value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$wa,$n,$Y,0);return"";}function
editHint($Q,$n,$Y){return"";}function
processInput($n,$Y,$r=""){if($r=="SQL")return$Y;$E=$n["field"];$K=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$r))$K="$r()";elseif(preg_match('~^current_(date|timestamp)$~',$r))$K=$r;elseif(preg_match('~^([+-]|\|\|)$~',$r))$K=idf_escape($E)." $r $K";elseif(preg_match('~^[+-] interval$~',$r))$K=idf_escape($E)." $r ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$K);elseif(preg_match('~^(addtime|subtime|concat)$~',$r))$K="$r(".idf_escape($E).", $K)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$r))$K="$r($K)";return
unconvert_field($n,$K);}function
dumpOutput(){$K=array('text'=>lang(54),'file'=>lang(55));if(function_exists('gzencode'))$K['gz']='gzip';return$K;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($Q,$ng,$md=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($ng)dump_csv(array_keys(fields($Q)));}else{if($md==2){$o=array();foreach(fields($Q)as$E=>$n)$o[]=idf_escape($E)." $n[full_type]";$i="CREATE TABLE ".table($Q)." (".implode(", ",$o).")";}else$i=create_sql($Q,$_POST["auto_increment"],$ng);set_utf8mb4($i);if($ng&&$i){if($ng=="DROP+CREATE"||$md==1)echo"DROP ".($md==2?"VIEW":"TABLE")." IF EXISTS ".table($Q).";\n";if($md==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($Q,$ng,$I){global$g,$y;$Ld=($y=="sqlite"?0:1048576);if($ng){if($_POST["format"]=="sql"){if($ng=="TRUNCATE+INSERT")echo
truncate_sql($Q).";\n";$o=fields($Q);}$J=$g->query($I,1);if($J){$fd="";$Ia="";$pd=array();$pg="";$tc=($Q!=''?'fetch_assoc':'fetch_row');while($L=$J->$tc()){if(!$pd){$rh=array();foreach($L
as$X){$n=$J->fetch_field();$pd[]=$n->name;$z=idf_escape($n->name);$rh[]="$z = VALUES($z)";}$pg=($ng=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$rh):"").";\n";}if($_POST["format"]!="sql"){if($ng=="table"){dump_csv($pd);$ng="INSERT";}dump_csv($L);}else{if(!$fd)$fd="INSERT INTO ".table($Q)." (".implode(", ",array_map('idf_escape',$pd)).") VALUES";foreach($L
as$z=>$X){$n=$o[$z];$L[$z]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$If=($Ld?"\n":" ")."(".implode(",\t",$L).")";if(!$Ia)$Ia=$fd.$If;elseif(strlen($Ia)+4+strlen($If)+strlen($pg)<$Ld)$Ia.=",$If";else{echo$Ia.$pg;$Ia=$fd.$If;}}}if($Ia)echo$Ia.$pg;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$g->error)."\n";}}function
dumpFilename($Xc){return
friendly_url($Xc!=""?$Xc:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Xc,$Xd=false){$Ie=$_POST["output"];$nc=(preg_match('~sql~',$_POST["format"])?"sql":($Xd?"tar":"csv"));header("Content-Type: ".($Ie=="gz"?"application/x-gzip":($nc=="tar"?"application/x-tar":($nc=="sql"||$Ie!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Ie=="gz")ob_start('ob_gzencode',1e6);return$nc;}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(56)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(57):lang(58))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(59)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(60)."</a>\n":"");return
true;}function
navigation($Wd){global$fa,$y,$Kb,$g;echo'<h1>
',$this->name(),' <span class="version">',$fa,'</span>
<a href="https://www.adminer.org/#download"',target_blank(),' id="version">',(version_compare($fa,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($Wd=="auth"){$Ie="";foreach((array)$_SESSION["pwds"]as$th=>$Tf){foreach($Tf
as$O=>$ph){foreach($ph
as$V=>$G){if($G!==null){$xb=$_SESSION["db"][$th][$O][$V];foreach(($xb?array_keys($xb):array(""))as$k)$Ie.="<li><a href='".h(auth_url($th,$O,$V,$k))."'>($Kb[$th]) ".h($V.($O!=""?"@".$this->serverName($O):"").($k!=""?" - $k":""))."</a>\n";}}}}if($Ie)echo"<ul id='logins'>\n$Ie</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$S=array();if($_GET["ns"]!==""&&!$Wd&&DB!=""){$g->select_db(DB);$S=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.8.1");if(support("sql")){echo'<script',nonce(),'>
';if($S){$Ed=array();foreach($S
as$Q=>$U)$Ed[]=preg_quote($Q,'/');echo"var jushLinks = { $y: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$Ed).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$y;\n";}$Sf=$g->server_info;echo'bodyLoad(\'',(is_object($g)?preg_replace('~^(\d\.?\d).*~s','\1',$Sf):""),'\'',(preg_match('~MariaDB~',$Sf)?", true":""),');
</script>
';}$this->databasesPrint($Wd);if(DB==""||!$Wd){echo"<p class='links'>".(support("sql")?"<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(53)."</a>\n<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(61)."</a>\n":"")."";if(support("dump"))echo"<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(62)."</a>\n";}if($_GET["ns"]!==""&&!$Wd&&DB!=""){echo'<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(63)."</a>\n";if(!$S)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($S);}}}function
databasesPrint($Wd){global$c,$g;$j=$this->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo'<form action="">
<p id="dbs">
';hidden_fields_get();$vb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".lang(64)."'>".lang(65)."</span>: ".($j?"<select name='db'>".optionlist(array(""=>"")+$j,DB)."</select>$vb":"<input name='db' value='".h(DB)."' autocapitalize='off'>\n"),"<input type='submit' value='".lang(20)."'".($j?" class='hidden'":"").">\n";foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}echo"</p></form>\n";}function
tablesPrint($S){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($S
as$Q=>$ig){$E=$this->tableName($ig);if($E!=""){echo'<li><a href="'.h(ME).'select='.urlencode($Q).'"'.bold($_GET["select"]==$Q||$_GET["edit"]==$Q,"select")." title='".lang(30)."'>".lang(66)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($Q).'"'.bold(in_array($Q,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($ig)?"view":"structure"))." title='".lang(31)."'>$E</a>":"<span>$E</span>")."\n";}}echo"</ul>\n";}}$c=(function_exists('adminer_object')?adminer_object():new
Adminer);$Kb=array("server"=>"MySQL")+$Kb;if(!defined("DRIVER")){define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($O="",$V="",$G="",$ub=null,$Ye=null,$ag=null){global$c;mysqli_report(MYSQLI_REPORT_OFF);list($Vc,$Ye)=explode(":",$O,2);$gg=$c->connectSsl();if($gg)$this->ssl_set($gg['key'],$gg['cert'],$gg['ca'],'','');$K=@$this->real_connect(($O!=""?$Vc:ini_get("mysqli.default_host")),($O.$V!=""?$V:ini_get("mysqli.default_user")),($O.$V.$G!=""?$G:ini_get("mysqli.default_pw")),$ub,(is_numeric($Ye)?$Ye:ini_get("mysqli.default_port")),(!is_numeric($Ye)?$Ye:$ag),($gg?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$K;}function
set_charset($La){if(parent::set_charset($La))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $La");}function
result($I,$n=0){$J=$this->query($I);if(!$J)return
false;$L=$J->fetch_array();return$L[$n];}function
quote($lg){return"'".$this->escape_string($lg)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($O,$V,$G){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(67,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($O!=""?$O:ini_get("mysql.default_host")),("$O$V"!=""?$V:ini_get("mysql.default_user")),("$O$V$G"!=""?$G:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($La){if(function_exists('mysql_set_charset')){if(mysql_set_charset($La,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $La");}function
quote($lg){return"'".mysql_real_escape_string($lg,$this->_link)."'";}function
select_db($ub){return
mysql_select_db($ub,$this->_link);}function
query($I,$bh=false){$J=@($bh?mysql_unbuffered_query($I,$this->_link):mysql_query($I,$this->_link));$this->error="";if(!$J){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($J===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($J);}function
multi_query($I){return$this->_result=$this->query($I);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($I,$n=0){$J=$this->query($I);if(!$J||!$J->num_rows)return
false;return
mysql_result($J->_result,0,$n);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($J){$this->_result=$J;$this->num_rows=mysql_num_rows($J);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$K=mysql_fetch_field($this->_result,$this->_offset++);$K->orgtable=$K->table;$K->orgname=$K->name;$K->charsetnr=($K->blob?63:0);return$K;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($O,$V,$G){global$c;$xe=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$gg=$c->connectSsl();if($gg){if(!empty($gg['key']))$xe[PDO::MYSQL_ATTR_SSL_KEY]=$gg['key'];if(!empty($gg['cert']))$xe[PDO::MYSQL_ATTR_SSL_CERT]=$gg['cert'];if(!empty($gg['ca']))$xe[PDO::MYSQL_ATTR_SSL_CA]=$gg['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$O)),$V,$G,$xe);return
true;}function
set_charset($La){$this->query("SET NAMES $La");}function
select_db($ub){return$this->query("USE ".idf_escape($ub));}function
query($I,$bh=false){$this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$bh);return
parent::query($I,$bh);}}}class
Min_Driver
extends
Min_SQL{function
insert($Q,$P){return($P?parent::insert($Q,$P):queries("INSERT INTO ".table($Q)." ()\nVALUES ()"));}function
insertUpdate($Q,$M,$ff){$e=array_keys(reset($M));$df="INSERT INTO ".table($Q)." (".implode(", ",$e).") VALUES\n";$rh=array();foreach($e
as$z)$rh[$z]="$z = VALUES($z)";$pg="\nON DUPLICATE KEY UPDATE ".implode(", ",$rh);$rh=array();$Bd=0;foreach($M
as$P){$Y="(".implode(", ",$P).")";if($rh&&(strlen($df)+$Bd+strlen($Y)+strlen($pg)>1e6)){if(!queries($df.implode(",\n",$rh).$pg))return
false;$rh=array();$Bd=0;}$rh[]=$Y;$Bd+=strlen($Y)+2;}return
queries($df.implode(",\n",$rh).$pg);}function
slowQuery($I,$Hg){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$Hg FOR $I";elseif(preg_match('~^(SELECT\b)(.+)~is',$I,$C))return"$C[1] /*+ MAX_EXECUTION_TIME(".($Hg*1000).") */ $C[2]";}}function
convertSearch($v,$X,$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->_conn).")":$v);}function
warnings(){$J=$this->_conn->query("SHOW WARNINGS");if($J&&$J->num_rows){ob_start();select($J);return
ob_get_clean();}}function
tableHelp($E){$Hd=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Hd?"information-schema-$E-table/":str_replace("_","-",$E)."-table.html"));if(DB=="mysql")return($Hd?"mysql$E-table/":"system-database.html");}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
connect(){global$c,$ah,$mg;$g=new
Min_DB;$nb=$c->credentials();if($g->connect($nb[0],$nb[1],$nb[2])){$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$g)){$mg[lang(68)][]="json";$ah["json"]=4294967295;}return$g;}$K=$g->error;if(function_exists('iconv')&&!is_utf8($K)&&strlen($If=iconv("windows-1250","utf-8",$K))>strlen($K))$K=$If;return$K;}function
get_databases($yc){$K=get_session("dbs");if($K===null){$I=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$K=($yc?slow_query($I):get_vals($I));restart_session();set_session("dbs",$K);stop_session();}return$K;}function
limit($I,$Z,$_,$ke=0,$Rf=" "){return" $I$Z".($_!==null?$Rf."LIMIT $_".($ke?" OFFSET $ke":""):"");}function
limit1($Q,$I,$Z,$Rf="\n"){return
limit($I,$Z,1,0,$Rf);}function
db_collation($k,$Xa){global$g;$K=null;$i=$g->result("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$C))$K=$C[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$C))$K=$Xa[$C[1]][-1];return$K;}function
engines(){$K=array();foreach(get_rows("SHOW ENGINES")as$L){if(preg_match("~YES|DEFAULT~",$L["Support"]))$K[]=$L["Engine"];}return$K;}function
logged_user(){global$g;return$g->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($j){$K=array();foreach($j
as$k)$K[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$K;}function
table_status($E="",$rc=false){$K=array();foreach(get_rows($rc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($E!=""?"AND TABLE_NAME = ".q($E):"ORDER BY Name"):"SHOW TABLE STATUS".($E!=""?" LIKE ".q(addcslashes($E,"%_\\")):""))as$L){if($L["Engine"]=="InnoDB")$L["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$L["Comment"]);if(!isset($L["Engine"]))$L["Comment"]="";if($E!="")return$L;$K[$L["Name"]]=$L;}return$K;}function
is_view($R){return$R["Engine"]===null;}function
fk_support($R){return
preg_match('~InnoDB|IBMDB2I~i',$R["Engine"])||(preg_match('~NDB~i',$R["Engine"])&&min_version(5.6));}function
fields($Q){$K=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($Q))as$L){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$L["Type"],$C);$K[$L["Field"]]=array("field"=>$L["Field"],"full_type"=>$L["Type"],"type"=>$C[1],"length"=>$C[2],"unsigned"=>ltrim($C[3].$C[4]),"default"=>($L["Default"]!=""||preg_match("~char|set~",$C[1])?(preg_match('~text~',$C[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$L["Default"])):$L["Default"]):null),"null"=>($L["Null"]=="YES"),"auto_increment"=>($L["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$L["Extra"],$C)?$C[1]:""),"collation"=>$L["Collation"],"privileges"=>array_flip(preg_split('~, *~',$L["Privileges"])),"comment"=>$L["Comment"],"primary"=>($L["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$L["Extra"]),);}return$K;}function
indexes($Q,$h=null){$K=array();foreach(get_rows("SHOW INDEX FROM ".table($Q),$h)as$L){$E=$L["Key_name"];$K[$E]["type"]=($E=="PRIMARY"?"PRIMARY":($L["Index_type"]=="FULLTEXT"?"FULLTEXT":($L["Non_unique"]?($L["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$K[$E]["columns"][]=$L["Column_name"];$K[$E]["lengths"][]=($L["Index_type"]=="SPATIAL"?null:$L["Sub_part"]);$K[$E]["descs"][]=null;}return$K;}function
foreign_keys($Q){global$g,$re;static$Ue='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$K=array();$lb=$g->result("SHOW CREATE TABLE ".table($Q),1);if($lb){preg_match_all("~CONSTRAINT ($Ue) FOREIGN KEY ?\\(((?:$Ue,? ?)+)\\) REFERENCES ($Ue)(?:\\.($Ue))? \\(((?:$Ue,? ?)+)\\)(?: ON DELETE ($re))?(?: ON UPDATE ($re))?~",$lb,$Jd,PREG_SET_ORDER);foreach($Jd
as$C){preg_match_all("~$Ue~",$C[2],$bg);preg_match_all("~$Ue~",$C[5],$Ag);$K[idf_unescape($C[1])]=array("db"=>idf_unescape($C[4]!=""?$C[3]:$C[4]),"table"=>idf_unescape($C[4]!=""?$C[4]:$C[3]),"source"=>array_map('idf_unescape',$bg[0]),"target"=>array_map('idf_unescape',$Ag[0]),"on_delete"=>($C[6]?$C[6]:"RESTRICT"),"on_update"=>($C[7]?$C[7]:"RESTRICT"),);}}return$K;}function
view($E){global$g;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$g->result("SHOW CREATE VIEW ".table($E),1)));}function
collations(){$K=array();foreach(get_rows("SHOW COLLATION")as$L){if($L["Default"])$K[$L["Charset"]][-1]=$L["Collation"];else$K[$L["Charset"]][]=$L["Collation"];}ksort($K);foreach($K
as$z=>$X)asort($K[$z]);return$K;}function
information_schema($k){return(min_version(5)&&$k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){global$g;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$g->error));}function
create_database($k,$Wa){return
queries("CREATE DATABASE ".idf_escape($k).($Wa?" COLLATE ".q($Wa):""));}function
drop_databases($j){$K=apply_queries("DROP DATABASE",$j,'idf_escape');restart_session();set_session("dbs",null);return$K;}function
rename_database($E,$Wa){$K=false;if(create_database($E,$Wa)){$S=array();$wh=array();foreach(tables_list()as$Q=>$U){if($U=='VIEW')$wh[]=$Q;else$S[]=$Q;}$K=(!$S&&!$wh)||move_tables($S,$wh,$E);drop_databases($K?array(DB):array());}return$K;}function
auto_increment(){$za=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$za="";break;}if($w["type"]=="PRIMARY")$za=" UNIQUE";}}return" AUTO_INCREMENT$za";}function
alter_table($Q,$E,$o,$_c,$bb,$Zb,$Wa,$ya,$Qe){$sa=array();foreach($o
as$n)$sa[]=($n[1]?($Q!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($Q!=""?$n[2]:""):"DROP ".idf_escape($n[0]));$sa=array_merge($sa,$_c);$ig=($bb!==null?" COMMENT=".q($bb):"").($Zb?" ENGINE=".q($Zb):"").($Wa?" COLLATE ".q($Wa):"").($ya!=""?" AUTO_INCREMENT=$ya":"");if($Q=="")return
queries("CREATE TABLE ".table($E)." (\n".implode(",\n",$sa)."\n)$ig$Qe");if($Q!=$E)$sa[]="RENAME TO ".table($E);if($ig)$sa[]=ltrim($ig);return($sa||$Qe?queries("ALTER TABLE ".table($Q)."\n".implode(",\n",$sa).$Qe):true);}function
alter_indexes($Q,$sa){foreach($sa
as$z=>$X)$sa[$z]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($Q).implode(",",$sa));}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($wh){return
queries("DROP VIEW ".implode(", ",array_map('table',$wh)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$wh,$Ag){global$g;$zf=array();foreach($S
as$Q)$zf[]=table($Q)." TO ".idf_escape($Ag).".".table($Q);if(!$zf||queries("RENAME TABLE ".implode(", ",$zf))){$Bb=array();foreach($wh
as$Q)$Bb[table($Q)]=view($Q);$g->select_db($Ag);$k=idf_escape(DB);foreach($Bb
as$E=>$vh){if(!queries("CREATE VIEW $E AS ".str_replace(" $k."," ",$vh["select"]))||!queries("DROP VIEW $k.$E"))return
false;}return
true;}return
false;}function
copy_tables($S,$wh,$Ag){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($S
as$Q){$E=($Ag==DB?table("copy_$Q"):idf_escape($Ag).".".table($Q));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $E"))||!queries("CREATE TABLE $E LIKE ".table($Q))||!queries("INSERT INTO $E SELECT * FROM ".table($Q)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$L){$Vg=$L["Trigger"];if(!queries("CREATE TRIGGER ".($Ag==DB?idf_escape("copy_$Vg"):idf_escape($Ag).".".idf_escape($Vg))." $L[Timing] $L[Event] ON $E FOR EACH ROW\n$L[Statement];"))return
false;}}foreach($wh
as$Q){$E=($Ag==DB?table("copy_$Q"):idf_escape($Ag).".".table($Q));$vh=view($Q);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $E"))||!queries("CREATE VIEW $E AS $vh[select]"))return
false;}return
true;}function
trigger($E){if($E=="")return
array();$M=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($E));return
reset($M);}function
triggers($Q){$K=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$L)$K[$L["Trigger"]]=array($L["Timing"],$L["Event"]);return$K;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($E,$U){global$g,$bc,$dd,$ah;$qa=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$cg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Zg="((".implode("|",array_merge(array_keys($ah),$qa)).")\\b(?:\\s*\\(((?:[^'\")]|$bc)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Ue="$cg*(".($U=="FUNCTION"?"":$dd).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Zg";$i=$g->result("SHOW CREATE $U ".idf_escape($E),2);preg_match("~\\(((?:$Ue\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Zg\\s+":"")."(.*)~is",$i,$C);$o=array();preg_match_all("~$Ue\\s*,?~is",$C[1],$Jd,PREG_SET_ORDER);foreach($Jd
as$Le)$o[]=array("field"=>str_replace("``","`",$Le[2]).$Le[3],"type"=>strtolower($Le[5]),"length"=>preg_replace_callback("~$bc~s",'normalize_enum',$Le[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Le[8] $Le[7]"))),"null"=>1,"full_type"=>$Le[4],"inout"=>strtoupper($Le[1]),"collation"=>strtolower($Le[9]),);if($U!="FUNCTION")return
array("fields"=>$o,"definition"=>$C[11]);return
array("fields"=>$o,"returns"=>array("type"=>$C[12],"length"=>$C[13],"unsigned"=>$C[15],"collation"=>$C[16]),"definition"=>$C[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($E,$L){return
idf_escape($E);}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ID()");}function
explain($g,$I){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$I);}function
found_rows($R,$Z){return($Z||$R["Engine"]!="InnoDB"?null:$R["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Kf,$h=null){return
true;}function
create_sql($Q,$ya,$ng){global$g;$K=$g->result("SHOW CREATE TABLE ".table($Q),1);if(!$ya)$K=preg_replace('~ AUTO_INCREMENT=\d+~','',$K);return$K;}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
use_sql($ub){return"USE ".idf_escape($ub);}function
trigger_sql($Q){$K="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")),null,"-- ")as$L)$K.="\nCREATE TRIGGER ".idf_escape($L["Trigger"])." $L[Timing] $L[Event] ON ".table($L["Table"])." FOR EACH ROW\n$L[Statement];;\n";return$K;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field($n,$K){if(preg_match("~binary~",$n["type"]))$K="UNHEX($K)";if($n["type"]=="bit")$K="CONV($K, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))$K=(min_version(8)?"ST_":"")."GeomFromText($K, SRID($n[field]))";return$K;}function
support($sc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$sc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$g;return$g->result("SELECT @@max_connections");}function
driver_config(){$ah=array();$mg=array();foreach(array(lang(69)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(70)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(68)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(71)=>array("enum"=>65535,"set"=>64),lang(72)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(73)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$z=>$X){$ah+=$X;$mg[$z]=array_keys($X);}return
array('possible_drivers'=>array("MySQLi","MySQL","PDO_MySQL"),'jush'=>"sql",'types'=>$ah,'structured_types'=>$mg,'unsigned'=>array("unsigned","zerofill","unsigned zerofill"),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",)),);}}$eb=driver_config();$cf=$eb['possible_drivers'];$y=$eb['jush'];$ah=$eb['types'];$mg=$eb['structured_types'];$hh=$eb['unsigned'];$ve=$eb['operators'];$Gc=$eb['functions'];$Lc=$eb['grouping'];$Rb=$eb['edit_functions'];if($c->operators===null)$c->operators=$ve;define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$fa="4.8.1";function
page_header($Jg,$m="",$Ha=array(),$Kg=""){global$a,$fa,$c,$Kb,$y;page_headers();if(is_ajax()&&$m){page_messages($m);exit;}$Lg=$Jg.($Kg!=""?": $Kg":"");$Mg=strip_tags($Lg.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$c->name());echo'<!DOCTYPE html>
<html lang="',$a,'" dir="',lang(74),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$Mg,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.8.1"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.8.1");if($c->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.1"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.1"),'">
';foreach($c->css()as$pb){echo'<link rel="stylesheet" type="text/css" href="',h($pb),'">
';}}echo'
<body class="',lang(74),' nojs">
';$vc=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($vc)&&filemtime($vc)+86400>time()){$uh=unserialize(file_get_contents($vc));$mf="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($uh["version"],base64_decode($uh["signature"]),$mf)==1)$_COOKIE["adminer_version"]=$uh["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$fa', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(75)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$y,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Ha!==null){$A=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($A?$A:".").'">'.$Kb[DRIVER].'</a> &raquo; ';$A=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$O=$c->serverName(SERVER);$O=($O!=""?$O:lang(23));if($Ha===false)echo"$O\n";else{echo"<a href='".h($A)."' accesskey='1' title='Alt+Shift+1'>$O</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Ha)))echo'<a href="'.h($A."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Ha)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Ha
as$z=>$X){$Db=(is_array($X)?$X[1]:h($X));if($Db!="")echo"<a href='".h(ME."$z=").urlencode(is_array($X)?$X[0]:$X)."'>$Db</a> &raquo; ";}}echo"$Jg\n";}}echo"<h2>$Lg</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$c;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($c->csp()as$ob){$Rc=array();foreach($ob
as$z=>$X)$Rc[]="$z $X";header("Content-Security-Policy: ".implode("; ",$Rc));}$c->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$fe;if(!$fe)$fe=base64_encode(rand_string());return$fe;}function
page_messages($m){$jh=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Ud=$_SESSION["messages"][$jh];if($Ud){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Ud)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$jh]);}if($m)echo"<div class='error'>$m</div>\n";}function
page_footer($Wd=""){global$c,$T;echo'</div>

';switch_lang();if($Wd!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(76),'" id="logout">
<input type="hidden" name="token" value="',$T,'">
</p>
</form>
';}echo'<div id="menu">
';$c->navigation($Wd);echo'</div>
',script("setupSubmitHighlight(document);");}function
int32($Zd){while($Zd>=2147483648)$Zd-=4294967296;while($Zd<=-2147483649)$Zd+=4294967296;return(int)$Zd;}function
long2str($W,$yh){$If='';foreach($W
as$X)$If.=pack('V',$X);if($yh)return
substr($If,0,end($W));return$If;}function
str2long($If,$yh){$W=array_values(unpack('V*',str_pad($If,4*ceil(strlen($If)/4),"\0")));if($yh)$W[]=strlen($If);return$W;}function
xxtea_mx($Eh,$Dh,$qg,$od){return
int32((($Eh>>5&0x7FFFFFF)^$Dh<<2)+(($Dh>>3&0x1FFFFFFF)^$Eh<<4))^int32(($qg^$Dh)+($od^$Eh));}function
encrypt_string($kg,$z){if($kg=="")return"";$z=array_values(unpack("V*",pack("H*",md5($z))));$W=str2long($kg,true);$Zd=count($W)-1;$Eh=$W[$Zd];$Dh=$W[0];$H=floor(6+52/($Zd+1));$qg=0;while($H-->0){$qg=int32($qg+0x9E3779B9);$Qb=$qg>>2&3;for($Je=0;$Je<$Zd;$Je++){$Dh=$W[$Je+1];$Yd=xxtea_mx($Eh,$Dh,$qg,$z[$Je&3^$Qb]);$Eh=int32($W[$Je]+$Yd);$W[$Je]=$Eh;}$Dh=$W[0];$Yd=xxtea_mx($Eh,$Dh,$qg,$z[$Je&3^$Qb]);$Eh=int32($W[$Zd]+$Yd);$W[$Zd]=$Eh;}return
long2str($W,false);}function
decrypt_string($kg,$z){if($kg=="")return"";if(!$z)return
false;$z=array_values(unpack("V*",pack("H*",md5($z))));$W=str2long($kg,false);$Zd=count($W)-1;$Eh=$W[$Zd];$Dh=$W[0];$H=floor(6+52/($Zd+1));$qg=int32($H*0x9E3779B9);while($qg){$Qb=$qg>>2&3;for($Je=$Zd;$Je>0;$Je--){$Eh=$W[$Je-1];$Yd=xxtea_mx($Eh,$Dh,$qg,$z[$Je&3^$Qb]);$Dh=int32($W[$Je]-$Yd);$W[$Je]=$Dh;}$Eh=$W[$Zd];$Yd=xxtea_mx($Eh,$Dh,$qg,$z[$Je&3^$Qb]);$Dh=int32($W[0]-$Yd);$W[0]=$Dh;$qg=int32($qg-0x9E3779B9);}return
long2str($W,true);}$g='';$Qc=$_SESSION["token"];if(!$Qc)$_SESSION["token"]=rand(1,1e6);$T=get_token();$We=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($z)=explode(":",$X);$We[$z]=$X;}}function
add_invalid_login(){global$c;$q=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$q)return;$id=unserialize(stream_get_contents($q));$Gg=time();if($id){foreach($id
as$jd=>$X){if($X[0]<$Gg)unset($id[$jd]);}}$hd=&$id[$c->bruteForceKey()];if(!$hd)$hd=array($Gg+30*60,0);$hd[1]++;file_write_unlock($q,serialize($id));}function
check_invalid_login(){global$c;$id=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$hd=($id?$id[$c->bruteForceKey()]:array());$ee=($hd[1]>29?$hd[0]-time():0);if($ee>0)auth_error(lang(77,ceil($ee/60)));}$xa=$_POST["auth"];if($xa){session_regenerate_id();$th=$xa["driver"];$O=$xa["server"];$V=$xa["username"];$G=(string)$xa["password"];$k=$xa["db"];set_password($th,$O,$V,$G);$_SESSION["db"][$th][$O][$V][$k]=true;if($xa["permanent"]){$z=base64_encode($th)."-".base64_encode($O)."-".base64_encode($V)."-".base64_encode($k);$hf=$c->permanentLogin(true);$We[$z]="$z:".base64_encode($hf?encrypt_string($G,$hf):"");cookie("adminer_permanent",implode(" ",$We));}if(count($_POST)==1||DRIVER!=$th||SERVER!=$O||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($th,$O,$V,$k));}elseif($_POST["logout"]&&(!$Qc||verify_token())){foreach(array("pwds","db","dbs","queries")as$z)set_session($z,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(78).' '.lang(79));}elseif($We&&!$_SESSION["pwds"]){session_regenerate_id();$hf=$c->permanentLogin();foreach($We
as$z=>$X){list(,$Qa)=explode(":",$X);list($th,$O,$V,$k)=array_map('base64_decode',explode("-",$z));set_password($th,$O,$V,decrypt_string(base64_decode($Qa),$hf));$_SESSION["db"][$th][$O][$V][$k]=true;}}function
unset_permanent(){global$We;foreach($We
as$z=>$X){list($th,$O,$V,$k)=array_map('base64_decode',explode("-",$z));if($th==DRIVER&&$O==SERVER&&$V==$_GET["username"]&&$k==DB)unset($We[$z]);}cookie("adminer_permanent",implode(" ",$We));}function
auth_error($m){global$c,$Qc;$Uf=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Uf]||$_GET[$Uf])&&!$Qc)$m=lang(80);else{restart_session();add_invalid_login();$G=get_password();if($G!==null){if($G===false)$m.=($m?'<br>':'').lang(81,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$Uf]&&$_GET[$Uf]&&ini_bool("session.use_only_cookies"))$m=lang(82);$Me=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Me["lifetime"]);page_header(lang(27),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(83)."\n";echo"</div>\n";$c->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(84),lang(85,implode(", ",$cf)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($Vc,$Ye)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$Ye,$C)&&($C[1]<1024||$C[1]>65535))auth_error(lang(86));check_invalid_login();$g=connect();$l=new
Min_Driver($g);}$Fd=null;if(!is_object($g)||($Fd=$c->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?h($g):(is_string($Fd)?$Fd:lang(87)));auth_error($m.(preg_match('~^ | $~',get_password())?'<br>'.lang(88):''));}if($_POST["logout"]&&$Qc&&!verify_token()){page_header(lang(76),lang(89));page_footer("db");exit;}if($xa&&$_POST["token"])$_POST["token"]=$T;$m='';if($_POST){if(!verify_token()){$cd="max_input_vars";$Pd=ini_get($cd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$z){$X=ini_get($z);if($X&&(!$Pd||$X<$Pd)){$cd=$z;$Pd=$X;}}}$m=(!$_POST["token"]&&$Pd?lang(90,"'$cd'"):lang(89).' '.lang(91));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(92,"'post_max_size'");if(isset($_GET["sql"]))$m.=' '.lang(93);}function
select($J,$h=null,$Be=array(),$_=0){global$y;$Ed=array();$x=array();$e=array();$Fa=array();$ah=array();$K=array();odd('');for($t=0;(!$_||$t<$_)&&($L=$J->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr>";for($nd=0;$nd<count($L);$nd++){$n=$J->fetch_field();$E=$n->name;$Ae=$n->orgtable;$_e=$n->orgname;$K[$n->table]=$Ae;if($Be&&$y=="sql")$Ed[$nd]=($E=="table"?"table=":($E=="possible_keys"?"indexes=":null));elseif($Ae!=""){if(!isset($x[$Ae])){$x[$Ae]=array();foreach(indexes($Ae,$h)as$w){if($w["type"]=="PRIMARY"){$x[$Ae]=array_flip($w["columns"]);break;}}$e[$Ae]=$x[$Ae];}if(isset($e[$Ae][$_e])){unset($e[$Ae][$_e]);$x[$Ae][$_e]=$nd;$Ed[$nd]=$Ae;}}if($n->charsetnr==63)$Fa[$nd]=true;$ah[$nd]=$n->type;echo"<th".($Ae!=""||$n->name!=$_e?" title='".h(($Ae!=""?"$Ae.":"").$_e)."'":"").">".h($E).($Be?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($E),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr".odd().">";foreach($L
as$z=>$X){$A="";if(isset($Ed[$z])&&!$e[$Ed[$z]]){if($Be&&$y=="sql"){$Q=$L[array_search("table=",$Ed)];$A=ME.$Ed[$z].urlencode($Be[$Q]!=""?$Be[$Q]:$Q);}else{$A=ME."edit=".urlencode($Ed[$z]);foreach($x[$Ed[$z]]as$Ua=>$nd)$A.="&where".urlencode("[".bracket_escape($Ua)."]")."=".urlencode($L[$nd]);}}elseif(is_url($X))$A=$X;if($X===null)$X="<i>NULL</i>";elseif($Fa[$z]&&!is_utf8($X))$X="<i>".lang(36,strlen($X))."</i>";else{$X=h($X);if($ah[$z]==254)$X="<code>$X</code>";}if($A)$X="<a href='".h($A)."'".(is_url($A)?target_blank():'').">$X</a>";echo"<td>$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$K;}function
referencable_primary($Pf){$K=array();foreach(table_status('',true)as$ug=>$Q){if($ug!=$Pf&&fk_support($Q)){foreach(fields($ug)as$n){if($n["primary"]){if($K[$ug]){unset($K[$ug]);break;}$K[$ug]=$n;}}}}return$K;}function
adminer_settings(){parse_str($_COOKIE["adminer_settings"],$Wf);return$Wf;}function
adminer_setting($z){$Wf=adminer_settings();return$Wf[$z];}function
set_adminer_settings($Wf){return
cookie("adminer_settings",http_build_query($Wf+adminer_settings()));}function
textarea($E,$Y,$M=10,$Ya=80){global$y;echo"<textarea name='$E' rows='$M' cols='$Ya' class='sqlarea jush-$y' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
edit_type($z,$n,$Xa,$Bc=array(),$pc=array()){global$mg,$ah,$hh,$re;$U=$n["type"];echo'<td><select name="',h($z),'[type]" class="type" aria-labelledby="label-type">';if($U&&!isset($ah[$U])&&!isset($Bc[$U])&&!in_array($U,$pc))$pc[]=$U;if($Bc)$mg[lang(94)]=$Bc;echo
optionlist(array_merge($pc,$mg),$U),'</select><td><input name="',h($z),'[length]" value="',h($n["length"]),'" size="3"',(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"");echo' aria-labelledby="label-length"><td class="options">',"<select name='".h($z)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'").'><option value="">('.lang(95).')'.optionlist($Xa,$n["collation"]).'</select>',($hh?"<select name='".h($z)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist($hh,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($z)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(96).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($Bc?"<select name='".h($z)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(97).")".optionlist(explode("|",$re),$n["on_delete"])."</select> ":" ");}function
process_length($Bd){global$bc;return(preg_match("~^\\s*\\(?\\s*$bc(?:\\s*,\\s*$bc)*+\\s*\\)?\\s*\$~",$Bd)&&preg_match_all("~$bc~",$Bd,$Jd)?"(".implode(",",$Jd[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Bd)));}function
process_type($n,$Va="COLLATE"){global$hh;return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],$hh)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $Va ".q($n["collation"]):"");}function
process_field($n,$Yg){return
array(idf_escape(trim($n["field"])),process_type($Yg),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value($n){$zb=$n["default"];return($zb===null?"":" DEFAULT ".(preg_match('~char|binary|text|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$zb)?q($zb):$zb));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$z=>$X){if(preg_match("~$z|$X~",$U))return" class='$z'";}}function
edit_fields($o,$Xa,$U="TABLE",$Bc=array()){global$dd;$o=array_values($o);$_b=(($_POST?$_POST["defaults"]:adminer_setting("defaults"))?"":" class='hidden'");$cb=(($_POST?$_POST["comments"]:adminer_setting("comments"))?"":" class='hidden'");echo'<thead><tr>
';if($U=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($U=="TABLE"?lang(98):lang(99)),'<td id="label-type">',lang(38),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(100),'<td>',lang(101);if($U=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><acronym id="label-ai" title="',lang(40),'">AI</acronym>',doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",)),'<td id="label-default"',$_b,'>',lang(41),(support("comment")?"<td id='label-comment'$cb>".lang(39):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($o))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.1")."' alt='+' title='".lang(102)."'>".script("row_count = ".count($o).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$Ce=$n[($_POST?"orig":"field")];$Hb=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!$_POST["drop_col"][$t]))&&(support("drop_col")||$Ce=="");echo'<tr',($Hb?"":" style='display: none;'"),'>
',($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",$dd),$n["inout"]):""),'<th>';if($Hb){echo'<input name="fields[',$t,'][field]" value="',h($n["field"]),'" data-maxlength="64" autocapitalize="off" aria-labelledby="label-name">';}echo'<input type="hidden" name="fields[',$t,'][orig]" value="',h($Ce),'">';edit_type("fields[$t]",$n,$Xa,$Bc);if($U=="TABLE"){echo'<td>',checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$t,'"';if($n["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td',$_b,'>',checkbox("fields[$t][has_default]",1,$n["has_default"],"","","","label-default"),'<input name="fields[',$t,'][default]" value="',h($n["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td$cb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.1")."' alt='+' title='".lang(102)."'> "."<input type='image' class='icon' name='up[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.8.1")."' alt='↑' title='".lang(103)."'> "."<input type='image' class='icon' name='down[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.8.1")."' alt='↓' title='".lang(104)."'> ":""),($Ce==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.1")."' alt='x' title='".lang(105)."'>":"");}}function
process_fields(&$o){$ke=0;if($_POST["up"]){$wd=0;foreach($o
as$z=>$n){if(key($_POST["up"])==$z){unset($o[$z]);array_splice($o,$wd,0,array($n));break;}if(isset($n["field"]))$wd=$ke;$ke++;}}elseif($_POST["down"]){$Dc=false;foreach($o
as$z=>$n){if(isset($n["field"])&&$Dc){unset($o[key($_POST["down"])]);array_splice($o,$ke,0,array($Dc));break;}if(key($_POST["down"])==$z)$Dc=$n;$ke++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($C){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($C[0][0].$C[0][0],$C[0][0],substr($C[0],1,-1))),'\\'))."'";}function
grant($Hc,$jf,$e,$qe){if(!$jf)return
true;if($jf==array("ALL PRIVILEGES","GRANT OPTION"))return($Hc=="GRANT"?queries("$Hc ALL PRIVILEGES$qe WITH GRANT OPTION"):queries("$Hc ALL PRIVILEGES$qe")&&queries("$Hc GRANT OPTION$qe"));return
queries("$Hc ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$jf).$e).$qe);}function
drop_create($Lb,$i,$Mb,$Dg,$Nb,$B,$Td,$Rd,$Sd,$ne,$ce){if($_POST["drop"])query_redirect($Lb,$B,$Td);elseif($ne=="")query_redirect($i,$B,$Sd);elseif($ne!=$ce){$mb=queries($i);queries_redirect($B,$Rd,$mb&&queries($Lb));if($mb)queries($Mb);}else
queries_redirect($B,$Rd,queries($Dg)&&queries($Nb)&&queries($Lb)&&queries($i));}function
create_trigger($qe,$L){global$y;$Ig=" $L[Timing] $L[Event]".(preg_match('~ OF~',$L["Event"])?" $L[Of]":"");return"CREATE TRIGGER ".idf_escape($L["Trigger"]).($y=="mssql"?$qe.$Ig:$Ig.$qe).rtrim(" $L[Type]\n$L[Statement]",";").";";}function
create_routine($Ff,$L){global$dd,$y;$P=array();$o=(array)$L["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$P[]=(preg_match("~^($dd)\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Ab=rtrim("\n$L[definition]",";");return"CREATE $Ff ".idf_escape(trim($L["name"]))." (".implode(", ",$P).")".(isset($_GET["function"])?" RETURNS".process_type($L["returns"],"CHARACTER SET"):"").($L["language"]?" LANGUAGE $L[language]":"").($y=="pgsql"?" AS ".q($Ab):"$Ab;");}function
remove_definer($I){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$I);}function
format_foreign_key($p){global$re;$k=$p["db"];$ge=$p["ns"];return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$p["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($ge!=""&&$ge!=$_GET["ns"]?idf_escape($ge).".":"").table($p["table"])." (".implode(", ",array_map('idf_escape',$p["target"])).")".(preg_match("~^($re)\$~",$p["on_delete"])?" ON DELETE $p[on_delete]":"").(preg_match("~^($re)\$~",$p["on_update"])?" ON UPDATE $p[on_update]":"");}function
tar_file($vc,$Ng){$K=pack("a100a8a8a8a12a12",$vc,644,0,0,decoct($Ng->size),decoct(time()));$Pa=8*32;for($t=0;$t<strlen($K);$t++)$Pa+=ord($K[$t]);$K.=sprintf("%06o",$Pa)."\0 ";echo$K,str_repeat("\0",512-strlen($K));$Ng->send();echo
str_repeat("\0",511-($Ng->size+511)%512);}function
ini_bytes($cd){$X=ini_get($cd);switch(strtolower(substr($X,-1))){case'g':$X*=1024;case'm':$X*=1024;case'k':$X*=1024;}return$X;}function
doc_link($Te,$Eg="<sup>?</sup>"){global$y,$g;$Sf=$g->server_info;$uh=preg_replace('~^(\d\.?\d).*~s','\1',$Sf);$lh=array('sql'=>"https://dev.mysql.com/doc/refman/$uh/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$uh/",'mssql'=>"https://msdn.microsoft.com/library/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Sf)."&id=",);if(preg_match('~MariaDB~',$Sf)){$lh['sql']="https://mariadb.com/kb/en/library/";$Te['sql']=(isset($Te['mariadb'])?$Te['mariadb']:str_replace(".html","/",$Te['sql']));}return($Te[$y]?"<a href='".h($lh[$y].$Te[$y])."'".target_blank().">$Eg</a>":"");}function
ob_gzencode($lg){return
gzencode($lg);}function
db_size($k){global$g;if(!$g->select_db($k))return"?";$K=0;foreach(table_status()as$R)$K+=$R["Data_length"]+$R["Index_length"];return
format_number($K);}function
set_utf8mb4($i){global$g;static$P=false;if(!$P&&preg_match('~\butf8mb4~i',$i)){$P=true;echo"SET NAMES ".charset($g).";\n\n";}}function
connect_error(){global$c,$g,$T,$m,$Kb;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(26).": ".h(DB),lang(106),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(107),drop_databases($_POST["db"]));page_header(lang(108),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(109),'privileges'=>lang(60),'processlist'=>lang(110),'variables'=>lang(111),'status'=>lang(112),)as$z=>$X){if(support($z))echo"<a href='".h(ME)."$z='>$X</a>\n";}echo"<p>".lang(113,$Kb[DRIVER],"<b>".h($g->server_info)."</b>","<b>$g->extension</b>")."\n","<p>".lang(114,"<b>".h(logged_user())."</b>")."\n";$j=$c->databases();if($j){$Lf=support("scheme");$Xa=collations();echo"<form action='' method='post'>\n","<table cellspacing='0' class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(26)." - <a href='".h(ME)."refresh=1'>".lang(115)."</a>"."<td>".lang(116)."<td>".lang(117)."<td>".lang(118)." - <a href='".h(ME)."dbsize=1'>".lang(119)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$S){$Ef=h(ME)."db=".urlencode($k);$u=h("Db-".$k);echo"<tr".odd().">".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$Ef' id='$u'>".h($k)."</a>";$Wa=h(db_collation($k,$Xa));echo"<td>".(support("database")?"<a href='$Ef".($Lf?"&amp;ns=":"")."&amp;database=' title='".lang(56)."'>$Wa</a>":$Wa),"<td align='right'><a href='$Ef&amp;schema=' id='tables-".h($k)."' title='".lang(59)."'>".($_GET["dbsize"]?$S:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(120)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(121)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$T'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$g->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}$re="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($hb){$this->size+=strlen($hb);fwrite($this->handler,$hb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$bc="'(?:''|[^'\\\\]|\\\\.)*'";$dd="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$b=$_GET["download"];$o=fields($b);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$b-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$N=array(idf_escape($_GET["field"]));$J=$l->select($b,$N,array(where($_GET,$o)),$N);$L=($J?$J->fetch_row():array());echo$l->value($L[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$b=$_GET["table"];$o=fields($b);if(!$o)$m=error();$R=table_status1($b,true);$E=$c->tableName($R);page_header(($o&&is_view($R)?$R['Engine']=='materialized view'?lang(122):lang(123):lang(124)).": ".($E!=""?$E:h($b)),$m);$c->selectLinks($R);$bb=$R["Comment"];if($bb!="")echo"<p class='nowrap'>".lang(39).": ".h($bb)."\n";if($o)$c->tableStructurePrint($o);if(!is_view($R)){if(support("indexes")){echo"<h3 id='indexes'>".lang(125)."</h3>\n";$x=indexes($b);if($x)$c->tableIndexesPrint($x);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($b).'">'.lang(126)."</a>\n";}if(fk_support($R)){echo"<h3 id='foreign-keys'>".lang(94)."</h3>\n";$Bc=foreign_keys($b);if($Bc){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(127)."<td>".lang(128)."<td>".lang(97)."<td>".lang(96)."<td></thead>\n";foreach($Bc
as$E=>$p){echo"<tr title='".h($E)."'>","<th><i>".implode("</i>, <i>",array_map('h',$p["source"]))."</i>","<td><a href='".h($p["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($p["db"]),ME):($p["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($p["ns"]),ME):ME))."table=".urlencode($p["table"])."'>".($p["db"]!=""?"<b>".h($p["db"])."</b>.":"").($p["ns"]!=""?"<b>".h($p["ns"])."</b>.":"").h($p["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$p["target"]))."</i>)","<td>".h($p["on_delete"])."\n","<td>".h($p["on_update"])."\n",'<td><a href="'.h(ME.'foreign='.urlencode($b).'&name='.urlencode($E)).'">'.lang(129).'</a>';}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($b).'">'.lang(130)."</a>\n";}}if(support(is_view($R)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(131)."</h3>\n";$Xg=triggers($b);if($Xg){echo"<table cellspacing='0'>\n";foreach($Xg
as$z=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($z)."<td><a href='".h(ME.'trigger='.urlencode($b).'&name='.urlencode($z))."'>".lang(129)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($b).'">'.lang(132)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(59),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$vg=array();$wg=array();$da=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$Jd,PREG_SET_ORDER);foreach($Jd
as$t=>$C){$vg[$C[1]]=array($C[2],$C[3]);$wg[]="\n\t'".js_escape($C[1])."': [ $C[2], $C[3] ]";}$Pg=0;$Ca=-1;$Kf=array();$wf=array();$_d=array();foreach(table_status('',true)as$Q=>$R){if(is_view($R))continue;$Ze=0;$Kf[$Q]["fields"]=array();foreach(fields($Q)as$E=>$n){$Ze+=1.25;$n["pos"]=$Ze;$Kf[$Q]["fields"][$E]=$n;}$Kf[$Q]["pos"]=($vg[$Q]?$vg[$Q]:array($Pg,0));foreach($c->foreignKeys($Q)as$X){if(!$X["db"]){$yd=$Ca;if($vg[$Q][1]||$vg[$X["table"]][1])$yd=min(floatval($vg[$Q][1]),floatval($vg[$X["table"]][1]))-1;else$Ca-=.1;while($_d[(string)$yd])$yd-=.0001;$Kf[$Q]["references"][$X["table"]][(string)$yd]=array($X["source"],$X["target"]);$wf[$X["table"]][$Q][(string)$yd]=$X["target"];$_d[(string)$yd]=true;}}$Pg=max($Pg,$Kf[$Q]["pos"][0]+2.5+$Ze);}echo'<div id="schema" style="height: ',$Pg,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$wg)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$Pg,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Kf
as$E=>$Q){echo"<div class='table' style='top: ".$Q["pos"][0]."em; left: ".$Q["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($E).'"><b>'.h($E)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($Q["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["full_type"].($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$Q["references"]as$Bg=>$xf){foreach($xf
as$yd=>$tf){$zd=$yd-$vg[$E][1];$t=0;foreach($tf[0]as$bg)echo"\n<div class='references' title='".h($Bg)."' id='refs$yd-".($t++)."' style='left: $zd"."em; top: ".$Q["fields"][$bg]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$zd)."em;'></div></div>";}}foreach((array)$wf[$E]as$Bg=>$xf){foreach($xf
as$yd=>$e){$zd=$yd-$vg[$E][1];$t=0;foreach($e
as$Ag)echo"\n<div class='references' title='".h($Bg)."' id='refd$yd-".($t++)."' style='left: $zd"."em; top: ".$Q["fields"][$Ag]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.8.1")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$zd)."em;'></div></div>";}}echo"\n</div>\n";}foreach($Kf
as$E=>$Q){foreach((array)$Q["references"]as$Bg=>$xf){foreach($xf
as$yd=>$tf){$Vd=$Pg;$Nd=-10;foreach($tf[0]as$z=>$bg){$af=$Q["pos"][0]+$Q["fields"][$bg]["pos"];$bf=$Kf[$Bg]["pos"][0]+$Kf[$Bg]["fields"][$tf[1][$z]]["pos"];$Vd=min($Vd,$af,$bf);$Nd=max($Nd,$af,$bf);}echo"<div class='references' id='refl$yd' style='left: $yd"."em; top: $Vd"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Nd-$Vd)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(133),'</a>
';}elseif(isset($_GET["dump"])){$b=$_GET["dump"];if($_POST&&!$m){$kb="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$z)$kb.="&$z=".urlencode($_POST[$z]);cookie("adminer_export",substr($kb,1));$S=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$nc=dump_headers((count($S)==1?key($S):DB),(DB==""||count($S)>1));$ld=preg_match('~sql~',$_POST["format"]);if($ld){echo"-- Adminer $fa ".$Kb[DRIVER]." ".str_replace("\n"," ",$g->server_info)." dump\n\n";if($y=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$g->query("SET time_zone = '+00:00'");$g->query("SET sql_mode = ''");}}$ng=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){$c->dumpDatabase($k);if($g->select_db($k)){if($ld&&preg_match('~CREATE~',$ng)&&($i=$g->result("SHOW CREATE DATABASE ".idf_escape($k),1))){set_utf8mb4($i);if($ng=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($k).";\n";echo"$i;\n";}if($ld){if($ng)echo
use_sql($k).";\n\n";$He="";if($_POST["routines"]){foreach(array("FUNCTION","PROCEDURE")as$Ff){foreach(get_rows("SHOW $Ff STATUS WHERE Db = ".q($k),null,"-- ")as$L){$i=remove_definer($g->result("SHOW CREATE $Ff ".idf_escape($L["Name"]),2));set_utf8mb4($i);$He.=($ng!='DROP+CREATE'?"DROP $Ff IF EXISTS ".idf_escape($L["Name"]).";;\n":"")."$i;;\n\n";}}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$L){$i=remove_definer($g->result("SHOW CREATE EVENT ".idf_escape($L["Name"]),3));set_utf8mb4($i);$He.=($ng!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($L["Name"]).";;\n":"")."$i;;\n\n";}}if($He)echo"DELIMITER ;;\n\n$He"."DELIMITER ;\n\n";}if($_POST["table_style"]||$_POST["data_style"]){$wh=array();foreach(table_status('',true)as$E=>$R){$Q=(DB==""||in_array($E,(array)$_POST["tables"]));$sb=(DB==""||in_array($E,(array)$_POST["data"]));if($Q||$sb){if($nc=="tar"){$Ng=new
TmpFile;ob_start(array($Ng,'write'),1e5);}$c->dumpTable($E,($Q?$_POST["table_style"]:""),(is_view($R)?2:0));if(is_view($R))$wh[]=$E;elseif($sb){$o=fields($E);$c->dumpData($E,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($E));}if($ld&&$_POST["triggers"]&&$Q&&($Xg=trigger_sql($E)))echo"\nDELIMITER ;;\n$Xg\nDELIMITER ;\n";if($nc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$E.csv",$Ng);}elseif($ld)echo"\n";}}if(function_exists('foreign_keys_sql')){foreach(table_status('',true)as$E=>$R){$Q=(DB==""||in_array($E,(array)$_POST["tables"]));if($Q&&!is_view($R))echo
foreign_keys_sql($E);}}foreach($wh
as$vh)$c->dumpTable($vh,$_POST["table_style"],1);if($nc=="tar")echo
pack("x512");}}}if($ld)echo"-- ".$g->result("SELECT NOW()")."\n";exit;}page_header(lang(62),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
';$wb=array('','USE','DROP+CREATE','CREATE');$xg=array('','DROP+CREATE','CREATE');$tb=array('','TRUNCATE+INSERT','INSERT');if($y=="sql")$tb[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$L);if(!$L)$L=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($L["events"])){$L["routines"]=$L["events"]=($_GET["dump"]=="");$L["triggers"]=$L["table_style"];}echo"<tr><th>".lang(134)."<td>".html_select("output",$c->dumpOutput(),$L["output"],0)."\n";echo"<tr><th>".lang(135)."<td>".html_select("format",$c->dumpFormat(),$L["format"],0)."\n";echo($y=="sqlite"?"":"<tr><th>".lang(26)."<td>".html_select('db_style',$wb,$L["db_style"]).(support("routine")?checkbox("routines",1,$L["routines"],lang(136)):"").(support("event")?checkbox("events",1,$L["events"],lang(137)):"")),"<tr><th>".lang(117)."<td>".html_select('table_style',$xg,$L["table_style"]).checkbox("auto_increment",1,$L["auto_increment"],lang(40)).(support("trigger")?checkbox("triggers",1,$L["triggers"],lang(131)):""),"<tr><th>".lang(138)."<td>".html_select('data_style',$tb,$L["data_style"]),'</table>
<p><input type="submit" value="',lang(62),'">
<input type="hidden" name="token" value="',$T,'">

<table cellspacing="0">
',script("qsl('table').onclick = dumpClick;");$ef=array();if(DB!=""){$Na=($b!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$Na>".lang(117)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(138)."<input type='checkbox' id='check-data'$Na></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$wh="";$yg=tables_list();foreach($yg
as$E=>$U){$df=preg_replace('~_.*~','',$E);$Na=($b==""||$b==(substr($b,-1)=="%"?"$df%":$E));$gf="<tr><td>".checkbox("tables[]",$E,$Na,$E,"","block");if($U!==null&&!preg_match('~table~i',$U))$wh.="$gf\n";else
echo"$gf<td align='right'><label class='block'><span id='Rows-".h($E)."'></span>".checkbox("data[]",$E,$Na)."</label>\n";$ef[$df]++;}echo$wh;if($yg)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($b==""?" checked":"").">".lang(26)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=$c->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$df=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$b==""||$b=="$df%",$k,"","block")."\n";$ef[$df]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$xc=true;foreach($ef
as$z=>$X){if($z!=""&&$X>1){echo($xc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$z%")."'>".h($z)."</a>";$xc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(60));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(139)."</a>";$J=$g->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$Hc=$J;if(!$J)$J=$g->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($Hc?"":"<input type='hidden' name='grant' value=''>\n"),"<table cellspacing='0'>\n","<thead><tr><th>".lang(24)."<th>".lang(23)."<th></thead>\n";while($L=$J->fetch_assoc())echo'<tr'.odd().'><td>'.h($L["User"])."<td>".h($L["Host"]).'<td><a href="'.h(ME.'user='.urlencode($L["User"]).'&host='.urlencode($L["Host"])).'">'.lang(10)."</a>\n";if(!$Hc||DB!="")echo"<tr".odd()."><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){dump_headers("sql");$c->dumpTable("","");$c->dumpData("","table",$_POST["query"]);exit;}restart_session();$Uc=&get_session("queries");$Tc=&$Uc[DB];if(!$m&&$_POST["clear"]){$Tc=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(61):lang(53)),$m);if(!$m&&$_POST){$q=false;if(!isset($_GET["import"]))$I=$_POST["query"];elseif($_POST["webfile"]){$eg=$c->importServerPath();$q=@fopen((file_exists($eg)?$eg:"compress.zlib://$eg.gz"),"rb");$I=($q?fread($q,1e6):false);}else$I=get_file("sql_file",true);if(is_string($I)){if(function_exists('memory_get_usage'))@ini_set("memory_limit",max(ini_bytes("memory_limit"),2*strlen($I)+memory_get_usage()+8e6));if($I!=""&&strlen($I)<1e6){$H=$I.(preg_match("~;[ \t\r\n]*\$~",$I)?"":";");if(!$Tc||reset(end($Tc))!=$H){restart_session();$Tc[]=array($H,time());set_session("queries",$Uc);stop_session();}}$cg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Cb=";";$ke=0;$Yb=true;$h=connect();if(is_object($h)&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$ab=0;$dc=array();$Ne='[\'"'.($y=="sql"?'`#':($y=="sqlite"?'`[':($y=="mssql"?'[':''))).']|/\*|-- |$'.($y=="pgsql"?'|\$[^$]*\$':'');$Qg=microtime(true);parse_str($_COOKIE["adminer_export"],$la);$Pb=$c->dumpFormat();unset($Pb["sql"]);while($I!=""){if(!$ke&&preg_match("~^$cg*+DELIMITER\\s+(\\S+)~i",$I,$C)){$Cb=$C[1];$I=substr($I,strlen($C[0]));}else{preg_match('('.preg_quote($Cb)."\\s*|$Ne)",$I,$C,PREG_OFFSET_CAPTURE,$ke);list($Dc,$Ze)=$C[0];if(!$Dc&&$q&&!feof($q))$I.=fread($q,1e5);else{if(!$Dc&&rtrim($I)=="")break;$ke=$Ze+strlen($Dc);if($Dc&&rtrim($Dc)!=$Cb){while(preg_match('('.($Dc=='/*'?'\*/':($Dc=='['?']':(preg_match('~^-- |^#~',$Dc)?"\n":preg_quote($Dc)."|\\\\."))).'|$)s',$I,$C,PREG_OFFSET_CAPTURE,$ke)){$If=$C[0][0];if(!$If&&$q&&!feof($q))$I.=fread($q,1e5);else{$ke=$C[0][1]+strlen($If);if($If[0]!="\\")break;}}}else{$Yb=false;$H=substr($I,0,$Ze);$ab++;$gf="<pre id='sql-$ab'><code class='jush-$y'>".$c->sqlCommandQuery($H)."</code></pre>\n";if($y=="sqlite"&&preg_match("~^$cg*+ATTACH\\b~i",$H,$C)){echo$gf,"<p class='error'>".lang(140)."\n";$dc[]=" <a href='#sql-$ab'>$ab</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$gf;ob_flush();flush();}$hg=microtime(true);if($g->multi_query($H)&&is_object($h)&&preg_match("~^$cg*+USE\\b~i",$H))$h->query($H);do{$J=$g->store_result();if($g->error){echo($_POST["only_errors"]?$gf:""),"<p class='error'>".lang(141).($g->errno?" ($g->errno)":"").": ".error()."\n";$dc[]=" <a href='#sql-$ab'>$ab</a>";if($_POST["error_stops"])break
2;}else{$Gg=" <span class='time'>(".format_time($hg).")</span>".(strlen($H)<1000?" <a href='".h(ME)."sql=".urlencode(trim($H))."'>".lang(10)."</a>":"");$na=$g->affected_rows;$zh=($_POST["only_errors"]?"":$l->warnings());$_h="warnings-$ab";if($zh)$Gg.=", <a href='#$_h'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$_h');","");$lc=null;$mc="explain-$ab";if(is_object($J)){$_=$_POST["limit"];$Be=select($J,$h,array(),$_);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$he=$J->num_rows;echo"<p>".($he?($_&&$he>$_?lang(142,$_):"").lang(143,$he):""),$Gg;if($h&&preg_match("~^($cg|\\()*+SELECT\\b~i",$H)&&($lc=explain($h,$H)))echo", <a href='#$mc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$mc');","");$u="export-$ab";echo", <a href='#$u'>".lang(62)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",$c->dumpOutput(),$la["output"])." ".html_select("format",$Pb,$la["format"])."<input type='hidden' name='query' value='".h($H)."'>"." <input type='submit' name='export' value='".lang(62)."'><input type='hidden' name='token' value='$T'></span>\n"."</form>\n";}}else{if(preg_match("~^$cg*+(CREATE|DROP|ALTER)$cg++(DATABASE|SCHEMA)\\b~i",$H)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($g->info)."'>".lang(144,$na)."$Gg\n";}echo($zh?"<div id='$_h' class='hidden'>\n$zh</div>\n":"");if($lc){echo"<div id='$mc' class='hidden'>\n";select($lc,$h,$Be);echo"</div>\n";}}$hg=microtime(true);}while($g->next_result());}$I=substr($I,$ke);$ke=0;}}}}if($Yb)echo"<p class='message'>".lang(145)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(146,$ab-count($dc))," <span class='time'>(".format_time($Qg).")</span>\n";}elseif($dc&&$ab>1)echo"<p class='error'>".lang(141).": ".implode("",$dc)."\n";}else
echo"<p class='error'>".upload_error($I)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$jc="<input type='submit' value='".lang(147)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$H=$_GET["sql"];if($_POST)$H=$_POST["query"];elseif($_GET["history"]=="all")$H=$Tc;elseif($_GET["history"]!="")$H=$Tc[$_GET["history"]][0];echo"<p>";textarea("query",$H,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>$jc\n",lang(148).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(149)."</legend><div>";$Mc=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$Mc (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$jc":lang(150)),"</div></fieldset>\n";$Zc=$c->importServerPath();if($Zc){echo"<fieldset><legend>".lang(151)."</legend><div>",lang(152,"<code>".h($Zc)."$Mc</code>"),' <input type="submit" name="webfile" value="'.lang(153).'">',"</div></fieldset>\n";}echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(154))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(155))."\n","<input type='hidden' name='token' value='$T'>\n";if(!isset($_GET["import"])&&$Tc){print_fieldset("history",lang(156),$_GET["history"]!="");for($X=end($Tc);$X;$X=prev($Tc)){$z=key($Tc);list($H,$Gg,$Tb)=$X;echo'<a href="'.h(ME."sql=&history=$z").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$Gg)."'>".@date("H:i:s",$Gg)."</span>"." <code class='jush-$y'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$H)))),80,"</code>").($Tb?" <span class='time'>($Tb)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(157)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(158)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$b=$_GET["edit"];$o=fields($b);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$ih=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$E=>$n){if(!isset($n["privileges"][$ih?"update":"insert"])||$c->fieldName($n)==""||$n["generated"])unset($o[$E]);}if($_POST&&!$m&&!isset($_GET["select"])){$B=$_POST["referer"];if($_POST["insert"])$B=($ih?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$B))$B=ME."select=".urlencode($b);$x=indexes($b);$dh=unique_array($_GET["where"],$x);$pf="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($B,lang(159),$l->delete($b,$pf,!$dh));else{$P=array();foreach($o
as$E=>$n){$X=process_input($n);if($X!==false&&$X!==null)$P[idf_escape($E)]=$X;}if($ih){if(!$P)redirect($B);queries_redirect($B,lang(160),$l->update($b,$P,$pf,!$dh));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$J=$l->insert($b,$P);$xd=($J?last_id():0);queries_redirect($B,lang(161,($xd?" $xd":"")),$J);}}}$L=null;if($_POST["save"])$L=(array)$_POST["fields"];elseif($Z){$N=array();foreach($o
as$E=>$n){if(isset($n["privileges"]["select"])){$ua=convert_field($n);if($_POST["clone"]&&$n["auto_increment"])$ua="''";if($y=="sql"&&preg_match("~enum|set~",$n["type"]))$ua="1*".idf_escape($E);$N[]=($ua?"$ua AS ":"").idf_escape($E);}}$L=array();if(!support("table"))$N=array("*");if($N){$J=$l->select($b,$N,array($Z),$N,array(),(isset($_GET["select"])?2:1));if(!$J)$m=error();else{$L=$J->fetch_assoc();if(!$L)$L=false;}if(isset($_GET["select"])&&(!$L||$J->fetch_assoc()))$L=null;}}if(!support("table")&&!$o){if(!$Z){$J=$l->select($b,array("*"),$Z,array("*"));$L=($J?$J->fetch_assoc():false);if(!$L)$L=array($l->primary=>"");}if($L){foreach($L
as$z=>$X){if(!$Z)$L[$z]=null;$o[$z]=array("field"=>$z,"null"=>($z!=$l->primary),"auto_increment"=>($z==$l->primary));}}}edit_form($b,$o,$L,$ih);}elseif(isset($_GET["create"])){$b=$_GET["create"];$Oe=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$z)$Oe[$z]=$z;$vf=referencable_primary($b);$Bc=array();foreach($vf
as$ug=>$n)$Bc[str_replace("`","``",$ug)."`".str_replace("`","``",$n["field"])]=$ug;$Ee=array();$R=array();if($b!=""){$Ee=fields($b);$R=table_status($b);if(!$R)$m=lang(9);}$L=$_POST;$L["fields"]=(array)$L["fields"];if($L["auto_increment_col"])$L["fields"][$L["auto_increment_col"]]["auto_increment"]=true;if($_POST)set_adminer_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($L["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(162),drop_tables(array($b)));else{$o=array();$ra=array();$mh=false;$_c=array();$De=reset($Ee);$pa=" FIRST";foreach($L["fields"]as$z=>$n){$p=$Bc[$n["type"]];$Yg=($p!==null?$vf[$p]:$n);if($n["field"]!=""){if(!$n["has_default"])$n["default"]=null;if($z==$L["auto_increment_col"])$n["auto_increment"]=true;$lf=process_field($n,$Yg);$ra[]=array($n["orig"],$lf,$pa);if(!$De||$lf!=process_field($De,$De)){$o[]=array($n["orig"],$lf,$pa);if($n["orig"]!=""||$pa)$mh=true;}if($p!==null)$_c[idf_escape($n["field"])]=($b!=""&&$y!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$Bc[$n["type"]],'source'=>array($n["field"]),'target'=>array($Yg["field"]),'on_delete'=>$n["on_delete"],));$pa=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$mh=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$De=next($Ee);if(!$De)$pa="";}}$Qe="";if($Oe[$L["partition_by"]]){$Re=array();if($L["partition_by"]=='RANGE'||$L["partition_by"]=='LIST'){foreach(array_filter($L["partition_names"])as$z=>$X){$Y=$L["partition_values"][$z];$Re[]="\n  PARTITION ".idf_escape($X)." VALUES ".($L["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$Qe.="\nPARTITION BY $L[partition_by]($L[partition])".($Re?" (".implode(",",$Re)."\n)":($L["partitions"]?" PARTITIONS ".(+$L["partitions"]):""));}elseif(support("partitioning")&&preg_match("~partitioned~",$R["Create_options"]))$Qe.="\nREMOVE PARTITIONING";$D=lang(163);if($b==""){cookie("adminer_engine",$L["Engine"]);$D=lang(164);}$E=trim($L["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($E),$D,alter_table($b,$E,($y=="sqlite"&&($mh||$_c)?$ra:$o),$_c,($L["Comment"]!=$R["Comment"]?$L["Comment"]:null),($L["Engine"]&&$L["Engine"]!=$R["Engine"]?$L["Engine"]:""),($L["Collation"]&&$L["Collation"]!=$R["Collation"]?$L["Collation"]:""),($L["Auto_increment"]!=""?number($L["Auto_increment"]):""),$Qe));}}page_header(($b!=""?lang(33):lang(63)),$m,array("table"=>$b),h($b));if(!$_POST){$L=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($ah["int"])?"int":(isset($ah["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($b!=""){$L=$R;$L["name"]=$b;$L["fields"]=array();if(!$_GET["auto_increment"])$L["Auto_increment"]="";foreach($Ee
as$n){$n["has_default"]=isset($n["default"]);$L["fields"][]=$n;}if(support("partitioning")){$Fc="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($b);$J=$g->query("SELECT PARTITION_METHOD, PARTITION_ORDINAL_POSITION, PARTITION_EXPRESSION $Fc ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");list($L["partition_by"],$L["partitions"],$L["partition"])=$J->fetch_row();$Re=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $Fc AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$Re[""]="";$L["partition_names"]=array_keys($Re);$L["partition_values"]=array_values($Re);}}}$Xa=collations();$ac=engines();foreach($ac
as$Zb){if(!strcasecmp($Zb,$L["Engine"])){$L["Engine"]=$Zb;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$b==""){echo
lang(165),': <input name="name" data-maxlength="64" value="',h($L["name"]),'" autocapitalize="off">
';if($b==""&&!$_POST)echo
script("focus(qs('#form')['name']);");echo($ac?"<select name='Engine'>".optionlist(array(""=>"(".lang(166).")")+$ac,$L["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($Xa&&!preg_match("~sqlite|mssql~",$y)?html_select("Collation",array(""=>"(".lang(95).")")+$Xa,$L["Collation"]):""),' <input type="submit" value="',lang(14),'">
';}echo'
';if(support("columns")){echo'<div class="scrollable">
<table cellspacing="0" id="edit-fields" class="nowrap">
';edit_fields($L["fields"],$Xa,"TABLE",$Bc);echo'</table>
',script("editFields();"),'</div>
<p>
',lang(40),': <input type="number" name="Auto_increment" size="6" value="',h($L["Auto_increment"]),'">
',checkbox("defaults",1,($_POST?$_POST["defaults"]:adminer_setting("defaults")),lang(167),"columnShow(this.checked, 5)","jsonly"),(support("comment")?checkbox("comments",1,($_POST?$_POST["comments"]:adminer_setting("comments")),lang(39),"editingCommentsClick(this, true);","jsonly").' <input name="Comment" value="'.h($L["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'">':''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($b!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$b));}if(support("partitioning")){$Pe=preg_match('~RANGE|LIST~',$L["partition_by"]);print_fieldset("partition",lang(169),$L["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$Oe,$L["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($L["partition"]),'">)
',lang(170),': <input type="number" name="partitions" class="size',($Pe||!$L["partition_by"]?" hidden":""),'" value="',h($L["partitions"]),'">
<table cellspacing="0" id="partition-table"',($Pe?"":" class='hidden'"),'>
<thead><tr><th>',lang(171),'<th>',lang(172),'</thead>
';foreach($L["partition_names"]as$z=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($z==count($L["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($L["partition_values"][$z]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["indexes"])){$b=$_GET["indexes"];$bd=array("PRIMARY","UNIQUE","INDEX");$R=table_status($b,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$R["Engine"]))$bd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$R["Engine"]))$bd[]="SPATIAL";$x=indexes($b);$ff=array();if($y=="mongo"){$ff=$x["_id_"];unset($bd[0]);unset($x["_id_"]);}$L=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$sa=array();foreach($L["indexes"]as$w){$E=$w["name"];if(in_array($w["type"],$bd)){$e=array();$Cd=array();$Eb=array();$P=array();ksort($w["columns"]);foreach($w["columns"]as$z=>$d){if($d!=""){$Bd=$w["lengths"][$z];$Db=$w["descs"][$z];$P[]=idf_escape($d).($Bd?"(".(+$Bd).")":"").($Db?" DESC":"");$e[]=$d;$Cd[]=($Bd?$Bd:null);$Eb[]=$Db;}}if($e){$kc=$x[$E];if($kc){ksort($kc["columns"]);ksort($kc["lengths"]);ksort($kc["descs"]);if($w["type"]==$kc["type"]&&array_values($kc["columns"])===$e&&(!$kc["lengths"]||array_values($kc["lengths"])===$Cd)&&array_values($kc["descs"])===$Eb){unset($x[$E]);continue;}}$sa[]=array($w["type"],$E,$P);}}}foreach($x
as$E=>$kc)$sa[]=array($kc["type"],$E,"DROP");if(!$sa)redirect(ME."table=".urlencode($b));queries_redirect(ME."table=".urlencode($b),lang(173),alter_indexes($b,$sa));}page_header(lang(125),$m,array("table"=>$b),h($b));$o=array_keys(fields($b));if($_POST["add"]){foreach($L["indexes"]as$z=>$w){if($w["columns"][count($w["columns"])]!="")$L["indexes"][$z]["columns"][]="";}$w=end($L["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$L["indexes"][]=array("columns"=>array(1=>""));}if(!$L){foreach($x
as$z=>$w){$x[$z]["name"]=$z;$x[$z]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$L["indexes"]=$x;}echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
<thead><tr>
<th id="label-type">',lang(174),'<th><input type="submit" class="wayoff">',lang(175),'<th id="label-name">',lang(176),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.1")."' alt='+' title='".lang(102)."'>",'</noscript>
</thead>
';if($ff){echo"<tr><td>PRIMARY<td>";foreach($ff["columns"]as$z=>$d){echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".lang(48)."</label> ";}echo"<td><td>\n";}$nd=1;foreach($L["indexes"]as$w){if(!$_POST["drop_col"]||$nd!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$nd][type]",array(-1=>"")+$bd,$w["type"],($nd==count($L["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$z=>$d){echo"<span>".select_input(" name='indexes[$nd][columns][$t]' title='".lang(37)."'",($o?array_combine($o,$o):$o),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($y=="sql"?"":$_GET["indexes"]."_")."')"),($y=="sql"||$y=="mssql"?"<input type='number' name='indexes[$nd][lengths][$t]' class='size' value='".h($w["lengths"][$z])."' title='".lang(100)."'>":""),(support("descidx")?checkbox("indexes[$nd][descs][$t]",1,$w["descs"][$z],lang(48)):"")," </span>";$t++;}echo"<td><input name='indexes[$nd][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$nd]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.1")."' alt='x' title='".lang(105)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$nd++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["database"])){$L=$_POST;if($_POST&&!$m&&!isset($_POST["add_x"])){$E=trim($L["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(177),drop_databases(array(DB)));}elseif(DB!==$E){if(DB!=""){$_GET["db"]=$E;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($E),lang(178),rename_database($E,$L["collation"]));}else{$j=explode("\n",str_replace("\r","",$E));$og=true;$wd="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$L["collation"]))$og=false;$wd=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($wd),lang(179),$og);}}else{if(!$L["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($E).(preg_match('~^[a-z0-9_]+$~i',$L["collation"])?" COLLATE $L[collation]":""),substr(ME,0,-1),lang(180));}}page_header(DB!=""?lang(56):lang(109),$m,array(),h(DB));$Xa=collations();$E=DB;if($_POST)$E=$L["name"];elseif(DB!="")$L["collation"]=db_collation(DB,$Xa);elseif($y=="sql"){foreach(get_vals("SHOW GRANTS")as$Hc){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$Hc,$C)&&$C[1]){$E=stripcslashes(idf_unescape("`$C[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($E,"\n")?'<textarea id="name" name="name" rows="10" cols="40">'.h($E).'</textarea><br>':'<input name="name" id="name" value="'.h($E).'" data-maxlength="64" autocapitalize="off">')."\n".($Xa?html_select("collation",array(""=>"(".lang(95).")")+$Xa,$L["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",)):""),script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(121)."'>".confirm(lang(168,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.1")."' alt='+' title='".lang(102)."'>\n";echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(181).": ".h($ca),$m);$Ff=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$ad=array();$He=array();foreach($Ff["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT")$He[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$ad[]=$t;}if(!$m&&$_POST){$Ja=array();foreach($Ff["fields"]as$z=>$n){if(in_array($z,$ad)){$X=process_input($n);if($X===false)$X="''";if(isset($He[$z]))$g->query("SET @".idf_escape($n["field"])." = $X");}$Ja[]=(isset($He[$z])?"@".idf_escape($n["field"]):$X);}$I=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($ca)."(".implode(", ",$Ja).")";$hg=microtime(true);$J=$g->multi_query($I);$na=$g->affected_rows;echo$c->selectQuery($I,$hg,!$J);if(!$J)echo"<p class='error'>".error()."\n";else{$h=connect();if(is_object($h))$h->select_db(DB);do{$J=$g->store_result();if(is_object($J))select($J,$h);else
echo"<p class='message'>".lang(182,$na)." <span class='time'>".@date("H:i:s")."</span>\n";}while($g->next_result());if($He)select($g->query("SELECT ".implode(", ",$He)));}}echo'
<form action="" method="post">
';if($ad){echo"<table cellspacing='0' class='layout'>\n";foreach($ad
as$z){$n=$Ff["fields"][$z];$E=$n["field"];echo"<tr><th>".$c->fieldName($n);$Y=$_POST["fields"][$E];if($Y!=""){if($n["type"]=="enum")$Y=+$Y;if($n["type"]=="set")$Y=array_sum($Y);}input($n,$Y,(string)$_POST["function"][$E]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(181),'">
<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["foreign"])){$b=$_GET["foreign"];$E=$_GET["name"];$L=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$D=($_POST["drop"]?lang(183):($E!=""?lang(184):lang(185)));$B=ME."table=".urlencode($b);if(!$_POST["drop"]){$L["source"]=array_filter($L["source"],'strlen');ksort($L["source"]);$Ag=array();foreach($L["source"]as$z=>$X)$Ag[$z]=$L["target"][$z];$L["target"]=$Ag;}if($y=="sqlite")queries_redirect($B,$D,recreate_table($b,$b,array(),array(),array(" $E"=>($_POST["drop"]?"":" ".format_foreign_key($L)))));else{$sa="ALTER TABLE ".table($b);$Lb="\nDROP ".($y=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($E);if($_POST["drop"])query_redirect($sa.$Lb,$B,$D);else{query_redirect($sa.($E!=""?"$Lb,":"")."\nADD".format_foreign_key($L),$B,$D);$m=lang(186)."<br>$m";}}}page_header(lang(187),$m,array("table"=>$b),h($b));if($_POST){ksort($L["source"]);if($_POST["add"])$L["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$L["target"]=array();}elseif($E!=""){$Bc=foreign_keys($b);$L=$Bc[$E];$L["source"][]="";}else{$L["table"]=$b;$L["source"]=array("");}echo'
<form action="" method="post">
';$bg=array_keys(fields($b));if($L["db"]!="")$g->select_db($L["db"]);if($L["ns"]!="")set_schema($L["ns"]);$uf=array_keys(array_filter(table_status('',true),'fk_support'));$Ag=array_keys(fields(in_array($L["table"],$uf)?$L["table"]:reset($uf)));$se="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(188).": ".html_select("table",$uf,$L["table"],$se)."\n";if($y=="pgsql")echo
lang(189).": ".html_select("ns",$c->schemas(),$L["ns"]!=""?$L["ns"]:$_GET["ns"],$se);elseif($y!="sqlite"){$xb=array();foreach($c->databases()as$k){if(!information_schema($k))$xb[]=$k;}echo
lang(65).": ".html_select("db",$xb,$L["db"]!=""?$L["db"]:$_GET["db"],$se);}echo'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(190),'"></noscript>
<table cellspacing="0">
<thead><tr><th id="label-source">',lang(127),'<th id="label-target">',lang(128),'</thead>
';$nd=0;foreach($L["source"]as$z=>$X){echo"<tr>","<td>".html_select("source[".(+$z)."]",array(-1=>"")+$bg,$X,($nd==count($L["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$z)."]",$Ag,$L["target"][$z],1,"label-target");$nd++;}echo'</table>
<p>
',lang(97),': ',html_select("on_delete",array(-1=>"")+explode("|",$re),$L["on_delete"]),' ',lang(96),': ',html_select("on_update",array(-1=>"")+explode("|",$re),$L["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(191),'"></noscript>
';if($E!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$E));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["view"])){$b=$_GET["view"];$L=$_POST;$Fe="VIEW";if($y=="pgsql"&&$b!=""){$ig=table_status($b);$Fe=strtoupper($ig["Engine"]);}if($_POST&&!$m){$E=trim($L["name"]);$ua=" AS\n$L[select]";$B=ME."table=".urlencode($E);$D=lang(192);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$b==$E&&$y!="sqlite"&&$U=="VIEW"&&$Fe=="VIEW")query_redirect(($y=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($E).$ua,$B,$D);else{$Cg=$E."_adminer_".uniqid();drop_create("DROP $Fe ".table($b),"CREATE $U ".table($E).$ua,"DROP $U ".table($E),"CREATE $U ".table($Cg).$ua,"DROP $U ".table($Cg),($_POST["drop"]?substr(ME,0,-1):$B),lang(193),$D,lang(194),$b,$E);}}if(!$_POST&&$b!=""){$L=view($b);$L["name"]=$b;$L["materialized"]=($Fe!="VIEW");if(!$m)$m=error();}page_header(($b!=""?lang(32):lang(195)),$m,array("table"=>$b),h($b));echo'
<form action="" method="post">
<p>',lang(176),': <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$L["materialized"],lang(122)):""),'<p>';textarea("select",$L["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($b!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$b));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$gd=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$jg=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$L=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(196));elseif(in_array($L["INTERVAL_FIELD"],$gd)&&isset($jg[$L["STATUS"]])){$Jf="\nON SCHEDULE ".($L["INTERVAL_VALUE"]?"EVERY ".q($L["INTERVAL_VALUE"])." $L[INTERVAL_FIELD]".($L["STARTS"]?" STARTS ".q($L["STARTS"]):"").($L["ENDS"]?" ENDS ".q($L["ENDS"]):""):"AT ".q($L["STARTS"]))." ON COMPLETION".($L["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(197):lang(198)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Jf.($aa!=$L["EVENT_NAME"]?"\nRENAME TO ".idf_escape($L["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($L["EVENT_NAME"]).$Jf)."\n".$jg[$L["STATUS"]]." COMMENT ".q($L["EVENT_COMMENT"]).rtrim(" DO\n$L[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(199).": ".h($aa):lang(200)),$m);if(!$L&&$aa!=""){$M=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$L=reset($M);}echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(176),'<td><input name="EVENT_NAME" value="',h($L["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(201),'<td><input name="STARTS" value="',h("$L[EXECUTE_AT]$L[STARTS]"),'">
<tr><th title="datetime">',lang(202),'<td><input name="ENDS" value="',h($L["ENDS"]),'">
<tr><th>',lang(203),'<td><input type="number" name="INTERVAL_VALUE" value="',h($L["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$gd,$L["INTERVAL_FIELD"]),'<tr><th>',lang(112),'<td>',html_select("STATUS",$jg,$L["STATUS"]),'<tr><th>',lang(39),'<td><input name="EVENT_COMMENT" value="',h($L["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$L["ON_COMPLETION"]=="PRESERVE",lang(204)),'</table>
<p>';textarea("EVENT_DEFINITION",$L["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$aa));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$Ff=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$L=$_POST;$L["fields"]=(array)$L["fields"];if($_POST&&!process_fields($L["fields"])&&!$m){$Ce=routine($_GET["procedure"],$Ff);$Cg="$L[name]_adminer_".uniqid();drop_create("DROP $Ff ".routine_id($ca,$Ce),create_routine($Ff,$L),"DROP $Ff ".routine_id($L["name"],$L),create_routine($Ff,array("name"=>$Cg)+$L),"DROP $Ff ".routine_id($Cg,$L),substr(ME,0,-1),lang(205),lang(206),lang(207),$ca,$L["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(208):lang(209)).": ".h($ca):(isset($_GET["function"])?lang(210):lang(211))),$m);if(!$_POST&&$ca!=""){$L=routine($_GET["procedure"],$Ff);$L["name"]=$ca;}$Xa=get_vals("SHOW CHARACTER SET");sort($Xa);$Gf=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(176),': <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',($Gf?lang(19).": ".html_select("language",$Gf,$L["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
';edit_fields($L["fields"],$Xa,$Ff);if(isset($_GET["function"])){echo"<tr><td>".lang(212);edit_type("returns",$L["returns"],$Xa,array(),($y=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$L["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($ca!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$ca));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["trigger"])){$b=$_GET["trigger"];$E=$_GET["name"];$Wg=trigger_options();$L=(array)trigger($E,$b)+array("Trigger"=>$b."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$Wg["Timing"])&&in_array($_POST["Event"],$Wg["Event"])&&in_array($_POST["Type"],$Wg["Type"])){$qe=" ON ".table($b);$Lb="DROP TRIGGER ".idf_escape($E).($y=="pgsql"?$qe:"");$B=ME."table=".urlencode($b);if($_POST["drop"])query_redirect($Lb,$B,lang(213));else{if($E!="")queries($Lb);queries_redirect($B,($E!=""?lang(214):lang(215)),queries(create_trigger($qe,$_POST)));if($E!="")queries(create_trigger($qe,$L+array("Type"=>reset($Wg["Type"]))));}}$L=$_POST;}page_header(($E!=""?lang(216).": ".h($E):lang(217)),$m,array("table"=>$b));echo'
<form action="" method="post" id="form">
<table cellspacing="0" class="layout">
<tr><th>',lang(218),'<td>',html_select("Timing",$Wg["Timing"],$L["Timing"],"triggerChange(/^".preg_quote($b,"/")."_[ba][iud]$/, '".js_escape($b)."', this.form);"),'<tr><th>',lang(219),'<td>',html_select("Event",$Wg["Event"],$L["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Wg["Event"])?" <input name='Of' value='".h($L["Of"])."' class='hidden'>":""),'<tr><th>',lang(38),'<td>',html_select("Type",$Wg["Type"],$L["Type"]),'</table>
<p>',lang(176),': <input name="Trigger" value="',h($L["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$L["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($E!=""){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,$E));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["user"])){$ea=$_GET["user"];$jf=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$L){foreach(explode(",",($L["Privilege"]=="Grant option"?"":$L["Context"]))as$ib)$jf[$ib][$L["Privilege"]]=$L["Comment"];}$jf["Server Admin"]+=$jf["File access on server"];$jf["Databases"]["Create routine"]=$jf["Procedures"]["Create routine"];unset($jf["Procedures"]["Create routine"]);$jf["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$jf["Columns"][$X]=$jf["Tables"][$X];unset($jf["Server Admin"]["Usage"]);foreach($jf["Tables"]as$z=>$X)unset($jf["Databases"][$z]);$be=array();if($_POST){foreach($_POST["objects"]as$z=>$X)$be[$X]=(array)$be[$X]+(array)$_POST["grants"][$z];}$Ic=array();$oe="";if(isset($_GET["host"])&&($J=$g->query("SHOW GRANTS FOR ".q($ea)."@".q($_GET["host"])))){while($L=$J->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$L[0],$C)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$C[1],$Jd,PREG_SET_ORDER)){foreach($Jd
as$X){if($X[1]!="USAGE")$Ic["$C[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$L[0]))$Ic["$C[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$L[0],$C))$oe=$C[1];}}if($_POST&&!$m){$pe=(isset($_GET["host"])?q($ea)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $pe",ME."privileges=",lang(220));else{$de=q($_POST["user"])."@".q($_POST["host"]);$Se=$_POST["pass"];if($Se!=''&&!$_POST["hashed"]&&!min_version(8)){$Se=$g->result("SELECT PASSWORD(".q($Se).")");$m=!$Se;}$mb=false;if(!$m){if($pe!=$de){$mb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $de IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Se));$m=!$mb;}elseif($Se!=$oe)queries("SET PASSWORD FOR $de = ".q($Se));}if(!$m){$Cf=array();foreach($be
as$je=>$Hc){if(isset($_GET["grant"]))$Hc=array_filter($Hc);$Hc=array_keys($Hc);if(isset($_GET["grant"]))$Cf=array_diff(array_keys(array_filter($be[$je],'strlen')),$Hc);elseif($pe==$de){$me=array_keys((array)$Ic[$je]);$Cf=array_diff($me,$Hc);$Hc=array_diff($Hc,$me);unset($Ic[$je]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$je,$C)&&(!grant("REVOKE",$Cf,$C[2]," ON $C[1] FROM $de")||!grant("GRANT",$Hc,$C[2]," ON $C[1] TO $de"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($pe!=$de)queries("DROP USER $pe");elseif(!isset($_GET["grant"])){foreach($Ic
as$je=>$Cf){if(preg_match('~^(.+)(\(.*\))?$~U',$je,$C))grant("REVOKE",array_keys($Cf),$C[2]," ON $C[1] FROM $de");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(221):lang(222)),!$m);if($mb)$g->query("DROP USER $de");}}page_header((isset($_GET["host"])?lang(24).": ".h("$ea@$_GET[host]"):lang(139)),$m,array("privileges"=>array('',lang(60))));if($_POST){$L=$_POST;$Ic=$be;}else{$L=$_GET+array("host"=>$g->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$L["pass"]=$oe;if($oe!="")$L["hashed"]=true;$Ic[(DB==""||$Ic?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(23),'<td><input name="host" data-maxlength="60" value="',h($L["host"]),'" autocapitalize="off">
<tr><th>',lang(24),'<td><input name="user" data-maxlength="80" value="',h($L["user"]),'" autocapitalize="off">
<tr><th>',lang(25),'<td><input name="pass" id="pass" value="',h($L["pass"]),'" autocomplete="new-password">
';if(!$L["hashed"])echo
script("typePassword(qs('#pass'));");echo(min_version(8)?"":checkbox("hashed",1,$L["hashed"],lang(223),"typePassword(this.form['pass'], this.checked);")),'</table>

';echo"<table cellspacing='0'>\n","<thead><tr><th colspan='2'>".lang(60).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($Ic
as$je=>$Hc){echo'<th>'.($je!="*.*"?"<input name='objects[$t]' value='".h($je)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$t]' value='*.*' size='10'>*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(23),"Databases"=>lang(26),"Tables"=>lang(124),"Columns"=>lang(37),"Procedures"=>lang(224),)as$ib=>$Db){foreach((array)$jf[$ib]as$if=>$bb){echo"<tr".odd()."><td".($Db?">$Db<td":" colspan='2'").' lang="en" title="'.h($bb).'">'.h($if);$t=0;foreach($Ic
as$je=>$Hc){$E="'grants[$t][".h(strtoupper($if))."]'";$Y=$Hc[strtoupper($if)];if($ib=="Server Admin"&&$je!=(isset($Ic["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$E><option><option value='1'".($Y?" selected":"").">".lang(225)."<option value='0'".($Y=="0"?" selected":"").">".lang(226)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$E value='1'".($Y?" checked":"").($if=="All privileges"?" id='grants-$t-all'>":">".($if=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";}$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(121),'">',confirm(lang(168,"$ea@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$rd=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$rd++;}queries_redirect(ME."processlist=",lang(227,$rd),$rd||!$_POST["kill"]);}}page_header(lang(110),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap checkable">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$L){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($L
as$z=>$X)echo"<th>$z".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($z),));echo"</thead>\n";}echo"<tr".odd().">".(support("kill")?"<td>".checkbox("kill[]",$L[$y=="sql"?"Id":"pid"],0):"");foreach($L
as$z=>$X)echo"<td>".(($y=="sql"&&$z=="Info"&&preg_match("~Query|Killed~",$L["Command"])&&$X!="")||($y=="pgsql"&&$z=="current_query"&&$X!="<IDLE>")||($y=="oracle"&&$z=="sql_text"&&$X!="")?"<code class='jush-$y'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($L["db"]!=""?"db=".urlencode($L["db"])."&":"")."sql=".urlencode($X)).'">'.lang(228).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill")){echo($t+1)."/".lang(229,max_connections()),"<p><input type='submit' value='".lang(230)."'>\n";}echo'<input type="hidden" name="token" value="',$T,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$b=$_GET["select"];$R=table_status1($b);$x=indexes($b);$o=fields($b);$Bc=column_foreign_keys($b);$le=$R["Oid"];parse_str($_COOKIE["adminer_import"],$ma);$Df=array();$e=array();$Fg=null;foreach($o
as$z=>$n){$E=$c->fieldName($n);if(isset($n["privileges"]["select"])&&$E!=""){$e[$z]=html_entity_decode(strip_tags($E),ENT_QUOTES);if(is_shortable($n))$Fg=$c->selectLengthProcess();}$Df+=$n["privileges"];}list($N,$s)=$c->selectColumnsProcess($e,$x);$kd=count($s)<count($N);$Z=$c->selectSearchProcess($o,$x);$ze=$c->selectOrderProcess($o,$x);$_=$c->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$eh=>$L){$ua=convert_field($o[key($L)]);$N=array($ua?$ua:idf_escape(key($L)));$Z[]=where_check($eh,$o);$K=$l->select($b,$N,$Z,$N);if($K)echo
reset($K->fetch_row());}exit;}$ff=$gh=null;foreach($x
as$w){if($w["type"]=="PRIMARY"){$ff=array_flip($w["columns"]);$gh=($N?$ff:array());foreach($gh
as$z=>$X){if(in_array(idf_escape($z),$N))unset($gh[$z]);}break;}}if($le&&!$ff){$ff=$gh=array($le=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($le));}if($_POST&&!$m){$Bh=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Oa=array();foreach($_POST["check"]as$Ma)$Oa[]=where_check($Ma,$o);$Bh[]="((".implode(") OR (",$Oa)."))";}$Bh=($Bh?"\nWHERE ".implode(" AND ",$Bh):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($b);$c->dumpTable($b,"");$Fc=($N?implode(", ",$N):"*").convert_fields($e,$o,$N)."\nFROM ".table($b);$Kc=($s&&$kd?"\nGROUP BY ".implode(", ",$s):"").($ze?"\nORDER BY ".implode(", ",$ze):"");if(!is_array($_POST["check"])||$ff)$I="SELECT $Fc$Bh$Kc";else{$ch=array();foreach($_POST["check"]as$X)$ch[]="(SELECT".limit($Fc,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$Kc,1).")";$I=implode(" UNION ALL ",$ch);}$c->dumpData($b,"table",$I);exit;}if(!$c->selectEmailProcess($Z,$Bc)){if($_POST["save"]||$_POST["delete"]){$J=true;$na=0;$P=array();if(!$_POST["delete"]){foreach($e
as$E=>$X){$X=process_input($o[$E]);if($X!==null&&($_POST["clone"]||$X!==false))$P[idf_escape($E)]=($X!==false?$X:idf_escape($E));}}if($_POST["delete"]||$P){if($_POST["clone"])$I="INTO ".table($b)." (".implode(", ",array_keys($P)).")\nSELECT ".implode(", ",$P)."\nFROM ".table($b);if($_POST["all"]||($ff&&is_array($_POST["check"]))||$kd){$J=($_POST["delete"]?$l->delete($b,$Bh):($_POST["clone"]?queries("INSERT $I$Bh"):$l->update($b,$P,$Bh)));$na=$g->affected_rows;}else{foreach((array)$_POST["check"]as$X){$Ah="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$J=($_POST["delete"]?$l->delete($b,$Ah,1):($_POST["clone"]?queries("INSERT".limit1($b,$I,$Ah)):$l->update($b,$P,$Ah,1)));if(!$J)break;$na+=$g->affected_rows;}}}$D=lang(231,$na);if($_POST["clone"]&&$J&&$na==1){$xd=last_id();if($xd)$D=lang(161," $xd");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$D,$J);if(!$_POST["delete"]){edit_form($b,$o,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(232);else{$J=true;$na=0;foreach($_POST["val"]as$eh=>$L){$P=array();foreach($L
as$z=>$X){$z=bracket_escape($z,1);$P[idf_escape($z)]=(preg_match('~char|text~',$o[$z]["type"])||$X!=""?$c->processInput($o[$z],$X):"NULL");}$J=$l->update($b,$P," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($eh,$o),!$kd&&!$ff," ");if(!$J)break;$na+=$g->affected_rows;}queries_redirect(remove_from_uri(),lang(231,$na),$J);}}elseif(!is_string($uc=get_file("csv_file",true)))$m=upload_error($uc);elseif(!preg_match('~~u',$uc))$m=lang(233);else{cookie("adminer_import","output=".urlencode($ma["output"])."&format=".urlencode($_POST["separator"]));$J=true;$Ya=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$uc,$Jd);$na=count($Jd[0]);$l->begin();$Rf=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$M=array();foreach($Jd[0]as$z=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Rf]*)$Rf~",$X.$Rf,$Kd);if(!$z&&!array_diff($Kd[1],$Ya)){$Ya=$Kd[1];$na--;}else{$P=array();foreach($Kd[1]as$t=>$Ua)$P[idf_escape($Ya[$t])]=($Ua==""&&$o[$Ya[$t]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$Ua))));$M[]=$P;}}$J=(!$M||$l->insertUpdate($b,$M,$ff));if($J)$J=$l->commit();queries_redirect(remove_from_uri("page"),lang(234,$na),$J);$l->rollback();}}}$ug=$c->tableName($R);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(42).": $ug",$m);$P=null;if(isset($Df["insert"])||!support("table")){$P="";foreach((array)$_GET["where"]as$X){if($Bc[$X["col"]]&&count($Bc[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$P.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$c->selectLinks($R,$P);if(!$e&&support("table"))echo"<p class='error'>".lang(235).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($b).'">',"</div>\n";$c->selectColumnsPrint($N,$e);$c->selectSearchPrint($Z,$e,$x);$c->selectOrderPrint($ze,$e,$x);$c->selectLimitPrint($_);$c->selectLengthPrint($Fg);$c->selectActionPrint($x);echo"</form>\n";$F=$_GET["page"];if($F=="last"){$Ec=$g->result(count_rows($b,$Z,$kd,$s));$F=floor(max(0,$Ec-1)/$_);}$Mf=$N;$Jc=$s;if(!$Mf){$Mf[]="*";$jb=convert_fields($e,$o,$N);if($jb)$Mf[]=substr($jb,2);}foreach($N
as$z=>$X){$n=$o[idf_unescape($X)];if($n&&($ua=convert_field($n)))$Mf[$z]="$ua AS $X";}if(!$kd&&$gh){foreach($gh
as$z=>$X){$Mf[]=idf_escape($z);if($Jc)$Jc[]=idf_escape($z);}}$J=$l->select($b,$Mf,$Z,$Jc,$ze,$_,$F,true);if(!$J)echo"<p class='error'>".error()."\n";else{if($y=="mssql"&&$F)$J->seek($_*$F);$Xb=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$M=array();while($L=$J->fetch_assoc()){if($F&&$y=="oracle")unset($L["RNUM"]);$M[]=$L;}if($_GET["page"]!="last"&&$_!=""&&$s&&$kd&&$y=="sql")$Ec=$g->result(" SELECT FOUND_ROWS()");if(!$M)echo"<p class='message'>".lang(12)."\n";else{$Ba=$c->backwardKeys($b,$ug);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$s&&$N?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(236)."</a>");$ae=array();$Gc=array();reset($N);$rf=1;foreach($M[0]as$z=>$X){if(!isset($gh[$z])){$X=$_GET["columns"][key($N)];$n=$o[$N?($X?$X["col"]:current($N)):$z];$E=($n?$c->fieldName($n,$rf):($X["fun"]?"*":$z));if($E!=""){$rf++;$ae[$z]=$E;$d=idf_escape($z);$Wc=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($z);$Db="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($z))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Wc.($ze[0]==$d||$ze[0]==$z||(!$ze&&$kd&&$s[0]==$d)?$Db:'')).'">';echo
apply_sql_function($X["fun"],$E)."</a>";echo"<span class='column hidden'>","<a href='".h($Wc.$Db)."' title='".lang(48)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(45).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($z)."');");}echo"</span>";}$Gc[$z]=$X["fun"];next($N);}}$Cd=array();if($_GET["modify"]){foreach($M
as$L){foreach($L
as$z=>$X)$Cd[$z]=max($Cd[$z],min(40,strlen(utf8_decode($X))));}}echo($Ba?"<th>".lang(237):"")."</thead>\n";if(is_ajax()){if($_%2==1&&$F%2==1)odd();ob_end_clean();}foreach($c->rowDescriptions($M,$Bc)as$Zd=>$L){$dh=unique_array($M[$Zd],$x);if(!$dh){$dh=array();foreach($M[$Zd]as$z=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$z))$dh[$z]=$X;}}$eh="";foreach($dh
as$z=>$X){if(($y=="sql"||$y=="pgsql")&&preg_match('~char|text|enum|set~',$o[$z]["type"])&&strlen($X)>64){$z=(strpos($z,'(')?$z:idf_escape($z));$z="MD5(".($y!='sql'||preg_match("~^utf8~",$o[$z]["collation"])?$z:"CONVERT($z USING ".charset($g).")").")";$X=md5($X);}$eh.="&".($X!==null?urlencode("where[".bracket_escape($z)."]")."=".urlencode($X):"null%5B%5D=".urlencode($z));}echo"<tr".odd().">".(!$s&&$N?"":"<td>".checkbox("check[]",substr($eh,1),in_array(substr($eh,1),(array)$_POST["check"])).($kd||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($b).$eh)."' class='edit'>".lang(238)."</a>"));foreach($L
as$z=>$X){if(isset($ae[$z])){$n=$o[$z];$X=$l->value($X,$n);if($X!=""&&(!isset($Xb[$z])||$Xb[$z]!=""))$Xb[$z]=(is_mail($X)?$ae[$z]:"");$A="";if(preg_match('~blob|bytea|raw|file~',$n["type"])&&$X!="")$A=ME.'download='.urlencode($b).'&field='.urlencode($z).$eh;if(!$A&&$X!==null){foreach((array)$Bc[$z]as$p){if(count($Bc[$z])==1||end($p["source"])==$z){$A="";foreach($p["source"]as$t=>$bg)$A.=where_link($t,$p["target"][$t],$M[$Zd][$bg]);$A=($p["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($p["db"]),ME):ME).'select='.urlencode($p["table"]).$A;if($p["ns"])$A=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($p["ns"]),$A);if(count($p["source"])==1)break;}}}if($z=="COUNT(*)"){$A=ME."select=".urlencode($b);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$dh))$A.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($dh
as$od=>$W)$A.=where_link($t++,$od,$W);}$X=select_value($X,$A,$n,$Fg);$u=h("val[$eh][".bracket_escape($z)."]");$Y=$_POST["val"][$eh][bracket_escape($z)];$Sb=!is_array($L[$z])&&is_utf8($X)&&$M[$Zd][$z]==$L[$z]&&!$Gc[$z];$Eg=preg_match('~text|lob~',$n["type"]);echo"<td id='$u'";if(($_GET["modify"]&&$Sb)||$Y!==null){$Nc=h($Y!==null?$Y:$L[$z]);echo">".($Eg?"<textarea name='$u' cols='30' rows='".(substr_count($L[$z],"\n")+1)."'>$Nc</textarea>":"<input name='$u' value='$Nc' size='$Cd[$z]'>");}else{$Gd=strpos($X,"<i>…</i>");echo" data-text='".($Gd?2:($Eg?1:0))."'".($Sb?"":" data-warning='".h(lang(239))."'").">$X</td>";}}}if($Ba)echo"<td>";$c->backwardKeysPrint($Ba,$M[$Zd]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($M||$F){$ic=true;if($_GET["page"]!="last"){if($_==""||(count($M)<$_&&($M||!$F)))$Ec=($F?$F*$_:0)+count($M);elseif($y!="sql"||!$kd){$Ec=($kd?false:found_rows($R,$Z));if($Ec<max(1e4,2*($F+1)*$_))$Ec=reset(slow_query(count_rows($b,$Z,$kd,$s)));else$ic=false;}}$Ke=($_!=""&&($Ec===false||$Ec>$_||$F));if($Ke){echo(($Ec===false?count($M)+1:$Ec-$F*$_)>$_?'<p><a href="'.h(remove_from_uri("page")."&page=".($F+1)).'" class="loadmore">'.lang(240).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$_).", '".lang(241)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($M||$F){if($Ke){$Md=($Ec===false?$F+(count($M)>=$_?2:1):floor(($Ec-1)/$_));echo"<fieldset>";if($y!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(242)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(242)."', '".($F+1)."')); return false; };"),pagination(0,$F).($F>5?" …":"");for($t=max(1,$F-4);$t<min($Md,$F+5);$t++)echo
pagination($t,$F);if($Md>0){echo($F+5<$Md?" …":""),($ic&&$Ec!==false?pagination($Md,$F):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Md'>".lang(243)."</a>");}}else{echo"<legend>".lang(242)."</legend>",pagination(0,$F).($F>1?" …":""),($F?pagination($F,$F):""),($Md>$F?pagination($F+1,$F).($Md>$F+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(244)."</legend>";$Ib=($ic?"":"~ ").$Ec;echo
checkbox("all",1,0,($Ec!==false?($ic?"":"~ ").lang(143,$Ec):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Ib' : checked); selectCount('selected2', this.checked || !checked ? '$Ib' : checked);")."\n","</fieldset>\n";if($c->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(236),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(232).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(120),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(228),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$Cc=$c->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($Cc['sql']);break;}}if($Cc){print_fieldset("export",lang(62)." <span id='selected2'></span>");$Ie=$c->dumpOutput();echo($Ie?html_select("output",$Ie,$ma["output"])." ":""),html_select("format",$Cc,$ma["format"])," <input type='submit' name='export' value='".lang(62)."'>\n","</div></fieldset>\n";}$c->selectEmailPrint(array_filter($Xb,'strlen'),$e);}echo"</div></div>\n";if($c->selectImportPrint()){echo"<div>","<a href='#import'>".lang(61)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$ma["format"],1);echo" <input type='submit' name='import' value='".lang(61)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$T'>\n","</form>\n",(!$s&&$N?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$ig=isset($_GET["status"]);page_header($ig?lang(112):lang(111));$sh=($ig?show_status():show_variables());if(!$sh)echo"<p class='message'>".lang(12)."\n";else{echo"<table cellspacing='0'>\n";foreach($sh
as$z=>$X){echo"<tr>","<th><code class='jush-".$y.($ig?"status":"set")."'>".h($z)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$rg=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$E=>$R){json_row("Comment-$E",h($R["Comment"]));if(!is_view($R)){foreach(array("Engine","Collation")as$z)json_row("$z-$E",h($R[$z]));foreach($rg+array("Auto_increment"=>0,"Rows"=>0)as$z=>$X){if($R[$z]!=""){$X=format_number($R[$z]);json_row("$z-$E",($z=="Rows"&&$X&&$R["Engine"]==($dg=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($rg[$z]))$rg[$z]+=($R["Engine"]!="InnoDB"||$z!="Data_free"?$R[$z]:0);}elseif(array_key_exists($z,$R))json_row("$z-$E");}}}foreach($rg
as$z=>$X)json_row("sum-$z",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$g->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($c->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$zg=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($zg&&!$m&&!$_POST["search"]){$J=true;$D="";if($y=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$J=truncate_tables($_POST["tables"]);$D=lang(245);}elseif($_POST["move"]){$J=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$D=lang(246);}elseif($_POST["copy"]){$J=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$D=lang(247);}elseif($_POST["drop"]){if($_POST["views"])$J=drop_views($_POST["views"]);if($J&&$_POST["tables"])$J=drop_tables($_POST["tables"]);$D=lang(248);}elseif($y!="sql"){$J=($y=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$D=lang(249);}elseif(!$_POST["tables"])$D=lang(9);elseif($J=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($L=$J->fetch_assoc())$D.="<b>".h($L["Table"])."</b>: ".h($L["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$D,$J);}page_header(($_GET["ns"]==""?lang(26).": ".h(DB):lang(189).": ".h($_GET["ns"])),$m,true);if($c->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(250)."</h3>\n";$yg=tables_list();if(!$yg)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(251)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(45)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]="LIKE %%";search_tables();}}echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(124),'<td>'.lang(252).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(116).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(253).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(254).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(255).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(40).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(256).doc_link(array('sql'=>'show-table-status.html',)),(support("comment")?'<td>'.lang(39).doc_link(array('sql'=>'show-table-status.html',)):''),"</thead>\n";$S=0;foreach($yg
as$E=>$U){$vh=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$E);echo'<tr'.odd().'><td>'.checkbox(($vh?"views[]":"tables[]"),$E,in_array($E,$zg,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($E)."' title='".lang(31)."' id='$u'>".h($E).'</a>':h($E));if($vh){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($E).'" title="'.lang(32).'">'.(preg_match('~materialized~i',$U)?lang(122):lang(123)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($E).'" title="'.lang(30).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(33)),"Index_length"=>array("indexes",lang(126)),"Data_free"=>array("edit",lang(34)),"Auto_increment"=>array("auto_increment=1&create",lang(33)),"Rows"=>array("select",lang(30)),)as$z=>$A){$u=" id='$z-".h($E)."'";echo($A?"<td align='right'>".(support("table")||$z=="Rows"||(support("indexes")&&$z!="Data_length")?"<a href='".h(ME."$A[0]=").urlencode($E)."'$u title='$A[1]'>?</a>":"<span$u>?</span>"):"<td id='$z-".h($E)."'>");}$S++;}echo(support("comment")?"<td id='Comment-".h($E)."'>":"");}echo"<tr><td><th>".lang(229,count($yg)),"<td>".h($y=="sql"?$g->result("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$z)echo"<td align='right' id='sum-$z'>";echo"</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$qh="<input type='submit' value='".lang(257)."'> ".on_help("'VACUUM'");$we="<input type='submit' name='optimize' value='".lang(258)."'> ".on_help($y=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(120)." <span id='selected'></span></legend><div>".($y=="sqlite"?$qh:($y=="pgsql"?$qh.$we:($y=="sql"?"<input type='submit' value='".lang(259)."'> ".on_help("'ANALYZE TABLE'").$we."<input type='submit' name='check' value='".lang(260)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(261)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(262)."'> ".on_help($y=="sqlite"?"'DELETE'":"'TRUNCATE".($y=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(121)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?$c->schemas():$c->databases());if(count($j)!=1&&$y!="sqlite"){$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(263).": ",($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(264)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(265)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(266)):""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $S);":"")." }"),"<input type='hidden' name='token' value='$T'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo'<p class="links"><a href="'.h(ME).'create=">'.lang(63)."</a>\n",(support("view")?'<a href="'.h(ME).'view=">'.lang(195)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(136)."</h3>\n";$Hf=routines();if($Hf){echo"<table cellspacing='0'>\n",'<thead><tr><th>'.lang(176).'<td>'.lang(38).'<td>'.lang(212)."<td></thead>\n";odd('');foreach($Hf
as$L){$E=($L["SPECIFIC_NAME"]==$L["ROUTINE_NAME"]?"":"&name=".urlencode($L["ROUTINE_NAME"]));echo'<tr'.odd().'>','<th><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($L["SPECIFIC_NAME"]).$E).'">'.h($L["ROUTINE_NAME"]).'</a>','<td>'.h($L["ROUTINE_TYPE"]),'<td>'.h($L["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($L["SPECIFIC_NAME"]).$E).'">'.lang(129)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(211).'</a>':'').'<a href="'.h(ME).'function=">'.lang(210)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(137)."</h3>\n";$M=get_rows("SHOW EVENTS");if($M){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(176)."<td>".lang(267)."<td>".lang(201)."<td>".lang(202)."<td></thead>\n";foreach($M
as$L){echo"<tr>","<th>".h($L["Name"]),"<td>".($L["Execute at"]?lang(268)."<td>".$L["Execute at"]:lang(203)." ".$L["Interval value"]." ".$L["Interval field"]."<td>$L[Starts]"),"<td>$L[Ends]",'<td><a href="'.h(ME).'event='.urlencode($L["Name"]).'">'.lang(129).'</a>';}echo"</table>\n";$gc=$g->result("SELECT @@event_scheduler");if($gc&&$gc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($gc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(200)."</a>\n";}if($yg)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();