<?php

class API {

    static function success($array){

        $array = array_merge(["success" => true], $array);

        echo strip_tags(stripslashes(json_encode($array, JSON_UNESCAPED_UNICODE)));

    }

    static function error($code, $message){

        echo json_encode([
            "success" => false,
            "message" => "Error $code, $message"
        ]);

        exit();
    }

    static function auth($post){

        if (!isset($post['login']) || $post['login'] !== LOGIN || !isset($post['token']) || $post['token'] !== TOKEN) {

            echo json_encode([
                "success" => false,
                "message" => "Error 001, Impossible de retourner un résultat"
            ]);

            exit();
        }

    }

    static function user($post, $db){

        if (!isset($post['app_token']) || !isset($post['id_user'])){

            API::error('00T1', 'Une erreur est servenu');

            exit();

        }

        $user = $db->query('SELECT idU FROM utilisateurs WHERE (idU = :id_user AND app_token = :app_token)', ['id_user' => $post['id_user'], 'app_token' => $post['app_token']])->fetch();

        if(empty($user)){

            API::error('00T2', 'Une erreur est servenu');

            exit();

        }

        return $user->idU;
        
    }

}