<?php

if (!isset($post['nom']) || !isset($post['email']) || !isset($post['tele']) || !isset($post['password'])) API::error('004', 'Impossible de retourner un résultat');

require '../gla-adminer/class/Mail.php';
require '../gla-adminer/class/Validation.php';

$nom = $post['nom'];
$email = $post['email'];
$tele = $post['tele'];
$password = $post['password'];

if (\Validation::between($nom, 2, 128)) API::error('00R1', "Veuillez vérifier votre nom");

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) API::error('00R1', "Veuillez vérifier votre adresse email");

if (!\Validation::isUnique(trim($email), 'email', 'utilisateurs', $db)) API::error('00R1', "Adresse email déja utilisée dans un autre compte");

if (!preg_match("/^\\+?\\d{1,4}?[-.\\s]?\\(?\\d{1,3}?\\)?[-.\\s]?\\d{1,4}[-.\\s]?\\d{1,4}[-.\\s]?\\d{1,9}$/", trim($tele))) API::error('00R1', "Veuillez entrer un numéro de téléphone valide");

$password = password_hash($password, PASSWORD_BCRYPT, ['cost' => 10]);

$email_val = rand(10000, 99999);
$tele_val = rand(10000, 99999);

$app_token = md5(rand(0, 99999) . "_gla") . '_' . md5(rand(0, 99999) . "_gla");

$db->query("INSERT INTO utilisateurs (nom,monentreprise,email,tele,password,date,email_val,tele_val,app_token,type) VALUES (?,?,?,?,?,NOW(),?,?,?,1)",[trim($nom),$nom, strtolower(trim($email)), trim($tele), $password, $email_val, $tele_val, $app_token]);

\Mail::welcom_email_validation(trim($email), $nom, $email_val);

$user = $db->query('SELECT idU, nom, email, tele, avatar, password, type, app_token FROM utilisateurs WHERE (email = :login OR tele = :login)', ['login' => strtolower(trim($email))])->fetch();

if (!empty($user)) {

    $avatar = (empty($user->avatar)) ? "" : WEBROOT . "theme/assets/img/profile/" . $user->avatar;

    unset($user->{'avatar'});
    unset($user->{'password'});

    API::success([
        "data" => $user,
        "avatar" => $avatar
    ]);

} else {

    API::error('005', 'Veuillez vérefier votre email ou numéro de téléphone');

}