<?php

session_start();

require "lib/vendor/autoload.php";

$provider = new \League\OAuth2\Client\Provider\Facebook([
    'clientId'          => '498525827985748',
    'clientSecret'      => 'bbf22ed422573e0d2a4d902ababa0c20',
    'redirectUri'       => 'https://www.nousartisans.com/return.php',
    'graphApiVersion'   => 'v12.0',
]);

// Try to get an access token (using the authorization code grant)
$token = $provider->getAccessToken('authorization_code', [
    'code' => $_GET['code']
]);

// Optional: Now you have a token you can look up a users profile data
try {

    // We got an access token, let's now get the user's details
    $user = $provider->getResourceOwner($token);

    // Use these details to create a new profile
    printf('Hello %s!', $user->getFirstName());

    echo '<pre>';
    var_dump($user);
    # object(League\OAuth2\Client\Provider\FacebookUser)#10 (1) { ...
    echo '</pre>';
} catch (\Exception $e) {

    // Failed to get user details
    exit('Oh dear...');
}

echo '<pre>';
// Use this to interact with an API on the users behalf
var_dump($token->getToken());
# string(217) "CAADAppfn3msBAI7tZBLWg...

// The time (in epoch time) when an access token will expire
var_dump($token->getExpires());
# int(1436825866)
echo '</pre>';

$id = $user->getId();
var_dump($id);
# string(1) "4"

$name = $user->getName();
var_dump($name);
# string(15) "Mark Zuckerberg"

$firstName = $user->getFirstName();
var_dump($firstName);
# string(4) "Mark"

$lastName = $user->getLastName();
var_dump($lastName);
# string(10) "Zuckerberg"

# Requires the "email" permission
$email = $user->getEmail();
var_dump($email);
# string(15) "thezuck@foo.com"

# Requires the "user_hometown" permission
$hometown = $user->getHometown();
var_dump($hometown);
# array(10) { ["id"]=> string(10) "12345567890" ...

# Requires the "user_about_me" permission
$bio = $user->getBio();
var_dump($bio);
# string(426) "All about me...

$pictureUrl = $user->getPictureUrl();
var_dump($pictureUrl);
# string(224) "https://fbcdn-profile-a.akamaihd.net/hprofile- ...

$isDefaultPicture = $user->isDefaultPicture();
var_dump($isDefaultPicture);
# boolean false

$coverPhotoUrl = $user->getCoverPhotoUrl();
var_dump($coverPhotoUrl);
# string(111) "https://fbcdn-profile-a.akamaihd.net/hphotos- ...

$gender = $user->getGender();
var_dump($gender);
# string(4) "male"

$locale = $user->getLocale();
var_dump($locale);
# string(5) "en_US"

$timezone = $user->getTimezone();
var_dump($timezone);
# int -5

$link = $user->getLink();
var_dump($link);
# string(62) "https://www.facebook.com/app_scoped_user_id/1234567890/"

$maxAge = $user->getMaxAge();
var_dump($maxAge);
# int 17 | null

$minAge = $user->getMinAge();
var_dump($minAge);
# int 21

?>