<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Datastream;

class MysqlColumn extends \Google\Model
{
  public $collation;
  public $column;
  public $dataType;
  public $length;
  public $nullable;
  public $ordinalPosition;
  public $primaryKey;

  public function setCollation($collation)
  {
    $this->collation = $collation;
  }
  public function getCollation()
  {
    return $this->collation;
  }
  public function setColumn($column)
  {
    $this->column = $column;
  }
  public function getColumn()
  {
    return $this->column;
  }
  public function setDataType($dataType)
  {
    $this->dataType = $dataType;
  }
  public function getDataType()
  {
    return $this->dataType;
  }
  public function setLength($length)
  {
    $this->length = $length;
  }
  public function getLength()
  {
    return $this->length;
  }
  public function setNullable($nullable)
  {
    $this->nullable = $nullable;
  }
  public function getNullable()
  {
    return $this->nullable;
  }
  public function setOrdinalPosition($ordinalPosition)
  {
    $this->ordinalPosition = $ordinalPosition;
  }
  public function getOrdinalPosition()
  {
    return $this->ordinalPosition;
  }
  public function setPrimaryKey($primaryKey)
  {
    $this->primaryKey = $primaryKey;
  }
  public function getPrimaryKey()
  {
    return $this->primaryKey;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MysqlColumn::class, 'Google_Service_Datastream_MysqlColumn');
